
/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: optionaltemplates.hpp,v 1.4 1998/10/09 18:18:52 pnewman Exp $
*/

#ifndef __optionaltemplates_hpp_
#define __optionaltemplates_hpp_ 1


// urTypeKind        embedded T                                 parameter wrapper

// Byte              iluOptionalByteMgr                      iluOptionalByteWrapper
// ShortCharacter    iluOptionalShortCharacterMgr            iluOptionalShortCharacterWrapper
// Integer           iluOptionalIntegerMgr                   iluOptionalIntegerWrapper
// ShortInteger      iluOptionalShortIntegerMgr              iluOptionalShortIntegerWrapper
// LongInteger       iluOptionalLongIntegerMgr               iluOptionalLongIntegerWrapper
// Cardinal          iluOptionalCardinalMgr                  iluOptionalCardinalWrapper
// ShortCardinal     iluOptionalShortCardinalMgr             iluOptionalShortCardinalWrapper
// LongCardinal      iluOptionalLongCardinalMgr              iluOptionalLongCardinalWrapper
// Real              iluOptionalRealMgr                      iluOptionalRealWrapper
// ShortReal         iluOptionalShortRealMgr                 iluOptionalShortRealWrapper
// LongReal          iluOptionalLongRealMgr                  iluOptionalLongRealWrapper

// Boolean           iluOptionalBooleanMgr                  iluOptionalBooleanWrapper
// Character         iluOptionalCharacterMgr                   iluOptionalCharacterWrapper

// Enumeration                                                  iluOptionalEnumerationWrapperT<T>

// Sequence          iluOptional{WithCleanup}MgrT<T>            iluOptional{WithCleanup}WrapperT<T>
// Record            iluOptional{WithCleanup}MgrT<T>            iluOptional{WithCleanup}WrapperT<T>
// Union             iluOptional{WithCleanup}MgrT<T>            iluOptional{WithCleanup}WrapperT<T>

// Array             iluOptionalArray{WithCleanup}MgrT<S, V>    iluOptionalArray{WithCleanup}WrapperT<S, V>

// Object            iluOptionalObjectMgrT<T>                   iluOptional{Sibling}ObjectWrapperT<T>

// CString           iluOptionalCStringMgr                      iluOptionalCStringWrapper
// WString           iluOptionalWStringMgr                      iluOptionalWStringWrapper




//////////////////////////////////////////////////////////////////
// TMP 8/25: String Length Procedures

// These should be defined in the iluCppRuntime namespace

inline
iluCardinal
iluStringLength (const char * str) {
	return (str == NULL ? 0 : strlen(str));
}

inline
iluCardinal
iluStringLength (const iluCharacter * str) {
	return (str == NULL ? 0 : iluCppRuntime::iluCharacterStringLength(str));
}



//////////////////////////////////////////////////////////////////
// Typedefs for Basic Type _var's


typedef iluTemplatableT_var<iluByte>           iluByte_var;
typedef iluTemplatableT_var<iluBoolean>        iluBoolean_var;
typedef iluTemplatableT_var<iluCharacter>      iluCharacter_var;
typedef iluTemplatableT_var<iluShortCharacter> iluShortCharacter_var;
typedef iluTemplatableT_var<iluInteger>        iluInteger_var;
typedef iluTemplatableT_var<iluShortInteger>   iluShortInteger_var;
typedef iluTemplatableT_var<iluLongInteger>    iluLongInteger_var;
typedef iluTemplatableT_var<iluCardinal>       iluCardinal_var;
typedef iluTemplatableT_var<iluShortCardinal>  iluShortCardinal_var;
typedef iluTemplatableT_var<iluLongCardinal>   iluLongCardinal_var;
typedef iluTemplatableT_var<iluReal>           iluReal_var;
typedef iluTemplatableT_var<iluShortReal>      iluShortReal_var;
typedef iluTemplatableT_var<iluLongReal>       iluLongReal_var;

typedef iluByte_var           ilu_CORBA_Octet_var;
typedef iluBoolean_var        ilu_CORBA_Boolean_var;
typedef iluShortCharacter_var ilu_CORBA_Char_var;
typedef iluInteger_var        ilu_CORBA_Long_var;
typedef iluShortInteger_var   ilu_CORBA_Short_var;
typedef iluCardinal_var       ilu_CORBA_ULong_var;
typedef iluShortCardinal_var  ilu_CORBA_UShort_var;
typedef iluReal_var           ilu_CORBA_Double_var;
typedef iluShortReal_var      ilu_CORBA_Float_var;


//////////////////////////////////////////////////////////////////
// Base class for Optional Wrappers


template <class T>
class iluOptionalWrapperBaseT {
public:
    iluOptionalWrapperBaseT (const T * & t) : _t(CONST_CAST(T*&, t)) {};
         // For both "T*" and "const T*" arguments. For "const T*",
         // the wrapper object may be declared const to prevent
         // non-const access.
    iluOptionalWrapperBaseT () : _default_t(NULL), _t(_default_t) {};
    T *& opt () {return _t;};
    const T * opt () const {return CONST_CAST(const T*, _t);};
//    void operator= (T * t) {_t = t;};
    operator T *& () {return _t;};
protected:
    T * _default_t;
    T *& _t;
};

template <class T>
class iluOptionalMgrBaseT: public iluTemplatableT_var<T> {
public:
    iluOptionalMgrBaseT () : iluTemplatableT_var<T>() {};
    iluOptionalMgrBaseT (T* t) : iluTemplatableT_var<T>(t) {};  // TMP 9/7: NEW
    iluOptionalMgrBaseT<T>& operator= (const iluOptionalMgrBaseT<T>& t_var) {iluTemplatableT_var<T>::operator=(t_var); return *this;};
    iluOptionalMgrBaseT<T>& operator= (const iluTemplatableT_var<T>& t_var) {iluTemplatableT_var<T>::operator=(t_var); return *this;};
    iluOptionalMgrBaseT<T>& operator= (T* t_ptr) {iluTemplatableT_var<T>::operator=(t_ptr); return *this;};
	T& operator* () {return STATIC_CAST(T&, *this);};  // TMP 8/26: NEW
// TMP 9/5	const T& operator* () const {return STATIC_CAST(T&, *this);};  // TMP 8/26: NEW
	const T& operator* () const {return STATIC_CAST(const T&, *this);};  // TMP 9/5: NEW
};

/* TMP 8/26

  NOTE: in the above operator "const T& operator* () const", we intentionally cast to "T&", instead of "const T&";
  the latter will lead to several errors similar to the one below. I believe this is caused by the definition of
  "operator T& () const" in iluTemplateableT_var<T> - it probably should be non-const method.

  c:\ilu-dev\install\include\corba-templates.hpp(382) : error C2084: function 'iluTemplatableT_var<unsigned short>::operator`unsigned short &'(void)const ' already has a body
*/

//////////////////////////////////////////////////////////////////
// Basic Types


template <class T>
class iluOptionalWrapperT: public iluOptionalWrapperBaseT<T> {
public:
    iluOptionalWrapperT (const T * & t) : iluOptionalWrapperBaseT<T>(t) {};
    iluOptionalWrapperT () : iluOptionalWrapperBaseT<T>() {};
    operator const T* () const {return _t;};
};


template <class T>
class iluOptionalMgrT: public iluOptionalMgrBaseT<T> {
public:
    iluOptionalMgrT () : iluOptionalMgrBaseT<T>() {};
    iluOptionalMgrT (T* t) : iluOptionalMgrBaseT<T>(t) {};  // TMP 9/7: NEW
    iluOptionalMgrT<T>& operator= (const iluOptionalMgrT<T>& t_var) {iluOptionalMgrBaseT<T>::operator=(t_var); return *this;};
    iluOptionalMgrT<T>& operator= (const iluOptionalMgrBaseT<T>& t_var) {iluOptionalMgrBaseT<T>::operator=(t_var); return *this;};
    iluOptionalMgrT<T>& operator= (T* t_ptr) {iluOptionalMgrBaseT<T>::operator=(t_ptr); return *this;};
};



typedef iluOptionalWrapperT<iluByte>           iluOptionalByteWrapper;
typedef iluOptionalWrapperT<iluShortCharacter> iluOptionalShortCharacterWrapper;
typedef iluOptionalWrapperT<iluInteger>        iluOptionalIntegerWrapper;
typedef iluOptionalWrapperT<iluShortInteger>   iluOptionalShortIntegerWrapper;
typedef iluOptionalWrapperT<iluLongInteger>    iluOptionalLongIntegerWrapper;
typedef iluOptionalWrapperT<iluCardinal>       iluOptionalCardinalWrapper;
typedef iluOptionalWrapperT<iluShortCardinal>  iluOptionalShortCardinalWrapper;
typedef iluOptionalWrapperT<iluLongCardinal>   iluOptionalLongCardinalWrapper;
typedef iluOptionalWrapperT<iluReal>           iluOptionalRealWrapper;
typedef iluOptionalWrapperT<iluShortReal>      iluOptionalShortRealWrapper;
typedef iluOptionalWrapperT<iluLongReal>       iluOptionalLongRealWrapper;

typedef iluOptionalMgrT<iluByte>               iluOptionalByteMgr;
typedef iluOptionalMgrT<iluShortCharacter>     iluOptionalShortCharacterMgr;
typedef iluOptionalMgrT<iluInteger>            iluOptionalIntegerMgr;
typedef iluOptionalMgrT<iluShortInteger>       iluOptionalShortIntegerMgr;
typedef iluOptionalMgrT<iluLongInteger>        iluOptionalLongIntegerMgr;
typedef iluOptionalMgrT<iluCardinal>           iluOptionalCardinalMgr;
typedef iluOptionalMgrT<iluShortCardinal>      iluOptionalShortCardinalMgr;
typedef iluOptionalMgrT<iluLongCardinal>       iluOptionalLongCardinalMgr;
typedef iluOptionalMgrT<iluReal>               iluOptionalRealMgr;
typedef iluOptionalMgrT<iluShortReal>          iluOptionalShortRealMgr;
typedef iluOptionalMgrT<iluLongReal>           iluOptionalLongRealMgr;


//////////////////////////////////////////////////////////////////
// Boolean, Character


template <class T, class W>
class iluOptionalNonUniqueWrapperT: public iluOptionalWrapperBaseT<T> {
public:
    iluOptionalNonUniqueWrapperT (const T * & t) : iluOptionalWrapperBaseT<T>(t) {};
    iluOptionalNonUniqueWrapperT () : iluOptionalWrapperBaseT<T>() {};
    operator const T* () const {return _t;};
};

template <class T, class W>
class iluOptionalNonUniqueMgrT: public iluOptionalMgrBaseT<T> {
public:
    iluOptionalNonUniqueMgrT () : iluOptionalMgrBaseT<T>() {};
    iluOptionalNonUniqueMgrT<T, W>& operator= (const iluOptionalMgrT<T>& t_var) {iluOptionalMgrBaseT<T>::operator=(t_var); return *this;};
    iluOptionalNonUniqueMgrT<T, W>& operator= (const iluOptionalMgrBaseT<T>& t_var) {iluOptionalMgrBaseT<T>::operator=(t_var); return *this;};
    iluOptionalNonUniqueMgrT<T, W>& operator= (T* t_ptr) {iluOptionalMgrBaseT<T>::operator=(t_ptr); return *this;};
};


typedef iluOptionalNonUniqueWrapperT<ILUCPP_BOOL,  iluBoolWrapper>      iluOptionalBooleanWrapper;
typedef iluOptionalNonUniqueWrapperT<iluCharacter, iluCharacterWrapper> iluOptionalCharacterWrapper;

typedef iluOptionalNonUniqueMgrT<ILUCPP_BOOL,  iluBoolWrapper>          iluOptionalBooleanMgr;
typedef iluOptionalNonUniqueMgrT<iluCharacter, iluCharacterWrapper>     iluOptionalCharacterMgr;


//////////////////////////////////////////////////////////////////
// Enumeration


template <class T>
class iluOptionalEnumerationWrapperT: public iluOptionalNonUniqueWrapperT<iluDummyEnum, iluEnumWrapper> {
public:
    iluOptionalEnumerationWrapperT (const T*& t) : iluOptionalNonUniqueWrapperT<iluDummyEnum, iluEnumWrapper>(REINTERPRET_CAST(iluDummyEnum*&, CONST_CAST(T*&, t))) {};
    iluOptionalEnumerationWrapperT () : iluOptionalNonUniqueWrapperT<iluDummyEnum, iluEnumWrapper>() {};
// TMP 8/25	iluOptionalEnumerationWrapperT<T>& operator = (T * t_ptr) {iluOptionalNonUniqueWrapperT<iluDummyEnum, iluEnumWrapper>::operator=(*STATIC_CAST(iluDummyEnum*, t_ptr)); return *this;};  // TMP 8/25: NEW
    operator T*& () {return REINTERPRET_CAST(T*&, (iluDummyEnum*&)*this);};
    operator const T* () const {return (T*&)*CONST_CAST(iluOptionalEnumerationWrapperT<T>*, this);};
};

template <class T>
class iluOptionalEnumerationMgrT: public iluOptionalNonUniqueMgrT<iluDummyEnum, iluEnumWrapper> {
public:
    iluOptionalEnumerationMgrT<T>& operator= (T* t_ptr) {iluOptionalNonUniqueMgrT<iluDummyEnum, iluEnumWrapper>::operator=(REINTERPRET_CAST(iluDummyEnum*, t_ptr)); return *this;};
	operator T*& () {return REINTERPRET_CAST(T*&, STATIC_CAST(iluDummyEnum*&, *this));};
};


//////////////////////////////////////////////////////////////////
// For Sequence, Record, Union


template <class T>
class iluOptionalWithCleanupMgrT: public iluOptionalMgrT<T> {
public:
    iluOptionalWithCleanupMgrT () : iluOptionalMgrT<T>() {};
    iluOptionalWithCleanupMgrT<T>& operator= (const iluOptionalWithCleanupMgrT<T>& t_var) {iluOptionalMgrT<T>::operator=(t_var); return *this;};
    iluOptionalWithCleanupMgrT<T>& operator= (const iluTemplatableT_var<T>& t_var) {return *this;};
    iluOptionalWithCleanupMgrT<T>& operator= (T* t_ptr) {iluOptionalMgrT<T>::operator=(t_ptr); return *this;};
    void _surrogateSideCleanup() const {if (!iluIsNull()) m_ptr->_surrogateSideCleanup();};
};


//////////////////////////////////////////////////////////////////
// String types


template <class C, class W>
    // C is character type (char or iluCharacter)
	// W is the IO wrapper type (iluCStringWrapper or iluWStringWrapper)
class iluOptionalStringWrapperT: public iluOptionalWrapperBaseT<C> {
    friend iluBaseCall& operator+= (iluBaseCall&, const iluOptionalStringWrapperT<C, W>&);
    friend iluBaseCall& operator<< (iluBaseCall&, const iluOptionalStringWrapperT<C, W>&);
    friend iluBaseCall& operator>> (iluBaseCall&, iluOptionalStringWrapperT<C, W>&);
public:
    iluOptionalStringWrapperT (const C*&, iluByte delete_when = ILUCPP_DELETE_NEVER);
        // surrogate IN, surrogate INOUT, surrogate OUT
    iluOptionalStringWrapperT (iluByte delete_when = ILUCPP_DELETE_NEVER);
        // surrogate return value
        // true IN, true INOUT, true OUT, true return value
    void revise ();
private:
    W _io_wrapper;
    iluCardinal _length;
};

typedef iluOptionalStringWrapperT<char, iluCStringWrapper> iluOptionalCStringWrapper;
typedef iluOptionalStringWrapperT<iluCharacter, iluWStringWrapper> iluOptionalWStringWrapper;

template <class C, class W, class V>
    // C is character type (char or iluCharacter)
	// W is the IO wrapper type (iluCStringWrapper or iluWStringWrapper)
	// V is var type (CORBA::String_var or iluWString_var)
class iluOptionalStringMgrT: public V {
public:
    iluOptionalStringMgrT () : V() {};
    iluOptionalStringMgrT<C, W, V>& operator= (const iluOptionalStringMgrT<C, W, V>& mgr) {V::operator=(mgr); return *this;};
    iluOptionalStringMgrT<C, W, V>& operator= (const V& var) {V::operator=(var); return *this;};
    iluOptionalStringMgrT<C, W, V>& operator= (C* str) {V::operator=(str); return *this;};
    iluOptionalStringMgrT<C, W, V>& operator= (const C* str) {V::operator=(str); return *this;};
};

typedef iluOptionalStringMgrT<char, iluCStringWrapper, CORBA(String_var)> iluOptionalCStringMgr;
typedef iluOptionalStringMgrT<iluCharacter, iluWStringWrapper, iluWString_var> iluOptionalWStringMgr;


////////////////////////////////////////////////

/* TMP 6/29: Need revise for Object, Array, String, WideString */
/* TMP 6/29: Need sibling check on object after true call (how about before ?) */
/* TMP 7/5: What about types (including basics) that need wrappers to disambiguate themselves for I/O ? */

////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////
// Object types


template <class T>
    // T has an urType of Object
class iluOptionalObjectWrapperT {
    friend iluBaseCall& operator+= (iluBaseCall&, const iluOptionalObjectWrapperT<T>&);
    friend iluBaseCall& operator<< (iluBaseCall&, const iluOptionalObjectWrapperT<T>&);
    friend iluBaseCall& operator>> (iluBaseCall&, iluOptionalObjectWrapperT<T>&);
public:
    iluOptionalObjectWrapperT (T*& t, iluClass ilu_class) : _t(t), _io_wrapper(t, ILUCPP_FALSE, ilu_class) {};
        // surrogate in, surrogate inOut
        // TMP 6/22: is NULL default for iluClass useful ?
    iluOptionalObjectWrapperT () : _default_t(NULL), _t(_default_t) {};
        // true out, true return
    iluOptionalObjectWrapperT (iluClass ilu_class, T*& t) : _t(t), _io_wrapper(ILUCPP_FALSE, ilu_class) {};
        // surrogate out
    iluOptionalObjectWrapperT (iluClass ilu_class) : _t(_default_t), _io_wrapper(ILUCPP_FALSE, ilu_class) {};
        // surrogate return, true in, true inOut
    void revise () {_io_wrapper.iluReviseForObject(_t);};
    operator T *& () {return _t;};
    iluOptionalObjectWrapperT& operator= (T* t) {_io_wrapper.iluReviseForObject(t); _t = t; return *this;};
protected:
    T *& opt () {return _t;};
    const T * opt () const {return _t;};
    T * _default_t;
    T *& _t;
    iluObjectWrapper _io_wrapper;
};


template <class T, class D>
    // T has an urType of Object
    // D has an urType of Object
    // Use when a T parm is declared as "SIBLING" AND
    // when a sibling check is needed (as indicated below)
class iluOptionalSiblingObjectWrapperT: public iluOptionalObjectWrapperT<T> {
public:
    iluOptionalSiblingObjectWrapperT (D*const& discriminator, T*& t, iluClass);
        // surrogate in, surrogate inOut
        // sibling checked on construction
    iluOptionalSiblingObjectWrapperT (D*const& discriminator);
        // true out
        // sibling checked on revise
    iluOptionalSiblingObjectWrapperT (D*const& discriminator, iluClass);
        // true inOut
        // sibling checked on revise
    void revise ();
private:
    D*const& _discriminator;
    void _siblingCheck () const;
};


template <class T>
    // T is an Object type
class iluOptionalObjectMgrT: public iluTemplatableObject_var<T> {
    friend iluBaseCall& operator+= (iluBaseCall&, const iluOptionalObjectMgrT<T>&);
    friend iluBaseCall& operator<< (iluBaseCall&, const iluOptionalObjectMgrT<T>&);
    friend iluBaseCall& operator>> (iluBaseCall&, iluOptionalObjectMgrT<T>&);
public:
    iluOptionalObjectMgrT () : iluTemplatableObject_var<T>() {};
    iluOptionalObjectMgrT<T>& operator= (const iluOptionalObjectMgrT<T>& mgr) {iluTemplatableObject_var<T>::operator=(mgr); return *this;};
    iluOptionalObjectMgrT<T>& operator= (const iluTemplatableObject_var<T>& t_var) {iluTemplatableObject_var<T>::operator=(t_var); return *this;};
    iluOptionalObjectMgrT<T>& operator= (T* t_ptr) {iluTemplatableObject_var<T>::operator=(t_ptr); return *this;};
    void _surrogateSideCleanup() const {if (iluGetObjectPointer() != NULL) iluDeleteWrapper();};
};


//////////////////////////////////////////////////////////////////
// "Container" types containing Objects


template <class T>
class iluOptionalWithCleanupWrapperT: public iluOptionalWrapperT<T> {
public:
    iluOptionalWithCleanupWrapperT (const T * & t) : iluOptionalWrapperT<T>(t) {};
    iluOptionalWithCleanupWrapperT () : iluOptionalWrapperT<T>() {};
    ~iluOptionalWithCleanupWrapperT () {if (_t != NULL) _t->_surrogateSideCleanup();};
};


//////////////////////////////////////////////////////////////////
// Array types


template <class S, class V>
class iluOptionalArrayWrapperT: public iluOptionalWrapperBaseT<S> {
    // S is an Array's slice type
    // V is the Array's var type
public:
    iluOptionalArrayWrapperT (S *& s) : iluOptionalWrapperBaseT<S>(CONST_CAST(const S*&, s)) {};
    iluOptionalArrayWrapperT () : iluOptionalWrapperBaseT<S>() {};
    ~iluOptionalArrayWrapperT () {};
};


template <class S, class V>
    // S is an Array's slice type
    // V is the Array's var type
class iluOptionalArrayWithCleanupWrapperT: public iluOptionalArrayWrapperT<S, V> {
public:
    iluOptionalArrayWithCleanupWrapperT (S *& s) : iluOptionalArrayWrapperT<S, V>(s) {};
    iluOptionalArrayWithCleanupWrapperT () : iluOptionalArrayWrapperT<S, V>() {};
    ~iluOptionalArrayWithCleanupWrapperT () {V::_surrogateSideCleanup(_t);};
};

template <class S, class V>
    // S is an Array's slice type
    // V is the Array's var type
class iluOptionalArrayMgrT: public V {
    friend iluBaseCall& operator+= (iluBaseCall&, const iluOptionalArrayMgrT<S, V>&);
    friend iluBaseCall& operator<< (iluBaseCall&, const iluOptionalArrayMgrT<S, V>&);
    friend iluBaseCall& operator>> (iluBaseCall&, iluOptionalArrayMgrT<S, V>&);
public:
    iluOptionalArrayMgrT () : V() {};
    iluOptionalArrayMgrT<S, V>& operator= (const iluOptionalArrayMgrT<S, V>& var) {V::operator=(var); return *this;};
    iluOptionalArrayMgrT<S, V>& operator= (const V& var) {V::operator=(var); return *this;};
    iluOptionalArrayMgrT<S, V>& operator= (S* slice) {V::operator=(slice); return *this;};
};

template <class S, class V>
    // S is an Array's slice type
    // V is the Array's var type
class iluOptionalArrayWithCleanupMgrT: public iluOptionalArrayMgrT<S, V> {
public:
    iluOptionalArrayWithCleanupMgrT () : V() {};
    iluOptionalArrayWithCleanupMgrT<S, V>& operator= (const iluOptionalArrayWithCleanupMgrT<S, V>& var) {V::operator=(var); return *this;};
    iluOptionalArrayWithCleanupMgrT<S, V>& operator= (const V& var) {V::operator=(var); return *this;};
    iluOptionalArrayWithCleanupMgrT<S, V>& operator= (S* slice) {V::operator=(slice); return *this;};
    void _surrogateSideCleanup() const {if (_slice_ != NULL) V::_surrogateSideCleanup(_slice_);};
};


//////////////////////////////////////////////////////////////////
// Misc Operations for Optional Object Parameters


template <class T, class D>
inline
iluOptionalSiblingObjectWrapperT<T, D>::
iluOptionalSiblingObjectWrapperT (D*const& discriminator, T*& t, iluClass ilu_class)
  : iluOptionalObjectWrapperT<T>(t, ilu_class), _discriminator(discriminator)
{
    _siblingCheck();
}

template <class T, class D>
inline
iluOptionalSiblingObjectWrapperT<T, D>::
iluOptionalSiblingObjectWrapperT (D*const& discriminator)
  : iluOptionalObjectWrapperT<T>(), _discriminator(discriminator)
{
}

template <class T, class D>
inline
iluOptionalSiblingObjectWrapperT<T, D>::
iluOptionalSiblingObjectWrapperT (D*const& discriminator, iluClass ilu_class)
  : iluOptionalObjectWrapperT<T>(ilu_class), _discriminator(discriminator)
{
}

template <class T, class D>
inline
void
iluOptionalSiblingObjectWrapperT<T, D>::
_siblingCheck () const {
    if (_t != NULL && !_discriminator->iluInSameServer(_t)) {
        CORBA(BAD_PARAM) exception;
        throw(exception);
    };
}

template <class T, class D>
inline
void
iluOptionalSiblingObjectWrapperT<T, D>::
revise ()
{
    iluOptionalObjectWrapperT<T>::revise();
    _siblingCheck();
}

//////////////////////////////////////////////////////////////////
// IO Operators for Optional String Parameters

template <class C, class W>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalStringWrapperT<C, W>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(C*, ow.opt()));
    call += oldStyleWrapper;
    if (ow.opt() != NULL)
        call += CONST_CAST(W&, ow._io_wrapper);
    return call;
}

template <class C, class W>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalStringWrapperT<C, W>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(C*, ow.opt()));
    call << oldStyleWrapper;
    if (ow.opt() != NULL)
        call << CONST_CAST(W&, ow._io_wrapper);
    return call;
}

template <class C, class W>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalStringWrapperT<C, W>& ow) {
    iluOptionalWrapper oldStyleWrapper(ow.opt());
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        call >> ow._io_wrapper;
    }
    else
        ow.opt() = NULL;
    return call;
}


//////////////////////////////////////////////////////////////////
// IO Operators for Most Optional Parameters

template <class T>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(T*, ow.opt()));
    call += oldStyleWrapper;
    if (ow.opt() != NULL)
        call += *ow.opt();
    return call;
}

template <class T>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(T*, ow.opt()));
    call << oldStyleWrapper;
    if (ow.opt() != NULL)
        call << *ow.opt();
    return call;
}

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper(ow.opt());
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
            ow.opt() = new T;
        call >> *ow.opt();
    }
    else
        ow.opt() = NULL;
    return call;
}


//////////////////////////////////////////////////////////////////
// IO Operators for Optional Object Parameters

template <class T>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalObjectWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(T*, ow.opt()));
    call += oldStyleWrapper;
    if (oldStyleWrapper.m_present)
        call += *CONST_CAST(iluObjectWrapper*, &ow._io_wrapper);
        // TMP 6/22: until operator defined in ilucpp.hpp handles const iluObjectWrapper
    return call;
}

template <class T>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalObjectWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(T*, ow.opt()));
    call << oldStyleWrapper;
    if (oldStyleWrapper.m_present)
        call << *CONST_CAST(iluObjectWrapper*, &ow._io_wrapper);
        // TMP 6/22: until operator defined in ilucpp.hpp handles const iluObjectWrapper
    return call;
}

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalObjectWrapperT<T>& ow) {
    iluOptionalWrapper oldStyleWrapper;
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present)
        call >> ow._io_wrapper;
    else
        ow._io_wrapper.iluReviseForObject(NULL);  // TMP 6/22: is this ok ?
    ow._t = REINTERPRET_CAST(T*, ow._io_wrapper.m_pv_iluobject);
    return call;
}


//////////////////////////////////////////////////////////////////
// Misc Operations for Optional String Parameters

template <class C, class W>
inline
iluOptionalStringWrapperT<C, W>::iluOptionalStringWrapperT<C, W> (const C*& t, iluByte delete_when)
  : iluOptionalWrapperBaseT<C>(t), _length(t == NULL ? 0 : iluStringLength(t)), _io_wrapper(t, _length, delete_when)
{
}

template <class C, class W>
inline
iluOptionalStringWrapperT<C, W>::iluOptionalStringWrapperT<C, W> (iluByte delete_when)
  : iluOptionalWrapperBaseT<C>(), _io_wrapper(_default_t, _length, delete_when)
{
}

template <class C, class W>
inline
void
iluOptionalStringWrapperT<C, W>::revise () {
    if (opt() != NULL)
        _length = iluStringLength(opt());
}


//////////////////////////////////////////////////////////////////
// IO Operators for Optional Array Parameters

template <class S, class V>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalArrayWrapperT<S, V>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(S*, ow.opt()));
    call += oldStyleWrapper;
    if (ow.opt() != NULL)
        V::_size_const(call, ow.opt());
    return call;
}

template <class S, class V>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalArrayWrapperT<S, V>& ow) {
    iluOptionalWrapper oldStyleWrapper(CONST_CAST(S*, ow.opt()));
    call << oldStyleWrapper;
    if (ow.opt() != NULL)
        V::_output_const(call, ow.opt());
    return call;
}

template <class S, class V>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalArrayWrapperT<S, V>& ow) {
    iluOptionalWrapper oldStyleWrapper(ow.opt());
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        ow.opt() = V::_alloc();
        V::_input(call, ow.opt());
    }
    else
        ow.opt() = NULL;
    return call;
}



//////////////////////////////////////////////////////////////////
// IO Operators for iluTemplatableT_var<T>
// TMP 8/23: Are these made obsolete by the operators below for iluOptionalMgrT<T> ?

template <class T>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluTemplatableT_var<T>& var) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(iluTemplatableT_var<T>&, var)));
    call += oldStyleWrapper;
    if (!var.iluIsNull())
// TMP 9/3 SRJ        call += STATIC_CAST(T&, var);
        call += STATIC_CAST(const T&, var);  // TMP 9/3 SRJ
    return call;
}

template <class T>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluTemplatableT_var<T>& var) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(iluTemplatableT_var<T>&, var)));
    call << oldStyleWrapper;
    if (!var.iluIsNull())
// TMP 9/3 SRJ        call << STATIC_CAST(T&, var);
        call << STATIC_CAST(const T&, var);  // TMP 9/3 SRJ
    return call;
}

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluTemplatableT_var<T>& var) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, var));
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        var = new T;
        call >> *STATIC_CAST(T*, var);
    }
    else
        var = STATIC_CAST(T*, NULL);
    return call;
}


//////////////////////////////////////////////////////////////////
// IO Operators for Most Embedded Typekinds
// TMP 8/23: Do these obsolete the operators above on iluTemplatableT_var<T> ?


template <class T>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalMgrT<T>& mgr) {
	typedef iluOptionalMgrT<T> MgrType;  // Use this below to avoid pre-processor parsing problems
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(MgrType&, mgr)));
	// TMP 8/23: CONST_CAST needed above because iluOptionalT_var doesn't have an operation to return a const T*
    call += oldStyleWrapper;
    if (!mgr.iluIsNull())
// TMP 9/5        call += STATIC_CAST(T&, mgr);
        call += STATIC_CAST(const T&, mgr);  // TMP 9/5: NEW
    return call;
}

template <class T>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalMgrT<T>& mgr) {
	typedef iluOptionalMgrT<T> MgrType;  // Use this below to avoid pre-processor parsing problems
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(MgrType&, mgr)));
	// TMP 8/23: CONST_CAST needed above because iluOptionalT_var doesn't have an operation to return a const T*
    call << oldStyleWrapper;
    if (!mgr.iluIsNull())
// TMP 9/5        call << STATIC_CAST(T&, mgr);
        call << STATIC_CAST(const T&, mgr);  // TMP 9/5: NEW
    return call;
}

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalMgrT<T>& mgr) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, mgr));
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
		mgr = new T;
        call >> STATIC_CAST(T&, mgr);
	}
	else
		mgr = STATIC_CAST(T*, NULL);
    return call;
}



//////////////////////////////////////////////////////////////////
// IO Operators for Embedded Optional Arrays


template <class S, class V>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalArrayMgrT<S, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr._slice_);
    call += oldStyleWrapper;
    if (mgr._slice_ != NULL)
        V::_size(call, mgr);
    return call;
}

template <class S, class V>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalArrayMgrT<S, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr._slice_);
    call << oldStyleWrapper;
    if (mgr._slice_ != NULL)
        V::_output(call, mgr);
    return call;
}

template <class S, class V>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalArrayMgrT<S, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr._slice_);
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        mgr = V::_alloc();
        V::_input(call, mgr);
    }
    else
        mgr = NULL;
    return call;
}



//////////////////////////////////////////////////////////////////
// IO Operators for Embedded Optional Objects


template <class T>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalObjectMgrT<T>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluGetObjectPointer());
    call += oldStyleWrapper;
    if (!mgr.iluIsNull())
        call += *STATIC_CAST(const iluTemplatableObject_var<T>*, &mgr);
    return call;
}

template <class T>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalObjectMgrT<T>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluGetObjectPointer());
    call << oldStyleWrapper;
    if (!mgr.iluIsNull())
        call << *STATIC_CAST(const iluTemplatableObject_var<T>*, &mgr);
    return call;
}

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalObjectMgrT<T>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluGetObjectPointer());
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present)
        call >> *STATIC_CAST(iluTemplatableObject_var<T>*, &mgr);
    return call;
}



//////////////////////////////////////////////////////////////////
// IO Operators for Optional Enumeration Parameters

// Other IO Operators are inherited from iluOptionalNonUniqueWrapperT<iluDummyEnum, iluEnumWrapper> 

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalEnumerationWrapperT<T>& ow) {
// TMP 8/25    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, ow));
    iluOptionalWrapper oldStyleWrapper(ow.opt());  // TMP 8/25
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
// TMP 8/25		ow = REINTERPRET_CAST(iluDummyEnum*, new T);
		ow.opt() = new iluDummyEnum;  // TMP 8/25
		call >> iluEnumWrapper(*ow.opt());
    }
    else
// TMP 8/25        ow = STATIC_CAST(iluDummyEnum*, NULL);
        ow.opt() = NULL;  // TMP 8/25
    return call;
}

//////////////////////////////////////////////////////////////////
// IO Operators for Embedded Optional Enumerations

// Other IO Operators are inherited from iluOptionalNonUniqueMgrT<iluDummyEnum, iluEnumWrapper> 

template <class T>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalEnumerationMgrT<T>& mgr) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*&, mgr));
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        mgr = new T;
        call >> iluEnumWrapper(*REINTERPRET_CAST(iluDummyEnum*, STATIC_CAST(T*, mgr)));
	}
	else
        mgr = STATIC_CAST(T*, NULL);
    return call;
}


////////////////////////////////////////////////

template <class T, class W>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalNonUniqueWrapperT<T, W>& ow) {
    typedef iluOptionalNonUniqueWrapperT<T, W> wrapperType;  // Use this below to avoid pre-processor parsing problems
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(wrapperType&, ow)));
    call += oldStyleWrapper;
    if (ow.opt() != NULL)
        call += W((T&)ow);
    return call;
}

template <class T, class W>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalNonUniqueWrapperT<T, W>& ow) {
    typedef iluOptionalNonUniqueWrapperT<T, W> wrapperType;  // Use this below to avoid pre-processor parsing problems
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, CONST_CAST(wrapperType&, ow)));
    call << oldStyleWrapper;
    if (ow.opt() != NULL)
        call << W((T&)ow);
    return call;
}

template <class T, class W>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalNonUniqueWrapperT<T, W>& ow) {
    iluOptionalWrapper oldStyleWrapper(STATIC_CAST(T*, ow));
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present) {
        ow = new T;
        call >> W(*STATIC_CAST(T*, ow));
    }
    else
        ow = STATIC_CAST(T*, NULL);
    return call;
}



//////////////////////////////////////////////////////////////////
// IO Operators for Embedded Optional Strings


template <class C, class W, class V>
inline
iluBaseCall&
operator+= (iluBaseCall& call, const iluOptionalStringMgrT<C, W, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluStringVarReference());
    call += oldStyleWrapper;
    if (!mgr.iluIsNull())
        call += iluOptionalStringWrapperT<C, W>(mgr.iluStringVarReference());
    return call;
}

template <class C, class W, class V>
inline
iluBaseCall&
operator<< (iluBaseCall& call, const iluOptionalStringMgrT<C, W, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluStringVarReference());
    call << oldStyleWrapper;
    if (!mgr.iluIsNull())
        call << iluOptionalStringWrapperT<C, W>(mgr.iluStringVarReference());
    return call;
}

template <class C, class W, class V>
inline
iluBaseCall&
operator>> (iluBaseCall& call, iluOptionalStringMgrT<C, W, V>& mgr) {
    iluOptionalWrapper oldStyleWrapper(mgr.iluStringVarReference());
    call >> oldStyleWrapper;
    if (oldStyleWrapper.m_present)
        call >> iluOptionalStringWrapperT<C, W>(mgr.iluStringVarReference());
    return call;
}


//////////////////////////////////////////////////////////////////
// TMP 8/18: Temporary workaround for const types

// TMP 8/18: Until operators in src/runtime/ilu.hpp can be changed

#define TMP_DEF_CONST_IO_OPS(T)                  \
												 \
	inline										 \
	iluBaseCall&								 \
	operator+= (iluBaseCall& call, const T& t) { \
		return call += *CONST_CAST(T*, &t);		 \
	}											 \
												 \
	inline										 \
	iluBaseCall&								 \
	operator<< (iluBaseCall& call, const T& t) { \
		return call << *CONST_CAST(T*, &t);		 \
	}


TMP_DEF_CONST_IO_OPS(iluLongInteger)
TMP_DEF_CONST_IO_OPS(iluLongCardinal)
TMP_DEF_CONST_IO_OPS(iluLongReal)


////////////////////////////////////////////////
// TMP 8/22: footypes-cpp.cpp used to generate the following errors in MSVC 5.0. They were triggered by
// calls to "+=" and "<<" for iluOptionalMgrT<T>, where T was one of the types below.
// The casts used in the "+=" and "<<" operators below seem to be what makes the compiler happy.

/*
error C2084: function 'iluTemplatableT_var<unsigned short>::operator`unsigned short &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<char>::operator`char &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<int>::operator`int &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<short>::operator`short &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<struct ilu_longinteger>::operator`ilu_longinteger &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<unsigned int>::operator`unsigned int &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<double>::operator`double &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<float>::operator`float &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<struct ilu_longreal>::operator`ilu_longreal &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<unsigned char>::operator`unsigned char &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<enum iluDummyEnum>::operator`enum iluDummyEnum &'(void)const ' already has a body
error C2084: function 'iluTemplatableT_var<struct footypes_OptRecBase>::operator`struct footypes_OptRecBase &'(void)const ' already has a body
*/

/* TMP 8/23
#ifdef _MSC_VER

	template <class T>
	inline
	iluBaseCall&
	operator+= (iluBaseCall& call, const iluOptionalMgrBaseT<T>& mgr) {
		call += (STATIC_CAST(T&, mgr));
		return call;
	}

	template <class T>
	inline
	iluBaseCall&
	operator<< (iluBaseCall& call, const iluOptionalMgrBaseT<T>& mgr) {
		call << (STATIC_CAST(T&, mgr));
		return call;
	}

#endif

TMP 8/23 */



#endif // __optionaltemplates_hpp_
																			
