
/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: cppparsestream.hpp,v 1.4 1998/10/09 18:18:52 pnewman Exp $
*/

#ifndef __cppparsesteam_hpp_
#define __cppparsesteam_hpp_ 1

#include <iostream.h>
#include <fstream.h>
#include "cppportability.hpp"


/* MSVC4.1 Compiler Note #1 */
const unsigned CppParseStream_Indent_maxValue = 125;
const unsigned CppParseStream_Indent_spacesPerIncr = 4;


#define CppParseStream_(name) NAME_INSIDE_SCOPE(CppParseStream, name)
#define CppParseStream(name) NAME_OUTSIDE_SCOPE(CppParseStream, name)

BEGIN_NAMESPACE(CppParseStream)

  class CppParseStream_(ofstream);

  class CppParseStream_(Indent) {
    friend ofstream;
    public:
      CppParseStream_(Indent) (unsigned value = 0) {initMargin(); set(value);}
      const char * margin () {return _margin;}
      CppParseStream_(Indent)& operator= (unsigned value) {set(value); return *this;}
      CppParseStream_(Indent)& operator= (const CppParseStream_(Indent)& to) {set(to._value); return *this;}
      operator unsigned () {return _value;}
      unsigned operator++ () {incr(); return _value;}
      unsigned operator++ (int) {unsigned rtn = _value; incr(); return rtn;}
      unsigned operator-- () {decr(); return _value;}
      unsigned operator-- (int) {unsigned rtn = _value; decr(); return rtn;}
    public:
      static const unsigned maxValue;
      static const unsigned spacesPerIncr;
    private:
      unsigned _value;
      char _margin[CppParseStream_Indent_maxValue*CppParseStream_Indent_spacesPerIncr];
      unsigned marginLen;
      void set (unsigned value) {
        _value = (value > maxValue) ? maxValue : value;
        setMargin();
      }
      void incr () {
        if (_value < maxValue) _value++;
        setMargin();
       }
      void decr () {
        if (_value > 0) _value--;
        setMargin();
        }
      void setMargin () {
        _margin[marginLen] = ' ';
        marginLen = _value*spacesPerIncr;
        _margin[marginLen] = '\0';
        }
      void initMargin () {
        for (unsigned i = 0; i < maxValue*spacesPerIncr; _margin[i++] = ' ');
        marginLen = 0;
      }
  };


/* A "dynamic output source" is essentially a callback mechanism which allows the client of a stream to create output on the fly, in response to invocation of the insertion operator (<<). DynOutObj and DynOutMethod are an object/method pair implementing the callback, and a DynOutSrc packages them together; the << operator is overloaded on DynOutSrc.

DynOutMethod is a pointer to member function, which allows a given DynOutObj to support multiple DynOutMethod's. A DynOutMethod receives the invoking stream as an argument, and will typically return the same stream.

As a typical scenario, a class A inherits from DynOutObj, and supports two DynOutSrc's, which are accessed via member functions message1 and message2:

  class A: public CppParseStream::DynOutObj {
    public:
      CppParseStream::DynOutSrc message1 () {return {this, &msg1};}
      CppParseStream::DynOutSrc message2 () {return {this, &msg2};}
    private:
      CppParseStream::ofstream & msg1 (CppParseStream::ofstream & ofs) {
        <do some output, using ofs>
        return ofs;
      }
      CppParseStream::ofstream & msg2 (CppParseStream::ofstream & ofs) {
        <do some output, using ofs>
        return ofs;
      }
    <other A-specific members>
  };

  CppParseStream::ofstream ofs;
  A * a;
  ...
  ofs << "Message #1 from a: " << a->message1() << endl;
  ofs << "Message #2 from a: " << a->message2() << endl;

*/

  // Declare CppParseStream::DynOutObj
  class CppParseStream_(DynOutObj) {
    virtual void _dummy () {}
    // MSVC4.1 Compiler Note #2, SunPro4.1 Compiler Note #1
  };

  // Declare CppParseStream::DynOutMethod
  typedef CppParseStream_(ofstream) & (CppParseStream_(DynOutObj)::*CppParseStream_(DynOutMethod))(CppParseStream_(ofstream) &);

  // Declare CppParseStream::DynOutSrc
  struct CppParseStream_(DynOutSrc) {
    const CppParseStream_(DynOutObj) * obj;
    CppParseStream_(DynOutMethod) method;
  };

  typedef CppParseStream_(ofstream) & (CppParseStream_(DynOutProc))(CppParseStream_(ofstream) &);

  class CppParseStream_(ofstream): public ::ofstream {
    public:
      CppParseStream_(ofstream) ();
      CppParseStream_(ofstream) (const char *file, int mode);
      CppParseStream_(ofstream) & operator << (CppParseStream_(DynOutSrc) s) {return (s.obj->*s.method)(*this);}
      CppParseStream_(ofstream) & operator << (CppParseStream_(DynOutProc) *p) {return p(*this);}
      CppParseStream_(ofstream) & operator << (const char *);
      CppParseStream_(ofstream) & operator << (long);
      CppParseStream_(ofstream) & operator << (::ostream & (*pf)(::ostream &));
      void newl () {_newline = ILUCPP_TRUE;}
      ILUCPP_BOOL newline () {return _newline;}
      CppParseStream_(Indent) indent;
      #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #2
        int is_open () {return rdbuf()->is_open();}
      #endif  // __SUNPRO_CC
    private:
      ILUCPP_BOOL _newline;  // TEMP: need a comment here
  };

END_NAMESPACE;  //  CppParseStream


inline
CppParseStream(ofstream) &
newl (CppParseStream(ofstream) & ofs)  {
  ofs.newl();
  return (ofs);
}

inline
CppParseStream(ofstream) &
CppParseStream(ofstream)::operator << (::ostream & (*pf)(::ostream &)) {
#ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #3
  static ::ostream & (*endlptr)(::ostream &) = endl;
  if (pf == endlptr)
#else 
  if (pf == endl)
#endif  // __SUNPRO_CC
    _newline = ILUCPP_TRUE;
  pf(*this);
  return *this;
}


#endif  // __cppparsesteam_hpp_



/*

    MSVC4.1 Compiler Note #1 - We define CppParseStream_Indent_maxValue and CppParseStream_Indent_spacesPerIncr because Visual C++ 4.1 won't allow us to use CppParseStream::Indent::maxValue and CppParseStream::Indent::spacesPerIncr in declaration of CppParseStream::Indent::_margin.

    MSVC4.1 Compiler Note #2, SunPro4.1 Compiler Note #1 - If there is not at least one virtual function in OutSrc, a runtime error (MSVC4.1: "... instruction at XXXXXXXXX referenced memory at XXXXXXXXX..."; SunPro4.1: Segment Fault) will occur when attempting to execute an OutMsg referring to a virtual function in a class derived from OutSrc. (_dummy need not be invoked nor implemented by any derived class).

    SunPro4.1 Compiler Note #2 - ANSI C++ (April 1995 Working Paper, X3J16/95-0087) calls for is_open() to be introduced by basic_ofstream (a base class of ofstream).

    SunPro4.1 Compiler Note #3 - The SunPro "endl" is an overloaded function, and the compiler needs help to determine which version to use in the comparison to "pf".

*/
