/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: cppparsestream.cpp,v 1.9 1998/10/09 18:18:17 pnewman Exp $
*/

/* Output Stream for ISL Parser C++ backend */

extern "C" {
#include <assert.h>
#include <limits.h>
}

#include <iostream.h>

#include "cppparsestream.hpp"


/*
    Compiler note: We'd like to initialize maxValue and spacesPerIncr in the
    declaration of CppParseStream::Indent, but Visual C++ 4.1 doesn't allow it.
*/

const unsigned CppParseStream(Indent)::maxValue = CppParseStream_Indent_maxValue;
const unsigned CppParseStream(Indent)::spacesPerIncr = CppParseStream_Indent_spacesPerIncr;

class IndentAssert {
  public: IndentAssert() {
    assert(
      CppParseStream(Indent)::maxValue*CppParseStream(Indent)::spacesPerIncr <
      UINT_MAX);}
};

const IndentAssert indentAssert;

#ifdef _MSC_VER
#define OFSTREAM_PARENT ostream
#else
#define OFSTREAM_PARENT ::ofstream
#endif  // _MSC_VER

CppParseStream(ofstream)::
CppParseStream_(ofstream) ()
  : ::ofstream(), _newline(ILUCPP_FALSE)
  {}

CppParseStream(ofstream) &
CppParseStream(ofstream)::
operator << (const char * s) {
  if (_newline)
    OFSTREAM_PARENT::operator<<(indent.margin());
  OFSTREAM_PARENT::operator<<(s);
  _newline = ILUCPP_FALSE;
  return(*this);
}

CppParseStream(ofstream) &
CppParseStream(ofstream)::
operator << (long n) {
  if (_newline)
    OFSTREAM_PARENT::operator<<(indent.margin());
  OFSTREAM_PARENT::operator<<(n);
  _newline = ILUCPP_FALSE;
  return(*this);
}

CppParseStream(ofstream)::
CppParseStream_(ofstream) (const char *file, int mode)
  : ::ofstream(file, mode)
  {}
