/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: cppparsename.cpp,v 1.36 1998/10/09 18:18:17 pnewman Exp $
*/

#ifdef __GNUC__
#pragma implementation "cppparsename.hpp"
#endif  // __GNUC__

#include <string.h>
#include <stdlib.h>  // for bsearch

#include "cppparse.hpp"
#include "cppparsename.hpp"
#include "iluptypecpp.hpp"


/*
  Forward declarations
*/

static
int
keyToUsage (CppParseName(Key));
// If key maps to a valid CppParseName::TypeUsage, returns it's numeric value;
// else, returns -1


template <class KEY_OR_USAGE>
TEMPLATE_STATIC
const char *
getCacheKey (KEY_OR_USAGE, const CppParseName(Scope) * definedIn, const CppParseName(Scope) * context);


/* TMP 9/6
// SunPro4.1 Compiler Note #1
template <class KEY_OR_USAGE>
TEMPLATE_STATIC
const char *
keyOrUsageToKey (KEY_OR_USAGE);
TMP 9/6 */

// SunPro4.1 Compiler Note #1
template <class KEY_OR_USAGE>  // TMP 9/6: NEW
TEMPLATE_STATIC
const char *
keyOrUsageToKey (KEY_OR_USAGE, const CppParseName(Scope) * definedIn, const CppParseName(Scope) * context);


template <class NAME_OR_TYPENAME, class KEY_OR_USAGE>
TEMPLATE_STATIC
const char *
// TMP 7/5getName (NAME_OR_TYPENAME *, ::iluptype::Name, KEY_OR_USAGE, const CppParseName(Scope) * context);
getName (  // TMP 7/6: NEW
    NAME_OR_TYPENAME *,
    ::iluptype::Name,
    KEY_OR_USAGE,
    const CppParseName(Scope) * context,
    const CppParseName(AffixPair) * affixes);

static
int
bsearch_callback (const void * keyval, const void * datum);

static
ILUCPP_BOOL
isCppKeyword (const char *);

static
const char *
catStrings (const char *, const char *);


static const CppParseName(Key) underscore_key = "underscore";  // TMP 8/27: NEW

#ifdef __GNUC__  // G++2.7.1 Compiler Note #1
  typedef ::iluptype::name_s iluptype_name_s_for_gnu;
  #define ILUPTYPE_NAME_S iluptype_name_s_for_gnu
  typedef ::iluptype::ilu_interface_s iluptype_ilu_interface_s_for_gnu;
  #define ILUPTYPE_ILU_INTERFACE_S iluptype_ilu_interface_s_for_gnu
  typedef ::iluptype::list_s iluptype_list_s_for_gnu;
  #define ILUPTYPE_LIST_S iluptype_list_s_for_gnu
#else
  #define ILUPTYPE_NAME_S ::iluptype::name_s
  #define ILUPTYPE_ILU_INTERFACE_S ::iluptype::ilu_interface_s
  #define ILUPTYPE_LIST_S ::iluptype::list_s
#endif  // __GNUC__

const ILUPTYPE_ILU_INTERFACE_S nullIluptypeInterfaceS = {
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL};
const ILUPTYPE_NAME_S nullIluptypeNameS = {NULL, NULL};
const ILUPTYPE_LIST_S nullIluptypeListS = {NULL, NULL, 0};

struct SelfInitializingPName : public ::iluptype::name_s {
  public:
    SelfInitializingPName ()
      : ILUPTYPE_NAME_S(nullIluptypeNameS),
        pSet(nullIluptypeListS)
      {
	langnames = &pSet;
      }
    SelfInitializingPName (const char * n)
      : ILUPTYPE_NAME_S(nullIluptypeNameS),
        pSet(nullIluptypeListS)
      {
	langnames = &pSet;
	if (n == NULL)
	  n = "";
	base_name = new char[strlen(n) + 1];
        // TEMP: should check for allocation failure
	strcpy(base_name, n);
      }
    ~SelfInitializingPName ()
      {
	delete base_name;
      }
  private:
    ::iluptype::list_s pSet;
};


struct InitablePInterface : public ::iluptype::ilu_interface_s {
  public:
    InitablePInterface (const char * base)
      : ILUPTYPE_ILU_INTERFACE_S(nullIluptypeInterfaceS)
      {
        name = &pName;
        iluptype::_name_set_base_name(&pName, base);
      }
  private:
    SelfInitializingPName pName;
};

static InitablePInterface corba_interface_s("CORBA");
::iluptype::ilu_interface_s * CppParseName(CorbaInterface) = &corba_interface_s;

#define DEF_CORBA_NAME(name)                                           \
  const CppParseName(Name) *                                           \
  CppParseName(Corba ## name) () {                                     \
    static SelfInitializingPName pName(#name);                         \
    static const CppParseName(Scope) * corbaScope                      \
      =  CppParse(InterfaceFactory)::findOrCreate(&corba_interface_s); \
    static const CppParseName(Name) rtn(&pName, corbaScope);           \
    return &rtn;                                                       \
  }

DEF_CORBA_NAME(Boolean);
DEF_CORBA_NAME(ULong);
DEF_CORBA_NAME(String_var);
DEF_CORBA_NAME(Object);
DEF_CORBA_NAME(Object_ptr);
DEF_CORBA_NAME(OBJECT_NIL);
DEF_CORBA_NAME(SystemException);
DEF_CORBA_NAME(UserException);
DEF_CORBA_NAME(UNKNOWN);
DEF_CORBA_NAME(COMPLETED_NO);
DEF_CORBA_NAME(COMPLETED_MAYBE);
DEF_CORBA_NAME(BAD_PARAM);


/* TMP 9/6
static SelfInitializingPName iluCStringPName("char*");  // TMP 9/6: NEW
static const CppParseName(Name) iluCStringName(&iluCStringPName, NULL);  // TMP 9/6: NEW
TMP 9/6 */
const CppParseName(Name) *  // TMP 9/6: NEW
CppParseName(iluCString) () {
	static SelfInitializingPName pName("char*");
	static const CppParseName(Name) rtn(&pName, NULL);
	return &rtn;
};


#define DEF_NAME_KEYS(keybase)                                                             \
  static const char key_ ## keybase ## _local[]          = "C++" #keybase;                 \
  static const char key_ ## keybase ## _fullyQualified[] = "C++" #keybase "FullyQualified"


DEF_NAME_KEYS(name);
DEF_NAME_KEYS(in);
DEF_NAME_KEYS(out);
DEF_NAME_KEYS(inOut);
DEF_NAME_KEYS(rtn);
DEF_NAME_KEYS(member);
DEF_NAME_KEYS(element);
DEF_NAME_KEYS(var);
DEF_NAME_KEYS(ptr);
DEF_NAME_KEYS(slice);
DEF_NAME_KEYS(constRef);


class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    void reset () {
        str[0] = '\0';
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }
    char * str;
    int maxLen;
};


static  // TMP 6/15: NEW
ILUCPP_BOOL
isCorbaObject (::iluptype::Type type) {
// TMP 9/6    const char * interface_name = iluptype::_interface_name(type->interface);
    return (
        iluptype::_type_kind(type) == iluptype::object_Type &&
        strcmp("CORBA-Object", iluptype::_name_base_name(type->name)) == 0 &&
        iluptype::_interface_name(type->interface) != NULL &&
        strcmp("ilu", iluptype::_interface_name(type->interface)) == 0
        );
}

static  // 9/6: NEW
ILUCPP_BOOL
isIluCString (::iluptype::Type type) {
    const char * interface_name = iluptype::_interface_name(type->interface);
    return (
        iluptype::_type_kind(type) == iluptype::sequence_Type &&
        iluptype::_type_kind(iluptype::_type_description(type)->structuredDes.sequence.type) == iluptype::shortcharacter_Type &&
        iluptype::_interface_name(type->interface) != NULL &&
        strcmp("ilu", iluptype::_interface_name(type->interface)) == 0 &&
		strcmp("CString", iluptype::_name_base_name(type->name)) == 0
        );
}

ILUCPP_BOOL  // 9/6: NEW
CppParseName(isIluCString) (const CppParseName(Name) * name) {
    return name->baseName() != NULL && strcmp(name->baseName(), CppParseName(iluCString())->baseName()) == 0;
}


#ifdef __SUNPRO_CC  // See note in cppparse.hpp

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Name n, const CppParseName_(Scope) *  ns)
    : definedIn(CONST_CAST(CppParseName(Scope)*, ns)),
      pName(n),
      sName(NULL),
      ownPName(ILUCPP_FALSE){
  }

  void
  CppParseName(Name)::
  reInit (::iluptype::Name n, const CppParseName_(Scope) *  ns) {
    pName = n;
    definedIn = CONST_CAST(CppParseName(Scope)*, ns);
    sName = NULL,
    ownPName = ILUCPP_FALSE;
  }

/* TMP 9/6
  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Type type)
// TMP 6/15    : definedIn(CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type))),
    : definedIn(isCorbaObject(type)  // TMP 6/15: NEW
          ? CppParseName_(CorbaObject)()->definedIn  // TMP 6/15: NEW
          : CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type))),  // TMP 6/15: NEW
// TMP 6/15      pName(type->name),
      pName(isCorbaObject(type)  // TMP 6/15: NEW
          ? CppParseName_(CorbaObject)()->pName  // TMP 6/15: NEW
          : type->name),  // TMP 6/15: NEW
      sName(NULL),
      ownPName(ILUCPP_FALSE){
  }

  void
  CppParseName(Name)::
  reInit (::iluptype::Type type) {
// TMP 6/15    pName = type->name;
// TMP 6/15    definedIn = CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type));
    definedIn = isCorbaObject(type)  // TMP 6/15: NEW
        ? CppParseName_(CorbaObject)()->definedIn  // TMP 6/15: NEW
        : CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type));  // TMP 6/15: NEW
    pName = isCorbaObject(type)  // TMP 6/15: NEW
        ? CppParseName_(CorbaObject)()->pName  // TMP 6/15: NEW
        : type->name;  // TMP 6/15: NEW
    sName = NULL;
    ownPName = ILUCPP_FALSE;
  }
TMP 9/6 */

  CppParseName(Name)::  // TMP 9/6: NEW
  CppParseName_(Name) (::iluptype::Type type)
    : definedIn(
	      isCorbaObject(type) ? CppParseName_(CorbaObject)()->definedIn :
	      isIluCString(type) ? CppParseName_(iluCString)()->definedIn :
          CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type))),
      pName(
	      isCorbaObject(type) ? CppParseName_(CorbaObject)()->pName :
	      isIluCString(type) ? CppParseName_(iluCString)()->pName :
          type->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE){
  }

  void  // TMP 9/6: NEW
  CppParseName(Name)::
  reInit (::iluptype::Type type) {
    definedIn =
		isCorbaObject(type) ? CppParseName_(CorbaObject)()->definedIn :
		isIluCString(type) ? CppParseName_(iluCString)()->definedIn :
        CONST_CAST(CppParseName(Scope)*, CppParse(InterfaceForType)(type));
    pName =
		isCorbaObject(type) ? CppParseName_(CorbaObject)()->pName :
		isIluCString(type) ? CppParseName_(iluCString)()->pName :
        type->name;
    sName = NULL;
    ownPName = ILUCPP_FALSE;
  }

  CppParseName(Name)::  // TMP 7/3: NEW
  CppParseName_(Name) (::iluptype::Procedure proc)  // TMP 7/3: NEW
    : definedIn(CppParse(ObjectFactory)::findOrCreate(proc->object)),  // TMP 7/3: NEW
      pName(proc->name),  // TMP 7/3: NEW
      sName(NULL),  // TMP 7/3: NEW
      ownPName(ILUCPP_FALSE){  // TMP 7/3: NEW
  }  // TMP 7/3: NEW

  void  // TMP 7/3: NEW
  CppParseName(Name)::  // TMP 7/3: NEW
  reInit (::iluptype::Procedure proc) {  // TMP 7/3: NEW
    pName = proc->name;  // TMP 7/3: NEW
    definedIn = CppParse(ObjectFactory)::findOrCreate(proc->object),  // TMP 7/3: NEW;
    sName = NULL,  // TMP 7/3: NEW
    ownPName = ILUCPP_FALSE;  // TMP 7/3: NEW
  }  // TMP 7/3: NEW

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Imported imported)
    : definedIn(NULL),
      pName(NULL),
      sName(imported->name),
      ownPName(ILUCPP_FALSE){
  }

  void
  CppParseName(Name)::
  reInit (::iluptype::Imported imported) {
    definedIn = CONST_CAST(CppParseName(Scope)*, NULL);
    pName = NULL;
    sName = imported->name; 
    ownPName = ILUCPP_FALSE;
  }

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Interface interface)
    : definedIn(NULL),
      pName(interface->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE){
  }

  void
  CppParseName(Name)::
  reInit (::iluptype::Interface interface) {
    pName = interface->name;
    definedIn = NULL;
    sName = NULL,
    ownPName = ILUCPP_FALSE;
  }

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Exception exception)
  : definedIn(CppParse(InterfaceFactory)::findOrCreate(exception->interface)),
      pName(exception->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE) {
  }

  void
  CppParseName(Name)::
  reInit (::iluptype::Exception exception) {
    definedIn = CppParse(InterfaceFactory)::findOrCreate(exception->interface);
    pName = exception->name;
    sName = NULL,
    ownPName = ILUCPP_FALSE;
  }

  CppParseName(Name)::
  CppParseName_(Name) (const char * s, const CppParseName_(Scope) *  ns)
    : definedIn(CONST_CAST(CppParseName(Scope)*, ns)),
      pName(NULL),
      sName(s),
      ownPName(ILUCPP_FALSE){
  }

  void
  CppParseName(Name)::
  reInit (const char * s, const CppParseName_(Scope) *  ns) {
    definedIn = CONST_CAST(CppParseName(Scope)*, ns);
    pName = NULL;
    sName = s; 
    ownPName = ILUCPP_FALSE;
    // TEMP: should check allocation of pName
  }

#else

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Name n, const CppParseName_(Scope) *  ns)
    : definedIn(ns),
      pName(n),
      sName(NULL),
      ownPName(ILUCPP_FALSE) {
  }

/* TMP 9/6
  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Type type)
// TMP 6/15    : definedIn(CppParse(InterfaceForType)(type)),
    : definedIn(isCorbaObject(type)  // TMP 6/15: NEW
          ? CppParseName_(CorbaObject)()->definedIn  // TMP 6/15: NEW
          : CppParse(InterfaceForType)(type)),  // TMP 6/15: NEW
// TMP 6/15      pName(type->name),
      pName(isCorbaObject(type)  // TMP 6/15: NEW
          ? CppParseName_(CorbaObject)()->pName  // TMP 6/15: NEW
          : type->name),  // TMP 6/15: NEW
      sName(NULL),
      ownPName(ILUCPP_FALSE) {
  }
TMP 9/6 */

  CppParseName(Name)::  // TMP 9/6: NEW
  CppParseName_(Name) (::iluptype::Type type)
    : definedIn(
	      isCorbaObject(type) ? CppParseName_(CorbaObject)()->definedIn :
	      isIluCString(type) ? CppParseName_(iluCString)()->definedIn :
          CppParse(InterfaceForType)(type)),
      pName(
	      isCorbaObject(type) ? CppParseName_(CorbaObject)()->pName :
	      isIluCString(type) ? CppParseName_(iluCString)()->pName :
          type->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE){
  }

  CppParseName(Name)::  // TMP 7/3: NEW
  CppParseName_(Name) (::iluptype::Procedure proc)  // TMP 7/3: NEW
    : definedIn(CppParse(ObjectFactory)::findOrCreate(proc->object)),  // TMP 7/3: NEW
      pName(proc->name),  // TMP 7/3: NEW
      sName(NULL),  // TMP 7/3: NEW
      ownPName(ILUCPP_FALSE){  // TMP 7/3: NEW
  }  // TMP 7/3: NEW

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Imported imported)
    : definedIn(NULL),
      pName(NULL),
      sName(imported->name),
      ownPName(ILUCPP_FALSE) {
  }

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Interface interface)
    : definedIn(NULL),
      pName(interface->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE) {
  }

  CppParseName(Name)::
  CppParseName_(Name) (::iluptype::Exception exception)
  : definedIn(CppParse(InterfaceFactory)::findOrCreate(exception->interface)),
      pName(exception->name),
      sName(NULL),
      ownPName(ILUCPP_FALSE) {
  }

  CppParseName(Name)::
  CppParseName_(Name) (const char * s, const CppParseName_(Scope) *  ns)
    : definedIn(ns),
      pName(NULL),
      sName(s),
      ownPName(ILUCPP_FALSE) {
  }

#endif  // __SUNPRO_CC

CppParseName(Name)::
~CppParseName_(Name) () {
  if (ownPName) {
    SelfInitializingPName * freeMe = STATIC_CAST(SelfInitializingPName*, pName);
    delete freeMe;
  };
}


/* TMP 9/19
const char *
CppParseName(Name)::
simpleName (const char *) const {
    const char * base = baseName();
    const int baseLen = strlen(base);
    static ReusableString rtn(100);
    rtn.strcpy("_");  // in case of C++ keyword
    rtn.strcat(base);
    for (int i = 1; i <= baseLen; i++) {  // translate hyphens to underscores
        if (rtn.str[i] == '-')
            rtn.str[i] = '_';
    };
    return (isCppKeyword(rtn.str + 1) ? rtn.str : (rtn.str + 1));
}
TMP 9/19 */

const char *  // TMP 9/19: NEW
CppParseName(Name)::
simpleName (const char *) const {
	const char * idlAttributeGetPrefix = "ilu--prefix-idlAttribute--get-";
	const int idlAttributeGetPrefixLength = strlen(idlAttributeGetPrefix);
	const char * idlAttributeSetPrefix = "ilu--prefix-idlAttribute--set-";
	const int idlAttributeSetPrefixLength = strlen(idlAttributeSetPrefix);
    const char * base = baseName();
    int baseLen;
    static ReusableString rtn(100);

    rtn.strcpy("_");  // in case of C++ keyword

	// Check for an IDL attribute
	if (strncmp(idlAttributeGetPrefix, base, idlAttributeGetPrefixLength) == 0)
		base = base + idlAttributeGetPrefixLength;
	if (strncmp(idlAttributeSetPrefix, base, idlAttributeSetPrefixLength) == 0)
		base = base + idlAttributeSetPrefixLength;

	rtn.strcat(base);

	// Translate hyphens to underscores
	baseLen = strlen(base);
    for (int i = 1; i <= baseLen; i++) {
        if (rtn.str[i] == '-')
            rtn.str[i] = '_';
    };

	// Check for C++ keyword
    return (isCppKeyword(rtn.str + 1) ? rtn.str : (rtn.str + 1));
}


const char *
CppParseName(TypeName)::
simpleName (const char * key) const {
    const int usage = keyToUsage(key);
    return (usage == -1 ?
        CppParseName_(Name)::simpleName() :
        simpleName(STATIC_CAST(CppParseName(TypeUsage), usage)));
}

const char *
CppParseName(TypeName)::
simpleName (CppParseName(TypeUsage) usage) const {
    static ReusableString rtn(100);
    CppParseName(AffixPair) affixPair = {"", ""};
// TMP 7/14    if (usage <= CppParseName(returnVal))
    if (usage <= CppParseName(returnVal))  // TMP 7/14
        affixPair = affixes()->base[usage];
    else {
        switch(usage) {
        case CppParseName(var):
            affixPair.suffix = "_var";
            break;
        case CppParseName(ptr):
            affixPair.suffix = "_ptr";
            break;
        case CppParseName(slice):
            affixPair.suffix = "_slice";
            break;
        case CppParseName(constRef):  // TMP 8/3: NEW
            affixPair.prefix = "const_";  // TMP 8/3: NEW
            break;  // TMP 8/3: NEW
        default:
            break;
        };
    };
    rtn.strcpy(affixPair.prefix);
    rtn.strcat(CppParseName(Name)::simpleName());
    rtn.strcat(affixPair.suffix);
    return rtn.str;
}


// TMP 8/27: Use this when comparing two CppParse_CreatableT's for equality
// TMP 8/27: When redundant allocations of equivalent CppParse_CreatableT's
// TMP 8/27: is eliminated, uses of this macro can be replaced with "A == B".
#define EQ_CREATABLES(A, B) \
	(A->_from == B->_from)


/* TMP 8/28
const char *
CppParse(UnionArm)::
simpleName (const char * key) const {

	const char * rtn;

    if (baseName() == NULL) {
		// No name specified for this arm in ISL,
		// so make up a name based on arm's type.
		static ReusableString work;
		const CppParse_(Union) *const u = CppParse_(Union)::narrow(scope());
		const CppParse_(Type) *const myType = type();
		CppParse_(MemberListIter) armListIter = u->arms();
		const CppParse_(Member) * arm;
		unsigned long numericSuffix = 0;
		work.strcpy("_");
		work.strcat(myType->name(underscore_key, u->scope()));
		work.strcat("_arm");
		// Check for unnamed arms similar to (ie, with same type as) this one
		// First, look at arms occuring before this one
		while ((arm = armListIter.next()) != NULL && !EQ_CREATABLES(arm, this)) {
			if (EQ_CREATABLES(arm->type(), myType) && arm->baseName() == NULL)
				numericSuffix++;
		};
		if (numericSuffix > 0)
			//  Found at least one similar unnamed arm before this one
			numericSuffix++;
		else {
			// Didn't find any similar unnamed arms before this one; check after this one
			while ((arm = armListIter.next()) != NULL && numericSuffix == 0) {
				if (EQ_CREATABLES(arm->type(), myType)) {
					numericSuffix = 1;
					break;
				};
			};
		}
		if (numericSuffix != 0) {
			// There's at least one other unnamed arm with same type,
			// So append numeric suffix to make unique name.
			work.strcat("_");
			work.ucat(numericSuffix);
		};
		rtn = work.str;
	}

	else
		rtn = CppParseName_(Name)::simpleName(key);

	return rtn;
}
TMP 8/28 */

const char *  // TMP 8/28: NEW
CppParse(NamedValue)::
simpleName (const char * key) const {

	const char * rtn;

	if (usage() == CppParseName(unionMember) && baseName() == NULL) {
		// No name specified for this arm in ISL,
		// so make up a name based on arm's type.
		static ReusableString work;
		const CppParse_(Union) *const u = CppParse_(Union)::narrow(scope());
		const CppParse_(Type) *const myType = type();
		CppParse_(MemberListIter) armListIter = u->arms();
		const CppParse_(Member) * arm;
		unsigned long numericSuffix = 0;
		work.strcpy("_");
		work.strcat(myType->name(underscore_key, u->scope()));
		work.strcat("_arm");
		// Check for unnamed arms similar to (ie, with same type as) this one
		// First, look at arms occuring before this one
		while ((arm = armListIter.next()) != this) {
			if (EQ_CREATABLES(arm->type(), myType) && arm->baseName() == NULL)
				numericSuffix++;
		};
		if (numericSuffix > 0)
			//  Found at least one similar unnamed arm before this one
			numericSuffix++;
		else {
			// Didn't find any similar unnamed arms before this one; check after this one
			while ((arm = armListIter.next()) != NULL && numericSuffix == 0) {
				if (EQ_CREATABLES(arm->type(), myType)) {
					numericSuffix = 1;
					break;
				};
			};
		}
		if (numericSuffix != 0) {
			// There's at least one other unnamed arm with same type,
			// So append numeric suffix to make unique name.
			work.strcat("_");
			work.ucat(numericSuffix);
		};
		rtn = work.str;
	}

	else
		rtn = CppParseName_(Name)::simpleName(key);

	return rtn;
}


const char *
CppParseName(Name)::
baseName () const {
    static const char * empty = "";
    return ((pName == NULL)
        ? ((sName == NULL) ? empty : sName)
        : iluptype::_name_base_name(pName)
    );
}

const CppParseName(Scope) *
CppParseName(Name)::
scope () const {
  return(definedIn); // TEMP
}


const char *
CppParseName(Name)::
name (const CppParseName_(Scope) * context) const {
  return name(NULL, context);
}


/* TMP 9/6
// Template specialization
TEMPLATE_STATIC
const char *
keyOrUsageToKey (const char * key) {
    return key;
}

// Template specialization
TEMPLATE_STATIC
const char *
keyOrUsageToKey (CppParseName(TypeUsage)) {
    static const char * rtn = "usage";
    return rtn;
}
TMP 9/6 */

// Template specialization  // TMP 9/6: NEW
TEMPLATE_STATIC
const char *
keyOrUsageToKey (const char * key, const CppParseName(Scope) *, const CppParseName(Scope) *) {
    return key;
}

// Template specialization  // TMP 9/6: NEW
TEMPLATE_STATIC
const char *
keyOrUsageToKey (CppParseName(TypeUsage) usage, const CppParseName(Scope) * definedIn, const CppParseName(Scope) * context) {
    return getCacheKey(usage, definedIn, context);
}


// template specialization
TEMPLATE_STATIC
const char *
getCacheKey (const char * keyRoot, const CppParseName(Scope) * definedIn, const CppParseName(Scope) * context) {
  const char * rtn;
  if (keyRoot == NULL)
    rtn = (context == definedIn)
      ? key_name_local
      : key_name_fullyQualified;
  else {
    static ReusableString str(100);
    str.strcpy("C++-");
    str.strcat(keyRoot);
    if (context != definedIn)
      str.strcat("FullyQualified");
    rtn = str.str;
  };
  return rtn;
}

// template specialization
TEMPLATE_STATIC
const char *
getCacheKey (CppParseName(TypeUsage) usage, const CppParseName(Scope) * definedIn, const CppParseName(Scope) * context) {
  const char * rtn;
  switch (usage) {
    case CppParseName(in):
      rtn = ((context == definedIn) ? key_in_local : key_in_fullyQualified);
      break;
    case CppParseName(out):
      rtn = ((context == definedIn) ? key_out_local : key_out_fullyQualified);
      break;
    case CppParseName(inOut):
      rtn = ((context == definedIn) ? key_inOut_local : key_inOut_fullyQualified);
      break;
    case CppParseName(returnVal):
      rtn = ((context == definedIn) ? key_rtn_local : key_rtn_fullyQualified);
      break;
    case CppParseName(recordMember):
    case CppParseName(unionMember):
      rtn = ((context == definedIn) ? key_member_local : key_member_fullyQualified);
      break;
    case CppParseName(element):
      rtn = ((context == definedIn) ? key_element_local : key_element_fullyQualified);
      break;
    case CppParseName(var):
      rtn = ((context == definedIn) ? key_var_local : key_var_fullyQualified);
      break;
    case CppParseName(ptr):
      rtn = ((context == definedIn) ? key_ptr_local : key_ptr_fullyQualified);
      break;
    case CppParseName(slice):
      rtn = ((context == definedIn) ? key_slice_local : key_slice_fullyQualified);
      break;
    case CppParseName(constRef):  // TMP 8/3: NEW
      rtn = ((context == definedIn) ? key_constRef_local : key_constRef_fullyQualified);  // TMP 8/3: NEW
      break;  // TMP 8/3: NEW
    default:  // Shouldn't happen
      rtn = ((context == definedIn) ? key_name_local : key_name_fullyQualified);
      break;
  };
  return rtn;
};


template <class NAME_OR_TYPENAME, class KEY_OR_USAGE>
TEMPLATE_STATIC
const char *
// TMP 7/6  getName (NAME_OR_TYPENAME * n, ::iluptype::Name pName, KEY_OR_USAGE ku, const CppParseName(Scope) * context) {
getName (  // TMP 7/6: NEW
    NAME_OR_TYPENAME * n,
    ::iluptype::Name pName,
    KEY_OR_USAGE ku,
    const CppParseName(Scope) * context,
    const CppParseName(AffixPair) * affixes) {

    const char * rtn = NULL;
    const char * cacheKey;
    const CppParseName(Scope) * definedIn = n->scope();

    // If this is a cacheable name, check cache
    if (pName != NULL) {
        cacheKey = getCacheKey(ku, definedIn, context);
        rtn = iluptype::_name_lang_name(pName, cacheKey);
    };

    // Compute name for given key/usage and context
    if (rtn == NULL) {
// TMP 9/6        const char * key = keyOrUsageToKey(ku);
        const char * key = keyOrUsageToKey(ku, definedIn, context);  // TMP 9/6: NEW
        const CppParseName(Scope) * ns = definedIn;
        CppParseName(ContinuationFlag) flag = CppParseName(proceed);

		//  Special checks for ilu::CString (char *)
		if (key != NULL && CppParseName(isIluCString)(n))  { // TMP 9/6: NEW
			if (key == key_var_local || key == key_var_fullyQualified)
				rtn = CppParseName(CorbaString_var)()->name();
			else if (key == key_constRef_local || key == key_constRef_fullyQualified) {
				static const char constCharStar[] = "const char*";
				rtn = constCharStar;
			}
			else if (key == underscore_key) {
				static const char iluCString[] = "ilu_CString";
				rtn = iluCString;
			};
			if (rtn != NULL)
				goto done;
		};

        rtn = n->simpleName(ku);

        // Name-scope qualification
        if (context == definedIn) {
            while ((flag != CppParseName(halt)) && (ns != NULL)) {
				if (key == underscore_key)
					flag = ns->CppParseName_(Scope)::qualifyLocal(rtn, &rtn, key);
				else
					flag = ns->qualifyLocal(rtn, &rtn, key);
                ns = ns->scope();
            };
        }
        else {
            while ((flag != CppParseName(halt)) && (ns != NULL)) {
				if (key == underscore_key)
					flag = ns->CppParseName_(Scope)::qualify(rtn, &rtn, key, context);
				else
					flag = ns->qualify(rtn, &rtn, key, context);
                ns = ns->scope();
            };
        };

        // Prepend/append affixes
        if (affixes != NULL) {  // TMP 7/5: NEW
            static ReusableString work(100);
            work.reset();
            if (affixes->prefix != NULL)
                work.strcat(affixes->prefix);
            work.strcat(rtn);
            if (affixes->suffix != NULL)
                work.strcat(affixes->suffix);
            rtn = work.str;
        };

        // If this is a cacheable name, enter it into cache
        if (pName != NULL) {
            iluptype::_name_set_lang_name(pName, cacheKey, rtn);
            rtn = iluptype::_name_lang_name(pName, cacheKey);
        };
    };
done:
    return rtn;
}



const char *
CppParseName(Name)::
name (const char * key, const CppParseName(Scope) * context) const {
// TMP 7/5    return getName(this, this->pName, key, context);
    return getName(this, this->pName, key, context, REINTERPRET_CAST(const CppParseName(AffixPair) *, NULL));  // TMP 7/5: NEW
}


const char *
CppParseName(Name)::
localName (const char * key) const {
// TMP 7/5    return getName(this, this->pName, key, scope());
    return getName(this, this->pName, key, scope(), REINTERPRET_CAST(const CppParseName(AffixPair) *, NULL));  // TMP 7/5: NEW
}

void
CppParseName(Name)::
resetName (const CppParseName(Scope) * scope) {
    definedIn = scope;
}

void
CppParseName(Name)::
resetName (::iluptype::Name n, const CppParseName(Scope) * scope) {
    pName = n;
    definedIn = scope;
}

const char *
CppParseName(TempName)::
name (const CppParseName_(Scope) * context) const {
  return name(NULL, context);
}

const char *
CppParseName(TempName)::
name (const char * key, const CppParseName_(Scope) * context) const {
    const char * rtn;
    if (context == definedIn)
        rtn = localName(key);
    else {
        CppParseName_(ContinuationFlag) flag = CppParseName_(proceed);
        const CppParseName(Scope) * ns = definedIn;
        rtn = simpleName();
        while ((flag != CppParseName_(halt)) && (ns != NULL)) {
            flag = ns->qualify(rtn, &rtn, key, context);
            ns = ns->scope();
        };
    };
    return rtn;
}

const char *
CppParseName(TempName)::
localName (CppParseName(Key) key) const {
  CppParseName_(ContinuationFlag) flag = CppParseName_(proceed);
  const CppParseName(Scope) * ns = definedIn;
  const char * rtn = simpleName();
    while ((flag != CppParseName_(halt)) && (ns != NULL)) {
      flag = ns->qualifyLocal(rtn, &rtn, key);
      ns = ns->scope();
    };
  return rtn;
}

const char *
CppParseName(TempName)::
baseName () const {
  return _m_baseName;
}

const char *
CppParseName(TempName)::
simpleName () const {
    const char * base = baseName();
    const int baseLen = strlen(base);
    static ReusableString rtn(100);
    ILUCPP_BOOL keyword;
    rtn.strcpy("_");  // in case of C++ keyword
    rtn.strcat(base);
    for (int i = 1; i <= baseLen; i++) {  // translate hyphens to underscores
        if (rtn.str[i] == '-')
            rtn.str[i] = '_';
    };
    keyword = isCppKeyword(rtn.str + 1);
    return (keyword ? rtn.str : (rtn.str + 1));
}

CppParseName(TempName)::
CppParseName_(TempName) () {
  reset(NULL, NULL);
};

CppParseName(TempName)::
CppParseName_(TempName) (const char * base, const CppParseName_(Scope) * ns) {
  reset(base, ns);
};

#ifdef __SUNPRO_CC  // See note in cppparse.hpp

  void
  CppParseName(TempName)::
  reInit (const char * base, const CppParseName_(Scope) * ns) {
    reset(base, ns);
  }

#endif  // __SUNPRO_CC

void
CppParseName(TempName)::
reset (const char * base, const CppParseName_(Scope) * ns) {
  _m_baseName = base;
  definedIn = ns;
};


static
inline
const char *
catStrings (const char * s1, const char * s2) {
  static ReusableString rtn(100);
  rtn.strcpy(s1);
  rtn.strcat(s2);
  return rtn.str;
}


CppParseName(Scope)::
CppParseName_(Scope) (::iluptype::Name n, const CppParseName_(Scope) * parent)
: CppParseName(Name)(n, parent) {
    #ifdef __SUNPRO_CC  // See note in cppparse.hpp
        CppParseName_(Name)::reInit(n, parent);
    #endif  // __SUNPRO_CC
}



CppParseName(ContinuationFlag)
CppParseName(Scope)::
qualify (const char * n, const char ** qn, const char * key, const CppParseName_(Scope) *) const {
  static ReusableString safeN(100);
  static ReusableString rtn2(100);
  safeN.strcpy(n);
  // It's likely that n came from simpleName, or from a previous call to
  // qualify; in either case, we need to be careful about overwriting it's
  // backing string prematurely, so we copy it into safeN.
  rtn2.strcpy(simpleName(key));
// TMP 8/27  rtn2.strcat("::");
  rtn2.strcat(key == underscore_key ? "_" : "::");  // TMP 8/27: NEW
  rtn2.strcat(safeN.str);
  *qn = rtn2.str;
  return CppParseName(proceed);
}


CppParseName(ContinuationFlag)
CppParseName(Scope)::
qualifyLocal (const char * n, const char ** qn, const char *) const {
/* TMP 7/4
    static ReusableString rtn(100);
    rtn.strcpy(n);
    *qn =  rtn.str;
*/
    *qn = n;  // TMP 7/4: NEW
    return CppParseName(halt);
}


/* TMP 6/15
CppParseName(TypeName)::
CppParseName_(TypeName) (::iluptype::Type type)
:
    CppParseName(Name)(type->name, CppParse(InterfaceForType)(type)) {
    #ifdef __SUNPRO_CC  // See note in cppparse.hpp
        CppParseName_(Name)::reInit(type->name, CppParse(InterfaceForType)(type));
    #endif  // __SUNPRO_CC
}
*/

CppParseName(TypeName)::  // TMP 6/15: NEW
CppParseName_(TypeName) (::iluptype::Type type)
:
    CppParseName(Name)(type) {
    #ifdef __SUNPRO_CC  // See note in cppparse.hpp
        CppParseName_(Name)::reInit(type);
    #endif  // __SUNPRO_CC
}


const char *
CppParseName(TypeName)::
usageName (CppParseName_(TypeUsage) usage, const CppParseName(Scope) * context) const {
/* TMP 7/5
    const char * rtn = NULL;
    const char * cacheKey;
    if (pName != NULL) {
        cacheKey = getCacheKey(usage, definedIn, context);
        rtn = iluptype::_name_lang_name(pName, cacheKey);
    };
    if (rtn == NULL) {
        rtn = getName(this, this->pName, usage, context);
        if (usage <= CppParseName(returnVal)) {
            static ReusableString work(100);
            const CppParseName_(AffixPair) affixPair = affixes()->name[usage];
            work.reset();
            if (affixPair.prefix != NULL)
                work.strcat(affixPair.prefix);
            work.strcat(rtn);
            if (affixPair.suffix != NULL)
                work.strcat(affixPair.suffix);
            rtn = work.str;
        };
        if (pName != NULL) {
            iluptype::_name_set_lang_name(pName, cacheKey, rtn);
            rtn = iluptype::_name_lang_name(pName, cacheKey);
        };
    };
    return rtn;

*/
    const CppParseName(AffixSet) * affixSet = NULL;
    const CppParseName(AffixPair) * affixPair = NULL;
    if (usage <= CppParseName(returnVal)) {
        affixSet = affixes();
        affixPair = &(affixSet->name[usage]);
    };
    return getName(this, this->pName, usage, context, affixPair);  // TMP 6/7: NEW
}

const char *
CppParseName(TypeName)::
localUsageName (CppParseName_(TypeUsage) usage) const {
    return usageName(usage, definedIn);
}


#define DEF_CORBA_SCALAR_TYPE_USAGE_NAME_FUNC(T, UNUSED1, UNUSED2, CORBANAME, UNUSED3)      \
    const char *                                                                            \
    CppParse(T)::                                                                           \
    usageName (CppParseName(TypeUsage) usage, const CppParseName(Scope) * context) const { \
    static const char * var_name = "ilu_CORBA_" #CORBANAME "_var";                          \
        return (usage == CppParseName(var))                                                 \
            ? var_name                                                                      \
            : CppParseName(TypeName)::usageName(usage, context);                            \
    }

CppParse_ENUMERATE_CORBA_SCALAR_TYPES(DEF_CORBA_SCALAR_TYPE_USAGE_NAME_FUNC)


#ifdef __SUNPRO_CC  // TMP 4/30: Until we can correct SunPro template problem
    extern
    CppParse(Type) *
    CppParse_findOrCreateType(::iluptype::Type);
#endif

CppParseName(AliasName)::
CppParseName_(AliasName) (::iluptype::Type alias)
  : CppParseName_(TypeName)(alias),
    CppParseName_(Name)(alias),
    #ifdef __SUNPRO_CC   // TMP 4/30: Until we can correct SunPro template problem
        urTypeName(CppParse_findOrCreateType(iluptype::_ur_type(alias))) {
    #else
        urTypeName(CppParse(TypeFactory)::findOrCreate(iluptype::_ur_type(alias))) {
    #endif  // __SUNPRO_CC
    #ifdef __SUNPRO_CC  // See note in cppparse.hpp
        CppParseName_(Name)::reInit(alias);
    #endif  // __SUNPRO_CC
}

const char *
CppParseName(AliasName)::
simpleName (CppParseName_(TypeUsage) usage) const {

    // Temporarily alter urTypeName's name & scope to be Alias'
    const char * rtn;
    ::iluptype::Name origPName = urTypeName->pName;
    const CppParseName_(Scope) * origScope = urTypeName->scope();
    urTypeName->resetName(pName, scope());

    // Now, use urTypeName's methods to produce simpleName
    rtn = urTypeName->simpleName(usage);

    // Set urTypeName's name & scope back to orginal values
    urTypeName->resetName(origPName, origScope);

    return rtn;
}

const char *
CppParseName(AliasName)::
simpleName (CppParseName_(Key) key) const {

    // Temporarily alter urTypeName's name & scope to be Alias'
    const char * rtn;
    ::iluptype::Name origPName = urTypeName->pName;
    const CppParseName_(Scope) * origScope = urTypeName->scope();
    urTypeName->resetName(pName, scope());

    // Now, use urTypeName's methods to produce simpleName
    rtn = urTypeName->simpleName(key);
    // Set urTypeName's name & scope back to orginal values
    urTypeName->resetName(origPName, origScope);

    return rtn;
}


const char *  // TMP 4/30 if this works out, we can probably get rid of this function
CppParse(String)::
simpleName (CppParseName(Key) key) const {
    return CppParse(Type)::simpleName(key);
}

const char *  // TMP 4/30 if this works out, we can probably get rid of this function
CppParse(WideString)::
simpleName (CppParseName(Key) key) const {
    return CppParse(Type)::simpleName(key);
}


/*
  Utiltity fuctions
*/


static
int
keyToUsage (const char * key) {
    const int rtn =
        ((key == key_in_local) || (key == key_in_fullyQualified)) ? CppParseName(in) :
        ((key == key_out_local) || (key == key_out_fullyQualified)) ? CppParseName(out) :
        ((key == key_inOut_local) || (key == key_inOut_fullyQualified)) ? CppParseName(inOut) :
        ((key == key_rtn_local) || (key == key_rtn_fullyQualified)) ? CppParseName(returnVal) :
        ((key == key_member_local) || (key == key_member_fullyQualified)) ? CppParseName(recordMember) :
        /* TEMP: Note that we map key_member_local and key_member_fullyQualified to CppParseName::recordMember,
           even though in some cases we may be dealing with a union member. This seems to be ok for the current
           use(s) of keyToUsage (ie, CppParseName::TypeName::simpleName), but might cause problems in other
           cases in the future...
        */
        ((key == key_element_local) || (key == key_element_fullyQualified)) ? CppParseName(element) :
        ((key == key_var_local) || (key == key_var_fullyQualified)) ? CppParseName(var) :
        ((key == key_ptr_local) || (key == key_ptr_fullyQualified)) ? CppParseName(ptr) :
        ((key == key_slice_local) || (key == key_slice_fullyQualified)) ? CppParseName(slice) :
        ((key == key_constRef_local) || (key == key_constRef_fullyQualified)) ? CppParseName(constRef) :  // TMP 8/3: NEW
        -1;
    return rtn;
};


char * cppKeywords[] = {
  "and",
  "and_eq",
  "asm",
  "auto",
  "bitand",
  "bitor",
  "bool",
  "break",
  "case",
  "catch",
  "char",
  "class",
  "compl",
  "const",
  "const_cast",
  "continue",
  "default",
  "delete",
  "do",
  "double",
  "dynamic_cast",
  "else",
  "enum",
  "explicit",
  "extern",
  "false",
  "float",
  "for",
  "friend",
  "goto",
  "if",
  "inline",
  "int",
  "long",
  "mutable",
  "namespace",
  "new",
  "not",
  "not_eq",
  "operator",
  "or",
  "or_eq",
  "private",
  "protected",
  "public",
  "register",
  "reinterpret_cast",
  "return",
  "short",
  "signed",
  "sizeof",
  "static",
  "static_cast",
  "struct",
  "switch",
  "template",
  "this",
  "throw",
  "true",
  "try",
  "typedef",
  "typeid",
  "typename",
  "union",
  "unsigned",
  "using",
  "virtual",
  "void",
  "volatile",
  "wchar_t",
  "while",
  "xor",
  "xor_eq"
  };


static
int
bsearch_callback (const void * keyval, const void * datum) {
#define CONST_CHAR_STAR const char *
  return(
    strcmp(
      STATIC_CAST(CONST_CHAR_STAR, keyval),
// TMP 9/20      STATIC_CAST(CONST_CHAR_STAR, datum)
      *REINTERPRET_CAST(CONST_CHAR_STAR*, CONST_CAST(void*, datum))  // TMP 9/20: NEW
    )
  );
}

static
ILUCPP_BOOL
isCppKeyword (const char * s) {
  static const size_t sizeOfString = sizeof(char *);
  static const size_t nKeywords = ((sizeof cppKeywords)/sizeOfString);
  return(
    bsearch(
      s,
// REINTERPRET_CAST used because SunOS 4.x, bsearch expects const char * 
// TMP 9/19      REINTERPRET_CAST(const char*, cppKeywords),
      REINTERPRET_CAST(const char*, &cppKeywords[0]),  // TMP 9/19: NEW
      nKeywords,
      sizeOfString,
      bsearch_callback
    ) != NULL
  );
}


int CppParseName(Scope)::cid;

/*

  SunPro4.1 Compiler Note #1 - keyOrUsageTo key must be a template function (ie, it cannot be a simple pair of overloaded functions), or the compiler will generate errors ("The name keyOrUsageToKey(const char *) is unusable in getName..." and "The name keyOrUsageToKey(CppParseName::TypeUsage) is unusable in getName..."). Curiously, the errors aren't generated when the overloaded functions are non-static.

  SunPro4.1 Compiler Note #2 - See Note in cppparse.h regarding definition of wchar_t.

*/
