/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: cppmain.cpp,v 1.33 1998/10/09 18:18:17 pnewman Exp $
*/

extern "C" {
    #include <stdlib.h>
    #include <string.h>
}  // extern "C"

#include <iostream.h>

#include "cppparse.hpp"
#include "cppgen.hpp"
#include "cppparsestream.hpp"

::iluptype::boolean GenerateImakefile = FALSE;
::iluptype::boolean GenerateServerSkeleton = FALSE;
::iluptype::boolean GenerateClasses = FALSE;
::iluptype::boolean RemoveFirst = FALSE;

char *OutputDirectory = ".";
char *ProgramName = NULL;
char *NamesFile = NULL;
char *HeaderFile = NULL;
char *StubsFile = NULL;
char *SurrogateCommonFile = NULL;
char *InterfaceHeaderTranslationFile = NULL;

CppGen(InterfaceScopingMode) ScopeMode;

static void PrintUsage(void);
static ::iluptype::boolean ParseArgs(int *pac, char ***pav);

CppParseStream(ofstream) surrogate_stubs;
CppParseStream(ofstream) surrogate_header;
CppParseStream(ofstream) common_header;
CppParseStream(ofstream) common_stubs;
CppParseStream(ofstream) true_stubs;
CppParseStream(ofstream) true_header;

const int FILENAMEBUFSIZE = 128;	// TEMPORARY VALUE

char *common_header_file_name = new char[FILENAMEBUFSIZE];
char *common_stubs_file_name = new char[FILENAMEBUFSIZE];
char *surrogate_header_file_name = new char[FILENAMEBUFSIZE];
char *surrogate_stubs_file_name = new char[FILENAMEBUFSIZE];
char *true_header_file_name = new char[FILENAMEBUFSIZE];
char *true_stubs_file_name = new char[FILENAMEBUFSIZE];
char *executable_name = new char[FILENAMEBUFSIZE];
char *isl_name = new char[FILENAMEBUFSIZE];

// Local function prototypes

static void SortMethodTypes(::iluptype::Procedure m, ::iluptype::list sorted);
static void SortMethodArgTypes(::iluptype::Argument arg, ::iluptype::list sorted);
static void SortArgTypes(::iluptype::Argument arg, ::iluptype::list sorted);
static void sort_types(::iluptype::Type type, ::iluptype::list sorted);
static void sort_classes(::iluptype::Type type, ::iluptype::list sorted);  // TMP 9/9: NEW
static void UnmarkSupertypes(::iluptype::Type t);
static void SortInterfaceTypes(::iluptype::Interface interface);
static void SortInterfaceClasses(::iluptype::Interface interface);  // TMP 9/9: NEW
static void sortTypes(::iluptype::list s);
static ::iluptype::boolean MatchPointer(::iluptype::refany p1, ::iluptype::refany p2);
::iluptype::boolean PassedByRef(::iluptype::Type type);
::iluptype::boolean TypeIsNonObjectStruct(::iluptype::Type type);


static void genInterface(const CppGen(Interface) * interface) 
{
	sprintf(common_header_file_name, "%s-cpp.hpp", interface->baseName());
	sprintf(common_stubs_file_name, "%s-cpp.cpp", interface->baseName());
	sprintf(surrogate_header_file_name, "%s-cppsurrogate.hpp", interface->baseName());
	sprintf(surrogate_stubs_file_name, "%s-cppsurrogate.cpp", interface->baseName());
	sprintf(true_header_file_name, "%s-cpptrue.hpp", interface->baseName());
	sprintf(true_stubs_file_name, "%s-cpptrue.cpp", interface->baseName());

	common_header.open(common_header_file_name, ios::out);
	if (!common_header.is_open()) 
	{
		cerr << "Couldn't open " << common_header_file_name << ", aborting." << endl;
		exit(1);
	}

	common_stubs.open(common_stubs_file_name, ios::out);
	if (!common_stubs.is_open()) 
	{
		cerr << "Couldn't open " << common_stubs_file_name << ", aborting." << endl;
		exit(1);
	}

	surrogate_header.open(surrogate_header_file_name, ios::out);
	if (!surrogate_header.is_open()) 
	{
		cerr << "Couldn't open " << surrogate_header_file_name << ", aborting." << endl;
		exit(1);
	}

	surrogate_stubs.open(surrogate_stubs_file_name, ios::out);
	if (!surrogate_stubs.is_open()) 
	{
		cerr << "Couldn't open " << surrogate_stubs_file_name << ", aborting." << endl;
		exit(1);
	}

	true_header.open(true_header_file_name, ios::out);
	if (!true_header.is_open()) 
	{
		cerr << "Couldn't open " << true_header_file_name << ", aborting." << endl;
		exit(1);
	}

	true_stubs.open(true_stubs_file_name, ios::out);
	if (!true_stubs.is_open()) 
	{
		cerr << "Couldn't open " << true_stubs_file_name << ", aborting." << endl;
		exit(1);
	}

	common_header << CppGen(herald)(executable_name, isl_name);
    common_header << endl;
    common_header << interface->commonDef();

	common_stubs << CppGen(herald)(executable_name, isl_name);
    common_stubs << endl;
	common_stubs << interface->commonImpl();

	surrogate_header << CppGen(herald)(executable_name, isl_name);
    surrogate_header << endl;
	surrogate_header << interface->surrogateDef();

	surrogate_stubs << CppGen(herald)(executable_name, isl_name);
    surrogate_stubs << endl;
	surrogate_stubs << interface->surrogateImpl();

	true_header << CppGen(herald)(executable_name, isl_name);
    true_header << endl;
	true_header << interface->trueDef();

	true_stubs << CppGen(herald)(executable_name, isl_name);
    true_stubs << endl;
	true_stubs << interface->trueImpl();
}


int main(int ac, char **av)
{
	int rtn = 0;
	::iluptype::list s;
	int i_num_isl_files_processed = 0;
	int i_renaming_files = 0;
	char **filename;

	ProgramName = "cpp2-stubber";
	strcpy(executable_name, av[0]);

// set default output mode according to how ILU is being built
#ifdef CPLUSPLUSMAPPING_NAMESPACES
	ScopeMode = CppGen(namespaces);
#elif (defined (CPLUSPLUSMAPPING_NESTEDCLASSES))
	ScopeMode = CppGen(classes);
#else
	ScopeMode = CppGen(underscores);
#endif
	
	if (ac < 2)
	{
		PrintUsage();
		exit(1);
	}
	if (!ParseArgs(&ac, &av))
		exit(1);

    CppGen(post)();

    CppGen(Namespace)::mode = ScopeMode;
    // TEMP: code generation mode for template function static, bools and cast should
    // be indicated via command line (or defaulted to values determined at configuration time)
    CppGen(TemplateStatic)::mode = CppGen(templateStaticPortable);
    CppGen(Bool)::mode = CppGen(boolPortable);
    CppGen(Cast)::mode = CppGen(castPortable);

	if (StubsFile || HeaderFile || SurrogateCommonFile)
		i_renaming_files = 1;

	for (filename = av;  *filename != NULL;  filename += 1)
	{
		if (i_renaming_files && (i_num_isl_files_processed > 0)) 
		{
			cerr << "Can't use -sname -hname or -cname with more than 1 isl file." << endl;
			exit(1);
		}

		cerr << "Parsing " << *filename << endl;
		if ((s = iluptype::_ParseFile(*filename)) == NULL)
		{
			cerr << "Couldn't find or parse " << filename << "." << endl;
			exit (1);
		}

		strcpy(isl_name, *filename);	// Save .isl name for comments
		sortTypes(s);	// Sort the type list; see below and then forget you saw it.

        iluptype::_iluparser_ClearMarks();  // This should be done by CppParse, somewhere. // TMP 7/23: NEW

		CppParse(InterfaceList) interfaceList((::iluptype::list) s);
		CppParse(InterfaceListIter) interfaces(interfaceList);
		const CppParse(Interface) * interface;
		
		while ((interface = interfaces.next()) != NULL) 
		{
			genInterface(CppGen(Interface)::narrow(interface));
		}

		i_num_isl_files_processed++;
	}

	cout << "Exiting main() with result " << rtn << endl;
	return(rtn);
}

static void PrintUsage(void)
{
  cerr << "Usage: " << ProgramName << " {arguments} ISLFILE [ISLFILE ...]" << endl;
  cerr << "\t{arguments} can be any of the following:" << endl;
  cerr << "\t[-nu|-underscores]" << endl;
  cerr << "\t[-np|-portable]" << endl;
  cerr << "\t[-nn|-nested]" << endl;
  cerr << "\t[-ns|-namespaces]" << endl;
  /* // currently unsupported switches as found in original c++ stubber
  cerr << "[-dir OUTPUTDIRECTORY]	specify an output directory" << endl; 
  cerr << "[-imakefile]" << endl;
  cerr << "[-serverskeleton]" << endl;
  cerr << "[-classes]" << endl;
  cerr << "[-renames NAMESFILE]" << endl;
  cerr << "[-hname HEADERFILENAME]" << endl;
  cerr << "[-sname STUBSFILENAME]" << endl;
  cerr << "[-removefirst]" << endl;
  cerr << "[-cname CLIENTCOMMONFILENAME]" << endl;
  cerr << "[-hdrmap INTERFACEHEADERTRANSLATIONFILE]" << endl;
  */
}

static ::iluptype::boolean ParseArgs(int *pac, char ***pav)
{
	int ac = *pac;
	char **av = *pav;

	ac--; // skip program name
	av++;

	for( ; *av[0] == '-'; ac--, av++) {

		if (strcmp(*av, "-underscores") == 0) {
			ScopeMode = CppGen(underscores);
			continue;
		}
		if (strcmp(*av, "-nu") == 0) {
			ScopeMode = CppGen(underscores);
			continue;
		}
		if (strcmp(*av, "-portable") == 0) {
			ScopeMode = CppGen(interfacePortable);
			continue;
		}
		if (strcmp(*av, "-np") == 0) {
			ScopeMode = CppGen(interfacePortable);
			continue;
		}
		if (strcmp(*av, "-nested") == 0) {
			ScopeMode = CppGen(classes);
			continue;
		}
		if (strcmp(*av, "-nn") == 0) {
			ScopeMode = CppGen(classes);
			continue;
		}
		if (strcmp(*av, "-ns") == 0) {
			ScopeMode = CppGen(namespaces);
			continue;
		}
		if (strcmp(*av, "-namespaces") == 0) {
			ScopeMode = CppGen(namespaces);
			continue;
		}
		
		/* // currently unsupported switches as found in original c++ stubber
		if (strcmp(*av, "-dir") == 0) {
		OutputDirectory = *av;
		continue;
		}
		if (strcmp(*av, "-imakefile") == 0) {
		GenerateImakefile = TRUE;
		continue;
		}
		if (strcmp(*av, "-serverskeleton") == 0) {
		GenerateServerSkeleton = TRUE;
		continue;
		}
		if (strcmp(*av, "-renames") == 0) {
		NamesFile = *av;
		continue;
		}
		if (strcmp(*av, "-classes") == 0) {
		GenerateClasses = TRUE;
		continue;
		}
		if (strcmp(*av, "-removefirst") == 0) {
		RemoveFirst = TRUE;
		continue;
		}
		if (strcmp(*av, "-hname") == 0) {
		HeaderFile = *av;
		continue;
		}
		if (strcmp(*av, "-sname") == 0) {
		StubsFile = *av;
		continue;
		}
		if (strcmp(*av, "-cname") == 0) {
		SurrogateCommonFile = *av;
		continue;
		}
		if (strcmp(*av, "-hdrmap") == 0) {
		InterfaceHeaderTranslationFile = *av;
		continue;
		}
		*/
		cerr << ProgramName << ": Invalid switch \"" << *av << "\"." << endl;
		PrintUsage();
		return (FALSE);
	}
	
	if (!(GenerateServerSkeleton || GenerateImakefile || GenerateClasses)) {
		GenerateClasses = TRUE;
	}

	// set to what might be left over
	*pac = ac;
	*pav = av;
	return (TRUE);
}

static void sortTypes(::iluptype::list s)
{
	// Enumerate through the interfaces, passing each one to SortInterfaceTypes

	iluptype::_list_enumerate(s, (::iluptype::iluparser_EnumProc) SortInterfaceTypes, NULL);
	iluptype::_list_enumerate(s, (::iluptype::iluparser_EnumProc) SortInterfaceClasses, NULL);  // TMP 9/9: NEW
}

static void SortInterfaceTypes(::iluptype::Interface interface)
{
	// Sort the type tree
	::iluptype::list sorted = iluptype::_iluparser_new_list();	// where the sorted tree will go

	// Clear the "marker" fields in the type tree
	iluptype::_list_enumerate(interface->types, (::iluptype::iluparser_EnumProc) UnmarkSupertypes, NULL);

	// Sort it, placing the results in "sorted"
	iluptype::_list_enumerate(interface->types, (::iluptype::iluparser_EnumProc) sort_types, sorted);

	// Replace the old Types list with the new sorted list; note: old list needs to be deleted!
	interface->types = sorted;
}

static void SortInterfaceClasses(::iluptype::Interface interface)  // TMP 9/9: NEW
{
	// Sort the type tree
	::iluptype::list sorted = iluptype::_iluparser_new_list();	// where the sorted tree will go

	// Clear the "marker" fields in the type tree
	iluptype::_list_enumerate(interface->classes, (::iluptype::iluparser_EnumProc) UnmarkSupertypes, NULL);

	// Sort it, placing the results in "sorted"
	iluptype::_list_enumerate(interface->classes, (::iluptype::iluparser_EnumProc) sort_classes, sorted);

	// Replace the old Types list with the new sorted list; note: old list needs to be deleted!
	interface->classes = sorted;
}

static void UnmarkSupertypes(::iluptype::Type t)
{
	::iluptype::Type st;

	if (t == NULL || iluptype::_type_ur_kind(t) != iluptype::object_Type)
		return;

	for (st = t;  st->supertype != NULL;  st = st->supertype)
		st->marked = FALSE;

	iluptype::_list_enumerate(iluptype::_class_object(st)->superclasses, (::iluptype::iluparser_EnumProc) UnmarkSupertypes, NULL);
	st->marked = FALSE;
}

static void sort_types(::iluptype::Type type, ::iluptype::list sorted)
{
	::iluptype::TypeKind t;
	static ::iluptype::list pending = NULL;

	if (type == NULL || type->importInterfaceName != NULL)
		return;
	if (pending == NULL)
		pending = iluptype::_iluparser_new_list();
	if (iluptype::_list_find(sorted, MatchPointer, type) != NULL)
		return;
	if (iluptype::_list_find(pending, MatchPointer, type) != NULL)
    {
		iluptype::_list_insert(sorted, type);
		iluptype::_list_remove(pending, type);
		return;
    }

	t = iluptype::_type_basic_type(type);
	iluptype::_list_insert(pending, type);

	if (type->importInterfaceName == NULL &&
		(t == iluptype::record_Type ||
		t == iluptype::array_Type ||
		t == iluptype::union_Type ||
		t == iluptype::optional_Type ||
		t == iluptype::sequence_Type ||
		t == iluptype::alias_Type ||
		t == iluptype::object_Type))
    {
		switch (t)
		{
			case iluptype::record_Type:     
				iluptype::_list_enumerate(iluptype::_type_description(type)->structuredDes.record.fields, (::iluptype::iluparser_EnumProc) SortArgTypes, sorted);
				break;	      

			case iluptype::union_Type:     
				iluptype::_list_enumerate(iluptype::_type_description(type)->structuredDes.uniond.types, (::iluptype::iluparser_EnumProc) SortArgTypes, sorted);
				break;

			case iluptype::optional_Type:
				sort_types(iluptype::_type_description(type)->structuredDes.optional, sorted);
				break;

			case iluptype::array_Type:	      
				if (!iluptype::_type_description(type)->structuredDes.array.optional)
					sort_types(iluptype::_type_description(type)->structuredDes.array.type, sorted);
				break;

			case iluptype::sequence_Type:
				sort_types(iluptype::_type_description(type)->structuredDes.sequence.type, sorted);
				break;

			case iluptype::alias_Type:
				sort_types(type->supertype, sorted);
				break;

			case iluptype::object_Type:
				if (type->marked)
					break;
				iluptype::_list_enumerate(iluptype::_class_object(type)->superclasses, (::iluptype::iluparser_EnumProc) sort_types, sorted);
				iluptype::_list_enumerate(iluptype::_class_object(type)->methods, (::iluptype::iluparser_EnumProc) SortMethodTypes, sorted);
				type->marked = TRUE;
				break;

			default:
				break;
		}
    }
	if (iluptype::_list_find(sorted, MatchPointer, type) == NULL)
		iluptype::_list_insert(sorted, type);
	iluptype::_list_remove(pending, type);
}

static void sort_classes(::iluptype::Type type, ::iluptype::list sorted)  // TMP 9/9: NEW
{
	::iluptype::TypeKind t;
	static ::iluptype::list pending = NULL;

	if (type == NULL || type->importInterfaceName != NULL)
		return;
	if (pending == NULL)
		pending = iluptype::_iluparser_new_list();
	if (iluptype::_list_find(sorted, MatchPointer, type) != NULL)
		return;
	if (iluptype::_list_find(pending, MatchPointer, type) != NULL)
    {
		iluptype::_list_insert(sorted, type);
		iluptype::_list_remove(pending, type);
		return;
    }

	t = iluptype::_type_basic_type(type);
	iluptype::_list_insert(pending, type);

	if (type->importInterfaceName == NULL)
    {
		switch (t)
		{
			case iluptype::object_Type:
				if (type->marked)
					break;
				iluptype::_list_enumerate(iluptype::_class_object(type)->superclasses, (::iluptype::iluparser_EnumProc) sort_classes, sorted);
				type->marked = TRUE;
				break;

			default:  // Shouldn't happen
				break;
		}
    }
	if (iluptype::_list_find(sorted, MatchPointer, type) == NULL)
		iluptype::_list_insert(sorted, type);
	iluptype::_list_remove(pending, type);
}

static void SortArgTypes(::iluptype::Argument arg, ::iluptype::list sorted)
{
	sort_types(arg->type, sorted);  
}

static void SortMethodArgTypes(::iluptype::Argument arg, ::iluptype::list sorted)
{
	if (!PassedByRef(arg->type))
		sort_types(arg->type, sorted);  
}

static void SortMethodTypes(::iluptype::Procedure m, ::iluptype::list sorted)
{
	::iluptype::TypeKind tk = iluptype::_type_kind(m->returnType);

	if (!m->returnOptional &&
		!(TypeIsNonObjectStruct(iluptype::_ur_type(m->returnType)) ||
		tk  == iluptype::sequence_Type || tk == iluptype::object_Type))
			sort_types(m->returnType, sorted);

	iluptype::_list_enumerate(m->arguments, (::iluptype::iluparser_EnumProc) SortMethodArgTypes, sorted);
}

static ::iluptype::boolean MatchPointer(::iluptype::refany p1, ::iluptype::refany p2)
{
  return (p1 == p2);
}

::iluptype::boolean PassedByRef(::iluptype::Type type)
{
	::iluptype::TypeKind t;

	if (type == NULL)
		return (FALSE);

	t = iluptype::_type_ur_kind(type);
	return (t == iluptype::record_Type 
		|| t == iluptype::union_Type 
		|| t == iluptype::array_Type 
		|| t == iluptype::object_Type 
		|| t == iluptype::pipe_Type 
		|| t == iluptype::sequence_Type);
}



::iluptype::boolean TypeIsNonObjectStruct(::iluptype::Type type)
{
	::iluptype::TypeKind t;

	if (type == NULL)
		return (FALSE);
	
	t = iluptype::_type_ur_kind(type);
	return (t == iluptype::record_Type || t == iluptype::union_Type);
}
