/** 
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
  
 EndILUCopyright
*/

/*
$Id: cppgenstub.cpp,v 1.23 1998/11/04 22:50:39 larner Exp $
*/

#include <string.h>  // TEMP: for ReusableString

#include "cppgen.hpp"
#include "cppparse.hpp"
#include "cppparsestream.hpp"
#include "cppportability.hpp"


// TEMP should move this to some common place
class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    void reset () {
        str[0] = '\0';
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }
    char * str;
    int maxLen;
};


CppParseStream(ofstream) &
CppGen(NamedValue)::
_sizing (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->sizing(this, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(NamedValue)::
_initialDeclsInput (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->initialDeclsInput(this, ILUCPP_FALSE, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(NamedValue)::
_initialDeclsOutput (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->initialDeclsOutput(this, ILUCPP_FALSE, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(NamedValue)::
_send (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->send(this, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(NamedValue)::
_receive (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->receive(this, ofs);
    return ofs;
}


CppParseStream(ofstream) &
CppGen(UnionArm)::
_setDefs (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->unionArmSetDefs(this, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(UnionArm)::
_getDefs (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->unionArmGetDefs(this, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(UnionArm)::
_setImpls (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->unionArmSetImpls(this, ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(UnionArm)::
_getImpls (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->unionArmGetImpls(this, ofs);
    return ofs;
}

/*
CppParseStream(ofstream) &
CppGen(Parameter)::
_surrogateInitialDecls (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->surrogateInitialDecls(this, ofs);
  return ofs;
}
*/

CppParseStream(ofstream) &
CppGen(Parameter)::
_surrogateReceive (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->surrogateReceive(this, ofs);
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_surrogatePreProcessing (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->surrogatePreProcessing(this, ofs);
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_surrogateCleanup (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->surrogateCleanup(this, ofs);
  return ofs;
}

/*
CppParseStream(ofstream) &
CppGen(Parameter)::
_trueInitialDecls (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->trueInitialDecls(this, ofs);
  return ofs;
}
*/

CppParseStream(ofstream) &
CppGen(Parameter)::
_trueReceive (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->trueReceive(this, ofs);
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_truePassToTrueMethod (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->truePassToTrueMethod(this, ofs);
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_truePostTrueMethodProcessing(CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->truePostTrueMethodProcessing(this, ofs);
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_initialDeclsInput (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->initialDeclsInput(this, sibling(), ofs);
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Parameter)::
_initialDeclsOutput (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(type())->initialDeclsOutput(this, sibling(), ofs);
    return ofs;
}


/* TMP 9/5 
void
CppGen(Type)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) nvUsage = nv->usage();
    const char * nvName =
        (nvUsage == CppParseName(recordMember) || nvUsage == CppParseName(unionMember)) ? nv->name(CppGen_(member_key)) :
        (nvUsage == CppParseName(element)) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    ofs << "_call += " << nvName << ";" << endl;
}

void
CppGen(Type)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) nvUsage = nv->usage();
    const char * nvName =
        (nvUsage == CppParseName(recordMember) || nvUsage == CppParseName(unionMember)) ? nv->name(CppGen_(member_key)) :
        (nvUsage == CppParseName(element)) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    ofs << "_call << " << nvName << ";" << endl;
}

void
CppGen(Type)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) nvUsage = nv->usage();
    const char * nvName =
        (nvUsage == CppParseName(recordMember)) ? nv->name(CppGen_(member_key)) :
        (nvUsage == CppParseName(element)) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    ofs << "_call >> " << nvName << ";" << endl;
    if (nvUsage == CppParseName(unionMember))
        ofs << nv->name(CppGen(accessor_key)) << "(" << nvName << ");" << endl;
}
TMP 9/5 */

/* TMP 9/19
void  // TMP 9/5: NEW
CppGen(Type)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	switch (nv->usage()) {
	case CppParseName(element):
		ofs << "_call += " << nv->name(CppGen_(element_key)) << ";" << endl;
		break;
	case CppParseName(recordMember):
		ofs << "_call += " << nv->name(CppGen_(member_key)) << ";" << endl;
		break;
	case CppParseName(unionMember):
		if (CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar())
			ofs << "_call += " << "*" << nv->name(CppGen_(member_key)) << ";" << endl;
		else
			ofs << "_call += " << nv->name(CppGen_(member_key)) << ";" << endl;
		break;
	default:
	    ofs << "_call += " << nv->localName() << ";" << endl;
		break;
	};
}
TMP 9/19 */


static  // TMP 9/19: NEW
void
booleanSizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

static  // TMP 9/19: NEW
void
booleanSend (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

static  // TMP 9/19: NEW
void
booleanReceive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
	if (nv->usage() == CppParseName(unionMember))
		ofs << nv->name(CppGen_(accessor_key)) << "(" << nv->name(CppGen_(member_key)) << ");" << endl;
}

static  // TMP 9/20: NEW
void
booleanInitialDecls (const CppGen(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    static ReusableString refType;
    refType.strcpy(nv->type()->name());
    refType.strcat("&");
    ofs << "iluBoolWrapper " << nv->localName(CppGen(wrapper_key)) << "(";
    ofs << CppGen(Cast)::constCast(refType.str);
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(out):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << nv->localName();
        break;
    case CppParseName(recordMember):
    case CppParseName(unionMember):
        ofs << nv->name(CppGen(member_key));
        break;
    case CppParseName(element):
        ofs << nv->localName(CppGen(element_key));
        break;
    };
    ofs << "));" << endl;
}

static  // TMP 9/19: NEW
void
booleanInitialDeclsInput (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::out, CppParseName(returnVal), CppParseName::member, CppParseName::element
        break;
    };
    booleanInitialDecls(nv, ofs);
}

static  // TMP 9/19: NEW
void
booleanInitialDeclsOutput (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::out, CppParseName(returnVal), CppParseName::member, CppParseName::element
        break;
    };
    booleanInitialDecls(nv, ofs);
}

void  // TMP 9/19: NEW
CppGen(Type)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	if (CppGen_(Boolean)::narrow(nv->type()) != NULL)  // TEMP: wish I didn't have to do this
		booleanSizing(nv, ofs);
	else {
		switch (nv->usage()) {
		case CppParseName(element):
			ofs << "_call += " << nv->name(CppGen_(element_key)) << ";" << endl;
			break;
		case CppParseName(recordMember):
			ofs << "_call += " << nv->name(CppGen_(member_key)) << ";" << endl;
			break;
		case CppParseName(unionMember):
			if (CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar())
				ofs << "_call += " << "*" << nv->name(CppGen_(member_key)) << ";" << endl;
			else
				ofs << "_call += " << nv->name(CppGen_(member_key)) << ";" << endl;
			break;
		default:
			ofs << "_call += " << nv->localName() << ";" << endl;
			break;
		};
	};
}

/* TMP 9/19
void  // TMP 9/5: NEW
CppGen(Type)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	switch (nv->usage()) {
	case CppParseName(element):
		ofs << "_call << " << nv->name(CppGen_(element_key)) << ";" << endl;
		break;
	case CppParseName(recordMember):
		ofs << "_call << " << nv->name(CppGen_(member_key)) << ";" << endl;
		break;
	case CppParseName(unionMember):
		if (CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar())
			ofs << "_call << " << "*" << nv->name(CppGen_(member_key)) << ";" << endl;
		else
			ofs << "_call << " << nv->name(CppGen_(member_key)) << ";" << endl;
		break;
	default:
	    ofs << "_call << " << nv->localName() << ";" << endl;
		break;
	};
}
TMP 9/19 */

void  // TMP 9/19: NEW
CppGen(Type)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	if (CppGen_(Boolean)::narrow(nv->type()) != NULL)  // TEMP: wish I didn't have to do this
		booleanSend(nv, ofs);
	else {
		switch (nv->usage()) {
		case CppParseName(element):
			ofs << "_call << " << nv->name(CppGen_(element_key)) << ";" << endl;
			break;
		case CppParseName(recordMember):
			ofs << "_call << " << nv->name(CppGen_(member_key)) << ";" << endl;
			break;
		case CppParseName(unionMember):
			if (CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar())
				ofs << "_call << " << "*" << nv->name(CppGen_(member_key)) << ";" << endl;
			else
				ofs << "_call << " << nv->name(CppGen_(member_key)) << ";" << endl;
			break;
		default:
			ofs << "_call << " << nv->localName() << ";" << endl;
			break;
		};
	};
}

/* TMP 9/19
void
CppGen(Type)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	switch (nv->usage()) {
	case CppParseName(element):
		ofs << "_call >> " << nv->name(CppGen_(element_key)) << ";" << endl;
		break;
	case CppParseName(recordMember):
		ofs << "_call >> " << nv->name(CppGen_(member_key)) << ";" << endl;
		break;
// TMP 9/13	case CppParseName(unionMember):
// TMP 9/13		if (CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar())
// TMP 9/13			ofs << "_call >> " << "*" << nv->name(CppGen_(member_key)) << ";" << endl;
// TMP 9/13		else
// TMP 9/13			ofs << "_call >> " << nv->name(CppGen_(member_key)) << ";" << endl;
// TMP 9/13		break;
	case CppParseName(unionMember): {  // TMP 9/13: NEW
		const char * nvName = CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar()
			? nv->localName()
			: nv->name(CppGen_(member_key));
		ofs << "_call >> " << nvName << ";" << endl;
		ofs << nv->name(CppGen_(accessor_key)) << "(" << nvName << ");" << endl;
		break; };
	default:
	    ofs << "_call >> " << nv->localName() << ";" << endl;
		break;
	};
}
TMP 9/19 */

void  // TMP 9/19: NEW
CppGen(Type)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
	if (CppGen_(Boolean)::narrow(nv->type()) != NULL)  // TEMP: wish I didn't have to do this
		booleanReceive(nv, ofs);
	else {
		switch (nv->usage()) {
		case CppParseName(element):
			ofs << "_call >> " << nv->name(CppGen_(element_key)) << ";" << endl;
			break;
		case CppParseName(recordMember):
			ofs << "_call >> " << nv->name(CppGen_(member_key)) << ";" << endl;
			break;
		case CppParseName(unionMember): {  // TMP 9/13: NEW
			const char * nvName = CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar()
				? nv->localName()
				: nv->name(CppGen_(member_key));
			ofs << "_call >> " << nvName << ";" << endl;
			ofs << nv->name(CppGen_(accessor_key)) << "(" << nvName << ");" << endl;
			break; };
		default:
			ofs << "_call >> " << nv->localName() << ";" << endl;
			break;
		};
	};
}
void
CppGen(Type)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream)& ofs) const {
/* TMP 9/7
    if (needsSurrogateSideCleanup())
        ofs << nv->localName() << "._surrogateSideCleanup();" << endl;
TMP 9/7 */
    if (needsSurrogateSideCleanup()) {  // TMP 9/7: NEW
		if (nv->usage() == CppParseName(unionMember))
			ofs << "(*" << nv->localName() << ")->_surrogateSideCleanup();" << endl;
		else
			ofs << nv->localName() << "._surrogateSideCleanup();" << endl;
	};
}

/* TMP 9/19
void
CppGen(Type)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(returnVal):
// TMP 9/5    case CppParseName(unionMember):
        ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
        break;
    default:
        break;
    };
}
TMP 9/19 */

void  // TMP 9/19: NEW
CppGen(Type)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
	if (CppGen_(Boolean)::narrow(nv->type()) != NULL)  // TEMP: wish I didn't have to do this
		booleanInitialDeclsInput(nv, ofs);
	else {
		switch (nv->usage()) {
		case CppParseName(in):
		case CppParseName(inOut):
		case CppParseName(returnVal):
	// TMP 9/5    case CppParseName(unionMember):
			ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
			break;
		default:
			break;
		};
	};
}

/* TMP 8/9
void  // TMP 6/28: NEW
CppGen(Type)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << ">  _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}
*/

void  // TMP 8/9: NEW
CppGen(Type)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper _returnVal;" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other mbedded optionals
        break;
    };
}

/* TMP 9/19
void
CppGen(Type)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
        break;
    default:
        break;
    };
}
TMP 9/19 */

void  // TMP 9/19: NEW
CppGen(Type)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
	if (CppGen_(Boolean)::narrow(nv->type()) != NULL)  // TEMP: wish I didn't have to do this
		booleanInitialDeclsOutput(nv, ofs);
	else {
		switch (nv->usage()) {
		case CppParseName(out):
		case CppParseName(returnVal):
			ofs << nv->type()->name() << " " << nv->localName() << ";" << endl;
			break;
		default:
			break;
		};
	};
}

/*
void  // TMP 6/28: NEW
CppGen(Type)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}
*/

void  // TMP 8/9: NEW
CppGen(Type)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptional" << typeKindName(ILUCPP_TRUE) << "Wrapper _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}

void
CppGen(Type)::
surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    receive(parm, ofs);
}

void
CppGen(Type)::
surrogatePreProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
}

void
CppGen(Type)::
trueReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    surrogateReceive(parm, ofs);
}

void
CppGen(Type)::
truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << parm->localName();
}

void
CppGen(Type)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
}

void
CppGen(Type)::
assignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
    ofs << to << " = " << from << ";" << endl;
}

void
CppGen(Type)::
optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << "if (" << from << " == NULL)" << endl;
	ofs.indent++;
	ofs << from << " = NULL;" << endl;
	ofs.indent--;
	ofs << "else" << endl;
	ofs.indent++;
    ofs << to << " = new " << name() << "(*" << from << ");" << endl;
	ofs.indent--;
}

void
CppGen(Type)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << "void" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (" << usageName(CppParseName(in)) << ");" << endl;
}

void
CppGen(Type)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	if (unionDataMemberIsVar()) {
		// return const reference
		ofs << "const " << arm->type()->name(scope()) << "&" << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
		// return reference
		ofs << endl;
		ofs << arm->type()->name(scope()) << "&" << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " ();" << endl;
	}
	else {
		// return value
		ofs << usageName(CppParseName(returnVal)) << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
	};
}

/* TMP 9/4

				const NewUnions(SimpleSeq)&  // TMP 9/4: NEW
				NewUnions(ConstructedTypes2Union)::
				_SimpleSeq_arm () const {
					return *_SimpleSeq_arm_val;
				}

				NewUnions(SimpleSeq)&  // TMP 9/4: NEW
				NewUnions(ConstructedTypes2Union)::
				_SimpleSeq_arm () {
					return *_SimpleSeq_arm_val;
				}

				void
				NewUnions(ConstructedTypes2Union)::
				_SimpleSeq_arm (const NewUnions(SimpleSeq)& _value) {
					_unset();
					_discriminator = 2;
				// TMP 9/1    _SimpleSeq_arm_val = _value;
					_SimpleSeq_arm_val = new NewUnions_(SimpleSeq_var)(new NewUnions_(SimpleSeq)(_value));  // TMP 9/1: NEW
					_beenSet = ILUCPP_TRUE;
				}
TMP 9/4 */

void
CppGen(Type)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	if (unionDataMemberIsVar()) {

		// set from const reference to value
		ofs << "void" << endl;
		ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
		ofs << arm->localName(CppGen_(accessor_key));
		ofs << " (const " << arm->type()->name(arm->scope()) << "& _value" << ") {" << endl;
		ofs.indent++;
		ofs << "_unset();" << endl;
		ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
		ofs << arm->localName(CppGen_(member_key)) << " = new " << arm->type()->usageName(CppParseName(var), arm->scope())
			<< "(new " << arm->type()->name(arm->scope()) << "( _value));" << endl;
		ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
		ofs.indent--;
		ofs << "}" << endl;

	}

	else {

		// set from value
		ofs << "void" << endl;
		ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
		ofs << arm->localName(CppGen_(accessor_key));
		ofs << " (" << arm->type()->usageName(CppParseName(in), arm->scope()) << " _value" << ") {" << endl;
		ofs.indent++;
		ofs << "_unset();" << endl;
		ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
		ofs << arm->localName() << " = _value;" << endl;
		ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
		ofs.indent--;
		ofs << "}" << endl;

	};

}

void
CppGen(Type)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	if (unionDataMemberIsVar()) {

		// get const reference to value
		ofs << "const "  << arm->type()->name() << "&" << endl;
		ofs << arm->scope()->name() << "::" << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " () const {" << endl;
		ofs.indent++;
		ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
		ofs.indent--;
		ofs << "}" << endl;

		// get reference to value
		ofs << endl;
		ofs << arm->type()->name() << "&" << endl;
		ofs << arm->scope()->name() << "::" << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " () {" << endl;
		ofs.indent++;
		ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
		ofs.indent--;
		ofs << "}" << endl;

	}

	else {

		// get value
		ofs << usageName(CppParseName(returnVal)) << endl;
		ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
		ofs << arm->localName(CppGen_(accessor_key)) << " () const {" << endl;
		ofs.indent++;
		ofs << "return " << arm->localName() << ";" << endl;
		ofs.indent--;
		ofs << "}" << endl;

	};
}

ILUCPP_BOOL
CppGen(Type)::
unionDataMemberIsVar () const {
    return ILUCPP_FALSE;
}


void
CppGen(Object)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(out):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(unionMember):
        ofs << "_call += *" << nv->name(CppGen_(member_key)) << ";" << endl;
        break;
    default:
        CppGen_(Type)::sizing(nv, ofs);
    };
}

void
CppGen(Object)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(out):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(unionMember):
        ofs << "_call << *" << nv->name(CppGen_(member_key)) << ";" << endl;
        break;
    default:
        CppGen_(Type)::send(nv, ofs);
    };
}

void
CppGen(Object)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(recordMember):
        ofs << nv->localName() << ".iluDeleteWrapper();" << endl;
        break;
    case CppParseName(unionMember):
        ofs << nv->localName() << "->iluDeleteWrapper();" << endl;
        break;
    case CppParseName(element):
        ofs << "_element->iluDeleteWrapper();" << endl;
        break;
    default:
        break;
    };
}

void
CppGen(Object)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << usageName(CppParseName(ptr)) << " " << nv->localName() << ";" << endl;
    case CppParseName(out):
        ofs << "iluObjectWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << CppGen_(Bool)::value(ILUCPP_FALSE) << ", " << name() << "::iluGetILUClassRecord());" << endl;
        break;
    case CppParseName(unionMember):
        ofs << usageName(CppParseName(var)) << " " << nv->localName() << ";" << endl;
        break;
    default:
		break;
    };
}

/* TMP 6/30
void  // TMP 6/28: NEW
CppGen(Object)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key))
            << "(" << name() << "::iluGetILUClassRecord());" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key))
            << "(" << name() << "::iluGetILUClassRecord(), " << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}
*/

void  // TMP 6/28: NEW
CppGen(Object)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(inOut):  // true INOUT parms
        if (sibling) {
            ofs << "iluOptionalSiblingObjectWrapperT<" << nv->scope()->scope()->name() << ", " << name() << "> "
                << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
                << "(_trueObject, " << name() << "::iluGetILUClassRecord());" << endl;  // discriminator, class
            break;
        };
    case CppParseName(in):  // true IN parms
        ofs << "iluOptionalObjectWrapperT<" << name() << "> "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << name() << "::iluGetILUClassRecord())"  // class
            << ";" << endl;
        break;
    case CppParseName(out):  // surrogate OUT parms
        ofs << "iluOptionalObjectWrapperT<" << name() << "> "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << name() << "::iluGetILUClassRecord(), " << nv->localName() << ")"  // class, object being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(returnVal):  // surrogate return values
        ofs << "iluOptionalObjectWrapperT<" << name() << "> "
            << "_returnVal;" << endl;  // wrapper instance name
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalObjectWrapperT<" << name() << "> " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other mbedded optionals
        break;
    };
}

void
CppGen(Object)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluObjectWrapper " << nv->localName(CppGen_(wrapper_key));
        ofs << "(" << nv->localName() << ", " << CppGen_(Bool)::value(ILUCPP_FALSE) << ", ";
        ofs << "((" << nv->localName() << " == NULL) ? " << name() << "::iluGetILUClassRecord() : NULL));" << endl;
        break;
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << usageName(CppParseName(ptr)) << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::member, CppParseName::element, CppParseName(in)
        break;
    };
}

/* TMP 6/30
void  // TMP 6/28: NEW
CppGen(Object)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key))
            << "(" << nv->localName() << ", "
            << "((" << nv->localName() << " == NULL) ? "
            << name() << "::iluGetILUClassRecord() : NULL));" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalObjectWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}
*/

void  // TMP 6/28: NEW
CppGen(Object)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // surrogate IN parms
        ofs << "const ";
    case CppParseName(inOut):  // surrogate INOUT parms
        if (sibling) {
            ofs << "iluOptionalSiblingObjectWrapperT<" << nv->scope()->scope()->name() << ", " << name() << "> "
                << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
                << "(this, " << nv->localName() << ", "  // discriminator, object being "wrapped"
                << "((" << nv->localName() << " == NULL) ? " << name() << "::iluGetILUClassRecord() : NULL));" << endl;  // class
        }
        else {
            ofs << "iluOptionalObjectWrapperT<" << name() << "> "
                << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
                << "(" << nv->localName() << ", "  // object being "wrapped"
                << "((" << nv->localName() << " == NULL) ? " << name() << "::iluGetILUClassRecord() : NULL));" << endl;  // class
        };
        break;
    case CppParseName(out):  // true OUT parms
        if (sibling) {
            ofs << "iluOptionalSiblingObjectWrapperT<" << nv->scope()->scope()->name() << ", " << name() << "> "
                << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
                << "(_trueObject);" << endl;  // discriminator for sibling check
        }
        else {
            ofs << "iluOptionalObjectWrapperT<" << name() << "> "
                << nv->localName(CppGen_(wrapper_key)) << ";" << endl;  // wrapper instance name
        };
        break;
    case CppParseName(returnVal):  // true return values
        ofs << "iluOptionalObjectWrapperT<" << name() << "> "
            << "_returnVal;" << endl;  // wrapper instance name
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}

void
CppGen(Object)::
surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << "_call >> " << parm->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << parm->localName() << " = " << CppGen_(Cast)::reinterpretCast(usageName(CppParseName(ptr)));
    ofs << parm->localName(CppGen_(wrapper_key)) << ".m_pv_iluobject);" << endl;
}

void
CppGen(Object)::
surrogatePreProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    switch (parm->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        // sibling check
        if (parm->sibling()) {
            ofs << "if (!iluInSameServer(" << parm->localName() << ")) {" << endl;
            ofs.indent++;
            ofs << CppParseName(CorbaBAD_PARAM)()->name() << " _exception;" << endl;
            ofs << "throw(_exception);" << endl;
            ofs.indent--;
            ofs << "};" << endl;
        };
        break;
    default:  // in, out, returnVal
        break;
    };
}

void
CppGen(Object)::
trueReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << "_call >> " << parm->localName(CppGen_(wrapper_key)) << ";" << endl;
    switch (parm->usage()) {
        case CppParseName(in):
        case CppParseName(inOut):
            ofs << parm->localName() << " = " << CppGen_(Cast)::reinterpretCast(usageName(CppParseName(ptr)));
            ofs << parm->localName(CppGen_(wrapper_key)) << ".m_pv_iluobject);" << endl;
            break;
        default:
            break;
    };
}

void
CppGen(Object)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ILUCPP_BOOL sibling = ILUCPP_FALSE;
    switch (parm->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        // declare wrapper, begin sibling check
        ofs << "iluObjectWrapper " << parm->localName(CppGen_(wrapper_key));
        ofs << "(*" << parm->localName() << ", " << CppGen_(Bool)::value(ILUCPP_FALSE) << ");" << endl;
        if (sibling = parm->sibling())
            ofs << "if (!_trueObject->iluInSameServer(" << parm->localName() << ")) {" << endl;
        break;
    case CppParseName(inOut):
        // update wrapper, begin sibling check
        ofs << parm->localName(CppGen_(wrapper_key)) << ".iluReviseForObject(";
        ofs << CppGen_(Cast)::reinterpretCast(usageName(CppParseName(ptr))) << parm->localName() << "));" << endl;
        if (sibling = parm->sibling()) {
            ofs << "if (!_trueObject->iluInSameServer("
                << CppGen_(Cast)::reinterpretCast(usageName(CppParseName(ptr)))
                << parm->localName(CppGen_(wrapper_key)) << ".m_pv_iluobject))) {" << endl;
        };
        break;
    default:  // in, returnVal
        break;
    };
    if (sibling) {
        // complete sibling check
        ofs.indent++;
        ofs << CppParseName(CorbaBAD_PARAM)()->name() << " _exception;" << endl;
        ofs << "throw(_exception);" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };
}

void  // TMP 9/9: NEW
CppGen(Object)::
assignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << to << " = " << name() << "::_duplicate(" << from << ");" << endl;
}

void  // TMP 9/9: NEW
CppGen(Object)::
optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << to << " = " << name() << "::_duplicate(" << from << ");" << endl;
}

void  // TMP 9/4: NEW
CppGen(Object)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << "void" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->usageName(CppParseName(ptr), arm->scope()) << ");" << endl;
}

void  // TMP 9/4: NEW
CppGen(Object)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << arm->type()->usageName(CppParseName(ptr), arm->scope()) << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
}

void
CppGen(Object)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
    ofs << "void" << endl;
    ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
    ofs << arm->localName(CppGen_(accessor_key))
        << " (" << usageName(CppParseName(in), arm->scope()) << " _value" << ") {" << endl;
    ofs.indent++;
    ofs << "_unset();" << endl;
    ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
// TMP 9/21    ofs << localName() << "::_duplicate(_value);" << endl;
    ofs << name(arm->scope()) << "::_duplicate(_value);" << endl;  // TMP 9/21: NEW
    ofs << arm->localName() << " = new " << arm->type()->usageName(CppParseName(var), arm->scope()) << "(_value);" << endl;
    ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
    ofs.indent--;
    ofs << "}" << endl;
}

void  // TMP 9/4: NEW
CppGen(Object)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << arm->type()->usageName(CppParseName(ptr)) << endl;
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () const {" << endl;
	ofs.indent++;
	ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

ILUCPP_BOOL
CppGen(Object)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


static
void
enumerationInitialDecls (const CppGen(NamedValue) * nv, CppParseStream(ofstream) & ofs) {
    static ReusableString enumRefType;
    enumRefType.strcpy(nv->type()->name());
    enumRefType.strcat("&");
    ofs << "iluEnumWrapper " << nv->localName(CppGen(wrapper_key)) << "(" << endl;
    ofs.indent++;
    ofs << CppGen(Cast)::reinterpretCast("iluDummyEnum&");
    ofs << CppGen(Cast)::constCast(enumRefType.str);
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(out):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << nv->localName();
        break;
    case CppParseName(recordMember):
    case CppParseName(unionMember):
        ofs << nv->name(CppGen(member_key));
        break;
    case CppParseName(element):
        ofs << nv->localName(CppGen(element_key));
        break;
    };
    ofs << "))" << endl;
    ofs.indent--;
    ofs << ");" << endl;
}

void
CppGen(Enumeration)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(returnVal):
        ofs << name() << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::out, CppParseName(returnVal), CppParseName::member, CppParseName::element
        break;
    };
    enumerationInitialDecls(nv, ofs);
}

void  // TMP 8/9: NEW
CppGen(Enumeration)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key))
            << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
	};
}

void
CppGen(Enumeration)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << name() << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::out, CppParseName(returnVal), CppParseName::member, CppParseName::element
        break;
    };
    enumerationInitialDecls(nv, ofs);
}

void  // TMP 8/9: NEW
CppGen(Enumeration)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key))
			<< "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalEnumerationWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}

void
CppGen(Enumeration)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(Enumeration)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(Enumeration)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

/*  TEMP 4/19
void
CppGen(Enumeration)::
surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    receive(parm, ofs);
}
*/

void
CppGen(Enumeration)::
truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    static ReusableString castTo;
    castTo.strcpy(parm->type()->name());
    castTo.strcat("&");
    ofs << CppGen_(Cast)::reinterpretCast(castTo.str)
        << parm->localName(CppGen_(wrapper_key)) << ".m_r_enum)";
}


void
CppGen(Sequence)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << "_call += *" << nv->localName() << ";" << endl;
        break;
    default:
        CppGen_(Type)::sizing(nv, ofs);
        break;
    };
}

void
CppGen(Sequence)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << "_call << *" << nv->localName() << ";" << endl;
        ofs << "delete " << nv->localName() << ";" << endl;
        break;
    default:
        CppGen_(Type)::send(nv, ofs);
        break;
    };
}

void
CppGen(Sequence)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << "_call >> *" << nv->localName() << ";" << endl;
        break;
    default:
        CppGen_(Type)::receive(nv, ofs);
        break;
    };
}

void
CppGen(Sequence)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    if (needsSurrogateSideCleanup()) {
        switch (nv->usage()) {
        case CppParseName(out):
        case CppParseName(returnVal):
            ofs << nv->localName() << "->_surrogateSideCleanup();" << endl;
            break;
        default:
            CppGen_(Type)::surrogateCleanup(nv, ofs);
            break;
        };
    };
}

void
CppGen(Sequence)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
        ofs << nv->localName() << " = new " << nv->type()->name() << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << nv->type()->name() << "* " << nv->localName() << " = new " << nv->type()->name() << ";" << endl;
        break;
	case CppParseName(unionMember):  // TMP 9/13: NEW
		ofs << name() << " " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW
    default:
        CppGen_(Type)::initialDeclsInput(nv, sibling, ofs);
        break;
    };
}

void
CppGen(Sequence)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << ">  _returnVal;" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
	};
}

void
CppGen(Sequence)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << nv->type()->name() << "* " << nv->localName() << ";" << endl;
        break;
    default:
        CppGen_(Type)::initialDeclsOutput(nv, sibling, ofs);
        break;
    };
}

void
CppGen(Sequence)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}

ILUCPP_BOOL  // TMP 9/1: NEW
CppGen(Sequence)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


void
CppGen(Array)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(returnVal): {
        ReusableString allocBaseName;
        allocBaseName.strcpy(simpleName());
        allocBaseName.strcat("_alloc");
        ofs << usageName(CppParseName(slice)) << "* " << nv->localName(CppGen_(parm_slice_key));
        ofs << " = " << CppParseName(TempName)(allocBaseName.str, scope()).name() << "();" << endl;
        break; };
    case CppParseName(inOut):
        ofs << name() << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::out, CppParseName::element, CppParseName::member
        break;
    };

}

void  // TMP 7/15: NEW
CppGen(Array)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // true IN parms
    case CppParseName(inOut):  // true INOUT parms
        ofs << "iluOptionalArrayWrapperT "  // template type
            << "<" << usageName(CppParseName(slice)) << ", "  // slice type
            << usageName(CppParseName(var)) << "> "  // var type
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << ";" << endl;
        break;
    case CppParseName(out):  // surrogate OUT parms
        ofs << "iluOptionalArray" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT"  // template type
            << "<" << usageName(CppParseName(slice)) << ", "  // slice type
            << usageName(CppParseName(var)) << "> "  // var type
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // array being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(returnVal):  // surrogate return values
        ofs << "iluOptionalArray" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT"  // template type
            << "<" << usageName(CppParseName(slice)) << ", "  // slice type
            << usageName(CppParseName(var)) << "> "  // var type
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << ";" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalArrayWrapperT<"
			<< usageName(CppParseName(slice)) << ", " << usageName(CppParseName(var)) << "> "
			<< nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
	};
}

void
CppGen(Array)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(out):
        if (variableLength())
            ofs << usageName(CppParseName(slice)) << "*";
        else
            ofs << name();
        ofs << " " << nv->localName() << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << usageName(CppParseName(var)) << " " << nv->localName() << ";" << endl;
        break;
    default:  // CppParseName::in, CppParseName::inOut, CppParseName::element, CppParseName:member
        break;
    };
}

void  // TMP 7/15: NEW
CppGen(Array)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // surrogate IN parms
    case CppParseName(inOut):  // surrogate INOUT parms
        ofs << "iluOptionalArray" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT"  // template type
            << "<" << usageName(CppParseName(slice)) << ", "  // slice type
            << usageName(CppParseName(var)) << "> "  // var type
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // array being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(out):  // true OUT parms
    case CppParseName(returnVal):  // true return values
        ofs << "iluOptionalArrayWrapperT "  // template type
            << "<" << usageName(CppParseName(slice)) << ", "  // slice type
            << usageName(CppParseName(var)) << "> "  // var type
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << ";" << endl;
        break;
    default:  // TMP 7/6: Embedded optionals
        break;
    };
}

void
CppGen(Array)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    const char * opName;
	ILUCPP_BOOL dereference = FALSE;  // TMP 9/5: NEW
    switch (usage) {
    case CppParseName(in):
    case CppParseName(recordMember):
        opName = "_size_const";
        break;
    case CppParseName(unionMember):  // TMP 9/5: NEW
        dereference = CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar();
        opName = "_size";
        break;
    default:
        opName = "_size";
        break;
    };
// TMP 9/5    ofs << usageName(CppParseName(var)) << "::" << opName << "(_call, " << nvName << ");" << endl;
    ofs << usageName(CppParseName(var)) << "::" << opName << "(_call, " << (dereference ? "*" : "") << nvName << ");" << endl;  // TMP 9/5: NEW
}

void
CppGen(Array)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    const char * opName;
	ILUCPP_BOOL dereference = FALSE;  // TMP 9/5: NEW
    switch (usage) {
    case CppParseName(in):
    case CppParseName(recordMember):
        opName = "_output_const";
        break;
    case CppParseName(unionMember):  // TMP 9/5: NEW
        dereference = CppGen_(Type)::narrow(nv->type())->unionDataMemberIsVar();
        opName = "_output";
        break;
    default:
        opName = "_output";
        break;
    };
// TMP 9/5    ofs << usageName(CppParseName(var)) << "::" << opName << "(_call, " << nvName << ");" << endl;
    ofs << usageName(CppParseName(var)) << "::" << opName << "(_call, " << (dereference ? "*" : "") << nvName << ");" << endl;  // TMP 9/5: NEW
}

void
CppGen(Array)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    if (needsSurrogateSideCleanup()) {
        const char * opName;
        switch (nv->usage()) {
        case CppParseName(in):
        case CppParseName(recordMember):
            opName = "_surrogateSideCleanup_const";
            break;
        default:
            opName = "_surrogateSideCleanup";
            break;
        };
        ofs << usageName(CppParseName(var)) << "::" << opName << "(" << nv->localName() << ");" << endl;
    };
};

void
CppGen(Array)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        usage == CppParseName(in) ? nv->localName(CppGen_(parm_slice_key)) :
        nv->localName();
	ILUCPP_BOOL dereference = (usage == CppParseName(unionMember));  // TMP 9/5: NEW
    if (usage == CppParseName(out) && variableLength()) {
        // Allocate the array
        ReusableString allocBaseName;
        CppParseName(TempName) allocName;
        allocBaseName.strcpy(simpleName());
        allocBaseName.strcat("_alloc");
        allocName.reset(allocBaseName.str, scope());
        ofs << nvName << " = " << allocName.name() << "();" << endl;
    };
    // Read in the array
// TMP 9/5    ofs << usageName(CppParseName(var)) << "::_input(_call, " << nvName << ");" << endl;
    ofs << usageName(CppParseName(var)) << "::_input(_call, " << (dereference ? "*" : "") << nvName << ");" << endl;  // TMP 9/5: NEW
    if (usage == CppParseName(in)) {
        // Put the array slice into a var
        ofs << usageName(CppParseName(var)) << " " << nv->localName()
            << "(" << nvName << ");" << endl;
    };
}

void
CppGen(Array)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    if (parm->usage() == CppParseName(out) && variableLength()) {
        ofs << "// make up var to take care of memory management" << endl;
        ofs << usageName(CppParseName(var)) << " " << parm->localName(CppGen_(parm_var_key))
            << "(" << parm->localName() << ");" << endl;
    };
}

void
CppGen(Array)::
assignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
    ofs << usageName(CppParseName(var)) << "::_copy(" << from << ", " << to << ");" << endl;
}

void  // TMP 9/9: NEW
CppGen(Array)::
optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << "if (" << from << " == NULL)" << endl;
	ofs.indent++;
	ofs << from << " = NULL;" << endl;
	ofs.indent--;
	ofs << "else" << endl;
	ofs.indent++;
    ofs << usageName(CppParseName(var)) << "::_copy(" << from << ", " << to << ");" << endl;
	ofs.indent--;
}

void  // TMP 9/4: NEW
CppGen(Array)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << "void" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->name(arm->scope()) << ");" << endl;
}

void  // TMP 9/4: NEW
CppGen(Array)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << arm->type()->usageName(CppParseName(slice), arm->scope()) << "*" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
}

void  // TMP 9/4: NEW
CppGen(Array)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	// build up name of array's _dup function
	static ReusableString dupSimpleName;
	dupSimpleName.strcpy(simpleName());
    dupSimpleName.strcat("_dup");
	CppParseName(TempName) dupName(dupSimpleName.str, arm->type()->scope());

    // define function
	ofs << "void" << endl;
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->name(arm->scope()) << " _value) {" << endl;
	ofs.indent++;
	ofs << "_unset();" << endl;
	ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
	ofs << arm->localName(CppGen_(member_key)) << " = new " << arm->type()->usageName(CppParseName(var), arm->scope())
		<< "(" << dupName.name(arm->scope()) << "(_value));" << endl;
	ofs << "_beenSet = ILUCPP_TRUE;" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

void  // TMP 9/4: NEW
CppGen(Array)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
	ofs << arm->type()->usageName(CppParseName(slice), arm->scope()) << "*" << endl;
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () const {" << endl;
	ofs.indent++;
	ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

ILUCPP_BOOL  // TMP 9/1: NEW
CppGen(Array)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


void
CppGen(String)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    switch (usage) {
    case CppParseName(in):
    case CppParseName(inOut):
        // declare parm
        ofs << name() << " " << nvName << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ", " << CppGen_(Bool)::value(ILUCPP_TRUE) << ");" << endl;
        break;
    case CppParseName(returnVal):
        CppGen_(Type)::initialDeclsInput(nv, sibling, ofs);
    case CppParseName(out):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key));
        ofs << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ");" << endl;
        break;
    case CppParseName(element):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
// TMP 9/9        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs << nv->localName() << ".iluStringVarReference(), " << nv->localName(CppGen_(parm_length_key)) << endl;  // TMP 9/9: NEW
        ofs.indent--;
        ofs << ");" << endl;
        break;
/* TMP 9/13
    default:  // CppParseName::recordMember, CppParseName::unionMember
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
// TMP 9/9        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs << nv->name(CppGen_(member_key)) << (usage == CppParseName(unionMember) ? "->" : ".")
			<< "iluStringVarReference(), " << nv->localName(CppGen_(parm_length_key)) << endl;  // TMP 9/9: NEW
        ofs.indent--;
        ofs << ");" << endl;
        break;
TMP 9/13 */
    case CppParseName(recordMember):  // TMP 9/13: NEW
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
        ofs << nv->name(CppGen_(member_key)) << ".iluStringVarReference(), "
			<< nv->localName(CppGen_(parm_length_key)) << endl;
        ofs.indent--;
        ofs << ");" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
		// declare string to read value into
		ofs << name() << " " << nv->localName(CppGen_(member_key)) << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
        ofs << nv->localName(CppGen_(member_key)) << ", "
			<< nv->localName(CppGen_(parm_length_key)) << endl;
        ofs.indent--;
        ofs << ");" << endl;
        break;
    default: ;  // TMP 9/13: NEW
    };
}

void  // TMP 7/6: NEW
CppGen(String)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // true IN parms
    case CppParseName(inOut):  // true INOUT parms
        ofs << "iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(ILUCPP_DELETE_ON_DESTRUCT)"  // when to delete string
            << ";" << endl;
        break;
    case CppParseName(out):  // surrogate OUT parms
        ofs << "iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // string being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(returnVal):  // surrogate return values
        ofs << "iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << ";" << endl;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalCStringWrapper " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
    };
}

void
CppGen(String)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    switch (usage) {
    case CppParseName(in):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = strlen(" << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ");" << endl;
        break;
    case CppParseName(inOut):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = strlen(" << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
// TMP 6/7        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_OUTPUT);" << endl;
        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_INPUT);" << endl;  // TMP 6/7
        break;
    case CppParseName(out):
    case CppParseName(returnVal):
        // declare parm
        ofs << name() << " " << nvName << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key));
        ofs << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ", " << CppGen_(Bool)::value(ILUCPP_TRUE) << ");" << endl;
        break;
    case CppParseName(element):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = strlen(" << (usage == CppParseName(unionMember) ? "*" : "") << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
// TMP 9/9        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs << nv->localName() << ".iluStringVarReference(), " << nv->localName(CppGen_(parm_length_key)) << endl;  // TMP 9/9: NEW
        ofs.indent--;
        ofs << ");" << endl;
        break;
    default:  // CppParseName::recordMember, CppParseName::unionMember
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = strlen(" << (usage == CppParseName(unionMember) ? "*" : "") << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluCStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
// TMP 9/9        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs << nv->name(CppGen_(member_key)) << (usage == CppParseName(unionMember) ? "->" : ".")
			<< "iluStringVarReference(), " << nv->localName(CppGen_(parm_length_key)) << endl;  // TMP 9/9: NEW
        ofs.indent--;
        ofs << ");" << endl;
        break;
    };
}

void  // TMP 7/6: NEW
CppGen(String)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // surogate IN parms
        ofs << "const iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // string being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(inOut):  // surrogate INOUT parms
        ofs << "iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ", ILUCPP_DELETE_ON_INPUT)"  // string being "wrapped", when to delete string
            << ";" << endl;
        break;
    case CppParseName(out):  // true OUT parms
    case CppParseName(returnVal):  // true return values
        ofs << "iluOptionalCStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(ILUCPP_DELETE_ON_DESTRUCT)"  // when to delete string
            << ";" << endl;
    default:  // TMP 7/6: Embedded optionals
        break;
    };
}

void
CppGen(String)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(String)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(String)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(String)::
truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_cstring";
}

void
CppGen(String)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    switch(parm->usage()) {
        case CppParseName(returnVal):  // set wrapper's cstring
            ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_cstring = "
                << parm->localName() << ";" << endl;
        case CppParseName(inOut):  // set wrapper's length
        case CppParseName(out):
            ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_card_length = "
                << "strlen(" << parm->localName(CppGen_(wrapper_key)) << ".m_r_cstring);" << endl;
        default: ;
    };
}

void  // TMP 9/9: NEW
CppGen(String)::
optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << to << " = " << from << ";" << endl;
}

void  // TMP 9/4: NEW
CppGen(String)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	// set from const string
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->usageName(CppParseName(in), scope()) << ");" << endl;
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string

	// set from string
	ofs << endl;
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->name(scope()) << ");" << endl;

	// set from string_var
	ofs << endl;
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (const " << arm->type()->usageName(CppParseName(var), scope()) << "&);" << endl;

}

void  // TMP 9/4: NEW
CppGen(String)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
    ofs << arm->type()->usageName(CppParseName(in), scope()) << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
}

/* Each union arm of typekind String (or WideString) has 3 modifier functions.
   The 3 functions have essentially the same code, except for the argument type.
   The following function is used to generate each modifier function (for both
   String's and WideString's.
*/
static  // TMP 9/4: NEW
void
stringUnionArmSetImpls (const char * valueType, const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) {
	ofs << "void" << endl;
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << "(" << valueType << " _value) {" << endl;
	ofs.indent++;
	ofs << "_unset();" << endl;
	ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
	ofs << arm->localName(CppGen_(member_key)) << " = new "
		<< arm->type()->usageName(CppParseName(var), arm->scope()) << "(_value);" << endl;
	ofs << "_beenSet = ILUCPP_TRUE;" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

void  // TMP 9/4: NEW
CppGen(String)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

    // set from const string
	stringUnionArmSetImpls(arm->type()->usageName(CppParseName(in), arm->scope()), arm, ofs);
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string

    // set from string
	ofs << endl;
	stringUnionArmSetImpls(arm->type()->name(arm->scope()), arm, ofs);

    // set from const reference to string
	ofs << endl;
	static ReusableString constRefTypeName;
	constRefTypeName.strcpy("const ");
	constRefTypeName.strcat(arm->type()->usageName(CppParseName(var), arm->scope()));
	constRefTypeName.strcat("&");
	stringUnionArmSetImpls(constRefTypeName.str, arm, ofs);
}

void  // TMP 9/4: NEW
CppGen(String)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
    ofs << arm->type()->usageName(CppParseName(in)) << endl;
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << "() const {" << endl;
	ofs.indent++;
	ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

ILUCPP_BOOL  // TMP 9/1: NEW
CppGen(String)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


void
CppGen(WideString)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(WideString)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(WideString)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
}

void
CppGen(WideString)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    switch (usage) {
    case CppParseName(in):
    case CppParseName(inOut):
        // declare parm
        ofs << name() << " " << nvName << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_DESTRUCT);" << endl;
        break;
    case CppParseName(returnVal):
        CppGen_(Type)::initialDeclsInput(nv, sibling, ofs);
    case CppParseName(out):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key));
        ofs << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ");" << endl;
        break;
/* TMP 9/13
    default:  // CppParseName::recordMember, CppParseName::unionMember
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
// TMP 9/9        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs << nv->name(CppGen_(member_key)) << (usage == CppParseName(unionMember) ? "->" : ".")
			<< "iluStringVarReference(), " << nv->localName(CppGen_(parm_length_key)) << endl;  // TMP 9/9: NEW
        ofs.indent--;
        ofs << ");" << endl;
        break;
TMP 9/13 */
    case CppParseName(recordMember):  // TMP 9/13: NEW
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
        ofs << nv->name(CppGen_(member_key)) << ".iluStringVarReference(), "
			<< nv->localName(CppGen_(parm_length_key)) << endl;
        ofs.indent--;
        ofs << ");" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
		// declare string to read value into
		ofs << name() << " " << nv->localName(CppGen_(member_key)) << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
        ofs << nv->localName(CppGen_(member_key)) << ", "
			<< nv->localName(CppGen_(parm_length_key)) << endl;
        ofs.indent--;
        ofs << ");" << endl;
        break;
    default: ;  // TMP 9/13: NEW
    };
}

void  // TMP 7/6: NEW
CppGen(WideString)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // true IN parms
    case CppParseName(inOut):  // true INOUT parms
        ofs << "iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(ILUCPP_DELETE_ON_DESTRUCT)"  // when to delete WString
            << ";" << endl;
        break;
    case CppParseName(out):  // surrogate OUT parms
        ofs << "iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // WString being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(returnVal):  // surrogate return values
        ofs << "iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << ";" << endl;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalWStringWrapper " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
    };
}

void
CppGen(WideString)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    const CppParseName(TypeUsage) usage = nv->usage();
    const char * nvName = 
        usage == CppParseName(recordMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(unionMember) ? nv->name(CppGen_(member_key)) :
        usage == CppParseName(element) ? nv->name(CppGen_(element_key)) :
        nv->localName();
    switch (usage) {
    case CppParseName(in):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = iluCppRuntime::iluCharacterStringLength(" << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ");" << endl;
        break;
    case CppParseName(inOut):
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = iluCppRuntime::iluCharacterStringLength(" << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key))
            << "(" << nvName << ", ";
// TMP 6/7        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_OUTPUT);" << endl;
        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_INPUT);" << endl;  // TMP 6/7
        break;
    case CppParseName(out):
    case CppParseName(returnVal):
        // declare parm
        ofs << name() << " " << nvName << ";" << endl;
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key)) << ";" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key));
        ofs << "(" << nvName << ", ";
        ofs << nv->localName(CppGen_(parm_length_key)) << ", ILUCPP_DELETE_ON_DESTRUCT);" << endl;
        break;
    default:  // CppParseName::recordMember, CppParseName::unionMember
        // declare length
        ofs << "iluCardinal " << nv->localName(CppGen_(parm_length_key))
            << " = iluCppRuntime::iluCharacterStringLength(" 
            << (usage == CppParseName(unionMember) ? "*" : "") << nvName << ");" << endl;
        // declare wrapper
        ofs << "iluWStringWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << endl;
        ofs.indent++;
        ofs << nvName << (usage == CppParseName(unionMember) ? "->" : ".") << "iluStringVarReference()," << endl;
        ofs << nv->localName(CppGen_(parm_length_key)) << endl;
        ofs.indent--;
        ofs << ");" << endl;
        break;
    };
}

void  // TMP 7/6: NEW
CppGen(WideString)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):  // surogate IN parms
        ofs << "const iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ")"  // string being "wrapped"
            << ";" << endl;
        break;
    case CppParseName(inOut):  // surrogate INOUT parms
        ofs << "iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(" << nv->localName() << ", ILUCPP_DELETE_ON_INPUT)"  // string being "wrapped", when to delete string
            << ";" << endl;
        break;
    case CppParseName(out):  // true OUT parms
    case CppParseName(returnVal):  // true return values
        ofs << "iluOptionalWStringWrapper "
            << nv->localName(CppGen_(wrapper_key))  // wrapper instance name
            << "(ILUCPP_DELETE_ON_DESTRUCT)"  // when to delete string
            << ";" << endl;
    default:  // TMP 7/6: Embedded optionals
        break;
    };
}

void
CppGen(WideString)::
truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_wstring";
}

void
CppGen(WideString)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    switch(parm->usage()) {
        case CppParseName(returnVal):  // set wrapper's wstring
            ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_wstring = "
                << parm->localName() << ";" << endl;
        case CppParseName(inOut):  // set wrapper's length
        case CppParseName(out):
            ofs << parm->localName(CppGen_(wrapper_key)) << ".m_r_card_length = "
                << "iluCppRuntime::iluCharacterStringLength(" << parm->localName(CppGen_(wrapper_key)) << ".m_r_wstring);" << endl;
        default: ;
    };
}

void  // TMP 9/9: NEW
CppGen(WideString)::
optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
	ofs << to << " = " << from << ";" << endl;
}

void  // TMP 9/4: NEW
CppGen(WideString)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	// set from const string
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->usageName(CppParseName(in), scope()) << ");" << endl;
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string

	// set from string
	ofs << endl;
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->name(scope()) << ");" << endl;

	// set from string_var
	ofs << endl;
    ofs << "void" << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " (const " << arm->type()->usageName(CppParseName(var), scope()) << "&);" << endl;

}

void  // TMP 9/4: NEW
CppGen(WideString)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
    ofs << arm->type()->usageName(CppParseName(in), scope()) << endl;
    ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
}

void  // TMP 9/4: NEW
CppGen(WideString)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

    // set from const string
	stringUnionArmSetImpls(arm->type()->usageName(CppParseName(in), arm->scope()), arm, ofs);
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string

    // set from string
	ofs << endl;
	stringUnionArmSetImpls(arm->type()->name(arm->scope()), arm, ofs);

    // set from const reference to string
	ofs << endl;
	static ReusableString constRefTypeName;
	constRefTypeName.strcpy("const ");
	constRefTypeName.strcat(arm->type()->usageName(CppParseName(var), arm->scope()));
	constRefTypeName.strcat("&");
	stringUnionArmSetImpls(constRefTypeName.str, arm, ofs);
}

void  // TMP 9/4: NEW
CppGen(WideString)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
    ofs << arm->type()->usageName(CppParseName(in)) << endl;
	// TEMP: use of CppParseName(in) above is a quick and dirty way of getting name for const string
	ofs << arm->scope()->name() << "::" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << "() const {" << endl;
	ofs.indent++;
	ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

ILUCPP_BOOL  // TMP 9/1: NEW
CppGen(WideString)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


void
CppGen(Record)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    if (variableLength()) {
        const CppParseName(TypeUsage) usage = nv->usage();
        if (usage == CppParseName(out) || usage == CppParseName(returnVal))
            ofs << "_call += *" << nv->localName() << ";" << endl;
        else
            CppGen(Type)::sizing(nv, ofs);
    }
    else
        CppGen(Type)::sizing(nv, ofs);
}

void
CppGen(Record)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    if (variableLength()) {
        const CppParseName(TypeUsage) usage = nv->usage();
        if (usage == CppParseName(out) || usage == CppParseName(returnVal)) {
            ofs << "_call << *" << nv->localName() << ";" << endl;
            ofs << "delete " << nv->localName() << ";" << endl;
        }
        else
            CppGen(Type)::send(nv, ofs);
    }
    else
        CppGen(Type)::send(nv, ofs);
}

void
CppGen(Record)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    if (needsSurrogateSideCleanup()) {
        switch (nv->usage()) {
        case CppParseName(inOut):
            ofs << nv->localName(CppGen_(parm_out_key)) << "._surrogateSideCleanup();" << endl;
            break;
        case CppParseName(out):
        case CppParseName(returnVal):
            ofs << nv->localName() << "->_surrogateSideCleanup();" << endl;
            break;
        default:
            CppGen_(Type)::surrogateCleanup(nv, ofs);
            break;
        };
    };
}

void
CppGen(Record)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
/* TMP 9/13
    if (variableLength() && nv->usage() == CppParseName(returnVal))
        ofs << name() << "* " << nv->localName() << " = new " << name() << ";" << endl;
    else
        CppGen(Type)::initialDeclsInput(nv, sibling, ofs);
TMP 9/13 */
	switch (nv->usage()) {  // TMP 9/13: NEW
	case CppParseName(unionMember):
		ofs << name() << " " << nv->localName(CppGen_(member_key)) << ";" << endl;
		break;
	case CppParseName(returnVal):
		if (variableLength()) {
			ofs << name() << "* " << nv->localName() << " = new " << name() << ";" << endl;
			break;
		};
	default:
        CppGen(Type)::initialDeclsInput(nv, sibling, ofs);
	};
}

void
CppGen(Record)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << ">  _returnVal;" << endl;
        break;
    case CppParseName(unionMember):  // TMP 9/13: NEW
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(member_key)) << ";" << endl;  // TMP 9/13: NEW;
        break;
    default:  // TMP 6/28: other embedded optionals
        break;
    };
}

void
CppGen(Record)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    if (variableLength()) {
        switch (nv->usage()) {
        case CppParseName(returnVal):
        case CppParseName(out):
            ofs << name() << "* " << nv->localName() << ";" << endl;
            break;
        case CppParseName(inOut):
            ofs << name() << " " << nv->localName(CppGen_(parm_out_key)) << ";" << endl;
            break;
        default: // CppParseName::in, CppParse::element, CppParse::member
            CppGen_(Type)::initialDeclsOutput(nv, sibling, ofs);
        };
    }
    else
        CppGen(Type)::initialDeclsOutput(nv, sibling, ofs);
}

void
CppGen(Record)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
        ofs << "const ";
    case CppParseName(inOut):
        ofs << "iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "WrapperT<"
            << name() << "> " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    case CppParseName(out):
        ofs << "iluOptionalWrapperT<" << name() << "> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    case CppParseName(returnVal):
        ofs << "iluOptionalWrapperT<" << name() << "> _returnVal;" << endl;
        break;
    default:  // TMP 6/28: Embedded optionals
        break;
    };
}

void
CppGen(Record)::
surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    if (variableLength()) {
        switch (parm->usage()) {
        case CppParseName(inOut):
            ofs << "_call >> " << parm->localName(CppGen_(parm_out_key)) << ";" << endl;
            ofs << parm->localName() << " = " << parm->localName(CppGen_(parm_out_key)) << ";" << endl;
            break;
        case CppParseName(out):
            if (variableLength())
                ofs << parm->localName() << " = new " << name() << ";" << endl;
        case CppParseName(returnVal):
            ofs << "_call >> *" << parm->localName() << ";" << endl;
            break;
        default:
            CppGen(Type)::surrogateReceive(parm, ofs);
            break;
        };
    }
    else
        CppGen(Type)::surrogateReceive(parm, ofs);
}

void
CppGen(Record)::
trueReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    CppGen(Type)::receive(parm, ofs);
}

ILUCPP_BOOL  // TMP 9/1: NEW
CppGen(Record)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


/* TMP 6/28
class OptionalValueParameter : public CppGen(Parameter) {
    friend CppGen(Optional);
public:
    OptionalValueParameter (const char *, const CppGen(NamedValue) *);
        // 2nd parameter must be an Optional
public:  // Override method from CppParseName::Name
    virtual const char * simpleName (CppParseName(Key) key) const;
private:
    const ILUCPP_BOOL _direct;
        // Indicates indirection of <optional> to reach <optional value>
        // true => <optional value> == <optional>
        // false => <optional value> == *<optional>
};

OptionalValueParameter::
OptionalValueParameter (const char * name, const CppGen(NamedValue) * nv)
  : CppParse(NamedValue)(
        CppParseName(Name)(name, nv->scope()),
        nv->usage(),
        CppGen(Optional)::narrow(nv->type()->urType())->valueType()),
    CppGen(Parameter)(
        CppParseName(Name)(name, nv->scope()),
        nv->usage(),
        CppGen(Type)::narrow(CppGen(Optional)::narrow(nv->type()->urType())->valueType())),
        _direct(CppGen(Optional)::narrow(nv->type()->urType())->valueType()->isPtr(nv->usage())) {
}

const char *
OptionalValueParameter::
simpleName (CppParseName(Key) key) const {
    const char * simple = CppParseName(Name)::simpleName(key);
    const char * suffix =
        (key == CppGen(parm_out_key)) ? "_valOut" :
        (key == CppGen(wrapper_key)) ? "_valWrapper" :
        (key == CppGen(parm_length_key)) ? "_valLength" :
        "";
    const char * prefix = (key == NULL)
        ? (_direct ? "" : "*")            // optional, or *optional
        : (simple[0] == '_' ? "" : "_");  // some intermediary quantity based on optional value
    static ReusableString rtn;
    rtn.strcpy(prefix);
    rtn.strcat(simple);
    rtn.strcat(suffix);
    return rtn.str;
}

void
CppGen(Optional)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(nv->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, nv);
    
    ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << "if (" << nv->localName(CppGen_(wrapper_key)) << ".m_present) {" << endl;
    ofs.indent++;
    CppGen_(Type)::narrow(valueType())->sizing(&ovp, ofs);
    ofs.indent--;
    ofs << "};" << endl;
}

void
CppGen(Optional)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(nv->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, nv);
    
    ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << "if (" << nv->localName(CppGen_(wrapper_key)) << ".m_present) {" << endl;
    ofs.indent++;
    CppGen_(Type)::narrow(valueType())->send(&ovp, ofs);
    ofs.indent--;
    ofs << "};" << endl;
}

void
CppGen(Optional)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(nv->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, nv);
    
    ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << "if (" << nv->localName(CppGen_(wrapper_key)) << ".m_present) {" << endl;
    ofs.indent++;
    if (!valueType()->isPtr(nv->usage()))
        ofs << nv->localName() << " = &" << nv->localName(CppGen_(val_key)) << ";" << endl;
    CppGen_(Type)::narrow(valueType())->receive(&ovp, ofs);
    ofs.indent--;
    ofs << "}" << endl;
    ofs << "else" << endl;
    ofs.indent++;
    ofs << nv->localName() << " = NULL;" << endl;
    ofs.indent--;
}
*/

void
CppGen(Optional)::
sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(out):
        ofs << "_call += " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
/* TMP 7/19
    case CppParseName(returnVal):
        ofs << "_call += _returnVal;" << endl;
        break;
    default:
        break;
*/
    default:  // TMP 7/19: NEW: Not sure if this is ok for unionMember
        CppGen_(Type)::sizing(nv, ofs);
        break;
    };
}

void
CppGen(Optional)::
send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(out):
        ofs << "_call << " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
/* TMP 7/19
    case CppParseName(returnVal):
        ofs << "_call << _returnVal;" << endl;
        break;
    default:
        break;
*/
    default:  // TMP 7/19: NEW: Not sure if this is ok for unionMember
        CppGen_(Type)::send(nv, ofs);
        break;
    };
}

void
CppGen(Optional)::
receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
    case CppParseName(out):
        ofs << "_call >> " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
/* TMP 7/19
    case CppParseName(returnVal):
        ofs << "_call >> _returnVal;" << endl;
        break;
    default:
        break;
*/
    default:  // TMP 7/19: NEW: Not sure if this is ok for unionMember
        CppGen_(Type)::receive(nv, ofs);
        break;
    };
}

void
CppGen(Optional)::
surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
/* TMP 9/7
    if (needsSurrogateSideCleanup()) {  // TMP 8/2: NEW
        switch (nv->usage()) {
        case CppParseName(recordMember):
        case CppParseName(unionMember):
            ofs << nv->localName() << "._surrogateSideCleanup();" << endl;
            break;
        case CppParseName(element):
            ofs << "_element._surrogateSideCleanup();" << endl;
            break;
        default:
            break;
        };
TMP 9/7 */
    if (needsSurrogateSideCleanup()) {  // TMP 9/7: NEW
        switch (nv->usage()) {
        case CppParseName(recordMember):
        case CppParseName(element):
	        ofs << nv->localName() << "._surrogateSideCleanup();" << endl;
            break;
        case CppParseName(unionMember):
	        ofs << nv->localName() << "->_surrogateSideCleanup();" << endl;
            break;
        default:
			// TEMP: should we be doing something here ?
            break;
        };
    };
}

/* TMP 6/28
void
CppGen(Optional)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(nv->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, nv);
    
    CppGen_(Type)::narrow(valueType())->initialDeclsInput(&ovp, ofs);
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        if (!valueType()->isPtr(nv->usage()))
            ofs << valueType()->name(scope()) << " " << nv->localName(CppGen_(val_key)) << ";" << endl;
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << "iluOptionalWrapper " << nv->localName(CppGen_(wrapper_key)) << ";" << endl;
        break;
    default:
        break;
    };
}
*/

void  // TMP 6/28: NEW
CppGen(Optional)::
initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    const char * TMP = valueType()->name();  // TMP 7/15
    CppGen_(Type)::narrow(valueType())->optionalInitialDeclsInput(nv, sibling, ofs);
}

void  // TMP 6/28: NEW
CppGen(Optional)::
optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    initialDeclsInput(nv, sibling, ofs);
}

/* TMP 6/28
void
CppGen(Optional)::
surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(parm->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, parm);
    
    ofs << "_call >> " << parm->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << "if (" << parm->localName(CppGen_(wrapper_key)) << ".m_present) {" << endl;
    ofs.indent++;
    if (!valueType()->isPtr(parm->usage()))
        ofs << parm->localName() << " = new " << valueType()->name() << ";" << endl;
    CppGen_(Type)::narrow(valueType())->surrogateReceive(&ovp, ofs);
    ofs.indent--;
    ofs << "}" << endl;
    ofs << "else" << endl;
    ofs.indent++;
    ofs << parm->localName() << " = NULL;" << endl;
    ofs.indent--;
}
*/

/* TMP 6/28
void
CppGen(Optional)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(nv->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, nv);
    
    CppGen_(Type)::narrow(valueType())->initialDeclsOutput(&ovp, ofs);
    switch (nv->usage()) {
    case CppParseName(in):
    case CppParseName(inOut):
        CppGen_(Type)::initialDeclsOutput(nv, sibling, ofs);  // TEMP: is this neccessary ?
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << "iluOptionalWrapper " << nv->localName(CppGen_(wrapper_key)) << "(" << nv->localName() << ");" << endl;
        break;
    default:
        break;
    };
}
*/

void  // TMP 6/28: NEW
CppGen(Optional)::
initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    CppGen_(Type)::narrow(valueType())->optionalInitialDeclsOutput(nv, sibling, ofs);
}

void  // TMP 6/28: NEW
CppGen(Optional)::
optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
    initialDeclsOutput(nv, sibling, ofs);
}

/* TMP 6/28
void
CppGen(Optional)::
trueReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(parm->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, parm);
    
    ofs << "_call >> " << parm->localName(CppGen_(wrapper_key)) << ";" << endl;
    ofs << "if (" << parm->localName(CppGen_(wrapper_key)) << ".m_present) {" << endl;
    ofs.indent++;
    if (!valueType()->isPtr(parm->usage()))
        ofs << parm->localName() << " = &" << parm->localName(CppGen_(val_key)) << ";" << endl;
    CppGen_(Type)::narrow(valueType())->trueReceive(&ovp, ofs);
    ofs.indent--;
    ofs << "}" << endl;
    ofs << "else" << endl;
    ofs.indent++;
    ofs << parm->localName() << " = NULL;" << endl;
    ofs.indent--;
}

void
CppGen(Optional)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    
    // Name of Optional Value is <optional name>
    static ReusableString ovpSimpleName;
    ovpSimpleName.strcpy(parm->simpleName());
    OptionalValueParameter ovp(ovpSimpleName.str, parm);
    
    CppGen_(Type)::narrow(valueType())->truePostTrueMethodProcessing(&ovp, ofs);
    switch (parm->usage()) {
    case CppParseName(inOut):
    case CppParseName(out):
    case CppParseName(returnVal):
        ofs << parm->localName(CppGen_(wrapper_key)) << ".iluSetFrom(" << parm->localName() << ");" << endl;
        break;
    default:
        break;
    };
}
*/

void  // TMP 6/29: NEW
CppGen(Optional)::
truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    ofs << parm->localName(CppGen_(wrapper_key));
}

void
CppGen(Optional)::
truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
    if (CppGen_(Type)::narrow(valueType())->needsPostTrueMethodRevise(parm->usage()))
// TMP 7/4        ofs << parm->name(CppGen_(wrapper_key)) << ".revise();" << endl;
        ofs << parm->localName(CppGen_(wrapper_key)) << ".revise();" << endl;  // TMP 7/4: NEW
}

void  // TMP 9/9: NEW
CppGen(Optional)::
assignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
    CppGen_(Type)::narrow(valueType())->optionalAssignValue(to, from, ofs);
}

void  // TMP 9/5: NEW
CppGen(Optional)::
unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	// set from Optional value
	ofs << "void" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (" << arm->type()->name(arm->scope()) << ");" << endl;

	// set from const Optional _var reference
	ofs << endl;
	ofs << "void" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " (const " << arm->type()->usageName(CppParseName(var), arm->scope()) << ");" << endl;

}

void  // TMP 9/5: NEW
CppGen(Optional)::
unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
/* TMP 9/7
	ofs << arm->type()->usageName(CppParseName(constRef), arm->scope()) << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () const;" << endl;
TMP 9/7 */
	ofs << arm->type()->name(arm->scope()) << endl;  // TMP 9/7
	ofs << arm->localName(CppGen_(accessor_key)) << " ();" << endl;  // TMP 9/7
}

void  // TMP 9/5: NEW
CppGen(Optional)::
unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {

	// set from Optional value
    ofs << "void" << endl;
    ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
    ofs << arm->localName(CppGen_(accessor_key))
        << " (" << arm->type()->name(arm->scope()) << " _value) {" << endl;
    ofs.indent++;
    ofs << "_unset();" << endl;
    ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
    ofs << arm->localName() << " = new " << arm->type()->usageName(CppParseName(var), arm->scope()) << ";" << endl;
	ofs << "*" << arm->localName() << " = _value;" << endl;
    ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
    ofs.indent--;
    ofs << "}" << endl;

	// set from const Optional _var
	ofs << endl;
    ofs << "void" << endl;
    ofs << CppGen_(Union)::narrow(arm->scope())->name() << "::" << endl;
    ofs << arm->localName(CppGen_(accessor_key))
        << " (" << arm->type()->usageName(CppParseName(var), arm->scope()) << " _value) {" << endl;
    ofs.indent++;
    ofs << "_unset();" << endl;
    ofs << "_discriminator = " << arm->firstValue()->str() << ";" << endl;
    ofs << arm->localName() << " = new " << arm->type()->usageName(CppParseName(var), arm->scope()) << "(_value);" << endl;
    ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
    ofs.indent--;
    ofs << "}" << endl;
}

void  // TMP 9/5: NEW
CppGen(Optional)::
unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
// TMP 9/7	ofs << arm->type()->usageName(CppParseName(constRef)) << endl;
	ofs << arm->type()->name() << endl;  // TMP 9/7: NEW
	ofs << arm->scope()->name() << "::" << endl;
// TMP 9/7	ofs << arm->localName(CppGen_(accessor_key)) << " () const {" << endl;
	ofs << arm->localName(CppGen_(accessor_key)) << " () {" << endl;  // TMP 9/7: NEW
	ofs.indent++;
	ofs << "return *" << arm->localName(CppGen_(member_key)) << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
}

ILUCPP_BOOL
CppGen(Optional)::
unionDataMemberIsVar () const {
    return ILUCPP_TRUE;
}


// Add of IIOP type registration


void
CppGen(Type)::
registerType (CppParseStream(ofstream) & ofs) const {
}


void CppGen(Optional)::
registerType (CppParseStream(ofstream) & ofs) const {

	
	ofs << "iluCppInternal::iluRegisterOptionalType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	ofs << "\t\"" << type_uid(iluptype::_type_description(_from)->structuredDes.optional) <<  "\"," << endl;	// base type uid

	ofs << "\t&b_new_registration);" << endl << endl;
}



void CppGen(Sequence)::
registerType (CppParseStream(ofstream) & ofs) const {
	
	ofs << "iluCppInternal::iluRegisterSequenceType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	ofs << "\t\"" << type_uid(iluptype::_type_description(_from)->structuredDes.sequence.type) <<  "\"," << endl;	// base type uid

	ofs << "\t" << iluptype::_type_description(_from)->structuredDes.sequence.limit << "," << endl;	// limit

	ofs << "\t&b_new_registration);" << endl << endl;
}


void CppGen(Object)::
registerType (CppParseStream(ofstream) & ofs) const {
	
	ofs << "iluCppInternal::iluRegisterObjectType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	ofs << "\t" << name() <<  "::iluGetILUClassRecord()," << endl;	// class ptr from iluDefineObjectType 

	ofs << "\t&b_new_registration);" << endl << endl;
}



void CppGen(Array)::
registerType (CppParseStream(ofstream) & ofs) const {

	ofs << "{" << endl;
	ofs << "iluCardinal _" << name(CppGen_(underscore_key)) << "_dims [] = { ";
	
    ::iluptype::listElement* p_dimension_node = (iluptype::_type_description(_from)->structuredDes.array.dimensions)->head;
	unsigned int card_dimension;

	// assumes at least one dimension - walk the list outputting dimensions
	do {
		card_dimension = (unsigned int) (p_dimension_node->data);
		ofs << card_dimension;
		if (p_dimension_node->next) {
			ofs << ", ";
			p_dimension_node = p_dimension_node->next;
		}
		else p_dimension_node = NULL;
	}
	while (p_dimension_node);

	ofs << " };" << endl;

	ofs << "iluCppInternal::iluRegisterArrayType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	ofs << "\t\"" << type_uid(iluptype::_type_description(_from)->structuredDes.array.type) << "\"," << endl;	// base type

	ofs << "\t" << iluptype::_list_size(iluptype::_type_description(_from)->structuredDes.array.dimensions) << "," << endl;	// number of dimensions 

	ofs << "\t_" << name(CppGen_(underscore_key)) << "_dims," << endl; // pointer to sequence of dimensions 

	ofs << "\t&b_new_registration);" << endl;

	ofs << "}" << endl << endl;
}



void CppGen(Alias)::
registerType (CppParseStream(ofstream) & ofs) const {
	
	ofs << "iluCppInternal::iluRegisterAliasType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	ofs << "\t\"" << type_uid(iluptype::_ur_type(_from)) <<  "\"," << endl;	// base type

	ofs << "\t&b_new_registration);" << endl << endl;
}



void CppGen(Record)::
registerType (CppParseStream(ofstream) & ofs) const {

	unsigned int i_number_of_fields;
    ::iluptype::Argument record_arg;

	ofs << "{" << endl;

	ofs << "a_type = iluCppInternal::iluRegisterRecordType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	i_number_of_fields = iluptype::_list_size(iluptype::_type_description(_from)->structuredDes.record.fields);
	ofs << "\t" << i_number_of_fields <<  "," << endl;	// number of fields

	ofs << "\t&b_new_registration);" << endl << endl;

	ofs << "if (b_new_registration) {" << endl;

	for (unsigned int i_count = 0; i_count < i_number_of_fields; i_count++) {

        record_arg = (::iluptype::Argument) (iluptype::_list_ref(iluptype::_type_description(_from)->structuredDes.record.fields, i_count));

		ofs << "\tiluCppInternal::iluRegisterRecordField(a_type, " << i_count << "," << endl;  // record type and which field 

		// field name  and  UID of field type 
		ofs << "\t\t\"" << iluptype::_argument_name(record_arg)  << "\", \"" << type_uid(argument_type(record_arg)) <<  "\");" << endl;  
		
	}

	ofs << "\t}" << endl;  // end of if (b_new_registration)

	ofs << "}" << endl << endl;
}


void CppGen(Union)::
registerType (CppParseStream(ofstream) & ofs) const {
	unsigned int i_number_of_arms;
    ::iluptype::Argument union_arg;
	unsigned int i_default_arm;
	unsigned int i_num_arm_values;
	unsigned int i_arm_value_index;
	unsigned int i;
    ::iluptype::ConstantValue const_value;
	
	ofs << "{" << endl;
	
	ofs << "a_type = iluCppInternal::iluRegisterUnionType(" << endl;
	
	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name
	
	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)
	
	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				
	
	ofs << "\t\"" << uid() << "\"," << endl;	// type uid
	
	ofs << "\t\"" << type_uid(iluptype::_type_description(_from)->structuredDes.uniond.discriminator_type) << "\"," << endl; // discriminant type 
	
	i_number_of_arms = iluptype::_list_size(iluptype::_type_description(_from)->structuredDes.uniond.types);
	ofs << "\t" << i_number_of_arms <<  "," << endl;	// number of arms
	
	// figure out the index of the default arm
	if (iluptype::_type_description(_from)->structuredDes.uniond.default_arm != NULL) {
		i_default_arm = iluptype::_list_size(iluptype::_type_description(_from)->structuredDes.uniond.types);
		for (i = 0;  i < i_default_arm;  i++) {
            if (((::iluptype::Argument) iluptype::_list_ref(iluptype::_type_description(_from)->structuredDes.uniond.types, i)) ==
				iluptype::_type_description(_from)->structuredDes.uniond.default_arm)
				break;
		}
		if (i < i_default_arm)
			i_default_arm = i + 1;
		else
			i_default_arm = 0;		// probably an error
	}
	else
		i_default_arm = 0;		// no default arm 
	
	ofs << "\t" <<  i_default_arm << "," << endl;	// default arm (0 for none { } 1-n otherwise) 
	
	// others allowed 
	ofs << "\t" <<  ((iluptype::_type_description(_from)->structuredDes.uniond.others_allowed) ? "ILUCPP_TRUE" : "ILUCPP_FALSE") << "," << endl;
	
	ofs << "\t&b_new_registration);" << endl << endl;
	
	
	ofs << "if (b_new_registration) {" << endl;
	
	ofs << "\tiluConstantValue_s constant_value;" << endl;
	ofs << "\tiluUnionArm union_arm;" << endl << endl;
	
	// blatantly stolen / modified code form the c-stubber
	for (i = 0;  i < i_number_of_arms;  i++) {
		
		// register the union arm
        union_arg = (::iluptype::Argument) iluptype::_list_ref(iluptype::_type_description(_from)->structuredDes.uniond.types, i);
		i_num_arm_values = iluptype::_list_size(union_arg->values);
		
		ofs <<  "\tunion_arm = iluCppInternal::iluRegisterUnionArm (a_type, " << i << ", " << endl;
		
		// union arms may have NIL names, so check... 
		if (iluptype::_argument_name(union_arg) == NULL)
			ofs <<  "\t\tNULL, " ;
		else
			ofs <<  "\t\t\"" << iluptype::_argument_name(union_arg) << "\", " ;
		
		// arm type uid  and number of values
		ofs << "\"" << type_uid(argument_type(union_arg)) << "\", " <<  i_num_arm_values << ");" << endl << endl;
		
		// register the possible values for that arm
		for (i_arm_value_index = 0;  i_arm_value_index < i_num_arm_values;  i_arm_value_index++) {
			
            const_value = (::iluptype::ConstantValue) iluptype::_list_ref(union_arg->values, i_arm_value_index);
			
			switch (iluptype::_type_ur_kind(iluptype::_type_description(_from)->structuredDes.uniond.discriminator_type)) {
				
			case iluptype::boolean_Type:
// TMP 9/7				ofs <<  "\tconstant_value.value.boolean_val = " << (const_value->val.b ? "ILUCPP_TRUE" : "ILUCPP_FALSE") << ";" << endl;
				ofs <<  "\tconstant_value.value.boolean_val = " << (const_value->val.b ? "iluTRUE" : "iluFALSE") << ";" << endl;  // TMP 9/7: NEW
				ofs <<  "\tconstant_value.kind = ilu_boolean_cvk;" << endl;
				break;
			case iluptype::shortinteger_Type:
				ofs <<  "\tconstant_value.value.shortinteger_val = " <<  const_value->val.i.value * const_value->val.i.sign << ";" << endl;
				ofs <<  "\tconstant_value.kind = ilu_shortinteger_cvk;" << endl;
				break;
			case iluptype::integer_Type:
				ofs <<  "\tconstant_value.value.integer_val = " << const_value->val.i.value * const_value->val.i.sign << ";" << endl;
				ofs <<  "\tconstant_value.kind = ilu_integer_cvk;" << endl;
				break;
			case iluptype::shortcardinal_Type:
				ofs <<  "\tconstant_value.value.shortcardinal_val = " << const_value->val.i.value << ";" << endl;
				ofs <<  "\tconstant_value.kind = ilu_shortcardinal_cvk;" << endl;
				break;
			case iluptype::cardinal_Type:
				ofs <<  "\tconstant_value.value.cardinal_val = " << const_value->val.i.value << ";" << endl;
				ofs <<  "\tconstant_value.kind = ilu_cardinal_cvk;" << endl;
				break;
			case iluptype::byte_Type:
				ofs <<  "\tconstant_value.value.byte_val = " << const_value->val.i.value << ";" << endl;
				ofs <<  "\tconstant_value.kind = ilu_byte_cvk;" << endl;
				break;
			case iluptype::enumeration_Type:
				{
					/* NOTE: This function was modified only slightly from the c-stubber version, which
					   is based on the structures defined in iluptype.h. Unfortunately, iluptype's
					   ConstantValue struct only stores the short form of enumerator names, whereas
					   C++ requires the names to be qualified by namespace/class in which the
					   enumeration type was defined. Thus, we have the following hack to get at the
					   equivalent CppGen::ConstantValue, from which the qualified enumerator names can
					   be obtained. (A better alternative would be to write this function in terms of
					   CppParse and CppGen classes instead of iluptype structures).
					*/
					// The following prints the enumerator's unqualified name
					ofs <<  "\tconstant_value.value.enumeration_val = \"" << const_value->val.s << "\";" << endl;
				};
				ofs <<  "\tconstant_value.kind = ilu_enumeration_cvk;" << endl;
				break;
			default:
				cerr << "CppGen(Union)::registerType (), Unexpected discriminant type encountered! - ignored" << endl;
			}
			ofs <<  "\tiluCppInternal::iluRegisterUnionArmValue(union_arm, " << i_arm_value_index << ", &constant_value);" << endl << endl;
		}
	}
	
	ofs << "\t}" << endl;  // end of if (b_new_registration)
	
	ofs << "}" << endl << endl;
}

/* TMP 9/10
void CppGen(Union)::
registerType (CppParseStream(ofstream) & ofs) const {  // TMP 9/10: NEW

	CppParse(MemberListIter) armListIter(arms());
	const CppParse(UnionArm) * arm;
	
	ofs << "{" << endl;
	
	ofs << "a_type = iluCppInternal::iluRegisterUnionType(" << endl;

	ofs.indent++;
	
	ofs << "\"" << simpleName() << "\"," << endl;	// name
	
	ofs << "\"" << scope()->name(CppGen_(period_key)) << "\"," << endl;	// interface name
	
	if (CppParse(Interface)::narrow(scope())->brand() != NULL)	// interface brand. NOTE: will fail if we ever allow types to be defined in scopes other than Interface's
		ofs << "\"" << CppParse(Interface)::narrow(scope())->brand() << "\"," << endl;
	else
		ofs << "NULL," << endl;				
	
	ofs << "\"" << uid() << "\"," << endl;	// type uid
	
	ofs << "\"" << discriminatorType()->uid() << "\"," << endl; // discriminant type 
	
	ofs << arms().count() <<  "," << endl;	// number of arms
	
	if (defaultArm() == NULL)	// default arm (0 for none { } 1-n otherwise)
		ofs << "0," << endl;
	else
		ofs << defaultArm()->index() + 1 << "," << endl;
	
	ofs <<  CppGen_(Bool)::value(otherDiscriminatorValuesOK()) << "," << endl;  // others allowed
	
	ofs << "&b_new_registration);" << endl << endl;

	ofs.indent--;

	ofs << "if (b_new_registration) {" << endl;

	ofs.indent++;
	
	ofs << "iluConstantValue_s constant_value;" << endl;
	ofs << "iluUnionArm union_arm;" << endl << endl;
	
	while ((arm = CppParse(UnionArm)::narrow(armListIter.next())) != NULL) {  // register the union arm
		
		CppParse_(ConstantValueListIter) valueListIter(arm->values());
		const CppParse_(ConstantValue) * value;
		long unsigned value_index = 0;

		ofs << "union_arm = iluCppInternal::iluRegisterUnionArm (a_type, " << arm->index() << ", " << endl;
		
		ofs.indent++;

		// union arms may have NIL names, so check... 
		if (arm->baseName() == NULL)
			ofs << "NULL, " ;
		else
			ofs << arm->simpleName() << "\", " ;

		ofs.indent--;
		
		// arm type uid  and number of values
		ofs << "\"" << arm->type()->uid() << "\", " <<  arms().count() << ");" << endl << endl;

		// register the possible values for that arm
		while ((value = valueListIter.next()) != NULL) {

			const char * discriminatorKind = CppGen_(Type)::narrow(discriminatorType())->typeKindName();

			ofs << "constant_value.value." << discriminatorKind << "_val = " << value->str() << ";" << endl;
			ofs << "constant_value.kind = ilu_" << discriminatorKind << "_cvk;" << endl;
		
			ofs <<  "iluCppInternal::iluRegisterUnionArmValue(union_arm, " << value_index << ", &constant_value);" << endl << endl;

			value_index++;
		}
	}
	
	ofs << "}" << endl;  // end of if (b_new_registration)

	ofs.indent--;
	
	ofs << "}" << endl << endl;
}
TMP 9/10 */


void CppGen(Enumeration)::
registerType (CppParseStream(ofstream) & ofs) const {

	unsigned int i_number_of_elements;
    ::iluptype::EnumField enum_field;

	ofs << "{" << endl;

	ofs << "a_type = iluCppInternal::iluRegisterEnumerationType(" << endl;

	ofs << "\t\"" << iluptype::_type_name(_from) << "\"," << endl;	// name

	ofs << "\t\"" << iluptype::_interface_name(iluptype::_type_interface(_from)) << "\"," << endl;	// interface name (xxx change when allow nested scopes?)

	if ((iluptype::_type_interface(_from))->brand)	// interface brand
		ofs << "\t\"" << (iluptype::_type_interface(_from))->brand << "\"," << endl;				
	else
		ofs << "\tNULL," << endl;				

	ofs << "\t\"" << uid() << "\"," << endl;	// type uid

	i_number_of_elements = iluptype::_list_size(iluptype::_type_description(_from)->structuredDes.enumeration);
	ofs << "\t" << i_number_of_elements <<  "," << endl;	// number of elements

	ofs << "\t&b_new_registration);" << endl << endl;

	ofs << "if (b_new_registration) {" << endl;

	for (unsigned int i_count = 0; i_count < i_number_of_elements; i_count++) {

        enum_field = (::iluptype::EnumField) (iluptype::_list_ref(iluptype::_type_description(_from)->structuredDes.enumeration, i_count));

		ofs << "\tiluCppInternal::iluRegisterEnumerationElement(a_type, " << i_count << ", " ;  // enum type and which element 

		// element name and value
		ofs << "\"" << enum_field->name  << "\", " << enum_field->id <<  ");" << endl;  
		
	}

	ofs << "\t}" << endl;  // end of if (b_new_registration)

	ofs << "}" << endl << endl;
}

// End add of IIOP type registration
