# BeginILUCopyright
# 
# Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
# 
# Unlimited use, reproduction, modification, and distribution of this
# software and modified versions thereof is permitted.  Permission is
# granted to make derivative works from this software or a modified
# version thereof.  Any copy of this software, a modified version
# thereof, or a derivative work must include both the above copyright
# notice of Xerox Corporation and this paragraph.  Any distribution of
# this software, a modified version thereof, or a derivative work must
# comply with all applicable United States export control laws.  This
# software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
# WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
# LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
# EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
# NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
# OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# EndILUCopyright
#
#   $Id: CORBA.py,v 1.11 1998/10/09 21:50:46 larner Exp $
#
#######################################################################
#
#  This module exports some of the functionality expected of a CORBA
#  system...
#
#######################################################################
import iluRt

InvalidName = "CORBA.InvalidName"

InitialReferences = {}

class ORB:

	def object_to_string (self, obj):
		return iluRt.IOROfObject(obj)

	def string_to_object (self, str):
		return iluRt.ObjectOfSBH(iluRt.CORBA_Object, str)

	def resolve_initial_references (self, str):
		if (InitialReferences.has_key(str)):
			return InitialReferences[str]
		else:
			raise InvalidName, str

theORB = ORB()

Object = iluRt.CORBA_Object

def ORB_init (argv=(), orb_id='ilu'):
	import os
	if (os.environ.has_key("ILU_COS_NAMING_IOR")):
		try:
			import CosNaming
			naming = iluRt.ObjectOfSBH(CosNaming.NamingContext, os.environ["ILU_COS_NAMING_IOR"])
			if naming:
				InitialReferences["NameService"] = naming
		except:
			import sys
			sys.stderr.write("CORBA.ORB_init:  Note:  Can't bind to COS Naming service specified in value of environment variable ILU_COS_NAMING_IOR.\n")
			pass
	return theORB
