/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* IluSystemException0.java */
/* Chris Jacobi, November 6, 1997 4:53 pm PST */

/*
 */ 
 

/*
 * $Id: IluSystemException0.java,v 1.8 1998/10/09 22:50:53 larner Exp $
 */

package xerox.ilu;

/**
 * IluSystemException0 is an artificial superclass of IluSystemException
 * - Clients may use this to catch all ilu system exceptions,
 *   but since all system exceptions are also IluSystemException's,
 *   clients can as well totally ignore this class.
 * - Clients must not throw this exceptions. 
 * - Clients must not declare methods to throw this exceptions. 
 */
public class IluSystemException0 extends xerox.ilu.IluSystemExceptionBase {

    public int minor = 0;
    public org.omg.CORBA.CompletionStatus completed = null;
    
    public IluSystemException0() {
        super();
    } //constructor

    public IluSystemException0(java.lang.String s) {
        super(s);
    } //constructor
    
    public java.lang.String toString() {
        java.lang.String s = super.toString();
        int iCompleted = org.omg.CORBA.CompletionStatus._COMPLETED_MAYBE;
        org.omg.CORBA.CompletionStatus cs = completed;
        if (cs != null) {
            iCompleted = cs.value();
        } 
        switch (iCompleted) {
            case org.omg.CORBA.CompletionStatus._COMPLETED_MAYBE:
                break;
            case org.omg.CORBA.CompletionStatus._COMPLETED_YES:
                s = s + " completed: yes";
                break;
            case org.omg.CORBA.CompletionStatus._COMPLETED_NO:
                s = s + " completed: no";
                break;
            default:
                s = s + " completed: bad";
                break;
        }
        if (minor  != 0) {
            s = s + " minor code: " + minor;
        }
        return s;
    } //toString


} // IluSystemException0
