/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* IluSystemException.java */
/* Chris Jacobi, September 24, 1998 10:51 am PDT */

/*
 */ 
 

/*
 * $Id: IluSystemException.java,v 1.13 1998/10/09 22:50:52 larner Exp $
 */

package xerox.ilu;

/**
 * IluSystemException.java
 * - applications may catch this exception 
 */
public class IluSystemException extends org.omg.CORBA.SystemException {


    public IluSystemException() {
	this("IluSystemException");
    } //constructor


    public IluSystemException(java.lang.String s) {
	super(s);
    } //constructor


    /**
     * Corba level constructor from ILU level class is not really
     * for clients (no harm however).  It is here, so corba
     * level code can use inheritance.
     */
    public IluSystemException(
            int minor, org.omg.CORBA.CompletionStatus completed) {
	super();
	super.minor = minor;
	super.completed = completed;
    } //constructor
    

    /**
     * Corba level constructor from ILU level class is not really
     * for clients (no harm however).  It is here, so corba
     * level code can use inheritance.
     */
    public IluSystemException(java.lang.String s, 
            int minor, org.omg.CORBA.CompletionStatus completed) {
	super(s);
	super.minor = minor;
 	super.completed = completed;
    } //constructor
    
    
    /** Corba mandated; not yet supported */
    public java.lang.String repositoryId() {
        return theRepositoryId;
    } //repositoryId


    /** Corba mandated; not yet supported */
    public static java.lang.String classNameOf (java.lang.String repositoryId) {
	return null;
    } //classNameOf
    
    
    private java.lang.String theRepositoryId = null;
    
    //straight from iluxport.h
    /*friendly*/ static final int protocolException_Success = 0;
    /*friendly*/ static final int protocolException_NoSuchClassAtServer = 1;
    /*friendly*/ static final int protocolException_ClassVersionMismatch = 2;
    /*friendly*/ static final int protocolException_NoSuchMethodOnClass = 3;
    /*friendly*/ static final int protocolException_GarbageArguments = 4;
    /*friendly*/ static final int protocolException_Unknown = 5;
    /*friendly*/ static final int protocolException_LostConnection = 6;
    /*friendly*/ static final int protocolException_RequestRejected = 7;
    /*friendly*/ static final int protocolException_RequestTimeout = 8;
    /*friendly*/ static final int protocolException_Not = 9;
        // non-protocol failure; see *err 
       

    /** Called from stubs; "code" argument set by runtime. */
    public static IluSystemException fromIluProtocolException(int code) {
        IluSystemException se = null;
        if (code<0) {code = -code;}
        switch (code % 100000) {
            case protocolException_Success: 
                se = new IluSomeSystemException("BadStub");
                break;
            case protocolException_NoSuchClassAtServer: 
                se = new IluSomeSystemException("NoSuchClassAtServer");
                break;
            case protocolException_ClassVersionMismatch: 
                se = new IluSomeSystemException("ClassVersionMismatch");
                break;
            case protocolException_NoSuchMethodOnClass: 
                se = new IluSomeSystemException("NoSuchMethodOnClass");
                break;
            case protocolException_GarbageArguments: 
                se = new IluSomeSystemException("GarbageArguments");
                break;
            case protocolException_Unknown: 
                se = new IluSomeSystemException("Unknown");
                break;
            case protocolException_LostConnection: 
                se = new IluSomeSystemException("LostConnection");
                break;
            case protocolException_RequestRejected: 
                se = new IluSomeSystemException("RequestRejected");
                break;
            case protocolException_RequestTimeout: 
                se = new IluSomeSystemException("RequestTimeout");
                break;
            case protocolException_Not: 
                se = new IluSomeSystemException("NotProtocolException");
                break;
            default: break;
        }
        if (se == null) {
            se = new IluSomeSystemException(
                "unknown_ilu_ProtocolException_" + code
                );
        }
        se.completed = org.omg.CORBA.CompletionStatus.from_int(code / 100000);
        return se;
    } //fromIluProtocolException


} // IluSystemException

