/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* IluObjectBase.java */
/* Chris Jacobi, August 19, 1998 12:39 pm PDT */

/*
 */
 
/* $Id: IluObjectBase.java,v 1.14 1998/10/09 22:50:45 larner Exp $ */
 

package xerox.ilu;

/**
 * Base super class used for surrogate object implementation.<p>
 * 
 * This might as well be used as base class for true objects, at the
 * discretion of the programmer (of the true object's class).<br>
 *
 * Actually, this is the PREFERRED method of implementing true
 * ilu objects, as the programmer gets the goodies for free.  
 * There are two alternative methods of implementing true
 * ilu object:  <br>
 *    a) Implement the IluDataSupport interface <br>
 *    b) Let the ilu server hang on permanently to the java object 
 *       (preventing java garbage collection while the server is alive).
 *
 * @see IluDataSupport
 * @see org.omg.CORBA.portable.ObjectImpl
 */
public abstract class IluObjectBase implements IluObject, IluDataSupport {
    
    protected IluOInt oint = null; 
    
    protected IluObjectBase() {
    }
    
    /** This is logically "friendly" but public to 
     * export the IluDataSupport interface
     */
    public void setIluData(Object internal) {
        //Ilu calls this only once
        if (oint==null) oint = (IluOInt) internal;
    }
    
    public java.lang.Object getIluData() {
        return oint;
    }
    
    /* Not public but for surrogate stubs 
     * Surrogates DO have IluDataSupport, others may crash...
     */
    public IluClassRep getIluClass() {
        return oint.jjClassRep;
    }
    
    
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _is_a(java.lang.String identifier) {
        throw new IluSystemException("not impl"); 
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _is_equivalent(org.omg.CORBA.Object that) {
        return (that == this);
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _non_existent() {
        try {
            IluRT0.ping(this);
            return false;
        } catch (xerox.ilu.IluSystemExceptionBase se) {
            return true;
        }
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public int _hash(int maximum) {
        throw new IluSystemException("not impl"); 
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public org.omg.CORBA.Object _duplicate() {
        if (this instanceof org.omg.CORBA.Object) {
            return (org.omg.CORBA.Object) this;
        }  
        throw new xerox.ilu.IluSomeSystemException("ilu object isn't corba::object");
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public void _release() {
    }


    /**
     * This construct prevents subclasses from implementing cloning.<p>
     * @see     java.lang.Cloneable
     */
    protected final java.lang.Object clone() 
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    } //clone
    
    
} //IluObjectBase
