/* IluDebugWriter.java */
/* Chris Jacobi, September 2, 1997 6:03 pm PDT */

/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/


/* 
 * $Id: IluDebugWriter.java,v 1.2 1998/10/09 22:50:36 larner Exp $
 */
 
package xerox.ilu;

/**
 * A stream which writes its output to ilu's kernel
 * debug output. <p>
 * Not really visible to applications.
 * @see IluDebug
 */
 public class IluDebugWriter extends java.io.Writer {
    
    public static java.io.PrintWriter getIluDebugWriter() {
        return new java.io.PrintWriter(new IluDebugWriter(), true);
    }
    
    public static native void debugWrite1(int b);
    
    public IluDebugWriter() {}
    public void close() {}
    public void flush() {}
    
    public void write(int b) {
        debugWrite1(b);
    }

    public void write(char c) {
        debugWrite1((int) c);
    }
    
    public void write(char[] ca, int off, int len) {
        for (int i = off; i < off+len; i++) {
            if (i >= ca.length) return;
            write(ca[i]);
        }
    } //write
    
} // IluDebugWriter
