/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* Ilu.java */
/* Chris Jacobi, October 23, 1998 8:44 pm PDT */

/*
 */
 
/* $Id: Ilu.java,v 1.25 1998/10/24 03:54:48 jacobi Exp $ */

 
package xerox.ilu;
import xerox.ilu.IluClassRep;
import xerox.ilu.IluInit;
import xerox.ilu.IluObject;
import xerox.ilu.IluSystemException;
import xerox.ilu.IluRT0;
import xerox.ilu.IluServer;

/**
 * Main application interface for ILU.<p>
 *
 * The javadoc documentation is only supplemental
 * to the regular ILU documentation.   The way javadoc
 * formats its output, reading the java sources is also
 * preferable to reading javadoc documentation.
 *
 */
public final class Ilu {
        
    /**
     * Don't create instances 
     */
    private Ilu(){};
    
    /** 
     * Importing an object <p>
     *
     * @see xerox.ilu.IluSBH  
     */
    public static IluObject 
    objectFromSBH (
            java.lang.String sbh, 
            IluClassRep iluClass
            ) throws IluSystemException {
        return IluRT0.objectFromSBH(sbh, iluClass);
    } //objectFromSBH

    /** 
     * Literals for the lifetime argument of registerTrueObject.
     */
    
    /** Requires ilu set a value depending on other arguments */
    public static final int unspec = IluLifetimeArgs.iluLifetimeUnspec;
    
    /** Remember obj to prevent java garbage collection. */
    public static final int remember = IluLifetimeArgs.iluLifetimeRemember;
    
    /** Forget obj to subject it to java garbage collection. */
    public static final int forget = IluLifetimeArgs.iluLifetimeForget;

    /**
     * Create true objects. <p>
     * Life time is important and must be determined.  Normally the ilu
     * object stays alive until the intermediate object is garbage
     * collected.  Use any of a large number of schemes to prevent
     * garbage collection. Setting a non-zero lifetime will
     * override marker interfaces like IluLifetimeForget or
     * IluLifetimeRemember.  <p>
     * 
     * Return value is intermediate object.  Caller may prevent this
     * from being garbage collected. <p>
     *
     * @see IluLifetimeArgs
     * @see IluIHProposer
     * @see IluLifetimeForget
     * @see IluLifetimeRemember
     *
     */
    public static java.lang.Object 
    registerTrueObject(
            java.lang.String ih,
            IluObject tobj, 
            IluServer server, 
            IluClassRep iluClass,
            int lifetime //0 gives default behaviour
            ) throws IluSystemException {
        return IluRT0.registerTrueObject(ih, tobj, server, iluClass, lifetime);
    } //registerTrueObject
    
    
    /** 
     * Returns the string binding handle.<br>
     * May return NIL if the object's server isn't exported through any
     * port; may return an invalid SBH if the cached one references a
     * closed port.
     */
    public static java.lang.String 
    sbhOfObject(IluObject obj) {
        return IluRT0.sbhOfObject(obj);
    } //sbhOfObject
    
    
    /** 
     * Returns OMG IIOP-specified IOR string for object. <br>
     * May return null if object is not exported through IIOP.
     */
    public static java.lang.String 
    iorOfObject(IluObject obj) {
        return IluRT0.iorOfObject(obj);
    } //iorOfObject
  
  
    /** 
     * Destroy ILU-ness of true object.<p>
     *
     * Only for impatient applications,
     * Normal applications leave this to the garbage collector. <br>
     * Do NOT use from applets; error behavior is not yet defined. <br>
     * Do not use on surrogates.
     */
    public static void 
    destroyObject(IluObject obj) {
        IluRT0.destroyObject(obj);
    } //destroyObject
    
    
    /**
     * Generates a string that's unique over space and time.
     * A server with nothing better to use might call this to 
     * get an ID.
     */
    public static java.lang.String 
    inventID() {
        return IluRT0.inventID();
    } //inventID
    
    
    /**
     * Test whether object is alive.
     */
    public static void 
    ping(IluObject obj) {
        IluRT0.ping(obj);
    } //ping
    

    /**
     * Makes sure Ilu is loaded.<p>
     * Idempotent.
     */
    public static void init() {
        IluInit.init();
    } //init

    
    static {
       init();
    }
  
} //Ilu
