/* ObjectImpl.java */
/* Chris Jacobi, August 19, 1998 12:17 pm PDT */

/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/

 
/* $Id: ObjectImpl.java,v 1.7 1998/10/09 22:49:54 larner Exp $ */

 
package org.omg.CORBA.portable;

/**
 * CORBA (but not ilu) requires all true classes to inherit from this class<p>
 *
 * This class is not an Ilu requirement; in fact since it implements
 * the org.omg.CORBA.Object interface it is not recommended to be used
 * by pure ilu objects unless they are also CORBA objects.<p>
 *
 * This class is not a corba complete implementation.
 * @see org.omg.CORBA.Object 
 * @see xerox.ilu.IluObjectBase 
 * @see xerox.ilu.IluDataSupport 
 */
public class ObjectImpl extends xerox.ilu.IluObjectBase 
        implements org.omg.CORBA.Object {
        
    /** constructor */
    protected ObjectImpl() {
    }
    
    private static org.omg.CORBA.ORB iluOrb = null;
    private static org.omg.CORBA.BOA iluBoa = null;
    
    public org.omg.CORBA.ORB _orb() {
        if (iluOrb==null) {
            iluOrb = org.omg.CORBA.ORB.init();
        }
        return iluOrb;
    } //_orb
    
    public org.omg.CORBA.BOA _boa() {
        if (iluBoa==null) {
            iluBoa = new org.omg.CORBA.BOA(_orb());
        }
        return iluBoa;
    } //_boa
  
} // ObjectImpl

