/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* ORB.java */
/* Chris Jacobi, October 13, 1998 3:50 pm PDT */

/*
 */
 
/* $Id: ORB.java,v 1.17 1998/10/13 22:50:47 jacobi Exp $ */

 
package org.omg.CORBA;

/**
 * Makes Ilu look like it were a CORBA ORB<p>
 * The purpose of this module is to be CORBA compatible; it will change
 * whenever necessary.
 *
 * It does not yet have the exact type required by CORBA.
 */
public class ORB {
     /*friendly*/ java.util.Properties props = null;
     /*friendly*/ java.lang.String[] args = null;
     /*friendly*/ java.applet.Applet app = null;
     /*friendly*/ xerox.ilu.IluServer defaultServer = null;
        
    /*friendly*/ ORB (java.util.Properties props) {
        if (props == null) props = System.getProperties();
        this.props = props;
    } //constructor
    
    
    /** 
     * Standard, no argument initialization 
     */
    public static ORB init() {
        xerox.ilu.Ilu.init();
        return new ORB(null);
    } //init
    
    /** 
     * Standard, application initialization 
     */
    public static ORB init(
        java.lang.String[] args, java.util.Properties props)
    {
        ORB orb;
        xerox.ilu.Ilu.init();
        orb = new ORB(props);
        orb.args = args;
        return orb;
    } //init
    
    
    /** 
     * Standard, applet initialization; 
     * Applet support in ilu is limited, but not checked
     * at this point. 
     */
    public static ORB init(
        java.applet.Applet app, java.util.Properties props)
    {
        ORB orb;
        xerox.ilu.Ilu.init();
        orb = new ORB(props);
        orb.app = app;
        return orb;
    } //init
    
    
    public org.omg.CORBA.Object 
        string_to_object(java.lang.String s) 
            throws xerox.ilu.IluSystemException
    {
        xerox.ilu.IluObject ob1 = 
            xerox.ilu.Ilu.objectFromSBH(
                s, 
                xerox.ilu.CORBA_ObjectStub.iluClass());
        if (ob1 instanceof org.omg.CORBA.Object) {
            return (org.omg.CORBA.Object) ob1;
        }  
        throw new xerox.ilu.IluSomeSystemException(
            "ilu object isn't corba::object"
            );
    } //string_to_object


    public java.lang.String object_to_string(xerox.ilu.IluObject ob) 
            throws xerox.ilu.IluSystemException
    {
        java.lang.String s = xerox.ilu.Ilu.iorOfObject(ob);
        return s;
    } //object_to_string
    
    
    
    public BOA BOA_init() {
        return new BOA(this);
    } //BOA_init
    
    
    public BOA BOA_init(java.lang.String boaType, java.util.Properties properties) {
        return new BOA(this);
    } //BOA_init
    
    
    /*friendly*/ static java.lang.String fromArgList(
        java.lang.String[] args, java.lang.String key)
    {
        if (args != null) {
            java.lang.String match = "-" + key;
            int cPos = match.length(); 
            for (int i = 0; i < args.length; i++) {
                java.lang.String arg = args[i];
                if ((arg != null) && (arg.startsWith(match))) {
                    if (arg.length() == cPos) {
                        //exact match; return next argument
                        if ((i+1)<args.length) {
                            return args[i+1];
                        }
                    } else if (arg.length() > (cPos+1)) {
                        //match with cont sign; return rest of argument
                        if (arg.charAt(cPos)=='#') {
                            return arg.substring(cPos+1);
                        }
                    }
                } 
            }
        }
        return null;
    } //fromArgList
    
    
    /*friendly*/ static java.lang.String fromAppEnv(
        java.applet.Applet app, java.lang.String key)
    {
        java.lang.String s = null;
        if (app != null) {s = app.getParameter(key);}
        return s;
    } //fromAppEnv
    
    
    /**  
     * Internal, non corba-compatible utility procedure
     * to read one line of a file.
     */
    public java.lang.String readFirstLine(java.lang.String filename) {
        try {
            java.io.FileReader fr = new java.io.FileReader(filename);
            java.io.BufferedReader br = new java.io.BufferedReader(fr);
            java.lang.String line = br.readLine();
            br.close();
            return line;
        } catch (java.io.IOException e) {
            throw new xerox.ilu.IluSomeSystemException(
                "From " + e
                );
        }
    } //readFromFile
    
    
    /**
     * Internal, non-corba compatible utility to find an initial
     * sbh to start your application; semantics is first step of
     * resolve_initial_references.
     *
     * Argument is the name of an initial service.  (Well it is 
     * a property key). This key will be used for a property look up 
     * and the found string is returned to be used as an sbh.
     *
     * If the found "sbh" starts with "file:" an additional
     * look up using the file system is performed.  This is usefull
     * to deal with foreign name services which can write the "root" 
     * name service object into a file. 
     *
     * @param serviceKey The name of an initial service
     * @return The "sbh" which could be used for initial service.
     */
    public java.lang.String     
        resolve_initial_sbh(java.lang.String serviceKey)
    {
        java.lang.String sbh = fromArgList(this.args, serviceKey);
        if (sbh==null) {
            sbh = fromAppEnv(this.app, serviceKey);
        }
        if (sbh==null) {
            sbh = this.props.getProperty(serviceKey);
        }
        if (sbh==null) {
            sbh = xerox.ilu.IluEnvironment.getStringPropX(serviceKey);
        }
        if (sbh != null) {
            if (sbh.regionMatches(true, 0, "file:", 0, 5)) {
                java.lang.String fn = sbh.substring(5).trim();
                sbh = readFirstLine(fn);
            }
        }
        if (sbh==null) {
            throw new xerox.ilu.IluSomeSystemException(
                "no clue to resolve initial references"
                ); 
        }
        return sbh;
    } //resolve_initial_sbh
    
    
    /**
     * Resolve an initial reference (bootstrap the naming service).
     * Argument is the name of an initial service.  (Well it is 
     * a property key). This key will be used for a property look up 
     * and the found string is used as an sbh used for the initial service
     * object which then will be looked up using ilu.
     *
     * If the found "sbh" starts with "file:" an additional
     * look up using the file system is performed.  This is usefull
     * to deal with foreign name services which can write the "root" 
     * name service object into a file. 
     *
     * @param serviceKey The name of an initial service
     * @return The ilu object refered to by the initial service.
     * Missing declaration of corba exceptions... 
     */
    public org.omg.CORBA.Object     
        resolve_initial_references(java.lang.String serviceKey)
    {
        java.lang.String sbh = resolve_initial_sbh(serviceKey);
        org.omg.CORBA.Object ob = string_to_object(sbh);
        return ob;
    } //resolve_initial_references
    
    
    public void connect(xerox.ilu.IluObject obj) {
        if (xerox.ilu.IluRT0.known(obj)) {
            //connecting an already connected object should have
            //no effect.
            return;
        }
        int defaultLifetime = xerox.ilu.IluLifetimeArgs.iluLifetimeRemember;
            //utterly bogus lifetime but this is used like standard corba...
        if (this.defaultServer==null) {
            this.defaultServer = xerox.ilu.IluServer.createServer(null);
        }
        xerox.ilu.Ilu.registerTrueObject(
            null, //ih 
            obj, 
            this.defaultServer, 
            null, //iluClass  
            defaultLifetime
            );
    } //connect
    
    
    /**
     * A non ilu based ORB is not likely to provide
     * this method. Use this for testing ilu-ness.
     */ 
    public static void check_ILU_ness() {
        //this is a double check:  
        //It checks first whether the compiler finds it
        //and secondly whether it can be used at runtime.
    } //check_ILU_ness
  
  
} // ORB

