# Top level makefile to build Win32 version of ILU using
# Microsoft Visual C++

JAVA_SRC_DIR = jsrc
ILU_CLASSPATHARG =
!IF "$(CFG)" == ""
CFG=Win32 Release
!MESSAGE No configuration specified.  Defaulting to Win32 Release.
!ENDIF 

!IF "$(CFG)" != "Win32 Release" && "$(CFG)" != "Win32 Debug"
!MESSAGE Invalid configuration "$(CFG)" specified.
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "iluwin32.mak" CFG="Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "Win32 Release"
!MESSAGE "Win32 Debug"
!MESSAGE 
!ERROR An invalid configuration is specified.
!ENDIF 

!IF "$(JAVA_HOME)" == ""
ALL : NOJAVAMAKE
!ELSE

!IF "$(JDK_HOME)" == ""
JDK_HOME = $(JAVA_HOME)
!ENDIF

JAVA_CLASS_DIR=.\javaclasses
JAVA_BUILD_DIR=.\build


!IF "$(CFG)" == "Win32 Release"

!IF "$(JAVASDK)" == "Microsoft"
ILU_JAVAC_FLAGS= /d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -rni
!ELSE
ILU_JAVAC_FLAGS= -d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -oni
!ENDIF
!ELSE
!IF "$(JAVASDK)" == "Microsoft"
ILU_JAVAC_FLAGS= /g /d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -rni
!ELSE
ILU_JAVAC_FLAGS= -g -d $(JAVA_CLASS_DIR)
ILU_GNH_FLAGS= -oni
!ENDIF
!ENDIF


!IF "$(JAVASDK)" == "Microsoft"
!MESSAGE Building for Microsoft SDK
JAVAC = $(JDK_HOME)\bin\jvc
JAVAH = $(JDK_HOME)\bin\msjavah
JAVAI = $(JAVA_HOME)\bin\jview
ILU_JAVAH_FLAGS= /d $(JAVA_BUILD_DIR) /noclinit
ILU_JAVAH_STUB_FLAG =
ILU_JAVARTMAKE = ilumsoft.mak
ALL : $(ILUHOME) $(ILUHOME)\bin $(ILUHOME)\lib JAVAMAKE
!ELSE
JAVAC= $(JDK_HOME)\bin\javac
JAVAH= $(JDK_HOME)\bin\javah
JAVAI= $(JAVA_HOME)\bin\java
ILU_JAVAH_FLAGS= -d $(JAVA_BUILD_DIR)
ILU_JAVAH_STUB_FLAG = -stubs
!IF "$(JAVAUSE12)" != ""
!MESSAGE Building for Javasoft JDK-1.2
ILU_JAVARTMAKE= ilujsoft12.mak
!ELSE
!MESSAGE Building for Javasoft JDK-1.1
ILU_JAVARTMAKE= ilujsoft.mak
!ENDIF
ALL : $(ILUHOME) $(ILUHOME)\bin $(ILUHOME)\lib JAVAMAKE JAVAGMAKE
!ENDIF


!ENDIF

################################################################################

NOJAVAMAKE :
    echo JAVA_HOME environment variable not set, not building Java runtime

$(ILUHOME) : 
    if not exist $(ILUHOME)\nul mkdir $(ILUHOME)

$(ILUHOME)\lib : 
    if not exist $(ILUHOME)\lib\nul mkdir $(ILUHOME)\lib

$(ILUHOME)\bin : 
    if not exist $(ILUHOME)\bin\nul mkdir $(ILUHOME)\bin

OMG_PATH_PART = org\omg
BASIC_SOURCES = \
    $(JAVA_SRC_DIR)\xerox\basics\NowhereStream.java \
    $(JAVA_SRC_DIR)\xerox\basics\NowhereWriter.java \
    $(JAVA_SRC_DIR)\xerox\basics\Consumer0.java \
    $(JAVA_SRC_DIR)\xerox\basics\Queue.java \
    $(JAVA_SRC_DIR)\xerox\basics\Environment.java \
    $(JAVA_SRC_DIR)\xerox\basics\VMExtras.java \
    $(JAVA_SRC_DIR)\xerox\basics\IntTab.java \
    $(JAVA_SRC_DIR)\xerox\ilu\float128.java

PRE_SOURCES = \
    $(JAVA_SRC_DIR)\xerox\ilu\IluInit.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluMozillaBase.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluPreLoad.java

PRE_EXCEPTION_SOURCES = \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\CompletionStatus.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\NO_MEMORY.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\IMP_LIMIT.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\COMM_FAILURE.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INITIALIZE.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\NO_IMPLEMENT.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BAD_TYPECODE.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\NO_RESOURCES.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\NO_RESPONSE.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\PERSIST_STORE.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BAD_INV_ORDER.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TRANSIENT.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\FREE_MEM.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INV_IDENT.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INV_FLAG.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INTF_REPOS.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BAD_CONTEXT.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\OBJ_ADAPTER.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\OBJECT_NOT_EXIST.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TRANSACTIONREQUIRED.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TRANSACTIONROLLEDBACK.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INTERNAL.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\MARSHAL.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BAD_PARAM.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\PortableServer\POA.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\PortableServer\DynamicImplementation.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluBadParameterException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\UNKNOWN.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluInconsistentCallException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluNoObjectException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluInternalException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluUnexpectedException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluNotConfiguredException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSomeSystemException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\SystemException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSystemException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSystemException0.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluRuntimeError.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluUserExceptionBase.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSystemExceptionBase.java 

EXCEPTION_SOURCES = \
    $(JAVA_SRC_DIR)\xerox\ilu\IluCallException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\UserException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluEnumerationRangeException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BAD_OPERATION.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluUnionDiscriminantException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\DATA_CONVERSION.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluCharacterRangeException.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\NO_PERMISSION.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\INV_OBJREF.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluConstantValueKind.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluTypeKind.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TCKind.java

RT_SOURCES = \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BOA.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\ORB.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluLifetimeArgs.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluLifetimeRemember.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluLifetimeForget.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluUserException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluDebugWriter.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluEnvironment.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluDebug.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluDataSupport.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluIHProposer.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluObject.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\Object.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\portable\ObjectImpl.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluWPBase.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluObjectBase.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluFactory.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluPassport.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSerializationContext.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluPipeline.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSurrogateConnection.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServiceThread.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServerConnection.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluIdentity.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluIdentityType.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluGssCred.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluGssOid.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluInit2.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluDebugHooks.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluClassRep.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluClassAccess.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluRuntimeException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluExceptionRep.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluOInt.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluAlarmTech.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluForkTech.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluCall.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluMethodRep.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluMethodArgRep.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServer.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServerRelocation.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServerRelocationInfo.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluObjectTable.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluRT0.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSkeleton.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSurrogateObject.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluTransportInfo.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluPort.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluBatcher.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluServantFinalizable.java \
    $(JAVA_SRC_DIR)\xerox\ilu\corba_ServantFinalizer.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluGCClient.java \
    $(JAVA_SRC_DIR)\xerox\ilu\Ilu.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSBH.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluSimpleBinding.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluTypeCode.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TypeCode.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluTypeRep.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\Any.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluAny.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluIOFunctions.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluCustomMapping.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluCustomMappingException.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluPickle.java \
    $(JAVA_SRC_DIR)\xerox\ilu\IluRootObjectHelper.java \
    $(JAVA_SRC_DIR)\xerox\ilu\CStringHolder.java \
    $(JAVA_SRC_DIR)\xerox\ilu\CStringHelper.java \
    $(JAVA_SRC_DIR)\xerox\ilu\CORBA_ObjectStub.java \
    $(JAVA_SRC_DIR)\xerox\ilu\CORBA_WStringHelper.java \
    $(JAVA_SRC_DIR)\xerox\ilu\CORBA_ObjectHelper.java

HOLDER_SOURCES = \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\ShortHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\IntHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\LongHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\ByteHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\FloatHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\DoubleHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\CharHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\BooleanHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\StringHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\ObjectHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\AnyHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\TypeCodeHolder.java \
    $(JAVA_SRC_DIR)\$(OMG_PATH_PART)\CORBA\PrincipalHolder.java 

XEROX_C_AND_H_SOURCES = \
    xerox.ilu.IluInit2 \
    xerox.ilu.IluPassport \
    xerox.ilu.IluSerializationContext \
    xerox.ilu.IluPipeline \
    xerox.ilu.IluIdentity \
    xerox.ilu.IluIdentityType \
    xerox.ilu.IluServiceThread \
    xerox.ilu.IluServerConnection \
    xerox.ilu.IluSurrogateConnection \
    xerox.ilu.IluOInt \
    xerox.ilu.IluClassRep \
    xerox.ilu.IluServer \
    xerox.ilu.IluServerRelocation \
    xerox.ilu.IluServerRelocationInfo \
    xerox.ilu.IluAlarmTech \
    xerox.ilu.IluForkTech \
    xerox.ilu.IluCall \
    xerox.ilu.IluExceptionRep \
    xerox.ilu.IluRT0 \
    xerox.ilu.IluTransportInfo \
    xerox.ilu.IluPort \
    xerox.ilu.IluBatcher \
    xerox.ilu.IluGssCred \
    xerox.ilu.IluGssOid \
    xerox.ilu.IluDebugHooks \
    xerox.ilu.IluGCClient \
    xerox.ilu.IluDebug \
    xerox.ilu.IluDebugWriter \
    xerox.ilu.IluPickle \
    xerox.ilu.IluTypeCode \
    xerox.ilu.IluTypeRep \
    xerox.ilu.IluSBH \
    xerox.ilu.IluWPBase


XEROX_H_SOURCES = \
    xerox.ilu.IluObject \
    xerox.ilu.IluMethodRep \
    xerox.ilu.IluMethodArgRep \
    xerox.ilu.IluObjectTable \
    xerox.ilu.IluSurrogateObject


JAVAMAKE :
    if not exist .\javaclasses\nul mkdir .\javaclasses
    if not exist .\build\nul mkdir .\build
    if exist .\ilunative.h attrib -r .\ilunative.h
    if exist .\ilunative.c attrib -r .\ilunative.c
    $(JAVAC) $(ILU_JAVAC_FLAGS) $(JAVA_SRC_DIR)\xerox\ilu\tools\gnh.java
    set CLASSPATH=.\javaclasses;$(CLASSPATH)
    $(JAVAI) $(ILU_CLASSPATHARG) xerox.ilu.tools.gnh $(ILU_GNH_FLAGS) ilunative.in
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(BASIC_SOURCES)
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(PRE_SOURCES)
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(PRE_EXCEPTION_SOURCES)
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(EXCEPTION_SOURCES)
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(RT_SOURCES)
    $(JAVAC) $(ILU_CLASSPATHARG) $(ILU_JAVAC_FLAGS) $(HOLDER_SOURCES)
    $(JAVAH) $(ILU_CLASSPATHARG) $(ILU_JAVAH_FLAGS) $(ILU_JAVAH_STUB_FLAG) $(XEROX_C_AND_H_SOURCES)
    $(JAVAH) $(ILU_CLASSPATHARG) $(ILU_JAVAH_FLAGS) $(XEROX_C_AND_H_SOURCES)
    $(JAVAH) $(ILU_CLASSPATHARG) $(ILU_JAVAH_FLAGS) $(XEROX_H_SOURCES)
    nmake -f $(ILU_JAVARTMAKE) CFG="$(CFG)"
    
# for javasoft, also make the _g version    
JAVAGMAKE : JAVAMAKE
    if exist $(JAVA_HOME)\lib\javai_g.lib nmake -f $(ILU_JAVARTMAKE) CFG="$(CFG)" ILUJG="_g"


clean :
    if exist WinDebug\nul del /q WinDebug\*
    if exist WinDebug\nul rmdir WinDebug
    if exist WinRel\nul del /q Winrel\*
    if exist WinRel\nul rmdir Winrel
    if exist $(JAVA_CLASS_DIR) rmdir $(JAVA_CLASS_DIR) /s
    if exist $(JAVA_BUILD_DIR) rmdir $(JAVA_BUILD_DIR) /s
    

# End 
################################################################################
