/*
 BeginILUCopyright
 
 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.
 
 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.
 
 EndILUCopyright
*/
/* IluJava_Common.h */
/* Chris Jacobi, September 16, 1998 11:21 am PDT */

/*
 */
 
/* $Id: IluJava_Common.h,v 1.15 1998/10/09 22:48:56 larner Exp $ */


#ifndef _ILUJAVA_COMMON_
#define _ILUJAVA_COMMON_

/*
 * Header file for ILU's Java implementation.
 *
 * This header file is mostly there to support internal 
 * file to file communication of the java language run time
 * support.  Presence of an identifier does not make this
 * identifier conceptionally public.
 */
 
#include "IluJava_Includes.h"

#include "IluJava_JTypes.h"
#include "ilunative.h"

/* ================ Generic conventions ================ */


/* Other identifier (variable, field, procedures) conventions
 *
 * jj... thing is java object in java land
 *     (Previously was also used in c land; replace this with jh_)
 *     (2 j's because JNI types start with one j)
 *
 * jh_...  thing is java object in C land (handle)
 * jwp_... thing is "weak" pointer to java object
 *         updated on memory compactions due to gc
 * jWP_    not yet used; reserved for real weak pointer to java object
 * jsp_    not yet used; reserved for pseudo strong pointer
 *
 * c... thing is on c side 
 * secondary:	c... if meta object -> for ilu kernel's object system
 * EVENTUALLY SWITCH TOWARDS k for similarity with other languages
 *
 * y... thing is c pointer stored in a (long) java object 
 *
 * _ilujava_...	 regular prefix for anything which is not exported
 *        	 ouside the language specific runtime  (But it is  
 *        	 in the .h file for internal reasons)
 * _iluJava_...	 prefix for export to stubs level but not java or clients
 *        	 (Doesn't yet occur)
 *
 * xerox_ilu_... prefix for exported to Java (given by java stubber)
 * 
 * ilu_		 ilu kernel defined feature
 *
 * Identifiers which don't follow any conventon are either used very local,
 * or they might be defined by a Java system header file. 
 */
 
 
/* File name conventions
 * I have not yet thought about systems which require short file names
 *
 * ...java      	manually writen source file
 *   			(ILU stubs should not be part of this directory)
 * IluJava...c  	manually writen source file
 * IluJava...h  	manually writen source file
 * xerox_ilu_...c	generated by java native code stubber
 * xerox_ilu_...h	generated by java native code stubber
 */
 


/* ================ Imports etc ================ */

#define INTERNALONLY static
/* Documents: following procedure is not used outside this file */

#define EXPORTLIMITED extern
/* Documents: following procedure is exported to other IluJava file 
 * (This is not applied religiously in .h files)
 */
 
#define EXPORTLIMITEDVAR 
/* Documents: following VARIABLE is implemented here but used also in 
 * other IluJava file 
 * (This is not used in .h files which must declare variable to be extern)
 */

#define IMPORTVAR extern
/* Documents: following VARIABLE is declared in other IluJava file 
 * (This is not used in .h files because all variable are extern anyway)
 */
 
#define OR ||
#define AND &&
 
/* ================ debugging ================ */


/* Available debugging flags (without any deep significance).
 *    0 means don't write to the log. 
 *    1 means log the interesting cases.
 *    Larger values of interest only while debugging a particular 
 *    feature (can cause excessive output).
 */
extern int _ilujava_iluGenericFlag; /* debugging mode */
extern int _ilujava_iluSpare1Flag;
extern int _ilujava_iluSpare2Flag;
extern int _ilujava_objectsFlag;
extern int _ilujava_pickleFlag;
extern int _ilujava_callsFlag;
extern int _ilujava_definitionsFlag;
extern int _ilujava_pctFlag;
extern int _ilujava_lockFlag;
extern int _ilujava_gcFlag;
extern int _ilujava_alarmFlag;


extern int _ilujava_getIntProp(char *, int);
/* Upcall to java to read an int property value as a means
 * to implement more debugging flags.
 * String is name of property (owned by caller). 
 * int is default value.
 */

#define PRINTRAISE	_ilujava_DebugPrintAndSignal
/* See _ilujava_DebugPrintAndSignal.
 */

extern void _ilujava_DebugPrintAndSignal(char * f);
/* Report an error condition.
 *
 * Used for condition which are caused by bugs in the application   
 * for which further progress is however still possible.
 *
 * In production mode:
 * May or may not print error message depending on switches.
 * Raises an IluSystemException
 *
 * In debugging mode:
 * "stop" immediately to ease debugging.
 */
 
#define CONDPRINT	_ilujava_DebugPrint
/* See _ilujava_DebugPrint.
 */

extern void _ilujava_DebugPrint(char * f);
/* Report an error condition.
 *
 * Used for condition which are caused by bugs in the application  
 * for which further progress is however still possible.
 *
 * In production mode:
 * May or may not print error message depending on switches.
 *
 * In debugging mode:
 * "stop" immediately to ease debugging.
 */
 

extern void _ilujava_PANIC(char * f);
/* 
 * Report error conditions for which ilu can not recover.
 */


extern char * _ilujava_captureJavaStack();
/* Debugging aid...
 * Caller takes ownership of returned string.
 * Rather expensive.
 */



/* ================ memory allocation ================ */

#include "IluJava_JMem.h"

/* ================ exception handling ================ */

#define completedYes "^Y"
#define completedNo "^N"

extern void 
_ilujava_IluErrorToException(ilu_Error* errPtr, char * t);
/* Causes the java system exception which fits the ilu_Error
 * to be raised.  
 * This procedure returns! Exceptions are a Java only concept.  
 * Java system exceptions put special meaning to t if it
 * starts with the character "^".  
 * Exceptions subclass of IluSystemException.
 *
 * This always raises an exception:  Even ILU_SUCCESS_CASE !!
 * Explicitely also supports errPtr==0.  
 *
 * If errPtr != 0  calls ILU_HANDLED
 */

extern void 
_ilujava_IluErrorToCallException(ilu_Error* errPtr, char * t);
/* Like IluErrorToException except that there is no switch
 * on the exception but allways IluCallException is raised.
 *
 * If errPtr != 0  calls ILU_HANDLED
 */


extern void 
_ilujava_Report(ilu_Error* errPtr, char* t);
/* OPTIONALLY (according to command line options)
 * makes a call to ilu_DebugPrintf.
 * Does not raise any errors or exceptions.
 * Explicitely also supports errPtr==0.
 */

extern void
_ilujava_NullPointerException(char* t);
/* Causes a NullPointerException to be reported when returned into java.
 */
 
 
extern void
_ilujava_SignalInconsistency(char* t);
/* Causes a serious internal error to be reported when returned into java.
 */


/* ================ miscellanious ================ */


extern ilu_LanguageIndex _ilujava_langidx; 

#define JAVALANGIDX _ilujava_langidx
/* Access to ilu's per language index */


extern void
_ilujava_registerJavaClass (
	ilu_Class cIluClass, 
	ilu_refany jClassRep   /* struct Hxerox_ilu_IluClassRep* */ 
	);
/* Register the mapping from ilu_Class to IluClassRep.
 * Implemented in IluJava_IluRT0.c
 * Used in IluJava_IluClassRep.c
 * Locked in IluJava_IluClassRep.c
 */


extern ilu_refany   /* struct Hxerox_ilu_IluClassRep* */
_ilujava_findJavaClass (
	ilu_Class cIluClass
	);
/* Find the IluClassRep for an ilu_Class.
 */


/* May run java GC */
extern ilu_refany /* JIluOInt */
_ilujava_newIluOInt(JENV_FORMAL_NOCOMMA);

/* May run java GC */
/* if cde is not 0, its value may over-ride clzz! */

extern void
_ilujava_throwException(JENV_FORMAL int cde, char* clzz, char* msg);


extern ilu_refany /* JIluOInt */ 
_ilujava_creatSurrOIFromRegistry (
	JENV_FORMAL
	ilu_Object cIluObject, 
	ilu_refany jh_staticClass /* (NIL IS OK) */
	);
/* Register a surrogate class.
 * Implemented in IluJava_IluRT0.c
 * Used in IluJava_IluCall.c
 */


extern ilu_Passport 
_ilujava_getIluPassport(JENV_FORMAL 
	ilu_refany jh_iluPassport /* struct Hxerox_ilu_IluPassport* */ 
	);
/* Converts java passport to ilu passport.
 * Converts null IluPassport into default passport. 
 * Implemented in IluJava_IluPassport.c
 * Used in IluJava_Ilucall.c
 */

/* GC: calling into java, may internally re-enable gc */
extern void
_ilujava_forkConnectionHandler(JENV_FORMAL ilu_Connection newConnection);


extern JObject _ilujava_createPermanentJavaObject();
/* Used for locking purposes */


/* ================ initialization ================ */

extern void _ilujava_IluRt0InitHashTable();
/* Initialization for IluJava_IluRT0 */

extern void _ilujava_AlarmTechInit();
/* Initialization for IluJava_AlarmTech */

extern void _ilujava_LockTechInit();
/* Initialization for IluJava_LockTech */

extern void _ilujava_IluOIntInit();
/* Initialization for IluJava_IluOInt */

extern void _ilujava_WaitTechInit();
/* Initialization for IluJava_pollwt.c */

extern void _ilujava_PassportInit();
/* Initialization for IluJava_IluPassport.c */

extern void _ilujava_IluServerInit();
/* Initialization for IluJava_IluServer.c */


/* ================ end ================ */

#endif /* _ILUJAVA_COMMON_ */


