/* $Id: TutorialServer.java,v 1.17 1998/10/09 20:54:44 spreitze Exp $
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.

 EndILUCopyright
*/
/* Chris Jacobi, November 3, 1997 3:38 pm PST */
/* Last edited by Mike Spreitzer October 9, 1998 1:48 pm PDT */

/*
 * Run this like
 * java Tutorial.TutorialServer servername
 */ 
 
/* $Id: TutorialServer.java,v 1.17 1998/10/09 20:54:44 spreitze Exp $ */

package Tutorial;

import Tutorial.Calculator;
import Tutorial.Factory;
import Tutorial.DivideByZero;
import Tutorial.CalculatorStub;
import Tutorial.FactoryStub;

import Tutorial.CalculatorImpl;

import xerox.ilu.Ilu;
import xerox.ilu.IluSimpleBinding;
import xerox.ilu.IluSystemException;
import xerox.ilu.IluServer;


class FactoryImpl 
        extends xerox.ilu.IluObjectBase 
        implements Tutorial.Factory  {
    xerox.ilu.IluServer server;
    public FactoryImpl(xerox.ilu.IluServer server) {
        this.server = server;
    }
    public Tutorial.Calculator CreateCalculator() 
                throws xerox.ilu.IluSystemException
    {
        Tutorial.Calculator calc = new Tutorial.CalculatorImpl();
        Ilu.registerTrueObject(
            Ilu.inventID(), 
            calc, 
            this.server, 
            Tutorial.CalculatorStub.iluClass(),
            0
            );
        return calc;
    }
} //FactoryImpl


public class TutorialServer {
    static FactoryImpl factory;
    static xerox.ilu.IluServer trueServer;
    public static void main(String argv[]) {
        try {
            String serverId;
            if (argv.length < 1) {
                 System.out.println("Must specify a server id");
                 return;
            }
            //Create a server with appropriate server id (which is
            //taken from the first argument) 
            serverId = argv[0];
            trueServer = xerox.ilu.IluServer.createServer(serverId);
            //Now create an instance of a Factory object on the server
            //with an instance handle "theFactory"
            factory = new FactoryImpl(trueServer);
            xerox.ilu.Ilu.registerTrueObject(
                "theFactory", 
                factory, 
                trueServer, 
                Tutorial.FactoryStub.iluClass(),
                0
                );
            //Make the factory well known by publishing it
            xerox.ilu.IluSimpleBinding.publish(factory);
            //Now we print the string binding handle (the object's name
            //plus its location) of the new Factory instance
            System.out.println("Factory instance published");
            System.out.println("Its SBH is '" + Ilu.sbhOfObject(factory) + "'");
            //the program doesn't terminate because the server is still alive...
        } catch (xerox.ilu.IluSystemException e) {
            System.out.println("raised IluSystemException: " + e);
        }
    }
} //TutorialServer
