/* $Id: CalculatorImpl.java,v 1.6 1998/10/09 20:54:44 spreitze Exp $
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.

 EndILUCopyright
*/
/* Chris Jacobi, August 20, 1997 4:35 pm PDT */
/* Last edited by Mike Spreitzer October 9, 1998 1:45 pm PDT */

package Tutorial;

/*
 * While this class matches the Tutorial.isl specification
 * it is a local implementation.  Its instances need to be
 * registered explicitely or implicitely with Ilu before they 
 * are publicly accessible.
 */

public class CalculatorImpl   
            extends xerox.ilu.IluObjectBase
            implements Tutorial.Calculator {
    double theValue = 0.0;
    public CalculatorImpl(){
        theValue = 0.0;
    }
    public void SetValue(double v) {
        theValue = v;
    }
    public double GetValue() {
        return theValue;
    }
    public void Add(double v) {
        theValue = theValue + v;
    }
    public void Subtract(double v) {
        theValue = theValue - v;
    }
    public void Multiply(double v) {
        theValue = theValue * v;
    }
    public void Divide(double v) throws Tutorial.DivideByZero {
        if (v==0.0) throw new Tutorial.DivideByZero();
        theValue = theValue / v;
    }
} //CalculatorImpl
