(** $Id: javaSerialObjects.isl,v 1.3 1998/10/09 16:59:11 spreitze Exp $
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.

 EndILUCopyright
*)
(* Last edited by Chris Jacobi, October 23, 1997 2:44 pm PDT *)
(* Last edited by Mike Spreitzer October 9, 1998 9:56 am PDT *)

INTERFACE javaSerialObjects;

TYPE JavaObject = OPTIONAL ObjectState;

TYPE ObjectState =               (* Represents non null java.lang.Object *)
  RECORD
    sb: ObjectBytes,             (* State of this java.lang.Object instance *)
    accessor: ClassAccessor      (* Accessing referenced classes  *)
  END;

TYPE ObjectBytes =               (* The serialized object instance *)
  SEQUENCE OF BYTE;

TYPE ClassBytes =                (* The bytecodes for a class *)
  SEQUENCE OF BYTE;

TYPE String =                    (* Unicode *)
  SEQUENCE OF CHARACTER;

EXCEPTION notFound: String;      (* "class"  (bytecodes) not found *)   

TYPE ClassAccessor =             (* ...input for class loader *)
  OBJECT OPTIONAL 
    DOCUMENTATION "Accessing the bytecodes of the class"
    METHODS
      GetBytes(classname: String): ClassBytes RAISES notFound END
    END;
