/* $Id: JavaObjectHandler.java,v 1.8 1998/10/09 20:32:18 spreitze Exp $
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.

 EndILUCopyright
*/
/* Chris Jacobi, October 24, 1997 12:14 pm PDT */
/* Last edited by Mike Spreitzer October 9, 1998 1:31 pm PDT */


package xerox.javaSerialObjects;

/**
 * This implements the transformation necessary for the full custom mapping
 * of JavaObject.
 */
public class JavaObjectHandler extends xerox.javaSerialObjects.ObjectState implements xerox.ilu.IluCustomMapping {
    private static final byte[] empty = new byte[0]; 
    private static final java.lang.Object lock = new Object(); 
    private java.lang.Object theObject = null; //synchronized with super.sb
    public static boolean debug = true;
    
    private static ClassAccessor defaultAccessor = null;
    
    /** 
     * This ClassAccessor will be used for java objects
     * which do not have an associated ClassAccessor (almost
     * all java objects which don't have a classloader pointing
     * to a ClassAccessor)
     */
    public static void setDefaultClassAccessor(ClassAccessor acc) {
        defaultAccessor = acc;
    }
    
    /** Transformation for IluCustomMapping */
    public java.lang.Object 
        iluCustomMapping_customFromIlu(java.lang.Object iluObject)
        // no instance data is used; this procedure is registered
        // independent on what JavaObject is used
    {
        if (iluObject == null) return null;
        JavaObjectHandler x = (JavaObjectHandler) iluObject;
        try {
            return x.getObject();
        } catch (java.lang.ClassNotFoundException e1) {
            throw new xerox.ilu.IluCustomMappingException("class not found");
        } catch (java.io.IOException e2) {
            throw new xerox.ilu.IluCustomMappingException("io exception");
        }
    }
        
    static JavaObjectHandler remembered = null;
    
    
    /** Transformation for IluCustomMapping */
    public java.lang.Object 
        iluCustomMapping_iluFromCustom(java.lang.Object customObject)
        // no instance data is used; this procedure is registered
        // independent on what JavaObject is used
    {
        if (customObject == null) return null;
        JavaObjectHandler x = null;
        if (customObject instanceof xerox.javaSerialObjects.ObjectState) {
           // the client must have created it for some (unknown) purpose
           return customObject;
        }
        x = remembered;
        if (x != null) {
           // very small cache, but usefull for transports
           // which ask for the size in a context where
           // only one custom mapped object is used...
           if (x.theObject == customObject) return x;
        }
        java.lang.ClassLoader cl = customObject.getClass().getClassLoader();
        ClassAccessor accessor = null;
        if (cl instanceof JavaObjectHandlerCLoader) {
           JavaObjectHandlerCLoader mcl = (JavaObjectHandlerCLoader) cl;
           accessor = mcl.accessor;
        } else {
           accessor = defaultAccessor;
        }
        try {
           x = new JavaObjectHandler(customObject, accessor);
        } catch (java.io.IOException e2) {
           throw new xerox.ilu.IluCustomMappingException("io exception");
        }
        remembered = x;
        return x;
    } //iluCustomMapping_iluFromCustom


    // This makes xerox.javaSerialObjects.JavaObject a custom record
    // We want it to be a custom record so it can cache the custom-object
    static { 
        try {
             xerox.javaSerialObjects._allJavaStubs.load();
             _theClass =  java.lang.Class.forName(
                 "xerox.javaSerialObjects.JavaObjectHandler"
                 );
        } catch (java.lang.Exception e) {
            System.err.println("Exception while loading JavaObjectHandler: " 
                + e );
        }
        System.err.println("this test is inherently unsafe because"); 
        System.err.println("it accesses bytecodes over the wire");
    } //static
    
    /** simple means to assure class is loaded */
    public static void load() {
    }
    
    /** Create a null pickle */
    public JavaObjectHandler() {
        try {
            setObject(null, null);
        } catch (java.io.IOException e) {
            throw new java.lang.RuntimeException();
        }
    }
    
    /** Create a pickle from serializable object and class accessor */
    JavaObjectHandler(java.lang.Object sob, ClassAccessor accessor) 
            throws java.io.IOException {
        setObject(sob, accessor);
    } 
    
    /** Accesses the java object from the serialized bytes */
    java.lang.Object getObject() 
            throws java.io.IOException, java.lang.ClassNotFoundException  {
        if (this.theObject != null) return this.theObject;
        byte[] ba = this.sb;
        if (ba == null || ba.length == 0) return null;
        if (debug) {
            System.out.println("JavaObjectHandler.getObject; enter");
        }
        java.io.ByteArrayInputStream in 
            = new java.io.ByteArrayInputStream(ba);
        JavaObjectHandlerInputStream s = 
            new JavaObjectHandlerInputStream(this, in);
        Object obj = s.readObject();
        if (debug) {
            System.out.println("JavaObjectHandler.getObject got: " + obj);
        }
        synchronized (lock) {
            if (this.sb == ba) this.theObject = obj;
        }
        return this.theObject;
    } //getObject
    
    
    /** 
     * Defines java object refered to by the serialized bytes.
     * Questionable whether this should be mutable as it might
     * change cached transformations
     */
    void setObject(java.lang.Object sob, ClassAccessor accessor) 
            throws java.io.IOException {
        if (sob == null) {
            synchronized (lock) {
                this.theObject = null;
                this.sb = empty;
                this.accessor = accessor;
                if (remembered == this) remembered = null;
            }
            return;
        }
        if (debug) { 
            System.out.println("JavaObjectHandler.setObject: " + sob);
        }
        java.io.ByteArrayOutputStream bstream  
            = new java.io.ByteArrayOutputStream();
        JavaObjectHandlerOutStream ostream 
            = new JavaObjectHandlerOutStream(bstream);
        ostream.writeObject(sob);
        ostream.flush();
        byte[] ba = bstream.toByteArray();
        synchronized (lock) {
            if (remembered == this) remembered = null;
            this.theObject = sob;
            this.sb = ba;
            this.accessor = accessor;
        }
        bstream.reset();
        if (debug) {
            System.out.println("JavaObjectHandler.setObject done");
        }
    } //setObject
    
    static {
        JavaObjectHelper._registerCustomMapping(new JavaObjectHandler());
    }
    
} //JavaObjectHandler


/** When serializing ilu objects this is the substitute we put on the wire */
class IluObjectCarrier implements java.io.Serializable {
    public java.lang.String sbh = null;
} //IluObjectCarrier


/** Helper class for serializing */
class JavaObjectHandlerOutStream 
        extends java.io.ObjectOutputStream 
{    
    public JavaObjectHandlerOutStream(java.io.ByteArrayOutputStream bstream) 
            throws java.io.IOException {
        super(bstream);
        try {
            this.enableReplaceObject(true); 
        } catch (java.lang.SecurityException s) {
            //dont raise exception here; simply
            //fail to serialize those object which shouldn't
        }
    } //constructor
    
    /**
     * Replace ilu objects by something which works as either
     * true or surrogate object.  Leave serializables alone however  
     */
    protected java.lang.Object replaceObject(java.lang.Object obj)
	throws java.io.IOException
    {
	if (obj instanceof java.io.Serializable) {
	    return obj;
	}
	if (obj instanceof xerox.ilu.IluObject) {
	    xerox.ilu.IluObject iobj = (xerox.ilu.IluObject) obj;
	    IluObjectCarrier placeholder = new IluObjectCarrier();
	    placeholder.sbh = xerox.ilu.IluRT0.sbhOfObject(iobj);
	    return placeholder;
	}
	return obj; //will later throw an NotSerializableException 
    } //replaceObject

} //JavaObjectHandlerOutStream


/** Helper class for serializing */
class JavaObjectHandlerInputStream 
        extends java.io.ObjectInputStream 
{    
    static boolean debug = JavaObjectHandler.debug;
    private JavaObjectHandler container;
    private JavaObjectHandlerCLoader loader = null;
    
    public JavaObjectHandlerInputStream(
            JavaObjectHandler container, java.io.InputStream s 
            ) throws java.io.IOException, java.io.StreamCorruptedException {
        super(s);
        this.container = container;
        try {
           this.enableResolveObject(true); 
        } catch (java.lang.SecurityException se) {
            //dont raise exception here; simply
            //fail to deserialize those object which shouldn't
        }
    }
    
    protected java.lang.Class resolveClass(java.io.ObjectStreamClass v)
            throws java.io.IOException, java.lang.ClassNotFoundException {
        java.lang.Class clazz = null;
        String name = v.getName();
        if (debug) {
            System.out.println("input stream resolve: " + name);
        }
        if (loader == null) {
            loader = new JavaObjectHandlerCLoader(container.accessor);
        }
        clazz = loader.loadClass(name, true);
        return clazz;
    } //resolveClass
    
    /**
     * Undo replacements of ilu objects  
     */
    protected java.lang.Object resolveObject(java.lang.Object obj)
	throws java.io.IOException
    {
	if (obj instanceof IluObjectCarrier) {
	    IluObjectCarrier carrier = (IluObjectCarrier) obj;
	    obj = xerox.ilu.IluRT0.objectFromSBH(
	        carrier.sbh, 
	        xerox.ilu.IluClassRep.rootClass()
	        );
	    // THIS DOES NOT LOAD THE CLASS
	}
	return obj;  
    } //resolveObject

    
} //JavaObjectHandlerInputStream


/** The class loader */
class JavaObjectHandlerCLoader extends java.lang.ClassLoader {
    static boolean debug = JavaObjectHandler.debug;
    ClassAccessor accessor = null;
    java.util.Hashtable cache = new java.util.Hashtable();
    
    public JavaObjectHandlerCLoader(ClassAccessor accessor) {
        this.accessor = accessor;
    }
    
    private byte[] getClassData(java.lang.String name) {
        byte[] b = null;
        if (debug) {
            System.out.println("class loader accessing bytes for " + name);
        }
        try {
            b = accessor.GetBytes(name);
        } catch (xerox.javaSerialObjects.notFound e) {
            System.out.println("Failed accessing class [" + name + "]: " + e);
        }
        if (debug) {
            System.out.println("class loader accessing bytes done");
        }
        return b;
    } //getClassData
    
    public synchronized java.lang.Class loadClass(
        java.lang.String name,
        boolean resolve)
    {
        java.lang.Class c = (java.lang.Class) cache.get(name);
        if (c == null) {
            try {
                c = findSystemClass(name);
                cache.put(name, c);
                if (resolve) resolveClass(c);
                return c;
            } catch (ClassNotFoundException e) {
            }
            byte[] data = getClassData(name);
            c = defineClass(name, data, 0, data.length);
            cache.put(name, c);
        }
        if (resolve) resolveClass(c);
        return c;
    } //loadClass
    
} //JavaObjectHandlerCLoader
