<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/

/*****************************************************************************
Portions of this code where inspired by smbwebclient.php, 
Copyright (C) 2003-2006 Victor M. Varela <vmvarela@gmail.com>
Homepage: http://smbwebclient.sourceforge.net
* Initial RegExps
*****************************************************************************/

	//function handleRequest()
	//Will call the appropriate Samba command then parse the results into an array that is returned
	//to JavaScript
	function handleRequest_PHP($useCred, $usr, $pwd, $location, $myVar, $workgroup='', $directory='', $opt){
		global $_SESSION;
		session_start();

		$location = str_replace("\\\\", "", $location);

		if($location == 'localhost')
			$location = LOCALHOST;
		$crypt = new EPI_CRYPT;
		$json = new Services_JSON();

		$old_location = $location;

		if(USESESSION == 'true'){
			$usr = rawurldecode($_SESSION['username']);
			$pwd = rawurldecode($_SESSION['password']);
			if(trim($usr) == ''){
				$returnMe = 'gotoMain';
				return $returnMe;
			}
		} else {
			$usr= rawurldecode($usr);
			$pwd= rawurldecode($pwd);
		}
		session_write_close();

		if(($myVar == 1|| $myVar == 3) && $location != LOCALHOST){
			$location = getIP($location);
			if(!$location){
				$error = array();
				$error['error'] = 'error';
				$error['msg'] = 'Could not lookup IP address for server.';

				$whatWeGot = $json->encode($error);
				return $whatWeGot;
			}
			$ip = $location;
		} else if($myVar == 2){
			$holder = explode('/',$location);
			$holder2 = getIP($holder[2]);
			if(!$holder2){
				$error = array();
				$error['error'] = 'error';
				$error['msg'] = 'Could not lookup IP address for server.';

				$whatWeGot = $json->encode($error);
				return $whatWeGot;
			}
			$ip = $holder2;
			$location = str_replace($holder[2],$holder2,$location);
		}

		$location = $old_location;
		//$preserve = "**$usr - $pwd**";
        //$usr= rawurldecode($usr);
        //$pwd= rawurldecode($pwd);
		//$preserve2 = "**$usr - $pwd**";

		$usr = $crypt->WEB_decrypt($usr);
		$pwd = $crypt->WEB_decrypt($pwd);
		$json = new Services_JSON();
		//the \t removes the space infront of the share name - easier to use
		$shareLines = "^\t(.*)[ ]+(Disk|Printer)[ ]+(.*)\$"; //don't forget the printers :P
		$sandwLines = "^\t([^ .]+?)[ ]+(.*)$";			//Since the format of the server and workgroup line are the
		$serverHeader = "^\tServer[ ]+Comment\$";		//same, I have to detect which one I am looking at ahead of time
		$workgroupHeader ="^\tWorkgroup[ ]+Master\$";
		$divider = "^\t---------[ ]+-------\$"; //The dividing bar between the Headers and the list of wgroups/servers
		//following gets files and directories - we'll sort them out later since we will have them in an array
		$fanddLines = '^[ ]+(.*)[ ]+([D|A|R|DR|AR|DH|DAH|HA]+)[ ]+([0-9]+)[ ]+(Mon|Tue|Wed|Thu|Fri|Sat|Sun)[ ](Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+([0-9]+)[ ]+([0-9]{2}:[0-9]{2}:[0-9]{2})[ ]([0-9]{4})$';
		$fanddLines2 = '^[ ]+(.*)[ ]+([0-9]+)[ ]+(Mon|Tue|Wed|Thu|Fri|Sat|Sun)[ ](Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+([0-9]+)[ ]+([0-9]{2}:[0-9]{2}:[0-9]{2})[ ]([0-9]{4})$';
			//report('Time:start',time());

		$result = returnList($usr, $pwd, $location, $myVar, $workgroup, $directory, $ip);
			//report('Time:gotList',time());
		if(DEBUG == 'true'){
			$fp = @fopen(DEBUGPATH . DEBUGFILE,"a");
			@fwrite ($fp,"Result:($result)");
			@fclose($fp);
		}

		$location = $old_location;

		$gotMe = errorHandler($result);
		if($gotMe != false)
			return $gotMe;
			//report('Time:errorParse',time());		
		//return $gotMe;
		$catchMe = explode("\n", $result);		
			//report('Time:explode',time());	
		report("Location:",$location);
		if($myVar == 1){
			global $nonoList;
			$noList = array();
			if(@file_exists("./wgnoshow.php")&&sizeof($nonoList)>0){
				foreach($nonoList as $key=>$item){
					$item = trim($item);
					$length_item = strlen($item);
					if($length_item == 0)
						continue;
					if(substr($item,0,2)=='//')
						continue;

					report('Exclude',$item);
					$noList[] = $item;
				}
			}
			$shares = $servers = $workgroups = array();
			$shares[] = $servers[] = $workgroups[] = 0;
			$lookFor = 'nothing';
			foreach($catchMe as $key => $item){
				if(utf8_encode(utf8_decode($item)) != $item)
					continue;

				if($item == '') {//blank line - just continue now
					$lookFor = 'nothing';
					continue;
				}
				$fields = array();
				//If we notice that we are reading the server or workgroup header,
				//we have to make note of it in the variable lookFor
				if (preg_match('/'.$serverHeader.'/', $item)){
					$lookFor = 'servers';
					continue;
				} else if (preg_match('/'.$workgroupHeader.'/', $item)){
					$lookFor = 'workgroups';
					continue;
				}else if (preg_match('/'.$shareLines.'/', $item, $fields)) {
					if(strpos($fields[1],'$')>=1)
						continue;
					$fields[1] = trim($fields[1]);
					++$shares[0];
					$shares[] = array('name' => $fields[1],
									  'type' => $fields[2],
						              'location' => '//'.$location.'/'.$fields[1],
									  'workgroup' => $workgroup);
				} else if (preg_match('/'.$sandwLines.'/', $item, $fields)) { //are we looking at a server
					//make sure it isn't the dividing dashes				  //or workgroup?
					if(preg_match('/'.$divider.'/', $item)){
						continue;
					}


                                        //-------------------------------------------
                                        //Problem is workgroup can have a space in the name.
                                        // but Might or might not have a master.
                                       // redo the string.. If only 1 space... then
                                        // wll assume that this is the still the workgroup namae
                                        // Of muultiple spaces, then can assum that
                                        // it is the master list after.
                                        //-------------------------------------------
                                        $f_holder = array();

							     $position=strpos($item,"  ");

								 if($position!==false) {
								   $fields[1]=trim(substr($item,0,$position));
								   $fields[2]=trim(substr($item,$position,strlen($item)));
                                 } else {
                                   $fields[1]=trim($item);
								   $fields[2]="";

								 }



					$fields[1] = trim($fields[1]);
					if($lookFor == 'servers'){
						++$servers[0];
						$servers[] = array('name' => $fields[1],
										   'type' => $fields[2],
							               'workgroup' => $workgroup);
					} else if($lookFor == 'workgroups'){
						$quit_wg = false;
						foreach($noList as $noKey=>$noItem){
							if(trim($fields[1]) == $noItem){
								$quit_wg = true;
								break;
							}
						}
						if($quit_wg)
							continue;
						
						//this code causes problems
						if($servers[0] == 0 && $workgroup == trim($fields[1])){ //If we have no servers by the time we reach workgroups,
											  //we need to 'fake it' - there's a good chance that the 
											  //network wasn't configured properly.
							++$servers[0];
							$servers[] = array('name' =>$fields[2],
											   'type' => '',
								               'workgroup' => $fields[1]);
						}
	
						++$workgroups[0];
						$workgroups[] = array('name' => $fields[1],
											  'type' => $fields[2]);
					}
				} 
			}//end foreach($catchMe as $key => $item)
			$sendThis = array();
			$sendThis[0] = array();
			$sendThis[0] = $shares;
			$sendThis[1] = array();
			$sendThis[1] = $servers;
			$sendThis[2] = array();
			$sendThis[2] = $workgroups;
			$sambaUser->changeWorkgroup=$workgroup;
			$sambaUser->changeServer=$location;
			if($location == LOCALHOST) {
				$sendThis['type'] = 'workgroups';
			} else if($location != LOCALHOST) {
				$sendThis['type'] = 'servers';
			}
			//$returnMe = $json->encode($sendThis);
		} else if($myVar == 2) {
			//report('Time:ItemProcessing',time());
			$files = $directories = array();
			$files[0] = $directories[0] = 0;
			$fields = array();

			$directory = trim($directory);
			//report('Time:before for',time());
			foreach($catchMe as $key => $item){
				if(utf8_encode(utf8_decode($item)) != $item)
					continue;

				if(preg_match('/'.$fanddLines.'/', $item, $fields)){
					//report('Time:start1',time());
					if(substr($fields[1],0,1)=='.'){
						continue;
						//report('Time:done1',time());
					}
					$fields[1] = trim($fields[1]);
					if(strstr($fields[2], 'D')===false) {
						//$icon = find_gif_name($fields[1]);
						//$sendName = trim($fields[1]);
						++$files[0];
						$icon = find_gif_name($sendName);
						if(utf8_encode(utf8_decode($item)) == $item){
							//report('Time:beforearray',time());	
							$files[] = array("name" => $fields[1],
											 "size" => format_doc_size($fields[3]),
											 "wday" => $fields[4],
											 "month" => $fields[5],
											 "day" => $fields[6],
											 "time" => $fields[7],
											 "year" => $fields[8],
											 "loc" => $location,
											 "dir" => trim($directory),
											 "icon" => $icon);
						}
					} else {
						if($fields[1] == '.' || $fields[1] == '..')
							continue;
						//++$directories[0];						
						
						++$directories[0];
						//report('Time:beforearray',time());
						$directories[] = array("name" => $fields[1],
											   "wday" => $fields[4],
											   "month" => $fields[5],
											   "day" => $fields[6],
											   "time" => $fields[7],
											   "year" => $fields[8],
											   "workgroup" => $workgroup,
											   "location" => $location,
											   "directory" => trim($directory) . '/'. $fields[1]);
						//report('Time:done1',time());
					}
				} else if(preg_match('/'.$fanddLines2.'/',$item, $fields)){
					//report('Time:start2',time());
					//are these always files???
					//We have a line without a D or an A in it's designation
					if(substr($fields[1],0,1)=='.'){
						//report('Time:done2',time());
						continue;
					}
					$fields[1] = trim($fields[1]);
					if(utf8_encode(utf8_decode($item)) == $item){
						++$files[0];
						//$icon = find_gif_name($fields[1]);
						$sendName = trim($fields[1]);
						$icon = find_gif_name($sendName);
						//report('Time:beforearray',time());
						$files[] = array("name" => $fields[1],
										 "size" => format_doc_size($fields[2]),
										 "wday" => $fields[3],
										 "month" => $fields[4],
										 "day" => $fields[5],
										 "time" => $fields[6],
										 "year" => $fields[7],
										 "loc" => $location,
										 "dir" => trim($directory),
										 "icon" => $icon);
						//report('Time:done2',time());			
					}
				}//end if(preg_match('/'.$fanddLines.'/', $item, $fields))
			}//end foreach($catchMe as $key => $item)

			$sendThis = array();
			$sendThis[0] = array();
			$sendThis[0] = $files;
			$sendThis[1] = array();
			$sendThis[1] = $directories;
			$sendThis['opt'] = $opt;
			//$returnMe = $json->encode($sendThis);
		} else if($myVar == 3){ //using net share
			//net share errors
			$var3[] = "Could not connect to server (.*)\$";
			$var3R[] = "A connection to the server could not be established.";
			$var3[] = "Invalid ip address specified\$";
			$var3R[] = "A connection could not be established because SSLBridge could not determine the proper IP address for the server.";
			$var3[] = "The username or password was not correct.\$";
			$var3R[] = "You could not authenticate yourself with the server.";
			$errors = false;
			$shares = false;
			$donedone = false;
			$errorThisTime = false;
			$shares = array();
			$shares[0] = 0;
			foreach($catchMe as $key=>$item){
				foreach($var3 as $key2=>$errorMsg){
					if(preg_match('/'.$errorMsg.'/',$item,$fields)){
						if($errorMsg == "Invalid ip address specified\$")
							continue;

						$errorThisTime = true;
						$errors = true;
						if($key2 == 0){
							$donedone = true;
						} 
						$sendThis = array();
						$sendThis['error'] = 'error';
						$sendThis['msg'] = $var3R[$key2];
					} //end if(preg_match('/'.$errorMsg.'/',$item,$fields))
				}//end foreach($var3 as $key2=>$errorMsg)
				if($donedone)
					break;
				if(strpos($item, '$')===false && !$errorThisTime && strlen($item) != 0 && trim($item)!="Invalid ip address specified"){
					++$shares[0];
					$shares[] = array('name' => trim($item),
									  'type' => "",
						              'location' => '//'.$location.'/'.trim($item),
									  'workgroup' => $workgroup);			
				}//end if(strpos($item, '$')===false)
				$errorThisTime = false;
			}//end foreach($catchMe as $key=>$item)
			if($sendThis['error'] != 'error'){
				$sendThis = array();
				$sendThis[0] = array();
				$sendThis[0] = $shares;
				$sendThis['opt'] = $opt;
			}
			//$returnMe = $json->encode($sendThis);
		} else {
			//donno ???
		}
		report("Location:",$location);					
		if(DEBUG == 'true'){
			$fp = @fopen(DEBUGPATH . DEBUGFILE,"a");
			@fwrite ($fp,"ReturnValue:($returnMe)");
			@fclose($fp);
		}
		if(PAGEDRESULTS == 'true')
			$sendThis['paged'] = PAGELIMIT + 0;
		else
			$sendThis['paged'] =  0;

		$returnMe = $json->encode($sendThis);
		return $returnMe;
	}

	//Is this function even  used?  I don't think so
	//PMW 10/19/2006
	function makeMountsForMultipleMove_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){
		global $_SESSION;
		session_start();
		$dShare = str_replace("\\\\", "", $dShare);
		$dDir = str_replace("\\\\", "", $dDir);

		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		session_write_close();
		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);

		$name = trim($name);
		$dShare = trim($dShare);
		$sShare = trim($sShare);
		$dDir = trim($dDir);
		$sDir = trim($sDir);
		$workgroup = trim($workgroup);

		$holdMe = explode('/', $sDir);
		$location1 = $holdMe[sizeof($holdMe)-1];
		//in case we are working in directly off of the share instead of in a directory
		if($location1 == '')
			$location1 = 'share1';
		$holdMe = explode('/', $dDir);
		$location2 = $holdMe[sizeof($holdMe)-1];
		if($location2 == '')
			$location2 = 'share2';

		$source = SYSTEMDIR.'/'.WORKINGDIR."/$username/$location1";
		$destination = SYSTEMDIR.'/'.WORKINGDIR."/$username/$location2";

		$s2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$location1$sDir";
		$d2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$location2$dDir";

		$cmd = '';

		$cmd .= '\n'.makeMount($source, $sShare, $workgroup, $username, $password);
		$cmd .= '\n'.MakeMount($destination, $dShare, $workgroup, $username, $password);

		$whatWeGot = errorHandler($cmd);
		report("Results",$cmd);	

		$error = array();
		if($whatWeGot == false && @fopen($d2.'/pmw_smb_test.txt', 'a') != false){
			$action = 'rm '.$d2.'/pmw_smb_test.txt';
			$val = `$action`;
			if(!@is_readable($s2.'/'.$name)) {
				$error['error'] = 'error';
				$error['msg'] = 'You do not have read permission on the selected files.';
			} else {
				$error['msg'] = 'ok';
				$error['error'] = 'no';
			}
		} else {
			$error['error'] = 'error';
			$error['msg'] = 'You do not have permission to move a file into the selected folder.';
		}
		$json = new Services_JSON();
		return($json->encode($error));
	}

	function handleFileMoveMultiple_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){
		global $_SESSION;
		$dShare = str_replace("\\\\", "", $dShare);
		$dDir = str_replace("\\\\", "", $dDir);
		session_start();
		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);
		session_write_close();

		//Make the mounts
		$name = trim($name);
		report("File List",$name);
		$nameList = array();
		$nameList = explode(';', $name);
		$dShare = trim($dShare);
		$sShare = trim($sShare);
		$dDir = trim($dDir);
		$sDir = trim($sDir);
		$workgroup = trim($workgroup);

		$holdMe = explode('/', $sDir);
		$location1 = $holdMe[sizeof($holdMe)-1];
		//in case we are working in directly off of the share instead of in a directory
		if($location1 == '')
			$location1 = 'share1';
		$holdMe = explode('/', $dDir);
		$location2 = $holdMe[sizeof($holdMe)-1];
		if($location2 == '')
			$location2 = 'share2';

		$uid1 = uniqid(rand());
		$uid2 = uniqid(rand());

		$source = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid1";
		$destination = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid2";

		//$s2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid1/$location1$sDir";
		//$d2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid2/$location2$dDir";
		$s2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid1$sDir";
		$d2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid2$dDir";
		$s2s = stripslashes($s2);
		$d2s = stripslashes($d2);

		$cmd = '';

		report("source",$source);
		report("destination",$destination);

		$cmd .= '\n'.makeMount($source, $sShare, $workgroup, $username, $password);
		$cmd .= '\n'.MakeMount($destination, $dShare, $workgroup, $username, $password);

		$whatWeGot = errorHandler($cmd);
		report("Results",$cmd);	

		$error = array();
		$error['nothere'] = 0;
		$error['names'] = '';

		if($whatWeGot == false && @fopen($d2s.'/pmw_smb_test.txt', 'a') != false){
			$action = 'rm '.$d2s.'/pmw_smb_test.txt';
			$val = `$action`;
			$i = 0;
			foreach($nameList as $key=>$ourName){
				if(!file_exists($s2.'/'.$ourName)){
					$error['error']='error';
					++$error['nothere'];
					if($error['nothere'] == 1)
						$error['msg'] = "The file $ourName was not found in this directory.  It could have been moved by another user.";
					else
						$error['msg'] = $error['nothere'] .' files where not found in this directy.  They could have been moved by another user.';
				} else if(!@is_readable($s2.'/'.$ourName)){
					$error['error'] = 'error';
					$error['msg'] = "You do not have access to all files selected.";
				} else { //everything is ok
					$cmd = '\n'.transferFile($status,$username, $password, $ourName, $s2, $d2, $sShare, $workgroup, $sDir);
					report("Move Multiple",$cmd);
					if($status != 'normal'){
						++$i;
						$error[$i]['size'] = 'ukwn';
						$error[$i]['name'] = $name;
						$today = getDate();
						$error[$i]['wday'] = substr($today['weekday'],0,3);
						$error[$i]['month'] = substr($today['month'],0,3);
						$error[$i]['day'] = $today['mday'];
						$error[$i]['time'] = $today['hours'] . ':' .$today['minutes'] . ':' .$today['seconds'];
						$error[$i]['year'] = $today['year'];	
						//$error[$i]['loc'] = $dShare;
						//$error[$i]['dir'] = $dDir;
						report("Copy-Status","not-normal");
					} 
				}
			}//end foreach
			if(@is_writable($s2.'/'.$nameList[0])){
				report("Writable?","yes");
				if($status != 'normal')
					$error['writable'] = 'no';
				else
					$error = 'no';
			} else {
				report("Writiable?","no");
				if($status != 'normal')
					$error['writable'] = 'yes';
				else
					$error = 'yes';
			}
		} else {
			$error['error'] = 'error';
			$error['msg'] = 'You do not have permission to move a file into the selected folder.';
		}
		//Remove Mounts
		$cmd .= '\n'.removeMount($source, $username, $password);
		$cmd .= '\n'.removeMount($destination, $username, $password);
		
		$json = new Services_JSON();
		if($error['error'] == 'error' || $status != 'normal') 
			return($json->encode($error));
		else
			return $error;
	}

	function handleFileMove_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){
	//function handleFileMove($name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup, $loc){
		global $_SESSION;
		session_start();
		$dShare = str_replace("\\\\", "", $dShare);
		$dDir = str_replace("\\\\", "", $dDir);

		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		session_write_close();

		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);
		$name = trim($name);
		$dShare = trim($dShare);
		$sShare = trim($sShare);
		$dDir = trim($dDir);
		$sDir = trim($sDir);
		$workgroup = trim($workgroup);
		//$location = //Server/share/path/here ex: //RED/html/mrc
		//$name = filename.file  ex: testing.php
		//$username = the user's name
		$holdMe = explode('/', $sDir);
		$location1 = $holdMe[sizeof($holdMe)-1];
		//in case we are working in directly off of the share instead of in a directory
		if($location1 == '')
			$location1 = 'share1';
		$holdMe = explode('/', $dDir);
		$location2 = $holdMe[sizeof($holdMe)-1];
		if($location2 == '')
			$location2 = 'share2';

		$uid1 = uniqid(rand());
		$uid2 = uniqid(rand());

		$source = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid1";
		$destination = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid2";

		$s2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid1$sDir";
		$d2 = SYSTEMDIR.'/'.WORKINGDIR."/$username/$uid2$dDir";

		$s2s = stripslashes($s2);
		$d2s = stripslashes($d2);

		$cmd = '';

		$cmd .= '\n'.makeMount($source, $sShare, $workgroup, $username, $password);
		$cmd .= '\n'.MakeMount($destination, $dShare, $workgroup, $username, $password);

		$whatWeGot = errorHandler($cmd);
		report("Results",$cmd);	
		if($whatWeGot == false && @fopen($d2s.'/pmw_smb_test.txt', 'a') != false){
			$action = 'rm '.$d2s.'/pmw_smb_test.txt';
			$val = `$action`;
			if(@is_readable($s2.'/'.$name)){
				$cmd = '\n'.transferFile($status,$username, $password, $name, $s2, $d2, $sShare, $workgroup, $sDir);
			} else {
				$error = array();
				$error['error'] = 'error';
				if(!file_exists($s2.'/'.$name))
					$error['msg'] = 'The file you tried to move is no longer in this directory';
				else 
					$error['msg'] = 'You do not have read permission on the selected file.';
				$json = new Services_JSON();
				$whatWeGot = $json->encode($error);
			}
		} else {
			$error = array();
			$error['error'] = 'error';
			$error['msg'] = 'You do not have permission to move a file into the selected folder.';
			$json = new Services_JSON();
			$whatWeGot = $json->encode($error);
		}

		//if we don't have an error, we will try to read the source file again.
		//If it is not there, then we have moved the file
		//if it is, we copied the file
		if($whatWeGot == false){
			if($status != 'normal'){
				$info = array();
				$info['size'] = 'ukwn';
				$info['name'] = $name;
				$today = getDate();
				$info['wday'] = substr($today['weekday'],0,3);
				$info['month'] = substr($today['month'],0,3);
				$info['day'] = $today['mday'];
				$info['time'] = $today['hours'] . ':' .$today['minutes'] . ':' .$today['seconds'];
				$info['year'] = $today['year'];	
				$info['loc'] = $dShare;
				$info['dir'] = $dDir;

				$json = new Services_JSON();
				$whatWeGot = $json->encode($info);
				if(DEBUG == 'true'){
					$fp = @fopen(DEBUGPATH . DEBUGFILE,"a");
					@fwrite ($fp,"Status:(not-normal)");
					@fclose($fp);
				}	
			} else if(@is_writable($s2.'/'.$name)){
				if(DEBUG == 'true'){
					$fp = @fopen(DEBUGPATH . DEBUGFILE,"a");
					@fwrite ($fp,"Writabe?:(yes)");
					@fclose($fp);
				}	
				$whatWeGot = 'no';
			} else {
				if(DEBUG == 'true'){
					$fp = @fopen(DEBUGPATH . DEBUGFILE,"a");
					@fwrite ($fp,"Writable?:(no)");
					@fclose($fp);
				}	
				$whatWeGot = 'yes';
			}
		}
		//now whatWeGot either equals an error message, yes, or no

		$cmd .= '\n'.removeMount($source, $username, $password);
		$cmd .= '\n'.removeMount($destination, $username, $password);
		//theoretically we don't have to check for more errors at this point
			//report('Time:return',time());
		return $whatWeGot;
	}//end handleFileMove_PHP

	function downloadFile_PHP($name, $share, $directory, $workgroup, $username, $password){
		global $_SESSION;
		$share = str_replace("\\\\", "", $share);
		$directory = str_replace("\\\\", "", $directory);
		session_start();
		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		session_write_close();
        //$username = rawurldecode($username);
        //$password = rawurldecode($password);
		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);
		$json = new Services_JSON();
		$share = trim($share);			//You can't be too careful, so
		$directory = trim($directory);	//I'm making sure that they all
		$username = trim($username);	//have their trim
		$password = trim($password);

		$uid = uniqid(rand());

		$source = SYSTEMDIR.'/'.WORKINGDIR."/$uid";
		$returnValue = array();
	
		$cmd = '\n'.makeMount($source, $share, $workgroup, $username, $password);
		report("Download Mount",$cmd);

		$whatWeGot = errorHandler($cmd);
		if($whatWeGot == false){
			$path = SYSTEMDIR.'/'.WORKINGDIR."/$uid";
			if($directory != '')
				$path .= $directory;

			$path = str_replace("\\'", "'", $path);
			if(is_readable($path."/$name")){
				$returnValue['path'] = $path;
				$returnValue['path'] .= "/$name";
				report("before",$returnValue['path']);
				$returnValue['path'] = $crypt->WEB_encrypt($returnValue['path']);
				report("after",$returnValue['path']);
			} else {
				report("Path that was read that failed:", $path.'/'.$name);
				$returnValue['path'] = 'no';
				$returnValue['error'] = 'error';
				$returnValue['msg'] = 'You do not have permission to acces the requested file.';
				$cmd .= '\n'.removeMount($source, $username, $password);
			}
		} else {
			//clean up after yourself
			$returnValue['path'] = 'no';
			$returnValue['error'] = 'error';
			$returnValue['msg'] = 'An error occured while setting up your download.  Please contact your network administrator.';
			$cmd .= '\n'.removeMount($source, $username, $password);
		}
		$returnMe = $json->encode($returnValue);
		return $returnMe;
	}

	function downloadMultipleFiles_PHP($name, $share, $directory, $workgroup, $username, $password){
		global $_SESSION;
		//report("Info","Name: $name, Share: $share, Dir: $dir, WG: $workgroup, TempDir: $temp_dir");
		$share = str_replace("\\\\", "", $share);
		$directory = str_replace("\\\\", "", $directory);
		session_start();
		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		session_write_close();
		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);
		$temp_dir = $crypt->WEB_decrypt($temp_dir);
		$json = new Services_JSON();
		$share = trim($share);			//You can't be too careful, so
		$directory = trim($directory);	//I'm making sure that they all
		$username = trim($username);	//have their trim
		$password = trim($password);
		$temp_dir = trim($temp_dir);

		$uid = uniqid(rand());

		$source = SYSTEMDIR.'/'.WORKINGDIR."/$uid";
		$returnValue = array();

		$cmd = '\n'.makeMount($source, $share, $workgroup, $username, $password);
		report('Download Mount',$cmd);

		report("Names",$name);
		$name = explode(';',$name);
		for($it = 0; $it < sizeof($name); $it++){
			$name[$it] = str_replace(" ", "\ ", $name[$it]);
			report($it, $name[$it]);
		}
		$whatWeGot = errorHandler($cmd);
		if($whatWeGot == false){
			$path = SYSTEMDIR.'/'.WORKINGDIR."/$uid";
			if($directory != '')
				$path .= $directory;

			$path = str_replace("\\'", "'", $path);
			if(is_readable($path."/".$name[1])){
				//then we have to zip up the files!  YAY!
				//Thx, Ryan
				$temp_dir = tempnam(SYSTEMDIR.'/',"zip_");
				@unlink($temp_dir);
				$temp_dir.='.zip';
				//done in getTempName() now :/

				$cmd = "zip -j  $temp_dir ";
				for($i = 0; $i <= sizeof($name); $i++){
					$cmd .= $path.'/'.$name[$i].' ';
				}
				report("Zip Command:", $cmd);
				$result = @exec($cmd);
				report("Zip Result:",$result);
				$returnValue['error']='no';
				$returnValue['path']=$temp_dir;
				report("before",$returnValue['path']);
				$returnValue['path'] = $crypt->WEB_encrypt($returnValue['path']);
				report("after",$returnValue['path']);
			} else {
				report("Path that was read that failed:", $path.'/');
				$returnValue['path'] = 'no';
				$returnValue['error'] = 'error';
				$returnValue['msg'] = 'You do not have permission to acces the requested files.';
			}
		} else {
			//clean up after yourself
			$returnValue['path'] = 'no';
			$returnValue['error'] = 'error';
			$returnValue['msg'] = 'An error occured while setting up your download.  Please contact your network administrator.';
		}
		$cmd .= '\n'.removeMount($source, $username, $password);
		$returnMe = $json->encode($returnValue);
		return $returnMe;
	}
	/*
	//Not needed - didn't accomplish what it could have.
	function getTempName_PHP(){
		$temp_dir = tempnam(SYSTEMDIR.'/',"zip_");
		@unlink($temp_dir);
		$temp_dir.='.zip';		
		$crypt = new EPI_CRYPT;
		$temp_dir = $crypt->WEB_encrypt($temp_dir);
		return $temp_dir;
	}
	*/
	function killZipFile_PHP($zipEnc){
		ignore_user_abort();
		report("zipEnc",$zipEnc);
		$crypt = new EPI_CRYPT;
		$zipPath = $crypt->WEB_decrypt($zipEnc);
		report("zipPath",$zipPath);
		$cmd = "rm $zipPath";
		$result = `$cmd`;
		report("Remove Zip",$cmd);
		report("Result",$result);
		return 0;
	}

	function triggerUpload_PHP($username, $password, $workgroup, $myLoc, $myDir){
		global $_SESSION;
		session_start();
		$myLoc = str_replace("\\\\", "", $myLoc);
		$crypt = new EPI_CRYPT;
		if(USESESSION == 'true'){
			$username = rawurldecode($_SESSION['username']);
			$password = rawurldecode($_SESSION['password']);
		} else {
			$username= rawurldecode($username);
			$password= rawurldecode($password);
		}
		session_write_close();
        //$username = rawurldecode($username);
        //$password = rawurldecode($password);
		$username = $crypt->WEB_decrypt($username);
		$password = $crypt->WEB_decrypt($password);		
		$uid = uniqid(rand());
		$source = SYSTEMDIR.'/'.WORKINGDIR."/$uid";
		$cmd .= '\n'.makeMount($source, $myLoc, $workgroup, $username, $password);	
		report('Results',$cmd);

		$path = $myLoc;
		if($myDir != '')
			$path .= $myDir;
		
		$test = @fopen($source.'/smb_test_save.txt', "a");
		@fclose($test);

		$json = new Services_JSON();
		if($test == false){
			$sendIt = array();
			$sendIt['error'] = 'error';
			$sendIt['msg'] = 'You do not have permission to upload a file to this directory.';
		} else {
			$cmd = 'rm '.$source.'/smb_test_save.txt';
			$result = `$cmd`;

			$sendIt = array();
			$sendIt['error'] = 'no';

			if(USESESSION == 'true'){
				$sendMe = "&l=$myLoc&d=$myDir&wg=$workgroup";
            } 
			else  {
				$sendMe = "&u=$username&p=$password&l=$myLoc&d=$myDir&wg=$workgroup";
            }
			$sendMe = $crypt->WEB_encrypt($sendMe);
			$sendIt['path'] = $sendMe;

		}
		$cmd .= '\n'.removeMount($source, $username, $password);
		/*
		$crypt = new EPI_CRYPT();
		$sendMe = "&u=$username&p=$password&l=$myLoc&d=$myDir";
		$sendMe = $crypt->WEB_encrypt($sendMe);
		*/
		$sendBack = $json->encode($sendIt);
		return $sendBack;
	}

?>