<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
	require_once('./json.php');
	//function errorHandler()
	//Given a string, usually what is returned from smbclient calls, it will use a RE to
	//see if an error has been thrown.  The format that an error is in will be the following:
	//		$returnMe = array();
	//		$returnMe['error'] = 'error';
	//		$returnMe['msg'] = $errorMessages[$errorNo];
	//		$sendMe = $json->encode($returnMe);
	// otherwise it will return false
	function errorHandler($result){
		//to check for errors, we should put an array of possible error REs here
		report('ErrorHandler','');
		$errorLines = array();
		$errorMessages = array();
		$errorLines[] = "(.*)NT_STATUS_LOGON_FAILURE(.*)\$";
		$errorMessages[] = "Could not authenticate user on the network you are accessing.";
		$errorLines[] = "(.*)NT_STATUS_CANNOT_DELETE(.*)\$";
		$errorMessages[] = "The folder you have selected can not be deleted by you.";
		$errorLines[] = "(.*)NT_STATUS_NETWORK_ACCESS_DENIED(.*)\$";
		$errorMessages[] = "You do not have access to this part of the network.";
		$errorLines[] = "(.*): NT_STATUS_ACCESS_DENIED(.*)\$";
		$errorMessages[] = "You do not have access to the directory you are trying to access.";
		$errorLines[] = "(.*)NT_STATUS_BAD_NETWORK_NAME(.*)\$";
		$errorMessages[] = "The name for the network being used is incorrect.";
		$errorLines[] = "(.*): Permission denied(.*)\$";
		$errorMessages[] = "You do not have access to the destination folder or file.";
		$errorLines[] = "(.*)ERRnosuchshare(.*)\$";
		$errorMessages[] = "The a share you are trying to access can not be recognized by the network right now.  It may have been removed from the network or can not be located due to the network configuration.";
		$errorLines[] = "(.*)<b>(.*)\$";
		$errorMessages[] = "There is a server-side error: Contact your network administrator.";
		$errorLines[] = "(.*)Anonymous login successful(.*)\$";
		$errorMessages[] = "You have not entered a valid login.  Please return to the login screen and try to authenticate again.  If this error persists contact your network administrator.";
		$errorLines[] = "(.*)Access denied(.*)\$";
		$errorMessages[] = "You do not have permission to access this file.";
		$errorLines[] = "(.*)timeout connecting to(.*)\$";
		$errorMessages[] = "A connection to the server cannot be established.  The server could be down or disconnected from the network.";
		$errorLines[] = "(.*)connectiond(.*)\$";
		$errorMessages[] = "You do not have authorization to access the destionation.";
		$errorLines[] = "(.*)not enough(.*)in service(.*)\$";
		$errorMessages[] = "An error occured while trying to access a part of the network: Wrong Syntax - Not Enough Characters.  Please contact your network administrator.";
		$errorLines[] = "(.*)Connection to (.*) failed\$";
		$errorMessages[] = "The connection has failed.  The connection is not available at this time.";
		$errorLines[] = "(.*)cannot mount on (.*): operation not permitted\$";
		$errorMessages[] = "The a server you are accessing is not properly set up to accept SSLBridge.";
		$errorLines[] = "(.*)NT_STATUS_OBJECT_NAME_NOT_FOUND\$";
		$errorMessages[] = "The location you are trying to access can not be reached by SSLBridge.";

		$json = new Services_JSON();
		$catchMe = explode("\n", $result);

		foreach($catchMe as $key => $item){
			foreach($errorLines as $errorNo => $errorType){
				if(preg_match('/'.$errorType.'/', $item)){
					$returnMe = array();
					$returnMe['error'] = 'error';
					$returnMe['msg'] = $errorMessages[$errorNo];
					$sendMe = $json->encode($returnMe);
			
					return $sendMe;
				}
			}
		}
		return false;
	}

	//The following are all used for the mounting and unmounting of shares for 
	//purposes of moving files
	//putenv() was used for convienience
	function makeBaseDirectory($username, $password){
		putenv("USER=$username%$password");
		if(!file_exists(SYSTEMDIR.'/'.WORKINGDIR)){
			$cmd = "mkdir ".SYSTEMDIR."/".WORKINGDIR;
			report('Mkdir',$cmd);	
			$result = `$cmd`;
		}
		if(!file_exists(SYSTEMDIR."/".WORKINGDIR."/$username")){
			$cmd = "mkdir ".SYSTEMDIR."/".WORKINGDIR."/$username";
			report('Mkdir',$cmd);
		}
		return `$cmd`;
	}

	//function removeBaseDirectory
	function removeBaseDirectory($username, $password){
		if(file_exists(SYSTEMDIR."/".WORKINGDIR."/$username")){
			$cmd = "rmdir ".SYSTEMDIR."/".WORKINGDIR."/$username";
			report('Rmdir',$cmd);
			$result = `$cmd`;
		}
		if(file_exists(SYSTEMDIR."/".WORKINGDIR)){
			$cmd = "rmdir ".SYSTEMDIR."/".WORKINGDIR;
			report('Rmdir',$cmd);
		}
		return `$cmd`;
	}

	//functionMakeDirectory
	function makeDirectory($name, $username, $password){
		putenv("USER=$username%$password");
		if(!file_exists(SYSTEMDIR.'/'.WORKINGDIR.'/'.$username.'/'.$name)){
			$cmd = 'mkdir '.SYSTEMDIR.'/'.WORKINGDIR.'/'.$username.'/'.$name;
			report('Mkdir',$cmd);
		}
		return `$cmd`;
	}

	//functionMakePath
	function makePath($path){
		if(!defined(SYSTEMDIR))
			define("SYSTEMDIR","/tmp");

		$pathNames = array();
		$pathNames = explode('/',$path);
		$currentPath = '';
		foreach($pathNames as $key=>$name){
			if($name != ''){
				$whatWeGot = $currentPath . $name;
				if($whatWeGot != SYSTEMDIR){
					$cmd = "mkdir $whatWeGot";
					$result = `$cmd`;
				}
				$currentPath = $whatWeGot;
			}
			$currentPath .= '/';
		}
		$currentPath = substr_replace($currentPath,"",-1);

		return $currentPath;
	}

	//function removePath
	function removePath($path){
		if(!defined(SYSTEMDIR))
			define("SYSTEMDIR","/tmp");

		$waitForIt = 20;
		while($path != SYSTEMDIR){
			$cmd = "rmdir $path";
			$result = `$cmd`;
			report('Path', $cmd);

			$lastSlash = strrpos($path, '/');
			$length = strlen($path)-1;
			$value=(-1)*($length-$lastSlash);
			$value--;

			$path=substr_replace($path,'',$value);
			--$waitForIt;
			if($waitForIt <= 0)
				break;
			//$path =  substr_replace($path,'',(((strlen($path)-1) - strrpos($path,'/'))*(-1))-1);
		}		
	}

	//Just makes the directory passed to it
	function makeNormDirectory($name, $username, $password){
		putenv("USER=$username%$password");
		if(!file_exists($name)){
			$cmd = 'mkdir '.$name;
			report('Mkdir',$cmd);
		}
		return `$cmd`;
	}

	//function makeMount
	function makeMount($whereTo, $whereFrom, $workgroup, $username, $password){
		$json = new Services_JSON();
		//putenv("USER=$username%$password");
		//$cmd = "smbmount '$whereFrom' '$whereTo' -o -S";
		$whereTo = str_replace("\\\\", "", $whereTo);
		$whereTo = str_replace (" ", "\ ", $whereTo);
		$whereFrom = str_replace("\\\\", "", $whereFrom);
		$whereFrom = str_replace(" ", "\ ", $whereFrom);
		$password = str_replace('\$','$',$password);

		$holder = explode('/',$whereFrom);
		$holder2 = getIP($holder[2]);
		if(!$holder2){
			$error = array();
			$error['error'] = 'error';
			$error['msg'] = 'Could not lookup IP address for server.';

			$whatWeGot = $json->encode($error);
			return $whatWeGot;
		}
		$ip = $holder2;

		makePath($whereTo);

		$cmd = "smbmount $whereFrom $whereTo -o username='$username/$workgroup',password='***',ip=$ip -S";
		report('Mount',$cmd);
		$cmd = "smbmount $whereFrom $whereTo -o username='$username/$workgroup',password='$password',ip=$ip -S";
		$theArray = array();
		$returnIt = '';
		$returnMe = exec($cmd, $theArray, $returnIt);
		$size = sizeof($theArray);
		return "$size - ".$theArray[0] . " - " . $returnIt;
	}

	//removeMount()
	//removes a mount that is passed to it from the $location var
	function removeMount($location, $username, $password){
		putenv("USER=$username%$password");
		$cmd = "smbumount '$location'";
		report('Unmount',$cmd);
		echo `$cmd`;

		removePath($location);

		return $cmd;
	}

	//function report()
	//a debug function (finally)
	//It takes 2 parameters.  It's output is like this:
	// param1:(param2)
	function report($title, $msg){
		if(DEBUG == 'true'){
			$fp = fopen(DEBUGPATH . DEBUGFILE,"a");
			fwrite ($fp,"$title:($msg)"."\n");
			fclose($fp);
		}
	}

	//function getIP()
	//Given a network name, it will use nmblookup to return an IP address
	function getIP($name){
		report('Nmblookup',"nmblookup $name -B");
		exec("nmblookup $name -B",$data);
		report('nmblookup',$data[1]);
		$catch = explode(' ', $data[1]);
		$ip = $catch[0];
		if($ip == 'name_query')
			return false;
		else
			return $ip;
	}
?>