<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>SSLBridge</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link href="./simple.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="./reg.css" title="EpiReg" />
<style type="text/css">
<!--
.wrap0, .wrap1, .wrap2, .wrap3 {
  display:inline-table;
  /* \*/display:block;/**/
  }
.wrap0 {
  float:left;
  background:url(images/shadow.gif) right bottom no-repeat;
  }
.wrap1 {
  background:url(images/shadow180.gif) no-repeat;
  }
.wrap2 {
  background:url(images/corner_bl.gif) -16px 100% no-repeat;
  }
.wrap3 {
  padding:4px 6px 6px 4px;
  background:url(images/corner_tr.gif) 100% -16px no-repeat;
  }
.box {
	padding: 10px;
	background: #FFFFF5;
	border: 1px solid;
	border-color:#ccc #999 #999 #ccc;
}
.texta {
 font-size: 14px;
 font-style: bold;
 color: #042696;
 background-color: #E7FFFF;
 border: 1px solid #666666;
}

h3 code {font-style:normal;}

.standardText{
	font-size:12pt;
	font-family: <?php echo FONT_FACE; ?>;
}

.errorText {
	color:#880000;
}

.noticeText{
	color:#555555;
}
-->
</style>

<style type="text/css">
	.leftBox{
		float:left;
		width:200px;
		text-align:center;
	}

	.rightBox{
		padding:5px;
		margin-left:201px;
		width:198px;
		border-style:solid;
		border-width:3px;
		border-color:#CCCCCC #999999 #999999 #CCCCCC;
		color:white;
	}
</style>
<script type="text/javascript">
	function backButton(loc){
		document.getElementById("form1").action = loc;
		document.getElementById("form1").submit();
	}
</script>
</head>
<body class="branded">
<?php
	if(isset($_POST['f'])){
		$f = $_POST['f'];
		if($f == 'install' || $f == 'yes')
			$install = "yes";
		else 
			$install = "no";
	} else {
		$install = "no";
	}

	@require_once('corecfg.php');
	@include_once('config.php');
	if(!defined("SYSTEMDIR"))
		define("SYSTEMDIR",'/tmp');
	if(!defined("WORKINGDIR"))
		define("WORKINGDIR", "sslbridge");

	function runTest($item){
		global $pwd;
		global $uname;
		$re = array();
		$re[1] = '(.*)command not found(.*)\$'; //not found
		$re[2] = '(.*)suid(.*)\$'; //no sid set
		$break = false;

		switch($item){ //WARNING: cases are not in order
			case 1:
				$type = "Is <i>config.php</i> created?";
				if(!@is_readable('./config.php')){
					$break = true;
					$error = 'You have not made your configuration file for SSLBridge.  Please return to the previous steps to create this critical system file.<br /><br />
					<form id="noconfig" name="noconfig" action="./setup1.php" method="post">
						<input type="hidden"  name="f" id="f" value="'.$install.'" />
						<input type="button" onClick="javascript:backButton(\'setup1.php\')" value="Create Configuation File" />
					</form>';
				} else {
					$error = "<i>config.php</i> has been created";
				}
				break;
			case 3:
				$type = 'Is <i>smbclient</i> installed?';
	            $cmd="smbclient -L  '" .  LOCALHOST . "' -N";

				$result = `$cmd`;

		         //If blank I cant even see the command.
		        if($result==""){
				 	 $break = true;
					 $error = 'SSLBridge could not find the <i>smbclient</i> command.';                     
                } else {
 				  if(preg_match('/'.$re[1].'/',$result)){
				 	 $break = true;
					 $error = 'SSLBridge could not find the <i>smbclient</i> command.';
				  } else {
					$error = 'SSLBridge is able to use the <i>smbclient</i> command.';
				  }
                }
				break;
			case 5:
				$type = 'Is <i>smbmnt</i> installed?';
			     
					$cmd = 'smbmnt ' . SYSTEMDIR . ' 2>&1';
				exec($cmd,$result);
//print $cmd;
				//$result = `$cmd`;
//print $result[0];

//print $re[2];
				if(stristr($result[0], 'found') == true){
					$break = true;
					$error = 'SSLBridge could not find the <i>smbmnt</i> command.  Ensure that the command is located at /usr/bin or in another location that is in the path of PHP.';

				} else if(stristr($result[0], 'suid') == true){
					$break=true;
					$error='The suid of <i>smbmnt</i> is not set.  Run the following command: <BR><B>chmod 4755 /bin/smbmnt</b>';
				} else {
					$error = 'SSLBridge is able to use the <i>smbmnt</i> command.';
				}
				break;
			case 6:
				$type = 'Is <i>smbumount</i> installed?';
				$cmd = 'smbumount /tmp 2>&1';

				exec($cmd, $result);
//print $cmd . "<BR><BR>";
//print $result[0] .  'xx';


				if(stristr($result[0], 'found') == true){
					$break = true;
					$error = 'SSLBridge could not find the <i>smbumount</i> command.  Ensure that the command is located off of /usr/bin or in another location that is in the path of PHP';
				} else if(stristr($result[0], 'suid') == true) {
					$break=true;
					$error='The suid of <i>smbumount</i> is not set.  Run the following command: chmod 4755 /bin/smbumount';
				} else {
					$error = 'SSLBridge is able to use the <i>smbumount</i> command.';
				}
				break;
			case 4:
				$type = 'Is <i>net</i> installed?';
				$cmd = 'net';
				$result = `$cmd` ;
                //print $result;
		        if($result==""){
				 	 $break = true;
					 $error = 'SSLBridge could not find the <i>net</i> command.';                     
                } else {
				  if(preg_match('/'.$re[1].'/',$result)){
				  	 $break = true;
					 $error = 'SSLBridge could not find the <i>net</i> command.';
				  } else {
					 $error = 'SSLBridge is able to use the <i>net</i> command.';
				 }
                }
				break;
			case 2:
				$type = 'Can SSLBridge write to it\'s working directory: '.SYSTEMDIR.'/'.WORKINGDIR;
			    $cmd = 'mkdir '.SYSTEMDIR.'/'.WORKINGDIR;
				$result = `$cmd`;
				$fp = @fopen(SYSTEMDIR.'/'.WORKINGDIR.'/testWrite.txt',"a");
				if(!$fp){
					$break = true;
					$error = 'Could not write a file to directory '.SYSTEMDIR.'/'.WORKINGDIR.'.';
				} else {
					$cmd = 'rm '.SYSTEMDIR.'/'.WORKINGDIR.'/testWrite.txt';
					$result = `$cmd`;
					@fclose($fp);
					$error = 'SSLBridge has access to '.SYSTEMDIR.'/'.WORKINGDIR.'.';
				}
				break;
			case 7:
				$type = 'Is <i>nmblookup</i> installed?';
				$cmd = 'nmblookup';
				$result = `$cmd`;
				if(preg_match('/'.$re[1].'/',$result)){
					$break = true;
					$error = 'SSLBridge could not find the <i>nmblookup</i> command.';
				} else {
					$error = 'SSLBridge is able to use the <i>nmblookup</i> command.';
				}
				break;
			case 8:
				$type = 'Is <i>zip</i> available?';
				$cmd = 'zip';
				$result = `$cmd`;
				if(preg_match('/'.$re[1].'/',$result)){
					$break = true;
					$error = 'SSLBridge could not find the <i>zip</i> command.';
				} else {
					$error = 'SSLBridge is able to use the <i>zip</i> command.';
				}
				break;
			default:
				break;
		}
		if(!$break){
			$bg = "green"; //make this gentler
			$text = "<b>VALID</b>";
		} else {
			$bg = "red"; //mkae this gentler
			$text = "<b>INVALID</b>";
		}
		$ourDiv = "<div class='leftBox'>$type</div><div class='rightBox' style='background-color:$bg;'>$text - $error</div>";
		echo $ourDiv;
		return !$break;
	}
	$error = false;
?>
<div id="masthead">Epiware SSLBridge</div> 
<div id="main">
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 		
						<h2>Check for System Compatability</h2>
						<p>SSLBride will now check several possible trouble areas that could cause SSLBridge to not function properly.  This could take a few minutes.</p>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(1))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(2))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(3))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(4))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(5))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(6))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(7))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 	
						<?php if(!runTest(8))
								$error = true; ?>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
<br />
	<div class="wrap0" style="width:500px;margin-left:auto;margin-right:auto;"> 
		<div class="wrap1"> 
			<div class="wrap2"> 
				<div class="wrap3"> 
					<div class="box"> 
						<p><?php
								if($error)
									echo 'Resolve all of the errors above in order to ensure that SSLBridge will function properly on your server.';
								else {
									echo 'SSLBridge has verified that it will work properly for your system.&nbsp;&nbsp;';
									echo '<BR><BR>';
                                    echo '<input type="button" id="backBtn" onClick="javascript:backButton(\'index.php\')" value=" Home " />';
								}
							?>
						</p>
						<p><form method="post" id="form1" name="form1" action="./setup4.php">
						   <input type="hidden" name="f" id="f" value="<?php echo $install; ?>" />
						   <?php
						      /*
								if($install=='yes' && @is_readable('./config.php')){
									echo '<input type="button" id="backBtn" onClick="javascript:backButton(\'setup1.php\')" value="<- Previous" />
										  <input type="submit" value="      Next ->       " />';
								}
								 */
						   ?>
						   </form>
						</p>
					</div> 
				</div> 
			</div> 
		</div> 
	</div>
</div>
</body>
</html>