<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
	if(!@is_readable('./config.php')){
		header("location:./missingFile.php?f=config.php");
		exit;
	} else if(!@is_readable('./corecfg.php')){
		header("location:./missingFile.php?f=smb_login_functions.php");
		exit;
	}else if(!@is_readable('./smbCommon.php')){
		header("location:./missingFile.php?f=smbCommon.php");
		exit;
	} else if(!@is_readable('./webcrypt.php')){
		header("location:./missingFile.php?f=webcrypt.php");
		exit;
	} else {
		require_once('./config.php');
		require_once('./corecfg.php');
		require_once('./smbCommon.php');
		require_once('./webcrypt.php');
	}
	session_write_close();

	function removeMount_dl(){
		global $mount;
		global $directory;
		global $fp;

		//close the stream, if it's still going
		@fclose($fp);

		$cmd = "smbumount $mount";
		if(DEBUG == 'true'){
			$fp = fopen(DEBUGPATH . DEBUGFILE,"a");
			fwrite ($fp,"Download umount:($cmd)"."\n");
			fclose($fp);
		}
		$return = `$cmd`;
		if(DEBUG == 'true'){
			$fp = fopen(DEBUGPATH . DEBUGFILE,"a");
			fwrite ($fp,"Dld Result:($return)"."\n");
			fclose($fp);
		}

		removePath($mount);
	}
	
	register_shutdown_function('removeMount_dl');

	//ignore_user_abort(); //critical - if user hits "cancel" on the download, this allows
						 //the page to finish - mainly to unmount the share made
	if(!isset($_GET)){ 
		exit;
	}

	$crypt = new EPI_CRYPT;
	$path = $_GET['path'];
	$path = $crypt->WEB_decrypt($path);
	
	$path = str_replace("\\\\", "", $path);
	$path = str_replace("\\'", "'", $path);

	$patha = explode('/',$path);
	$number = sizeof($patha);

	$directory = $patha[$number-2];

	$fileName = $patha[$number-1];
	$filea = explode('.',$fileName);
	$fileNo = sizeof($filea);
	$fileType = $filea[$fileNo-1];
	$share = '';
	$mount = '/'.$patha[1].'/'.$patha[2].'/'.$patha[3];
	for($it = 1; $it < $number-1; $it++)
		$share .= '/'.$patha[$it];

	//$ftest = @is_readable($share.'/'.$fileName);
	$ftest = @is_readable($path);

	report("Info","Path: $path - Number: $number - Dir: $directory - FileName: $fileName - Share: $share - Mount: $mount - FTest: $ftest");

	if($ftest != false){
		//clean up after ourselves
		//$removeFile = "rm $share/smbb_text_3.txt";
		//$result = `$removeFile`;

		$fileSize = fileSize($path);
		//create the header
		header('Pragma: private');							//these two needed when site forces
		header('Cache-control: private, must-revalidate');	//ssl
		header("Content-Type: $fileType");
		header("Content-Disposition: attachment; filename=\"$fileName\"");
		header("Content-Length: ".$fileSize);
		header("Content-Transfer-Encoding: binary");

		//send it
		
		$fp = fopen($path, "r");
		while (! feof($fp)) {
			print fread($fp,32728);
			flush();
		}
		
		//fread($fp,filesize($path));
		fclose($fp);
	} else {
		//there is an issue with the download - they don't have permission.
		//If this get's triggered, it's too late.  
		//It should have been caught earlier.
		echo '
			<html>
			<head><title>SSLBridge</title></head>
			<script type="text/javascript">
				alert("You do not have permission to access this file.  It may have been moved or you could not have access to it.");
			</script>
			<body>
			<p>You do not have permission to access this file.  Please hit the back button in your browser window.</p>
			</body>
			</html>
		';
	}
	exit;
?>