<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
	if(!defined("VERSION"))
		define("VERSION","1.3");				//versioning information
	if(!defined("BUILD"))
		define("BULID","41");

	require_once('./Sajax.php');
	require_once('./webcrypt.php');
	require_once('./smbCommon.php');

	function authenticateSamba($uname, $pwd){
		$invalidLogin = "(.*)NT_STATUS_LOGON_FAILURE\$";
		//$invalidLogin2 = "(.*)NT\$";
		$invalidLogin2 = "(.*)NT_STATUS_PASSWORD_EXPIRED\$";
		$invalidLogin3 = "(.*)NT_STATUS_ACCOUNT_LOCKED_OUT\$";
		$cmd = "smbclient -L  '".LOCALHOST."' -U '$uname%***' -N";
		if(DEBUG == 'true'){
			$fp = fopen(DEBUGPATH . DEBUGFILE,"a");
			fwrite ($fp,"Command:($cmd)");
			fclose($fp);
		}
		$cmd = "smbclient -L  '".LOCALHOST."' -U '$uname%$pwd' -N";
		$result = `$cmd`;
		if(DEBUG == 'true'){
			$fp = fopen(DEBUGPATH . DEBUGFILE,"a");
			fwrite ($fp,"Result:($result)");
			fclose($fp);
		}

		//if this RE is matched, then the login must be invalid
		if(preg_match('/'.$invalidLogin.'/', $result)){
			return ("bad0");
		} else if(preg_match('/'.$invalidLogin2.'/', $result)){
			return ("bad1");
		} else if(preg_match('/'.$invalidLogin3.'/', $result)){
			return ("bad2");
		} else {
			//we should encrypt the username and password and pass it along
			//so that we can put it into the SambaManager class on the
			//next page
			return "ok";
		}
	}

	function user_login($uname, $pwd){
		global $_SESSION;
		$checkMe = trim($pwd);
		if($checkMe == '')
			return 0;
		$pwd = trim(stripslashes(urldecode($pwd)));
		$uname = trim($uname);

		$evalMe = authenticateSamba($uname, $pwd);
		if($evalMe == "ok"){
			$pwd = str_replace('$','\$',$pwd);
			$crypt = new EPI_CRYPT();
			$uname = $crypt->WEB_encrypt($uname);
			$pwd = $crypt->WEB_encrypt($pwd);
			if(USESESSION == 'true'){
				$_SESSION['username'] = $uname;
				$_SESSION['password'] = $pwd;
				return "session";
			} else {
				$sendMe = "&username=$uname&password=$pwd";
				$sendMe = $crypt->WEB_encrypt($sendMe);
				return $sendMe;
			}
		}
		//if this returns, then the user was not authenticated (for any reason)
		return $evalMe;
	}	
	$sajax_request_type = "POST";
	sajax_init();
	sajax_export("user_login");
	sajax_handle_client_request();

	function display_login($width, $height, $ex, $why, $style = 0, $color="red"){
		if(!strpos($why,'%')){
			$why += 0;
			$why = $why . 'px';
		}

		if(!strpos($ex,'%')){
			$ex += 0;
			$ex = $ex . 'px';
		}

		if(PORTAL == 'true'){
			global $_COOKIE;
			if($_COOKIE['enc_user_id']){
				$crypt = new EPI_CRYPT();
				$enc_user_id = rawurldecode(trim($_COOKIE['enc_user_id']));
				$dec_user_id = $crypt->WEB_decrypt($enc_user_id);
			} else {
				$dec_user_id = -1;
			}

			if($dec_user_id < 1){ //display You Can't Login message
				echo '
						<div class="wrap0" style="width:'.$width.'px;"> 
							<div class="wrap1"> 
								<div class="wrap2"> 
									<div class="wrap3"> 
										<div class="box" style="height:'.($height - 32).';"> 
											<h2>Login</h2> 
											<br />
											You must log in through EpiWare to access SSLBridge.
										</div> 
									</div> 
								</div> 
							</div> 
						</div>
				';
				exit;
			}
		}

		if(DEMOMODE == 'true'){
				if(strlen($color) < 1)
					$color = "red";
						//	<a href="http://www.sslbridge.com/">Goto www.SSLBridge.com to learn more.</a><br />
						echo '
<BR><BR>
							<div id="demoWrapper" style="border-bottom:1px dashed #bbbbbb;positiion:absolute;top:'.$why.';left:'.$ex.';width:100%;">


					<table align=center width=600 border=0 style="padding:0px" cellspacing=0 cellpadding=0>
						<tr><td width=354><img width=354 height=201 src="./front_images/arch_yellow_txt.gif" /></td>

						       <td width=164 style=" font-size: 90%; color: #64635f; margin: 0; font-family:  Verdana, Helvetica, sans-serif;" >

				

                               <b>Instant Familiarity</b><BR><BR>
							    Easy to use and responsive 
								interface.  
								<BR><BR>   
							   Always have access to your resources, without specialized client software.

								   
							        </td>
						       <td valign=top>

					<form id="form1" enctype="application/x-www-form-urlencoded" action="" method="post" onSubmit="return LoginUser()">
						<div  style="width:230px;border:solid 2px '.$color.'"> 

							<div class="box" style="height:100%;font-size:small;"> 


			<div id="shakeMe" style="position:relative;left:0px;text-align:center; ">
			<table width="100%" border="0" style="font-size:8pt;">
				<tr>
				<td colspan="2">Login &nbsp;&nbsp;&nbsp; version</td>
				</tr>
				<tr>
				<td colspan="2"><input name="username" id="username" type="text" size="20" maxlength="70" class="texta" value="'.$glogin.'"></td>
				</tr>
				<tr>
				<td colspan="2">Password</td>
				</tr>
				<tr>
				<td colspan="2"><input name="password" id="password" type="password" size="20" maxlength="50" class="texta"></td>
				</tr>

				<tr>
				<td valign="top"><input id=loginButton type="submit" name="loginButton" value="Login"></td>
				<td>&nbsp;
				</td>
				</tr>
			</table>
			</div>
			<div id="warning" name="warning" style="text-align:center;color:red;height:40px;">
			   <div  id="waiting" style="background:url(images/loading.gif) top left no-repeat;height:20px;width:160px;border:0px solid green;display:none;margin-left:auto;margin-right:auto;" ></div>
			   <div id="warning1" style="color:red;text-align:center;display:none;font-size:x-small;">Enter your username.</div>
			   <div id="warning2" style="color:red;text-align:center;display:none;font-size:x-small;">Enter your password.</div>
			   <div id="warning3" style="color:red;text-align:center;display:none;font-size:x-small;">Username or Password is incorrect.</div>
			   <div id="warning4" style="color:red;text-align:center;display:none;font-size:x-small;">Password Expired.</div>
			   <div id="warning5" style="color:red;text-align:center;display:none;font-size:x-small;">Account Locked.</div>
			</div>	

							</div> 
						</div>
					</form>
					</td></tr>
					<tr><td width=354 style=" font-size: 90%; color: #64635f; margin: 0px; font-family:  Verdana, Helvetica, sans-serif;">
							
					   <B>SECURE</B><Br><BR>
						Uses SSL 128-Bit encryption for <BR>secure data transmission
                        from server 
						   to web browser.   
						<BR><BR>	
 Helps users safely access their digital assets,
while eliminating the need to learn how to use new software.						  
							 
								
							
							
							
							
							
							</td>
					    <td width=164 ><img width=164 height=201 src="./front_images/secure_yellow_txt.gif" /></td>
						<td valign=top style=" font-size: 90%; color: #333333; margin: 0; font-family:  Verdana, Helvetica, sans-serif;">
								
							<BR>
							<b>&nbsp;Learn More</b><BR><BR>


								&nbsp;&nbsp;<a href="http://www.sslbridge.com/Home/ajax_samba_browser.php">SSLBridge Home</a>	 

									<BR><BR>

                                &nbsp;&nbsp;
								<a href="https://www.sslbridge.com/SSLBridge_White_Paper.pdf"><img width="34" vspace="0" hspace="0" height="20" border="0" align="texttop" src="https://www.sslbridge.com/uploaded_images/pdf_vpn_software.gif" /></a>

								<a href="https://www.sslbridge.com/SSLBridge_White_Paper.pdf">SSLBRIDGE&nbsp;Whitepaper</a>



							</td></tr></table>
										
						</div>';
		} else if($style == 0 || $style == "verbose" || $style == "large") {
				echo '
			<form id="form1" enctype="application/x-www-form-urlencoded" action="" method="post" onSubmit="return LoginUser()">
			<div class="wrap0" style="width:'.$width.'px;position:absolute;left:'.$ex.';top:'.$why.';"> 
				<div class="wrap1"> 
					<div class="wrap2"> 
						<div class="wrap3"> 
							<div class="box" style="height:'.($height - 32).';"> 

								<h2>Login</h2> 
                   ';
                
                

           echo '								
			<BR>
			<div id="shakeMe" style="position:relative;left:0px;">
			<div id="warning" name="warning" style="text-align:center;color:red;height:20px;">
			   <div  id="waiting" style="background:url(images/loading.gif) top left no-repeat;height:20px;width:160px;border:0px solid green;display:none;margin-left:auto;margin-right:auto;" ></div>
			   <div id="warning1" style="color:red;text-align:center;display:none;">Please enter your username to log in.</div>
			   <div id="warning2" style="color:red;text-align:center;display:none;">Please enter your password to log in.</div>
			   <div id="warning3" style="color:red;text-align:center;display:none;">Your username or password is incorrect.</div>
			   <div id="warning4" style="color:red;text-align:center;display:none;">Your password has expired.</div>
			   <div id="warning5" style="color:red;text-align:center;display:none;">Your account has been locked.</div>
			</div>
			<table border=0 width=300>
			<tr>
			<td align=right>Login:</td><td><input class="texta" type="text" name="username" id="username" size="25" maxlength="70" value="'.$glogin.'"></td></tr>

			<tr>
			<td align=right>Password:</td><td><input class=texta type=password name=password id=password size="25" maxlength=50></td></tr>

			<tr>
			<td><p>&nbsp;</p></td><td align=left><input id=loginButton type=submit value="  Login  ">
          ';

           echo '
			&nbsp;&nbsp;&nbsp;<a href="forgot_password.php" class="back"></a>
			</td></tr>

			</table>
			</div>	
							</div> 
						</div> 
					</div> 
				</div> 
			</div>
			</form>
				';
		} else if($style == 1 || $style == "compact" || $style == "small") {
				echo '
			<form id="form1" enctype="application/x-www-form-urlencoded" action="" method="post" onSubmit="return LoginUser()">
			<div class="wrap0" style="width:'.$width.'px;position:absolute;left:'.$ex.';top:'.$why.';"> 
				<div class="wrap1"> 
					<div class="wrap2"> 
						<div class="wrap3"> 
							<div class="box" style="height:100%;font-size:small;"> 


			<div id="shakeMe" style="position:relative;left:0px;text-align:center;">
			<table width="100%" border="0" style="font-size:8pt;">
				<tr>
				<td colspan="2">Login</td>
				</tr>
				<tr>
				<td colspan="2"><input name="username" id="username" type="text" size="20" maxlength="70" class="texta" value="'.$glogin.'"></td>
				</tr>
				<tr>
				<td colspan="2">Password</td>
				</tr>
				<tr>
				<td colspan="2"><input name="password" id="password" type="password" size="20" maxlength="50" class="texta"></td>
				</tr>

				<tr>
				<td valign="top"><input id=loginButton type="submit" name="loginButton" value="Login"></td>
				<td>&nbsp;<br>
				</td>
				</tr>
			</table>
			</div>
			<div id="warning" name="warning" style="text-align:center;color:red;height:20px;">
			   <div  id="waiting" style="background:url(images/loading.gif) top left no-repeat;height:20px;width:160px;border:0px solid green;display:none;margin-left:auto;margin-right:auto;" ></div>
			   <div id="warning1" style="color:red;text-align:center;display:none;font-size:x-small;">Enter your username.</div>
			   <div id="warning2" style="color:red;text-align:center;display:none;font-size:x-small;">Enter your password.</div>
			   <div id="warning3" style="color:red;text-align:center;display:none;font-size:x-small;">Username or Password is incorrect.</div>
			   <div id="warning4" style="color:red;text-align:center;display:none;font-size:x-small;">Password Expired.</div>
			   <div id="warning5" style="color:red;text-align:center;display:none;font-size:x-small;">Account Locked.</div>
			</div>

							</div> 
						</div> 
					</div> 
				</div> 
			</div>
			</form>
				';
		}
	}
?>