<?php
/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
	if(!defined("VERSION"))
		define("VERSION","1.3");				//versioning information
	if(!defined("BUILD"))
		define("BUILD","41");

	//Verify that we have all of the fiels we need
	if(!@is_readable('./config.php')){
		header("location:./missingFile.php?f=config.php");
		exit;
	} else if(!@is_readable('./webcrypt.php')){
		header("location:./missingFile.php?f=webcrypt.php");
		exit;
	} else if(!@is_readable('./Sajax.php')){
		header("location:./missingFile.php?f=Sajax.php");
		exit;
	} else if(!@is_readable('./json.php')){
		header("location:./missingFile.php?f=json.php");
		exit;
	}else if(!@is_readable('./icon.php')){
		header("location:./missingFile.php?f=icon.php");
		exit;
	} else if(!@is_readable('./smbCommon.php')){
		header("location:./missingFile.php?f=smbCommon.php");
		exit;
	} else if(!@is_readable('./corecfg.php')){
		header("location:./missingFile.php?f=corecfg.php");
		exit;
	}else if(!@is_readable('./smbb.php')){
		header("location:./missingFile.php?f=smbb.php");
		exit;
	}else{ //we have them all - include them
		global $_SESSION;
		require_once('./corecfg.php');
		require_once('./webcrypt.php');
		require_once('./Sajax.php'); //This implimentation of Sajax has been modified slightly -PMW1302 NO LONGER NEEDED
		require_once('./json.php');
		require_once('./icon.php');
		require_once('./config.php');
		require_once('./smbb.php');
		require_once('./smbCommon.php');
	}

	//wgnoshow.php is a file that can store workgroup names that you don't want other accessing
	//Usefull for when other employees connect a private laptop to the network and think they
	//know what they're doing
	//Yes, it could have been a .txt file, if I wanted ppl on the internet to be able to read the
	//contents of it easily
	if(@is_readable('./wgnoshow.php')){
		require_once('./wgnoshow.php');
	}

	//Sajax functions
	//These are all stubs so that this file can be encrypted
	//If this file isn't encrypted, then this is just a waste of clock cycles
	//functions found in smbCommon.php
	function handleRequest($useCred, $usr, $pwd, $location, $myVar, $workgroup='', $directory='', $opt){
		return handleRequest_PHP($useCred, $usr, $pwd, $location, $myVar, $workgroup, $directory, $opt);
	}

	function handleFileMove($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){
		return handleFileMove_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup);
	}

	function downloadFile($name, $share, $directory, $workgroup, $username, $password){
		return downloadFile_PHP($name, $share, $directory, $workgroup, $username, $password);
	}

	function downloadMultipleFiles($name, $share, $directory, $workgroup, $username, $password){
		return downloadMultipleFiles_PHP($name, $share, $directory, $workgroup, $username, $password);
	}

	function makeMountsForMultipleMove($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){
		return makeMountsForMultipleMove_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup);
	}

	function handleFileMoveMultiple($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup){	
		return handleFileMoveMultiple_PHP($status, $name, $username, $password, $dShare, $dDir, $sShare, $sDir, $workgroup);
	}

	function removeMountsForMultipleMove($username, $password, $source, $destination){
		return removeMountsForMultipleMove_PHP($username, $password, $source, $destination);
	}

	function getTempName(){
		return getTempName_PHP();
	}

	function killZipFile($zipEnc){
		return killZipFile_PHP($zipEnc);
	}

	function triggerUpload($username, $password, $workgroup, $myLoc, $myDir){
		return triggerUpload_PHP($username, $password, $workgroup, $myLoc, $myDir);
	}

	//Set up Sajax
	$sajax_request_type = "POST";
	sajax_init();
	sajax_export("handleRequest");
	sajax_export("handleFileMove");
	sajax_export("downloadFile");
	sajax_export("downloadMultipleFiles");
	sajax_export("getTempName");
	sajax_export("killZipFile");
	sajax_export("triggerUpload");
	sajax_export("makeMountsForMultipleMove");
	sajax_export("handleFileMoveMultiple");
	sajax_export("removeMountsForMultipleMove");
	sajax_handle_client_request();

	//functions
	//function returnList()
	//This command is called to return the results of a Samba command
	function returnList($uname, $pwd, $location, $myVar, $workgroup = '', $directory = '', $ip = ''){

		//Make sure that we have no extra spaces on our data

		$uname = trim($uname);
		$pwd = trim($pwd);
		$location = trim($location);
		$myVar = trim($myVar);
		$workgroup = trim($workgroup);
		$directory = trim($directory);

		//If we want to detect if the login is valid or not, we can not use
		//enviromental variables - ???  wonder why
		//environmental variables are the suck - they don't do much for you: PMW1302
		//putenv("USER=$uname%$pwd");
		//found a use for them - figures...
		//NOPE, false alarm
		if($myVar ==1){ //looking for workgroups, servers, shares
			if($location == LOCALHOST){
	            $cmd="smbclient -L  '" .  $location . "' -U \"".$uname."%***\" -N";
				report("Command",$cmd);
	            $cmd="smbclient -L  '" .  $location . "' -U \"".$uname."%".$pwd."\" -N";
			}else{
	            $cmd="smbclient -L  \"" .  $location . "\" -I '$ip' -U \"".$uname."%***\" -W '".$workgroup."' -N";
				report("Command",$cmd);
	            $cmd="smbclient -L  \"" .  $location . "\" -I '$ip' -U \"".$uname."%".$pwd."\" -W '".$workgroup."' -N";
			}
		} else if($myVar == 2){
			$location = str_replace(" ", "\ ", $location);
			$directory = str_replace(" ", "\ ", $directory);
			$pwd = str_replace('\$','$',$pwd);

			if($directory == ''){
				$cmd = "smbclient ".$location." -c 'dir' -I '$ip' -U '".$uname."%***' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N | sort";
				report("Command",$cmd); //$cmd is made twice, because the first time we spit out the command to a
										//debug file w/o the person's password - the reall command is the second one.
				$cmd = "smbclient ".$location." -c 'dir' -I '$ip' -U '".$uname."%".$pwd."' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N | sort";
			} else {
				//$directory = str_replace(" ", "\ ", $directory);
				$cmd = "smbclient ".$location." -c 'dir' -D ".$directory." -I '$ip' -U '".$uname."%***' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N | sort";
				report("Command",$cmd);
				$cmd = "smbclient ".$location." -c 'dir' -D ".$directory." -I '$ip' -U '".$uname."%".$pwd."' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N | sort";
			}//end if($directory == '')
		} else if($myVar == 3){
			$cmd = 'net share -W "'.$workgroup.'" -S "'.$location.'" -I "'.$ip.'" -U "'.$uname.'%***"';
			report("Command",$cmd);
			$cmd = 'net share -W "'.$workgroup.'" -S "'.$location.'" -I "'.$ip.'" -U "'.$uname.'%'.$pwd.'"';
		} else //we recieved a value of myVar that isn't supported.
			return false;
	
		return `$cmd`;
	}//end returnList

	//function format_doc_size()
	//Returns the size of the file measured in kilobytes instead of bytes
	function format_doc_size($doc_size){
				 $doc_size = "". $doc_size;
				 $string_len =  strlen($doc_size);    
				 if($string_len > 3) {
					 //Going to chop and add the k
					 $doc_size = substr($doc_size,0,($string_len-3));
					 $doc_size = $doc_size . " k ";
				 }else {
					  if($string_len == 3) {
						$doc_size = substr($doc_size,0,1);    
						$doc_size = "~." . $doc_size . "k";
					  } else {
						$doc_size = "~.1k";
					 }
				 }
				 return $doc_size;
	} //end function format_doc_siz

	//function transferFile
	//copies or moves a file from one directory to another, depending upon the circumstance
	function transferFile($status, $username, $password, $fileName, $source, $destination, $location, $workgroup, $directory){
		if(is_writable($source.'/'.$fileName) && $status == 'normal'){
			/*
			$cmd = "smbclient '".$location."' -c 'mv $source/$fileName $destination/$fileName' -D '".$directory."' -U '".$username."%".$password."' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N";*/
			$cmd = "mv $source/$fileName $destination/$fileName";
			$remove = "yes";
		}else{
			/*
			$cmd = "smbclient '".$location."' -c 'cp $source/$fileName $destination/$fileName' -D '".$directory."' -U '".$username."%".$password."' -W '".$workgroup."' -O 'TCP_NODELAY IPTOS_LOWDELAY SO_KEEPALIVE SO_RCVBUF=8192 SO_SNDBUF=8192' -b 1200 -N";*/
			$cmd = "cp $source/$fileName $destination/$fileName";
			$remove = "no";
		}
		report('Transfer',$cmd);
		$returnMe = `$cmd`;
		report('Result',$returnMe);
		return $returnMe;
	}//end transferFile
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><title>SSLBridge</title>
<link rel="stylesheet" type="text/css" href="./smbb.css" title="SambaBrowser" />
<script type="text/javascript" >
</script>

<script type="text/javascript" src="./event.js"></script>
<script type="text/javascript" src="./scoot.js"></script>
<script type="text/javascript" src="./fade.js"></script>
<script type="text/javascript" src="./overlay.js"></script>
<script type="text/javascript" src="./drag.js"></script>

<script type="text/javascript" src="./notice.js"></script>

<script type='text/javascript'>
	<?
	sajax_show_javascript();
	?>
</script>

<script type="text/javascript" src="smbb.js"></script>
<link rel="stylesheet" type="text/css" href="./notice.css" title="notice" />
</head>
<body unselectable="on" onselectstart='return false;' ondrag='return false;'>
	<div class="wrapper">
		<div id = 'topBar' class="topBar" style=";border-bottom:1px solid #333399;">
<?php
    $msie='/msie\s(5\.[5-9]|[6]\.[0-9]*).*(win)/i';
    if( !isset($_SERVER['HTTP_USER_AGENT']) || !preg_match($msie,$_SERVER['HTTP_USER_AGENT']) || preg_match('/opera/i',$_SERVER['HTTP_USER_AGENT'])) {
        $ie_explorer=0;
	}  else {
        $ie_explorer=1;
    }
?>

			<div class="topLeft" style="font-size:14pt;border:0px solid green; color:#14249e;z-index:3;position:absolute;top:4px;left:20px;"><span style="color:white;font-style:normal;"><a href="http://www.sslbridge.com" style="text-decoration:none;color:white">SSLBridge</a></span></div>
			<div class="topRight">
<?php
	
	//--------------------------
    //  Check to see what browser is accessing PNG transparency stuff..
	//--------------------------
$href_pop = "<a href=\"#\" onclick=\"window_make_new(-1, -1, 400, 300, './smb_help.html','SSLBridge - Help');return false;\">";

if($ie_explorer){
	print $href_pop;
	echo "
<img border=0 src=\"images/spacer.png\" style=\"width: 22px; height: 22px; filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='images/info.png', sizingMethod=scale);\" alt=\"Help\" title=\"Help\" style=\"z-index:3;position:absolute;top:2px;right:37px;\" /></a>

<a href=\"./smb_logoff.php\">
<img border=0 src=\"images/spacer.png\" style=\"width: 22px; height: 22px; filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='images/button_cancel.png', sizingMethod=scale);\" alt=\"Exit SSLBridge\" title=\"Exit SSLBridge\" style=\"z-index:3;position:absolute;top:2px;right:10px;\" /></a>
	";
} else {
   //Just standard buttons.. no need for transparency crap.

echo "$href_pop<img  alt=\"Help\" title=\"Help\" border=0 src='images/info.png' style=\"width: 22px; height: 22px;float: left; margin-right: 37px;margin-top:2px;\" ></a>";
echo "<a href=\"./smb_logoff.php\"><img title=\"Exit SSLBridge\" alt=\"Exit SSLBridge\"  border=0 src='images/button_cancel.png' style=\"width: 22px; height: 22px;z-index:3;position:absolute;top:2px;right:10px;\" ></a>";
}


?>
		     </a>
			</div>
			<div class = "warningBlock">
				<div class="waitingDiv" id="messageDiv"><span  id="messageText" style="font-size:10pt;">Message</span></div>
				<div class="waitingDiv" id="waitingDiv"><span  id="waitingText">Working:</span><img align=middle src="./images/loading.gif" /></div>
				<iframe id="hiddenFrame" class="hiddenFrame" src="empty.html"></iframe>
			</div>
			<img src="./images/nbg3.jpg" class="topImage" />
		</div>
        <div style="clear: both"></div>
		<div id="loadingDiv" name="loadingDiv" class="loadingDiv">Loading...</div>
		<div id='theDragger' class = 'dragger' unselectable='on'>
			<div id = 'dragWrap' class="dragWrap">  
			</div>
		</div>
		<div id="moveBar" class = 'moveBar' unselectable='on'>
		</div>
		<div id="rightClkMenu" class = "rightClkMenu" unselectable='on'>
			<a id="upload" class="rightClk" unselectable='on' href="javascript:activateLink();">Upload</a>
		</div>
		<div id="rightClkMenu2" class = "rightClkMenu" unselectable='on'>
			<a id="download" class="rightClk" unselectable='on' href="javascript:activateLink();"></a>
		</div>
		<div class="browserWindow"><div id="left" name = "left" class = "leftMenu"></div><div id="mover" name="mover" class="mover" unselectable='on'></div><div id="right" name="right" class="rightMenu"></div></div>
		<div id = "statusBar" class="statusBar">
			<div style="float:right;font-size:.75em;padding:2px 5px 0px 0px;">
			Version <?= VERSION ?>b<?= BUILD ?> -  2006 <a href="http://www.epiware.com">Epiware</a>, All Rights Reserved
			</div>		
		</div>
	</div>
</body>
</html>