/******************************************************************************
SSLBRIDGE:Remotely access Network Neighborhood using just a browser.
http://www.epiware.com
Copyright (C) 2006 Patrick Waddingham

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

Epiware, Inc., hereby disclaims all copyright
interest in the program `SSLBridge' written
by Patrick Waddingham.

21 August 2006
James Kern, President of Epiware
*****************************************************************************/
var notice_messages = new Array();
var notice_titles = new Array();
var notice_window = null;
var notice_window_message = null;
var notice_window_title = null;
var notice_window_close = null;
var notice_window_bottom = null;
var notice_window_title_text = null;

var notice_intervals = new Array();

var notice_intervals_timestart = new Array();
var notice_intervals_timestop = new Array();

var notice_interval_fadein = null;
var notice_interval_fadeout = null;

var notice_relative_ex_value = 0;
var notice_relative_why_value = 0;

function notice_last(){
	return (notice_messages.length -1);
}

function loadMessage(msg, title){
	var whereTo = notice_messages.length;
	notice_messages[whereTo] = msg;

	if(title.length > 0)
		notice_titles[whereTo] = title;
	else
		notice_titles[whereTo] = '';
}

function changeMessage(msgID){
	if(notice_window == null)
		makeNotice();

	if(window.attachEvent){
		notice_window_message.innerText = notice_messages[msgID];
		notice_window_title_text.innerText = notice_titles[msgID];
	} else {
		while(notice_window_message.firstChild != null)
			notice_window_message.removeChild(notice_window_message.firstChild);
		notice_window_message.appendChild(document.createTextNode(notice_messages[msgID]));
		while(notice_window_title_text.firstChild != null)
			notice_window_title_text.removeChild(notice_window_title_text.firstChild);
		notice_window_title_text.appendChild(document.createTextNode(notice_titles[msgID])); 
	}	

}

function showMessage(killtime){
	if(notice_window == null)
		makeNotice();

	if(notice_intervals[0] != null){
		clearInterval(notice_intervals[0]);
		notice_intervals[0] = null;
	}

	if(notice_window.style.display == 'none' || notice_window.style.display == ''){
		notice_window.style.display = 'block';
		fade(notice_window,8,0,100);
	}

	if(killtime > 0)
		notice_intervals[0] = setInterval("hideMessage()",killtime);
}

function hideMessage(){
	if(notice_intervals[0] != null){
		clearInterval(notice_intervals[0]);
		notice_intervals[0] = null;
	}	

	//notice_interval_fadeout = setInterval("notice_fadeOut()", 5);
	fade(notice_window,8,100,0);
	notice_intervals[0] = setInterval("removeNotice()",800);

}

function removeNotice(){
	notice_window.style.display = 'none';
	clearInterval(notice_intervals[0]);
}

function timeMessage(start, dur, msgID){
	if (dur == 0 || dur == '')
		dur = 0;
	setTimeout("readyMsg("+msgID+", "+dur+")", start);
}

function readyMsg(msgID, kill){
	if(kill == 0 || kill == '')
		kill = 0;
	changeMessage(msgID);
	showMessage(kill);
}

function makeNotice(){
	if(notice_window != null)
		return;

	var newNotice = document.createElement('div');
	newNotice.id = 'notice_window';
	newNotice.className = 'notice_window';
	newNotice.style.top = '0px';
	newNotice.style.left = '0px';
	notice_window = newNotice;
	
	var newClose = document.createElement('span');
	newClose.id = 'notice_window_close';
	newClose.className = 'notice_window_close';
	var img = document.createElement('img');
	img.src = './images/noticeclose.jpg';
	img.style.height = '10px';
	img.style.width = '10px';
	newClose.appendChild(img);
	notice_window_close = newClose;

	var newMessage =  document.createElement('div');
	newMessage.id = 'notice_window_message'
	newMessage.className = 'notice_window_message';
	notice_window_message = newMessage;

	var newTitle = document.createElement('div');
	newTitle.id = 'notice_window_title';
	newTitle.className = 'notice_window_title';
	notice_window_title = newTitle;

	var newTitleText = document.createElement('span');
	notice_window_title_text = newTitleText;
	notice_window_title_text.style.marginLeft = '20px';

	var topBar = document.createElement('div');
	var bottomBar = document.createElement('div');

	var newBottom = document.createElement('div');
	newBottom.id = 'notice_window_bottom';
	newBottom.className = 'notice_window_bottom';
	notice_window_bottom = newBottom;

	//attach listeners
	addEvent('mousedown',hideMessage,notice_window_close);
	addEvent('mousedown',notice_drag_start,notice_window);

	var ul = document.createElement('div');
	ul.className = 'notice_corner_left';
	var uli = document.createElement('img');
	if(document.body.attachEvent){
		var uli = document.createElement('div');
		uli.style.width = '20px';
		uli.style.height = '20px';
		uli.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='./images/corner1.png', sizingMethod=scale)";
	} else {
		var uli = document.createElement('img');
		uli.src = "./images/corner1.png";
		uli.style.height = '22px';
		uli.style.width = '20px';
	}
	ul.appendChild(uli);

	var ur = document.createElement('div');
	ur.className = 'notice_corner_right';
	if(document.body.attachEvent){
		var uri = document.createElement('div');
		uri.style.width = '20px';
		uri.style.height = '20px';
		uri.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='./images/corner2.png', sizingMethod=scale)";
	} else {
		var uri = document.createElement('img');
		uri.src = "./images/corner2.png";
		uri.style.height = '22px';
		uri.style.width = '20px';
	}
	ur.appendChild(uri);

	var ll = document.createElement('div');
	ll.className = 'notice_corner_left';
	var lli = document.createElement('img');
	lli.src = "./images/corner3.png";
	if(document.body.attachEvent){
		var lli = document.createElement('div');
		lli.style.width = '20px';
		lli.style.height = '20px';
		lli.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='./images/corner3.png', sizingMethod=scale)";
	} else {
		var lli = document.createElement('img');
		lli.src = "./images/corner3.png";
	}
	ll.appendChild(lli);

	var lr = document.createElement('div');
	lr.className = 'notice_corner_right';
	if(document.body.attachEvent){
		var lri = document.createElement('div');
		lri.style.width = '20px';
		lri.style.height = '20px';
		lri.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='./images/corner4.png', sizingMethod=scale)";
	} else {
		var lri = document.createElement('img');
		lri.src = "./images/corner4.png";
	}

	lr.setAttribute('unselectable','on');
	ur.setAttribute('unselectable','on');
	ul.setAttribute('unselectable','on');
	ll.setAttribute('unselectable','on');
	
	topBar.setAttribute('unselectable','on');
	newTitleText.setAttribute('unselectable','on');
	newNotice.setAttribute('unselectable','on');

	lr.appendChild(lri);
	topBar.appendChild(ur);
	newTitle.appendChild(newClose);
	topBar.appendChild(ul);
	topBar.appendChild(newTitle);
	newTitle.appendChild(newTitleText);

	newNotice.appendChild(topBar);
	if(!window.attachEvent){
		var clear = document.createElement('div');
		clear.id = 'notice_window_clear';

		newNotice.appendChild(clear);
	}
	newNotice.appendChild(newMessage);
	bottomBar.appendChild(lr);
	bottomBar.appendChild(ll);
	bottomBar.appendChild(newBottom);
	newNotice.appendChild(bottomBar);
	//document.body.insertBefore(newNotice,document.body.firstChild);
	document.body.appendChild(newNotice);
	newNotice.style.position = 'absolute';
	newNotice.style.top = '30px';
	newNotice.style.left = '30px';
}



	function notice_drag_start(e){
		var evt = getEvent(e);
		notice_relative_ex_value = parseInt(notice_window.style.left);
		notice_relative_why_value = parseInt(notice_window.style.top);

		if(window.attachEvent){
			notice_relative_ex_value = notice_relative_ex_value - evt.clientX;
			notice_relative_why_value = notice_relative_why_value - evt.clientY;
		} else {
			notice_relative_ex_value = notice_relative_ex_value - evt.pageX;
			notice_relative_why_value = notice_relative_why_value - evt.pageY;
		}
		
		if(window.attachEvent){
			addEvent('mousemove', notice_drag_while, document.body);
			addEvent('mouseup', notice_drag_end, document.body);
		} else{
			addEvent('mousemove', notice_drag_while, window);
			addEvent('mouseup', notice_drag_end, window);
		}
	}

	function notice_drag_while(e){
		var evt = getEvent(e);
		//reposition the div to where we currently are
		if(evt.target.attachEvent){
			notice_window.style.top = (evt.clientY + notice_relative_why_value) + 'px';
			if(parseInt(notice_window.style.top) < 0)
				notice_window.style.top = '0px';
			notice_window.style.left = (evt.clientX + notice_relative_ex_value)+ 'px';
		} else {
			notice_window.style.top = (evt.pageY + notice_relative_why_value) + 'px';
			notice_window.style.left = (evt.pageX + notice_relative_ex_value)+ 'px';
		}
		if(parseInt(notice_window.style.top) < 0)
			notice_window.style.top = '0px';
		if(parseInt(notice_window.style.left) < 0)
			notice_window.style.left = '0px';
	}

	function notice_drag_end(e){
		//deactivate the listeners we created
		var evt = getEvent(e);
		if(window.attachEvent){
			removeEvent('mousemove', notice_drag_while, document.body);
			removeEvent('mouseup', notice_drag_end, document.body);
		} else {
			removeEvent('mousemove', notice_drag_while, window);
			removeEvent('mouseup', notice_drag_end, window);
		}
	}