# Wright Group scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"

    #Get detail page, if necessary
    i = string.find(source, ">Search Results:<")

    if i != -1:
        source = searchForPlus(source, ">Search Results:<")
        source = searchForPlus(source, "<table")
        source = searchForPlus(source, "<a href=\"")
        i = string.find(source, "\"")
        url = "http://www.wrightgroup.com/" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Find Ranking
    # Find Reading level
    i = string.find(marketinfo, ">Grade:<")

    if (i != -1):
        readinglevel = searchForPlus(marketinfo, ">Grade:<")
        readinglevel = searchForPlus(readinglevel, "\">")
        i = string.find(readinglevel, "<")
        readinglevel = stripText(readinglevel[0:i])


    # Find List price
    i = string.find(marketinfo, ">$")

    if (i != -1):
        listprice = searchFor(marketinfo, ">$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[1:i])


    # Main extraction
    # Find Category
    i = string.find(source, ">Online Catalog<")

    if i != -1:
        category = ""
        categories = searchForPlus(source, ">Online Catalog<")
        i = string.find(source, "</span>")
        categories = stripText(categories[0:i])

        while (searchFor(categories, "\"pathline\"") != None):
            categories = searchForPlus(categories, "\"pathline\"")
            categories = searchForPlus(categories, ">")
            i = string.find(categories, "<")
            temp = stripText(categories[0:i])

            if (category != ""):
                category = category + " : "

            i = string.find(temp, "&trade;")

            if i != -1:
                temp = temp[0:i] + temp[i+7:]

            category = category + temp


    source = searchForPlus(source, "contentcopybold")


    # Find Title
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    i = string.find(source, "by ")
    haveAuthor = 1
    authorList = []

    if i == -1:
        haveAuthor = 0

    if (i > 1000):
        haveAuthor = 0

    if haveAuthor == 1:
        source = searchForPlus(source, "by ")
        i = string.find(source, "<")
        authors = stripText(source[0:i])

        while (searchFor(authors, " &amp; ") != None):
            i = string.find(authors, " &amp; ")
            author = stripText(authors[0:i])
            authors = stripText(authors[i+7:])
            i = string.rfind(author, " ")

            if (i != -1):
                authorfirst = stripText(author[0:i])
                authorlast = stripText(author[i:])
                author = stripText(authorlast) + ", " + stripText(authorfirst)

            authorList.append(author)

        author = stripText(authors)
        i = string.rfind(author, " ")

        if (i != -1):
            authorfirst = stripText(author[0:i])
            authorlast = stripText(author[i:])
            author = stripText(authorlast) + ", " + stripText(authorfirst)

        authorList.append(author)


        if len(authorList) > 0:
            author = authorList[0]

        if len(authorList) > 1:
            author2 = authorList[1]

        if len(authorList) > 2:
            author3 = authorList[2]

        if len(authorList) > 3:
            author4 = authorList[3]

        if len(authorList) > 4:
            author5 = authorList[4]

        if len(authorList) > 5:
            author6 = authorList[5]

    if title != "" and len(authorList) == 0:
        author = "No Author"


    # Find ISBN
    i = string.find(source, "ISBN:")

    if i != -1:
        source = searchForPlus(source, "ISBN:")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "contentcopy")

    if i != -1 and i < 100:
        comments = ""
        source = searchForPlus(source, "contentcopy")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        comments = source[0:i]


    # Find Image
    i = string.find(source, "covers/Jpeg_250")

    if i != -1:
        source = stripText(source[i-50:])
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">$")

    if (i != -1):
        source = searchFor(source, ">$")
        i = string.find(source, "<")
        value = stripText(source[1:i])


    # Find Series
    i = string.find(source, "is a part of")

    if i != -1:
        source = searchForPlus(source, "is a part of")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        series = stripText(source[0:i])

        i = string.find(series, "&trade;")

        if i != -1:
            series = series[0:i] + series[i+7:]




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
