# Tower records video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    #Check for not found
    i = string.find(source, "is not a valid Tower Records product number.")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return


    # Find Title
    source = searchForPlus(source, "size=5>")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "</b>")
    title = stripText(source[0:i])

    i = string.rfind(title, "(")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Image
    i = string.find(source, "border=1")

    if (i != -1):
        source = searchForPlus(source, "border=1")
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])
    else:
        i = string.find(source, ".musicserver")

        if (i != -1):
            source = source[i-100:]
            source = searchForPlus(source, "src=\"")
            i = string.find(source, "\"")
            image = stripText(source[0:i])


    # Find Copyright date
    i = string.find(source, ">Theatrical Release Year:<")

    if (i != -1):
        source = searchForPlus(source, ">Theatrical Release Year:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(copyDate, "/")

            if i != -1:
                copyDate = stripText(copyDate[i+1:])


    # Find Studio
    i = string.find(source, ">Release Company:<")

    if (i != -1):
        source = searchForPlus(source, ">Release Company:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        studio = stripText(source[0:i])


    # Find Release date
    i = string.find(source, ">Release Date:<")

    if (i != -1):
        source = searchForPlus(source, ">Release Date:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Run time
    i = string.find(source, ">Runtime:<")

    if (i != -1):
        source = searchForPlus(source, ">Runtime:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        running = stripText(source[0:i])


    # Find Sound
    i = string.find(source, ">Recording Mode:<")

    if (i != -1):
        source = searchForPlus(source, ">Recording Mode:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        sound = stripText(source[0:i])


    # Find Rating
    i = string.find(source, ">Rating:<")

    if (i != -1):
        source = searchForPlus(source, ">Rating:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Widescreen
    i = string.find(source, ">Letterboxed:<")

    if (i != -1):
        source = searchForPlus(source, ">Letterboxed:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        wide = stripText(source[0:i])


    # Find Closed Cap
    i = string.find(source, ">Closed Captioned<")

    if (i != -1):
        closedCap = "Y"


    # Find Color
    i = string.find(source, ">Color:<")

    if (i != -1):
        source = searchForPlus(source, ">Color:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        color = stripText(source[0:i])


    # Find Format
    i = string.find(source, "<td width=\"50%\">")

    if (i != -1):
        source = searchForPlus(source, "<td width=\"50%\">")
        source = searchForPlus(source, "<b>")
        i = string.find(source, " -")

        format = stripText(source[0:i])


        # Find Price
        source = searchForPlus(source, " -")
        i = string.find(source, "<")

        if (i != -1):
            value = stripText(source[0:i])


    # Find Actors
    actorList = []
    i = string.find(source, ">Starring<")

    if (i != -1):
        source = searchForPlus(source, ">Starring<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        actors = stripText(source[0:i])

        while (searchFor(actors, "href=") != None):
            actors = searchForPlus(actors, "href=")
            actors = searchForPlus(actors, ">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])
            actorList.append(actor)

    i = string.find(source, ">Featuring<")

    if (i != -1):
        source = searchForPlus(source, ">Featuring<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        actors = stripText(source[0:i])

        while (searchFor(actors, " href=") != None):
            actors = searchForPlus(actors, " href=")
            actors = searchForPlus(actors, ">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])
            actorList.append(actor)

    i = string.find(source, ">Voice<")

    if (i != -1):
        source = searchForPlus(source, ">Voice<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        actors = stripText(source[0:i])

        while (searchFor(actors, " href=") != None):
            actors = searchForPlus(actors, " href=")
            actors = searchForPlus(actors, ">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])
            actorList.append(actor)


    if len(actorList) > 0:
        actor1 = actorList[0]

    if len(actorList) > 1:
        actor2 = actorList[1]

    if len(actorList) > 2:
        actor3 = actorList[2]

    if len(actorList) > 3:
        actor4 = actorList[3]

    if len(actorList) > 4:
        actor5 = actorList[4]

    if len(actorList) > 5:
        actor6 = actorList[5]

    if len(actorList) > 6:
        actor7 = actorList[6]

    if len(actorList) > 7:
        actor8 = actorList[7]

    if len(actorList) > 8:
        actor9 = actorList[8]

    if len(actorList) > 9:
        actor10 = actorList[9]


    # Find Director
    i = string.find(source, ">Director<")

    if (i != -1):
        source = searchForPlus(source, ">Director<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        directors = stripText(source[0:i])
        director = ""

        while (searchFor(directors, " href=") != None):
            directors = searchForPlus(directors, " href=")
            directors = searchForPlus(directors, ">")
            i = string.find(directors, "<")

            if (director != ""):
                director = director + " / "

            director = director + stripText(directors[0:i])


    # Find Composer
    i = string.find(source, ">Composer<")

    if (i != -1):
        source = searchForPlus(source, ">Composer<")
        source = searchForPlus(source, "href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        composer = stripText(source[0:i])


    # Find Screenwriter
    i = string.find(source, ">Screenwriter<")

    if (i != -1):
        source = searchForPlus(source, ">Screenwriter<")
        source = searchForPlus(source, "href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        screenwriter = stripText(source[0:i])


    # Find Composer
    i = string.find(source, "Composer:<")

    if (i != -1):
        temp = searchForPlus(source, "Composer:<")
        temp = searchForPlus(temp, "HREF=")
        temp = searchForPlus(temp, "first=")
        i = string.find(temp, "&")
        first = stripText(temp[0:i])
        temp = searchForPlus(temp, "last=")
        i = string.find(temp, "\"")
        last = stripText(temp[0:i])

        i = string.find(last, "&urlid=")

        if (i != -1):
            last = stripText(last[0:i])

        composer = last + ", " + first


    # Find Dir of Photography
    i = string.find(source, "Director of Photography:<")

    if (i != -1):
        temp = searchForPlus(source, "Director of Photography:<")
        temp = searchForPlus(temp, "HREF=")
        temp = searchForPlus(temp, "first=")
        i = string.find(temp, "&")
        first = stripText(temp[0:i])
        temp = searchForPlus(temp, "last=")
        i = string.find(temp, "\"")
        last = stripText(temp[0:i])

        i = string.find(last, "&urlid=")

        if (i != -1):
            last = stripText(last[0:i])

        photographer = last + ", " + first


    # Find Editor
    i = string.find(source, "Editor:<")

    if (i != -1):
        temp = searchForPlus(source, "Editor:<")
        temp = searchForPlus(temp, "HREF=")
        temp = searchForPlus(temp, "first=")
        i = string.find(temp, "&")
        first = stripText(temp[0:i])
        temp = searchForPlus(temp, "last=")
        i = string.find(temp, "\"")
        last = stripText(temp[0:i])

        i = string.find(last, "&urlid=")

        if (i != -1):
            last = stripText(last[0:i])

        editor = last + ", " + first


    # Find Author
    i = string.find(source, "Story:<")

    if (i != -1):
        temp = searchForPlus(source, "Story:<")
        temp = searchForPlus(temp, "HREF=")
        temp = searchForPlus(temp, "first=")
        i = string.find(temp, "&")
        first = stripText(temp[0:i])
        temp = searchForPlus(temp, "last=")
        i = string.find(temp, "\"")
        last = stripText(temp[0:i])

        i = string.find(last, "&urlid=")

        if (i != -1):
            last = stripText(last[0:i])

        author = last + ", " + first


    # Find Comments
    i = string.find(source, ">Description<")

    if (i != -1):
        source = searchForPlus(source, ">Description<")
        source = searchForPlus(source, "<font")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<br>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "\n", " ")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")

        while (searchFor(comments, "<a ") != None):
            i = string.find(comments, "<a ")
            j = string.find(comments[i:], "\">")
            comments = comments[0:i] + comments[i+j+2:]


    #Find Category
    i = string.find(source, ">Genres<")

    if i != -1:
        source = searchForPlus(source, ">Genres<")
        source = searchForPlus(source, "<tr>")
        source = searchForPlus(source, "<tr>")
        i = string.find(source, "</tr>")
        categories = stripText(source[0:i])
        category = ""

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            categories = searchForPlus(categories, ">")
            i = string.find(categories, "<")

            if (category != ""):
                category = category + " : "

            category = category + stripText(categories[0:i])
            categories = categories[i:]



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
