# Tower records video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripNewLines
from    scrapers.scrapers import calcUPCCheckDigit
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    #Check for not found
    i = string.find(source, "is not a valid Tower Records product number.")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        temp = searchForPlus(marketinfo, "List Price:")
        i = string.find(temp, ">")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])



    # Main extraction

    # Find Image
    i = string.find(source, "\"reflect rheight10\"")

    if i != -1:
        source = stripText(source[i-100:])
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "777777777")

        if i != -1:
            image = ""


    # Find Title
    source = searchForPlus(source, "color: #c00;")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    i = string.rfind(title, "[")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Price
    i = string.find(source, "Price:")

    if i != -1:
        source = searchForPlus(source, "Price:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Release date
    i = string.find(source, ">Release Date:")

    if (i != -1):
        source = searchForPlus(source, ">Release Date:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Copyright date
    copyDate = ""
    i = string.find(source, ">Original Release:")

    if i != -1:
        source = searchForPlus(source, ">Original Release:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(copyDate, " ")

            if i != -1:
                copyDate = stripText(copyDate[i+1:])
    else:
        i = string.find(source, ">Theatrical Release:")

        if i != -1:
            copyDate = searchForPlus(source, ">Theatrical Release:")
            copyDate = searchForPlus(copyDate, ">")
            i = string.find(copyDate, "<")
            copyDate = stripText(copyDate[0:i])
            
            if fullDateFormat == "false":
                i = string.rfind(copyDate, " ")
                
                if i != -1:
                    copyDate = stripText(copyDate[i+1:])

    if copyDate == "---":
        copyDate = ""


    # Find UPC
    i = string.find(source, ">UPC/EAN:")

    if i != -1:
        upc = searchForPlus(source, ">UPC/EAN:")
        upc = searchForPlus(upc, ">")
        i = string.find(upc, "<")
        upc = stripText(upc[0:i])


    # Find Category
    i = string.find(source, ">Genre:")

    if i != -1:
        category = searchForPlus(source, ">Genre:")
        category = searchForPlus(category, ">")
        i = string.find(category, "<")
        category = stripText(category[0:i])


    # Find Actors
    actors = source
    actorList = []

    while (searchFor(actors, "Star:") != None):
        actors = searchForPlus(actors, "Star:")
        actors = searchForPlus(actors, "href=")
        actors = searchForPlus(actors, "cast_free=")
        i = string.find(actors, "&")
        temp = stripText(actors[0:i])
        i = string.rfind(temp, "+")
        first = stripText(temp[0:i])
        last = stripText(temp[i+1:])

        if first == "":
            actor = last
        else:
            actor = last + ", " + first

        actor = string.replace(actor, "+", " ")
        actorList.append(actor)


    actors = source

    while (searchFor(actors, "Featured:") != None):
        actors = searchForPlus(actors, "Featured:")
        actors = searchForPlus(actors, "href=")
        actors = searchForPlus(actors, "cast_free=")
        i = string.find(actors, "&")
        temp = stripText(actors[0:i])
        i = string.rfind(temp, "+")
        first = stripText(temp[0:i])
        last = stripText(temp[i+1:])

        if first == "":
            actor = last
        else:
            actor = last + ", " + first

        actor = string.replace(actor, "+", " ")
        actorList.append(actor)


    actors = source

    while (searchFor(actors, " Performer:") != None):
        actors = searchForPlus(actors, " Performer:")
        actors = searchForPlus(actors, "href=")
        actors = searchForPlus(actors, "cast_free=")
        i = string.find(actors, "&")
        temp = stripText(actors[0:i])
        i = string.rfind(temp, "+")
        first = stripText(temp[0:i])
        last = stripText(temp[i+1:])

        if first == "":
            actor = last
        else:
            actor = last + ", " + first

        actor = string.replace(actor, "+", " ")
        actorList.append(actor)


    if len(actorList) > 0:
        actor1 = actorList[0]

    if len(actorList) > 1:
        actor2 = actorList[1]

    if len(actorList) > 2:
        actor3 = actorList[2]

    if len(actorList) > 3:
        actor4 = actorList[3]

    if len(actorList) > 4:
        actor5 = actorList[4]

    if len(actorList) > 5:
        actor6 = actorList[5]

    if len(actorList) > 6:
        actor7 = actorList[6]

    if len(actorList) > 7:
        actor8 = actorList[7]

    if len(actorList) > 8:
        actor9 = actorList[8]

    if len(actorList) > 9:
        actor10 = actorList[9]


    # Find Comments
    comments = ""
    i = string.find(source, "Distributor Notes")

    if (i != -1):
        source = searchForPlus(source, "Distributor Notes")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</table>")
        tempcomments = stripText(source[0:i])

        tempcomments = string.replace(tempcomments, "\n", " ")
        tempcomments = string.replace(tempcomments, "\r", " ")
        tempcomments = string.replace(tempcomments, "\t", " ")
        tempcomments = string.replace(tempcomments, "<i>", "")
        tempcomments = string.replace(tempcomments, "</i>", "")
        tempcomments = string.replace(tempcomments, "<I>", "")
        tempcomments = string.replace(tempcomments, "</I>", "")
        tempcomments = string.replace(tempcomments, "<br>", "\n")
        tempcomments = string.replace(tempcomments, "<tr>", "\n")
        tempcomments = string.replace(tempcomments, "<td>", "")
        tempcomments = string.replace(tempcomments, "</td>", "")
        tempcomments = string.replace(tempcomments, "</tr>", "")
        tempcomments = string.replace(tempcomments, "</div>", "")
        tempcomments = string.replace(tempcomments, "\n ", "\n")

        while (searchFor(tempcomments, "  ") != None):
            i = string.find(tempcomments, "  ")
            tempcomments = tempcomments[0:i] + tempcomments[i+1:]

        while (searchFor(tempcomments, "<td ") != None):
            i = string.find(tempcomments, "<td ")
            j = string.find(tempcomments[i:], "\">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+2:]

        while (searchFor(tempcomments, "<div ") != None):
            i = string.find(tempcomments, "<div ")
            j = string.find(tempcomments[i:], "\">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+3:]

        while (searchFor(tempcomments, "<a ") != None):
            i = string.find(tempcomments, "<a ")
            j = string.find(tempcomments[i:], "\">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+2:]

        while (searchFor(tempcomments, "<table ") != None):
            i = string.find(tempcomments, "<table ")
            j = string.find(tempcomments[i:], "</table>")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+8:]

        comments = tempcomments





try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
