# Michael's Movie Mayhem video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,imageref,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    format              = "DVD"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find marketplace pricing
    marketinfo = source


    # Main extraction
    # Find Price
    i = string.find(source, "<!--lowest price-->")

    if i != -1:
        value = stripText(source[i-50:])
        i = string.find(value, "$")

        if i != -1:
            value = searchFor(value, "$")
            i = string.find(value, "<")
            value = stripText(value[0:i])
            i = string.find(value, "!")

            if i != -1:
                value = stripText(value[0:i])


    # Find Title
    i = string.find(source, ">Title: <")

    if i == -1:
        title = ""
        return

    title = searchForPlus(source, ">Title: <")
    title = searchForPlus(title, "<td>")

    if title.startswith("<a href="):
        title = searchForPlus(title, "'>")

    i = string.find(title, "<")
    title = stripText(title[0:i])


    # Find title IMDB URL
    i = string.find(source, "imdb_popup.php")

    if i != -1:
        titleURL = searchFor(source, "imdb_popup.php")
        i = string.find(titleURL, "&")
        titleURL = "http://dvdlist.kazart.com/" + stripText(titleURL[0:i])
    else:
        titleURL = ""


    # Find Copyright date
    i = string.find(source, ">Year: <")

    if i != -1:
        source = searchForPlus(source, ">Year: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])


    # Find Studio
    i = string.find(source, ">Studio: <")

    if i != -1:
        source = searchForPlus(source, ">Studio: <")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "'>")
        i = string.find(source, "<")
        studio = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">Genre: <")

    if i != -1:
        source = searchForPlus(source, ">Genre: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Sound
    i = string.find(source, ">Sound: <")

    if i != -1:
        source = searchForPlus(source, ">Sound: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        sound = stripText(source[0:i])


    # Find Rating
    i = string.find(source, ">Rating: <")

    if i != -1:
        source = searchForPlus(source, ">Rating: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Widescreen
    i = string.find(source, ">Version: <")

    if i != -1:
        source = searchForPlus(source, ">Version: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        temp = stripText(source[0:i])

        if string.find(temp, "LBX") != -1:
            wide = "Y"

        if string.find(temp, "Letterbox") != -1:
            wide = "Y"


    # Find Release date
    i = string.find(source, ">Release: <")

    if i != -1:
        source = searchForPlus(source, ">Release: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])


    # Find UPC Code
    i = string.find(source, ">UPC: <")

    if i != -1:
        source = searchForPlus(source, ">UPC: <")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


    # Find MMM Image
    i = string.find(source, "target='Cover'")

    if i != -1:
        source = searchForPlus(source, "target='Cover'")
        source = searchForPlus(source, "<IMG SRC=")
        i = string.find(source, " ")
        image = stripText(source[0:i])


    # Retrieve IMDb data
    if titleURL == "":
        return

    http = HTTPConnection()
    http.resetReferer();
    http.blockForLoad();
    source = http.getContents(titleURL)
    imageref = "http://www.imdb.com"


    # Find Image
    i = string.find(source, "<IMG SRC=")

    if (i != -1):
        source = searchForPlus(source, "<IMG SRC=")
        i = string.find(source, " ")
        image = "http://dvdlist.kazart.com/" + stripText(source[0:i])


    # Find Director
    i = string.find(source, ">Directed by:<")

    if i != -1:
        source = searchForPlus(source, ">Directed by:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        director = stripHTML(source[0:i])

        i = string.rfind(director, " ")

        if (i != -1):
            director = stripText(director[i:]) + ", " + stripText(director[0:i])


    # Find Actors
    i = string.find(source, ">Starring:<")

    if i != -1:
        source = searchForPlus(source, ">Starring:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        actors = stripHTML(source[0:i])
        actorList = []

        while (actors != ""):
            i = string.find(actors, ",")

            if i != -1:
                actor = stripText(actors[0:i])
                actors = searchForPlus(actors, ",")
            else:
                actor = actors
                actors = ""

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find user rating
    i = string.find(source, ">IMDb Rating:<")

    if i != -1:
        source = searchForPlus(source, ">IMDb Rating:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        rating = stripText(source[0:i]) + " (IMDB)"


    # Find user comments
    i = string.find(source, ">Plot:<")

    if i != -1:
        source = searchForPlus(source, ">Plot:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "</P>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "&#34;", "\"")



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
