# Internet Adult Database video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"

    # Find marketplace pricing
    marketinfo = source


    # Main extraction
    # Find Title
    i = string.find(source, "<h2>")

    if i == -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return

    source = searchForPlus(source, "<h2>")
    i = string.find(source, "</h2>")
    title = stripText(source[0:i])

    # Find Release date
    i = string.find(source, "Year")

    if i != -1:
        source = searchForPlus(source, "Year")
        source = searchForPlus(source, "<dd>")
        i = string.find(source, "<")
        date = stripText(source[0:i])

    # Find Studio
    i = string.find(source, "Distributor<")

    if i != -1:
        tempData = searchForPlus(source, "Distributor<")
        tempData = searchForPlus(tempData, "<dd>")
        i = string.find(tempData, "<")
        studio = stripText(tempData[0:i])       

    # Find Director
    i = string.find(source, "Director<")

    if i != -1:
        tempData = searchForPlus(source, "Director<")
        tempData = searchForPlus(tempData, "<dd>")
        tempData = searchForPlus(tempData, ">")
        i = string.find(tempData, "<")
        director = stripText(tempData[0:i]) 
        i = string.rfind(director, " ")

        if (i != -1):
        	director = stripText(director[i:]) + ", " + stripText(director[0:i])
 
             
    # Find Running time
    i = string.find(source, "Minutes<")

    if i != -1:
        running = searchForPlus(source, "Minutes<")
        running = searchForPlus(running, "<dd>")
        i = string.find(running, "<")
        running = stripText(running[0:i])

    # Find Image
    i = string.find(source, "boxcover\">")

    if i != -1:
    	source = searchForPlus(source, "boxcover\">")
        temp = source[1:30]
        i = string.find(temp, "spacer")
        if i != -1:
        	image = ""
        else:
        
        	source = searchForPlus(source, " src=\"")
        	i = string.find(source, "\"")
        	image = stripText(source[0:i])

   # Find Actors
    actorTag = ">Actresses<"
    i = string.find(source, actorTag)

    if i != -1:
        source = searchForPlus(source, actorTag)
        i = string.find(source, "sceneinfo")
        actors = stripText(source[0:i])

        actorList = []

        while (searchFor(actors, "htm\">") != None):
            actors = searchForPlus(actors, "htm\">")
            i = string.find(actors, "</a>")
            actor = stripText(actors[0:i])
            actor = string.replace(actor, "<b>", "")
            actor = string.replace(actor, "</b>", "")

            i = string.find(actor, "(")

            if (i != -1):
                actor = stripText(actor[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])



            actorList.append(actor)


        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Rating
    mpaa = "XXX"

    # Find Scene Breakdown
    comments = ""
    SceneTag = ">Scene Breakdowns<"
    i = string.find(source, SceneTag)

    if i != -1:
        source = searchForPlus(source, SceneTag)
        i = string.find(source, "ratings")
        tempcomments = stripText(source[0:i])
        
        while (searchFor(tempcomments, "<li") != None):
            tempcomment = searchForPlus(tempcomments, "<li")
            i = string.find(tempcomment, ">")

            if (i != -1 and i < 100):
                tempcomment = searchForPlus(tempcomment, ">")

            i = string.find(tempcomment, "</li")

            

            tempcomment = stripText(tempcomment[0:i]) + "\n"
            
            if comments != "":
                comments = comments + tempcomment
            else:
                comments = tempcomment
                
            tempcomments = searchForPlus(tempcomments, "</li>")

            

    



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
