# half.com video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripNewLines
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    i = string.find(source, "Search Results</B>")

    if i != -1:
        source = searchForPlus(source, "Search Results</B>")
        source = searchForPlus(source, "<A HREF=")

        # URL delimiter is somtimes single quote, sometimes
        # double quote, so use what is there
        i = string.find(source[1:], source[0:1])
        source = source[1:]
        url = stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])

        i = string.find(listprice, "(")

        if (i != -1):
            listprice = stripText(listprice[0:i])


    # Find New price
    i = string.find(marketinfo, "header_items_brandNew.gif")

    if (i != -1):
        try:
            newprice = searchForPlus(marketinfo, "header_items_brandNew.gif")
            newprice = searchForPlus(newprice, "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\">")
            i = string.find(newprice, "</table>")
            newprice = stripText(newprice[0:i])
            newprice = searchFor(newprice, "$")
            
            i = string.find(newprice, "<")
            
            if (i != -1):
                newprice = stripText(newprice[0:i])
        except:
            newprice = ""


    # Find Used price
    i = string.find(marketinfo, "header_items_likeNew.gif")

    if (i != -1):
        try:
            usedprice = searchForPlus(marketinfo, "header_items_likeNew.gif")
            usedprice = searchForPlus(usedprice, "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\">")
            i = string.find(usedprice, "</table>")
            usedprice = stripText(usedprice[0:i])
            usedprice = searchFor(usedprice, "$")
            
            i = string.find(usedprice, "<")
            
            if (i != -1):
                usedprice = stripText(usedprice[0:i])
        except:
            usedprice = ""


    # Main extraction
    # Find Image
    source = searchForPlus(source, "&gt; Movies<")
    i = string.find(source, ".ebayimg.")

    if i != -1:
        source = stripText(source[i-50:])
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "593229")

        if (i != -1):
            image = ""


    # Get product attributes
    source = searchForPlus(source, "/branding/borderedbox/corner_grey_round_top_right.gif")
    source = searchForPlus(source, "><b>")
    i = string.find(source, "</td>")
    attributes = stripText(source[0:i+5])


    # Find Format
    i = string.find(attributes, "Format:")

    if i != -1:
        format = searchForPlus(attributes, "Format:")
        format = searchForPlus(format, ">")
        i = string.find(format, "<")
        format = stripText(format[0:i])


    # Find Publication Date
    i = string.find(attributes, "Format:")

    if i != -1:
        date = searchForPlus(attributes, "Format:")
        date = searchForPlus(date, "\"><br>")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find UPC
    i = string.find(attributes, "UPC:")

    if (i != -1):
        upc = searchForPlus(attributes, "UPC:")
        upc = searchForPlus(upc, ">")
        i = string.find(upc, "<")
        upc = stripText(upc[0:i])
        upc = string.replace(upc, "-", "")


    # Find Rating
    i = string.find(attributes, ">Rated ")

    if (i != -1):
        attributes = searchForPlus(attributes, ">Rated ")
        i = string.find(attributes, "<")
        mpaa = stripText(attributes[0:i])
    else:
        mpaa = "Not Rated"


    # Find Color
    i = string.find(attributes, ">Color")

    if (i != -1):
        color = "Color"
    else:
        color = "B&W"


    # Find Captioning
    i = string.find(attributes, " Closed Captioned")

    if (i != -1):
        closedCap = "Y"
    else:
        closedCap = "N"


    # Find Running time
    i = string.find(attributes, " min.")

    if (i != -1):
        running = attributes[i-10:]
        running = searchForPlus(running, ">")
        i = string.find(running, "<")
        running = stripText(running[0:i])


    # Find Title
    source = searchForPlus(source, "class=\"pagetitle\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Price
    source = searchForPlus(source, " class=\"red\">")
    source = searchFor(source, "$")
    i = string.find(source, "<")
    value = stripText(source[0:i])
    usedprice = stripText(source[0:i])


    # Find Comments
    i = string.find(source, ">Movie Description<")

    if i != -1:
        source = searchForPlus(source, ">Movie Description<")
        source = searchForPlus(source, "class=\"br\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<table ")
        comments = stripText(source[0:i])

        i = string.find(comments, "</td>")

        if i != -1:
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "<br class=\"br\"/>", "\n")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "<B>", "")
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "</B>", "")
        comments = string.replace(comments, "<br />", "\n")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")


    # Find Actors
    i = string.find(source, ">Cast:<")
    actorList = []

    if (i != -1):
        source = searchForPlus(source, ">Cast:<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</td>")
        actors = source[0:i]

        while (searchFor(actors, "href=") != None):
            actors = searchForPlus(actors, "href=")
            actors = searchForPlus(actors, "\">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])

            i = string.rfind(actor, " ")
            first = stripText(actor[0:i])
            last = stripText(actor[i:])
            actor = last + ", " + first

            actorList.append(actor)

    if len(actorList) > 0:
        actor1 = actorList[0]

    if len(actorList) > 1:
        actor2 = actorList[1]

    if len(actorList) > 2:
        actor3 = actorList[2]

    if len(actorList) > 3:
        actor4 = actorList[3]

    if len(actorList) > 4:
        actor5 = actorList[4]

    if len(actorList) > 5:
        actor6 = actorList[5]

    if len(actorList) > 6:
        actor7 = actorList[6]

    if len(actorList) > 7:
        actor8 = actorList[7]

    if len(actorList) > 8:
        actor9 = actorList[8]

    if len(actorList) > 9:
        actor10 = actorList[9]


    # Find Director
    i = string.find(source, ">Director:<")

    if (i != -1):
        source = searchForPlus(source, ">Director:<")
        source = searchForPlus(source, "\">")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        director = stripText(source[0:i])

        i = string.find(director, " ")
        first = stripText(director[0:i])
        last = stripText(director[i:])
        director = last + ", " + first


    # Find Widescreen
    i = string.find(source, ">Widescreen<")

    if i != -1:
        wide = "Y"
    else:
        wide = "N"


    # Find Sound
    i = string.find(source, ">Audio:<")

    if (i != -1):
        sound = searchForPlus(source, ">Audio:<")
        sound = searchForPlus(sound, ">")
        i = string.find(sound, "<")
        sound = stripText(sound[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
