# Amazon video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find marketplace pricing
    marketinfo = source


    # Main extraction
    # Find Title
    i = string.find(source, "\"Item_Title\"")

    if i == -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return


    # Find Image
    i = string.find(source, "\"Item_BoxCover_Container\"")

    if i != -1:
        source = searchForPlus(source, "\"Item_BoxCover_Container\"")
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""

    source = searchForPlus(source, "\"Item_Title\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Format
    i = string.find(source, "\"Item_MediaTab_Selected\"")

    if i != -1:
        format = searchForPlus(source, "\"Item_MediaTab_Selected\"")
        format = searchForPlus(format, ">")
        i = string.find(format, "<")
        format = stripText(format[0:i])


    # Find Price
    i = string.find(source, "$")

    if (i != -1):
        source = source[i:]
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    comments = ""
    i = string.find(source, ">Synopsis<")

    if i != -1:
        source = searchForPlus(source, ">Synopsis<")
        source = searchForPlus(source, "\"Item_InfoContainer\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "</div>")
        tempcomment = stripText(source[0:i])

        tempcomment = string.replace(tempcomment, "\n", "")
        tempcomment = string.replace(tempcomment, "\t", " ")
        tempcomment = string.replace(tempcomment, "  ", " ")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "i</font>", " ")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "</span>", "\n\n")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "</a>", "")

        while (searchFor(tempcomment, "<span ") != None):
            i = string.find(tempcomment, "<span ")
            j = string.find(tempcomment[i:], ">")

            if j == -1:
                j = 2

            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<font ") != None):
            i = string.find(tempcomment, "<font ")
            j = string.find(tempcomment[i:], ">")

            if j == -1:
                j = 2

            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<a ") != None):
            i = string.find(tempcomment, "<a ")
            j = string.find(tempcomment[i:], ">")

            if j == -1:
                j = 2

            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "\r ") != None):
            tempcomment = string.replace(tempcomment, "\r ", "\r")

        comments = tempcomment


    # Find Comments, Part 2
    i = string.find(source, ">Features:<")

    if (i != -1):
        source = searchForPlus(source, ">Features:<")
        source = searchForPlus(source, "\"Item_ProductInfoSectionConatiner\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "</div>")
        tempcomment = stripText(source[0:i])

        tempcomment = string.replace(tempcomment, "\n", "")
        tempcomment = string.replace(tempcomment, "\t", " ")
        tempcomment = string.replace(tempcomment, "  ", " ")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "i</font>", " ")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "<Br>", "\n")
        tempcomment = string.replace(tempcomment, "<bR>", "\n")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "<B>", "")
        tempcomment = string.replace(tempcomment, "</B>", "")

        while (searchFor(tempcomment, "<font ") != None):
            i = string.find(tempcomment, "<font ")
            j = string.find(tempcomment[i:], ">")

            if j == -1:
                j = 2

            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        if comments != "":
            comments = comments + "\n\n" +  tempcomment
        else:
            comments = tempcomment


    # Find Running time
    i = string.find(source, "Length:")

    if i != -1:
        running = searchForPlus(source, "Length:")
        i = string.find(running, "<")
        running = stripText(running[0:i])


    # Find Rating
    i = string.find(source, "Rating:")

    if i != -1:
        mpaa = searchForPlus(source, "Rating:")
        i = string.find(mpaa, "<")
        mpaa = stripText(mpaa[0:i])


    # Find Release date
    i = string.find(source, "Release Date:")

    if i != -1:
        date = searchForPlus(source, "Release Date:")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Copyright date
    i = string.find(source, "Production Year:")

    if i != -1:
        copyDate = searchForPlus(source, "Production Year:")
        i = string.find(copyDate, "<")
        copyDate = stripText(copyDate[0:i])


    # Find Studio
    i = string.find(source, "Studio:")

    if i != -1:
        studio = searchForPlus(source, "Studio:")
        studio = searchForPlus(studio, "\">")
        i = string.find(studio, "<")
        studio = stripText(studio[0:i])


    # Find UPC
    i = string.find(source, ">UPC Code:")

    if i != -1:
        source = searchForPlus(source, ">UPC Code:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


    # Find Actors
    actorTag = ">Cast"
    i = string.find(source, actorTag)

    if i != -1:
        source = searchForPlus(source, actorTag)
        source = searchForPlus(source, "<table>")
        i = string.find(source, "\"Section_Separator\"")
        actors = stripText(source[0:i])

        actorList = []

        while (searchFor(actors, "type=1\">") != None):
            actors = searchForPlus(actors, "type=1\">")
            i = string.find(actors, "</a>")
            actor = stripText(actors[0:i])
            actor = string.replace(actor, "<b>", "")
            actor = string.replace(actor, "</b>", "")

            i = string.find(actor, "(I)")

            if (i != -1):
                actor = stripText(actor[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])

            i = string.find(actors, " - Director<")

            if i != -1 and i < 75:
                director = actor
                continue

            i = string.find(actors, " - Writer<")

            if i != -1 and i < 75:
                screenwriter = actor
                continue

            actorList.append(actor)


        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
