# FBO Entertainment [AU] video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    format              = "DVD"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    i = string.find(source, "familyboxoffice&product")

    if i != -1:
        source = source[i-50:]
        source = searchForPlus(source, "href=\"")
        i = string.find(source, "\"")
        url = "http://www.dvdplaza.com.au" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find marketplace pricing


    # Main extraction
    i = string.find(source, "<!-- main movie table -->")

    if i == -1:
        title = ""
        return

    source = searchForPlus(source, "<!-- main movie table -->")


    # Find Image
    i = string.find(source, "DVDImages")
    print "I=",i

    if i != -1 and i < 500:
        source = source[i-25:]
        source = searchForPlus(source, " src=\".")
        i = string.find(source, "\"")
        image = "http://www.fbo.com.au" + stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""

    # Find Title
    source = searchForPlus(source, "class=\"titlefilmw\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    i = string.rfind(title, " - ")

    if i != -1:
        format = stripText(title[i+3:])
        title = stripText(title[0:i])


    # Find Comments
    comments = ""
    i = string.find(source, "alt=\"Synopsis\"")

    if (i != -1):
        comments = searchForPlus(source, "alt=\"Synopsis\"")
        comments = searchForPlus(comments, "class=\"sm\"")
        comments = searchForPlus(comments, ">")
        i = string.find(comments, "<!--")
        comments = comments[0:i]

        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<br> ", "\n")
        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "</b>", "")


    # Find Price
    i = string.find(source, "class=\"hdr14w\"")

    if (i != -1):
        source = searchForPlus(source, "class=\"hdr14w\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Actors
    i = string.find(source, ">Actors")

    if i != -1:
        source = searchForPlus(source, ">Actors")
        source = searchForPlus(source, "class=\"sm\"")
        i = string.find(source, "</span>")
        actors = stripText(source[0:i])
        actorList = []

        while (searchFor(actors, "href=\"") != None):
            actors = searchForPlus(actors, "href=\"")
            actors = searchForPlus(actors, "\">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Director
    i = string.find(source, ">Director")

    if i != -1:
        source = searchForPlus(source, ">Director")
        source = searchForPlus(source, "class=\"sm\"")
        source = searchForPlus(source, "href=\"")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        director = stripText(source[0:i])

        i = string.rfind(director, " ")

        if (i != -1):
            director = stripText(director[i:]) + ", " + stripText(director[0:i])


    # Find Rating
    i = string.find(source, ">Rated")

    if i != -1:
        source = searchForPlus(source, ">Rated")
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        mpaa = stripText(source[0:i])

        if string.find(mpaa, "/G.jpg") != -1:
            mpaa = "G"
        elif string.find(mpaa, "/PG.jpg") != -1:
            mpaa = "PG"
        elif string.find(mpaa, "/M.jpg") != -1:
            mpaa = "M"
        elif string.find(mpaa, "/MA.jpg") != -1:
            mpaa = "MA"
        elif string.find(mpaa, "/R.jpg") != -1:
            mpaa = "R"
        else:
            mpaa = ""


    # Find Copyright date
    i = string.find(source, ">Year Released")

    if i != -1:
        source = searchForPlus(source, ">Year Released")
        source = searchForPlus(source, "href=\"")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])


    # Find Comments (Part 2)
    i = string.find(source, "Special Features:")

    if (i != -1):
        tempcomments = searchForPlus(source, "Special Features:")
        tempcomments = searchForPlus(tempcomments, "class=\"sm\"")
        tempcomments = searchForPlus(tempcomments, ">")
        i = string.find(tempcomments, "</span>")
        tempcomments = stripText(tempcomments[0:i])

        tempcomments = string.replace(tempcomments, "\n", "")
        tempcomments = string.replace(tempcomments, "<BR>", "\n")

        if comments == "":
            comments = tempcomments
        else:
            comments = comments + "\n\n" + tempcomments


    # Find Studio
    i = string.find(source, ">Studio:<")

    if i != -1:
        studio = searchForPlus(source, ">Studio:<")
        studio = searchForPlus(studio, "class=\"sm\"")
        studio = searchForPlus(studio, ">")
        i = string.find(studio, "<")
        studio = stripText(studio[0:i])

        if studio == "?":
            studio = ""


    # Find Widescreen
    i = string.find(source, ">Video Format:<")

    if i != -1:
        wide = searchForPlus(source, ">Video Format:<")
        wide = searchForPlus(wide, "class=\"sm\"")
        i = string.find(wide, "</span>")
        wide = stripText(wide[0:i])

        i = string.find(wide, "Wide")

        if i != -1:
            wide = "Y"
        else:
            wide = "N"


    # Find Sound
    i = string.find(source, ">Audio Tracks:<")

    if i != -1:
        sound = searchForPlus(source, ">Audio Tracks:<")
        sound = searchForPlus(sound, "class=\"sm\"")
        sound = searchForPlus(sound, ">")
        i = string.find(sound, "<")
        sound = stripText(sound[0:i])

        if sound.startswith("English"):
            sound = stripText(sound[7:])


    # Find Running time
    i = string.find(source, "Run Time:")
    if i != -1:
        running = searchForPlus(source, "Run Time:")
        running = searchForPlus(running, "class=\"sm\"")
        running = searchForPlus(running, ">")
        i = string.find(running, "<")
        running = stripText(running[0:i])

        if running == "00:00":
            running = ""




try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
