# Family Christian Stores video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    i = string.find(source, "matching records...<")

    if i != -1:
        source = searchFor(source, "<a href=\"/shop/product.asp?prodID=")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        url = "http://www.familychristian.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find marketplace pricing


    # Main extraction
    i = string.find(source, "<!--Begin Content Well-->")

    if i == -1:
        title = ""
        return

    source = searchForPlus(source, "<!--Begin Content Well-->")


    # Find Image
    i = string.find(source, "images/shop")

    if i != -1:
        source = source[i-25:]
        source = searchForPlus(source, " SRC=")
        i = string.find(source, " ")
        image = stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""
        else:
            image = "http://www.familychristian.com/" + image


    # Find Format
    i = string.find(source, "Checked>")

    if i != -1:
        source = searchForPlus(source, "Checked>")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        format = stripText(source[0:i])
    else:
        i = string.find(source, "Format:")

        if i != -1: 
            source = searchForPlus(source, "Format:")
            i = string.find(source, "<")
            format = stripText(source[0:i])


    # Find Value
    i = string.find(source, "Retail:")

    if i != -1:
        source = searchForPlus(source, "Retail:")
        i = string.find(source, "<")
        value = stripText(source[0:i])
        

    # Find Title
    source = searchForPlus(source, "SIZE=4><I>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "goldline.gif")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, "goldline.gif")
        source = searchForPlus(source, "<BR>")
        i = string.find(source, "<BR ")
        comments = stripText(source[0:i])

        i = string.find(comments, "<font")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<P>", "")
        comments = string.replace(comments, "<p>", "")


    # Find Rating
    i = string.find(source, "<B>Rated")

    if i != -1:
        source = searchForPlus(source, "<B>Rated")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Release date
    i = string.find(source, "release date of")

    if i != -1:
        source = searchForPlus(source, "release date of")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
