# eztdvd [AU] video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    format              = "DVD"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find marketplace pricing


    # Main extraction
    # Find Title
    i = string.find(source, "font-size: 16pt;")

    if i == -1:
        title = ""
        return

    source = searchForPlus(source, "font-size: 16pt;")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Price
    i = string.find(source, "\"big\">$")

    if (i != -1):
        source = source[i:]
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Image
    i = string.find(source, "<img src=\"/g/i/p/")

    if (i != -1):
        source = source[i:]
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = "http://www.ezydvd.com.au" + stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""


    # Find Comments
    i = string.rfind(source, "class=\"smlralert\"")

    if (i != -1):
        comments = searchForPlus(source, "class=\"smlralert\"")
        comments = searchForPlus(source, "</span>")
        comments = searchForPlus(comments, "<br />\n")
        comments = searchForPlus(comments, "<p>")
        i = string.find(comments, "<br />\n")
        comments = comments[0:i]

        i = string.rfind(comments, "<table")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.rfind(comments, "Special Features:<")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "<br />", "\n")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "<li>", "\n")
        comments = string.replace(comments, "<ul>", "\n")
        comments = string.replace(comments, "</ul>", "")
        comments = string.replace(comments, "</p>", "")

        while (searchFor(comments, "<a ") != None):
            i = string.find(comments, "<a ")
            j = string.find(comments[i:], ">")

            if j == -1:
                j = 2

            comments = comments[0:i] + comments[i+j+1:]


    # Find Released date
    i = string.find(source, ">Released:<")

    if i != -1:
        source = searchForPlus(source, ">Released:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Actors
    i = string.find(source, ">Actors:<")

    if i != -1:
        source = searchForPlus(source, ">Actors:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        actors = stripText(source[0:i])
        actorList = []

        while (searchFor(actors, "\">") != None):
            actors = searchForPlus(actors, "\">")
            i = string.find(actors, "<")
            actor = stripText(actors[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Director
    i = string.find(source, ">Director:<")

    if i != -1:
        source = searchForPlus(source, ">Director:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "</td>")
        director = stripText(source[0:i])

        i = string.find(director, "<a href")

        if (i != -1):
            director = searchForPlus(director, "\">")
            i = string.find(director, "<")
            director = stripText(director[0:i])
            

        i = string.rfind(director, " ")

        if (i != -1):
            director = stripText(director[i:]) + ", " + stripText(director[0:i])


    # Find Sound
    i = string.find(source, ">Audio:<")

    if i != -1:
        source = searchForPlus(source, ">Audio:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        sound = stripText(source[0:i])


    # Find Widescreen
    i = string.find(source, ">Transfer Format:<")

    if i != -1:
        source = searchForPlus(source, ">Transfer Format:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        wide = stripText(source[0:i])

        i = string.find(wide, "Wide")

        if i != -1:
            wide = "Y"
        else:
            wide = "N"


    # Find Category
    i = string.find(source, ">Category:<")

    if i != -1:
        source = searchForPlus(source, ">Category:<")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Copyright date
    i = string.find(source, ">Year:<")

    if i != -1:
        source = searchForPlus(source, ">Year:<")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])


    # Find Studio
    i = string.find(source, ">Distributor:<")

    if i != -1:
        source = searchForPlus(source, ">Distributor:<")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        studio = stripText(source[0:i])


    # Find Rating
    i = string.find(source, ">Rating:<")

    if i != -1:
        source = searchForPlus(source, ">Rating:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Running time
    i = string.find(source, ">Running Time:<")

    if i != -1:
        source = searchForPlus(source, ">Running Time:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        running = stripText(source[0:i])




try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
