# Amazon video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Stereo"
    wide                = "N"
    closedCap           = "N"
    format              = "DVD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Main extraction
    # Not supported.
    return

    source = searchForPlus(source, "</div>")


    # Find Image
    i = string.find(source, "<a href=\"")

    print "I=",i

    if i != -1 and i < 650:
        source = searchForPlus(source, "<a href=\"")
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = "http://www.dvdpacific.com.au" + stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "<b>")
    i = string.find(source, "</b>")
    title = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">Category :")
    if i != -1:
        source = searchForPlus(source, ">Category :")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Actors
    actorTag = ">Starring :"
    i = string.find(source, actorTag)

    if i != -1:
        source = searchForPlus(source, actorTag)
        i = string.find(source, "<br>")
        actors = stripText(source[0:i]) + ", "
        actorList = []

        while (searchFor(actors, ", ") != None):
            i = string.find(actors, ", ")
            actor = stripText(actors[0:i])

            actorList.append(actor)

            actors = searchForPlus(actors, ", ")

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Comments
    i = string.find(source, "size=\"1\">")

    if i != -1:
        source = searchForPlus(source, "size=\"1\">")
        i = string.find(source, "</font>")
        comments = stripText(source[0:i])


    # Find Run time
    i = string.find(source, "Run Time:")

    if i != -1:
        source = searchForPlus(source, "Run Time:")
        i = string.find(source, "<br>")
        running = stripText(source[0:i])

        i = string.find(running, "app.")

        if i != -1:
            running = stripText(running[i+4:])


    # Find Rating
    i = string.find(source, "Rated:")

    if i != -1:
        source = searchForPlus(source, "Rated:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Our Price:")

    if i == -1:
        source = searchForPlus(source, ">Our Price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
