# Borders scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import convertAuthor
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"

    i = string.find(source, "<!---START OF ROW WITH PRODUCT INFORMATION--->")

    if i == -1:
        return


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        i = string.find(listprice, "$")

        if i != -1 and i < 50:
            listprice = searchFor(listprice, "$")
            i = string.find(listprice, "<")
            listprice = stripText(listprice[0:i])
        else:
            listprice = ""


    # Main extraction
    # Find Image
    source = searchForPlus(source, "<!---START OF ROW WITH PRODUCT INFORMATION--->")
    i = string.find(source, "web_images")

    if (i != -1):
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        tempimage = stripText(source[0:i])
        i = string.find(tempimage, "placeholder")

        if (i == -1):
            image = "http://www.bordersstores.com" + tempimage


    # Find Title
    source = searchForPlus(source, "class=\"titledetail\"")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "</b>")
    title = stripText(source[0:i])
    format = ""

    i = string.rfind(title, "[HD]")

    if i != -1:
        format = "HD DVD"

    i = string.rfind(title, "[Blu-ray]")

    if i != -1:
        format = "Blu-ray Disc"

    i = string.rfind(title, " [")

    if i != -1:
        title = stripText(title[0:i])


    # Find Format
    attrs = searchForPlus(source, ">Bibliographic Data:")
    attrs = searchForPlus(attrs, "</b>")
    i = string.find(attrs, "<br><br>")
    attrs = stripText(attrs[0:i])

    i = string.find(attrs, ",")

    if i != -1:
        if format == "":
            format = stripText(attrs[0:i])

        attrs = stripText(attrs[i+1:])
    else:
        format = "LaserDisc"

    # Find Running time
    i = string.find(attrs, ",")

    if i != -1:
        running = stripText(attrs[0:i])
        attrs = stripText(attrs[i+1:])


    # Find remaining attributes
    attrs = attrs + ","
    sound = "Mono"
    date = ""
    attrCount = 0

    while (searchFor(attrs, ",") != None):
        attrCount = attrCount + 1
        i = string.find(attrs, ",")
        attr = stripText(attrs[0:i])
        attrs = searchForPlus(attrs, ",")

        i = string.find(attr, "Closed")

        if i != -1:
            closedCap = "Y"
            continue

        i = string.find(attr, "Wides")

        if i != -1:
            wide = "Y"
            continue

        i = string.find(attr, "Sound")

        if i != -1:
            sound = attr
            continue

        i = string.find(attr, "Color")

        if i != -1:
            color = attr
            continue

        i = string.find(attr, "B&W")

        if i != -1:
            color = attr
            continue

        i = string.find(attr, "Rated")

        if i != -1:
            mpaa = attr

            if mpaa.startswith("Rated") == 1:
                mpaa = stripText(mpaa[5:])

            continue

        if attrCount == 1:
            studio = attr
            continue

        date = attr

    i = string.find(date, "Digitally")

    if i != -1:
        date = ""

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find Director
    i = string.find(source, ">Director:")

    if i != -1:
        source = searchForPlus(source, ">Director:")
        source = searchForPlus(source, "</b>")
        i = string.find(source, "<")
        director = convertAuthor(stripText(source[0:i]))


    # Find Actors
    actorTag = ">Star:"
    i = string.find(source, actorTag)

    if i == -1:
        actorTag = ">Featured:"
        i = string.find(source, actorTag)

    if i == -1:
        actorTag = ">Voice:"
        i = string.find(source, actorTag)

    if i == -1:
        actorTag = ">Actor:"
        i = string.find(source, actorTag)

    if i != -1:
        source = searchForPlus(source, actorTag)
        source = searchForPlus(source, "</b>")
        i = string.find(source, "<")
        actors = " / "  + stripText(source[0:i])
        actorList = []

        while (searchFor(actors, " / ") != None):
            actors = searchForPlus(actors, " / ")
            i = string.find(actors, " / ")

            if (i == -1):
                actor = convertAuthor(actors)
            else:
                actor = convertAuthor(stripText(actors[0:i]))

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]

    # Find Writer
    i = string.find(source, ">Story:")

    if i != -1:
        source2 = searchForPlus(source, ">Story:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        writer = convertAuthor(stripText(source2[0:i]))


    # Find Screenplay, will overwrite with screenwriter
    i = string.find(source, ">Screenplay:")

    if i != -1:
        source2 = searchForPlus(source, ">Screenplay:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        screenwriter = convertAuthor(stripText(source2[0:i]))


    # Find Screenwriter
    i = string.find(source, ">Screen Writer:")

    if i != -1:
        source2 = searchForPlus(source, ">Screen Writer:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        screenwriter = convertAuthor(stripText(source2[0:i]))
    else:
        i = string.find(source, ">Screenwriter:")

        if i != -1:
            source2 = searchForPlus(source, ">Screenwriter:")
            source2 = searchForPlus(source2, "</b>")
            i = string.find(source2, "<")
            screenwriter = convertAuthor(stripText(source2[0:i]))


    # Find Author
    i = string.find(source, ">Book Author:")

    if i != -1:
        source2 = searchForPlus(source, "Book Author:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        author = convertAuthor(stripText(source2[0:i]))


    # Find Director of photography
    i = string.find(source, ">Director of Photography:")

    if i != -1:
        source2 = searchForPlus(source, ">Director of Photography:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        photographer = convertAuthor(stripText(source2[0:i]))


    # Find Composer
    i = string.find(source, ">Music Contributor(s):")

    if i != -1:
        source2 = searchForPlus(source, ">Music Contributor(s):")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        composer = convertAuthor(stripText(source2[0:i]))


    # Find Composer
    i = string.find(source, ">Composer:")

    if i != -1:
        source2 = searchForPlus(source, ">Composer:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        composer = convertAuthor(stripText(source2[0:i]))


    # Find Editor
    i = string.find(source, ">Editor:")

    if i != -1:
        source2 = searchForPlus(source, ">Editor:")
        source2 = searchForPlus(source2, "</b>")
        i = string.find(source2, "<")
        editor = convertAuthor(stripText(source2[0:i]))


    # Find Price
    i = string.find(source, " Price:<")

    if i != -1:
        source = searchForPlus(source, " Price:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find UPC
    source = searchForPlus(source, ">UPC:</B>")
    i = string.find(source, "<")
    upc = stripText(source[0:i])


    #Find Category
    i = string.find(source, ">Shelf Location:<")

    if i != -1:
        source = searchForPlus(source, ">Shelf Location:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])

        i = string.find(category, ", ")

        if i != -1:
            category = stripText(category[0:i])

        category = string.replace(category, "\t", "")
        category = string.replace(category, "\n", "")


    #Find Category
    i = string.find(source, ">Subject:<")

    if i != -1:
        source = searchForPlus(source, ">Subject:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])

        while (searchFor(category, ",") != None):
            i = string.find(category, ",")
            category = stripText(category[0:i]) + " : " + stripText(category[i+1:])


    #Find Ccmments
    i = string.find(source, ">VideoHound")

    if i != -1:
        tempData = searchFor(source, ">VideoHound")
        tempData = searchForPlus(tempData, ">")
        i = string.find(tempData, "<")
        comments = stripText(tempData[0:i])
        tempData = searchForPlus(tempData, ">")
        i = string.find(tempData, "<")
        comments = comments + " " + stripText(tempData[0:i])
    else:
        i = string.find(source, "<B>Description:<")
        comments = ""

        if (i != -1):
            while (searchFor(source, "<B>Description:<") != None):
                source = searchFor(source, "<B>Description:<")
                i = string.find(source, "\n")
                tempcomments = stripText(source[0:i])
                i = string.find(source, "DVD Features:<")

                if (i != -1):
                    tempcomments = stripText(tempcomments[0:i])

                i = string.find(source, "        <")

                if (i != -1):
                    tempcomments = stripText(tempcomments[0:i])

                tempcomments = string.replace(tempcomments, "\n", " ")
                tempcomments = string.replace(tempcomments, "<P><P><UL>", "\n\n")
                tempcomments = string.replace(tempcomments, "<P><P>", "\n\n")
                tempcomments = string.replace(tempcomments, "<p>", "\n\n")
                tempcomments = string.replace(tempcomments, "<P>", "\n\n")
                tempcomments = string.replace(tempcomments, "</P>", "")
                tempcomments = string.replace(tempcomments, "<i>", "")
                tempcomments = string.replace(tempcomments, "</i>", "")
                tempcomments = string.replace(tempcomments, "<I>", "")
                tempcomments = string.replace(tempcomments, "</I>", "")
                tempcomments = string.replace(tempcomments, "<B>", "")
                tempcomments = string.replace(tempcomments, "</B>", "")
                tempcomments = string.replace(tempcomments, "<ul>", "\n")
                tempcomments = string.replace(tempcomments, "<UL>", "\n")
                tempcomments = string.replace(tempcomments, "<li> ", "\n    ")
                tempcomments = string.replace(tempcomments, "<li>", "\n    ")
                tempcomments = string.replace(tempcomments, "<LI> ", "\n    ")
                tempcomments = string.replace(tempcomments, "<LI>", "\n    ")
                tempcomments = string.replace(tempcomments, "</UL>", "\n")
                tempcomments = string.replace(tempcomments, "<br>", "\n")
                tempcomments = string.replace(tempcomments, "<BR>", "\n")
                tempcomments = stripText(tempcomments)

                while (searchFor(tempcomments, "<a ") != None):
                    i = string.find(tempcomments, "<a ")
                    j = string.find(tempcomments[i:], "\">")
                    tempcomments = tempcomments[0:i] + tempcomments[i+j+2:]

                if tempcomments != "Description:":
                    if comments != "":
                        comments = comments + "\n\n" + tempcomments
                    else:
                        comments = comments + tempcomments

                source = source[1:]


    #Find Tracks
    i = string.find(source, ">Table of Contents<")

    if i != -1:
        source = searchForPlus(source, ">Table of Contents<")
        i = string.find(source, "</ol>")
        tracks = stripText(source[0:i])
        trackList = []

        while (searchFor(tracks, "<li>") != None):
            tracks = searchForPlus(tracks, "<li>")
            i = string.find(tracks, "</li>")

            if (i == -1):
                track = tracks
            else:
                track = stripText(tracks[0:i])

            i = string.find(track, "<br>")

            if (i != -1):
                track = stripText(track[0:i])


            trackList.append(track)

        if len(trackList) > 0:
            track1 = trackList[0]

        if len(trackList) > 1:
            track2 = trackList[1]

        if len(trackList) > 2:
            track3 = trackList[2]

        if len(trackList) > 3:
            track4 = trackList[3]

        if len(trackList) > 4:
            track5 = trackList[4]

        if len(trackList) > 5:
            track6 = trackList[5]

        if len(trackList) > 6:
            track7 = trackList[6]

        if len(trackList) > 7:
            track8 = trackList[7]

        if len(trackList) > 8:
            track9 = trackList[8]

        if len(trackList) > 9:
            track10 = trackList[9]

        if len(trackList) > 10:
            track11 = trackList[10]

        if len(trackList) > 11:
            track12 = trackList[11]

        if len(trackList) > 12:
            track13 = trackList[12]

        if len(trackList) > 13:
            track14 = trackList[13]

        if len(trackList) > 14:
            track15 = trackList[14]

        if len(trackList) > 15:
            track16 = trackList[15]

        if len(trackList) > 16:
            track17 = trackList[16]

        if len(trackList) > 17:
            track18 = trackList[17]

        if len(trackList) > 18:
            track19 = trackList[18]

        if len(trackList) > 19:
            track20 = trackList[19]



try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
