# Barpoint scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Image
    i = string.find(source, "*THE PRODUCT IMAGE IS DISPLAYED HERE")

    if i != -1:
        source = searchForPlus(source, "*THE PRODUCT IMAGE IS DISPLAYED HERE")
        source = searchForPlus(source, "src='")
        i = string.find(source, "'")
        image = stripText(source[0:i])

        if string.find(source, "Movies_default") != -1:
            image = ""

        if string.find(source, "Music_default") != -1:
            image = ""


    # Find Price
    i = string.find(source, ">Price:")

    if i != -1:
        source = searchForPlus(source, ">Price:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        value = stripText(source[0:i])
    else:
        i = string.find(source, ">Price Range:<")

        if i != -1:
            source = searchForPlus(source, ">Price Range:<")
            source = searchForPlus(source, "\">")
            i = string.find(source, " - ")
            value = stripText(source[0:i])
        else:
            i = string.find(source, ">List:<")

            if i != -1:
                source = searchForPlus(source, ">List:<")
                source = searchForPlus(source, "\">")
                i = string.find(source, "<")
                value = stripText(source[0:i])

            i = string.find(source, ">List Price:<")

            if i != -1:
                source = searchForPlus(source, ">List Price:<")
                source = searchForPlus(source, "\">")
                i = string.find(source, "<")
                value = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "*THE PRODUCT DESCRIPTION IS DISPLAYED HERE")
    source = searchForPlus(source, "'>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format<")

    if i != -1:
        source = searchForPlus(source, ">Format<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Director
    i = string.find(source, ">Directed by<")

    if i != -1:
        source = searchForPlus(source, ">Directed by<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        director = stripText(source[0:i])

        i = string.rfind(director, " ")

        if (i != -1):
            director = stripText(director[i+1:]) + ", " + stripText(director[0:i])


    # Find Actors
    i = string.find(source, ">Starring<")

    if i != -1:
        source = searchForPlus(source, ">Starring<")
        i = string.find(source, "<b>")
        actors = stripText(source[0:i])
        actorList = []

        while (searchFor(actors, "href=") != None):
            actors = searchForPlus(actors, "href=")
            actor = searchForPlus(actors, ">")
            i = string.find(actor, "<")
            actor = stripText(actor[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i+1:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Copyright date
    i = string.find(source, "Original release")

    if i != -1:
        source = searchForPlus(source, "Original release")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])


    # Find release date
    i = string.find(source, ">Date of release<")

    if i != -1:
        source = searchForPlus(source, ">Date of release<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "-")

            if i != -1:
                date = stripText(date[i+1:])


    # Find MPAA Rating
    i = string.find(source, ">Rating<")

    if i != -1:
        source = searchForPlus(source, ">Rating<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])


    # Find Categories
    i = string.find(source, ">Category<")

    if i != -1:
        source = searchForPlus(source, ">Category<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        category = stripText(source[0:i])

        while (searchFor(category, ",") != None):
            i = string.find(category, ",")
            category = stripText(category[0:i]) + " : " + stripText(category[i+1:])


    # Find Comments
    i = string.find(source, "Description<")

    if i != -1:
        source = searchForPlus(source, "Description<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        comments = stripText(source[0:i])
    else:
        i = string.find(source, "<span class='body'>")

        if i != -1:
            source = searchForPlus(source, "<span class='body'>")
            source = searchForPlus(source, "<br><br>")
            i = string.find(source, "<")
            comments = stripText(source[0:i])


    # Find Running time
    i = string.find(source, ">RUN TIME<")

    if i != -1:
        source = searchForPlus(source, ">RUN TIME<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        running = stripText(source[0:i])


    # Find Studio
    i = string.find(source, ">RELEASE COMPANY NAME<")

    if i != -1:
        source = searchForPlus(source, ">RELEASE COMPANY NAME<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        studio = stripText(source[0:i])
    else:
        i = string.find(source, ">Manufacturer Information<")

        if i != -1:
            source = searchForPlus(source, ">Manufacturer Information<")
            source = searchForPlus(source, "<hr>")
            i = string.find(source, "<")
            studio = stripText(source[0:i])


    # Find Color
    i = string.find(source, ">COLOR<")

    if i != -1:
        source = searchForPlus(source, ">COLOR<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        color = stripText(source[0:i])


    # Find Director
    i = string.find(source, "\tDirected by")

    if i != -1:
        source = searchForPlus(source, "Directed by")
        source = searchForPlus(source, "HREF=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        director = stripText(source[0:i])

        i = string.rfind(director, " ")

        if (i != -1):
            director = stripText(director[i+1:]) + ", " + stripText(director[0:i])


    # Find Sound
    i = string.find(source, ">Sound:")

    if i != -1:
        source = searchForPlus(source, ">Sound:")
        i = string.find(source, "<")
        sound = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
