# Amazon video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find marketplace pricing
    marketinfo = source

    # Find List Price
    listprice = ""
    i = string.find(marketinfo, ">List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">List Price:")
        listprice = searchForPlus(listprice, "\">")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    source = searchForPlus(source, "<!-- Begin Page Data -->")

    # Find Title
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    i = string.find(source, "thumb")

    if (i != -1):
        source = searchForPlus(source, "thumb")
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Crazy Price:")

    if (i == -1):
        i = string.find(source, ">List Price:")

    if (i != -1):
        source = source[i:]

        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:")

    if i != -1:
        source = searchForPlus(source, ">Format:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Running time
    i = string.find(source, ">Running Time:")

    if i != -1:
        source = searchForPlus(source, ">Running Time:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        running = stripText(source[0:i])


    # Find Rating
    i = string.find(source, ">Rating:")

    if i != -1:
        source = searchForPlus(source, ">Rating:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        mpaa = stripText(source[0:i])

        i = string.find(mpaa, ")&nbsp;(")

        if (i != -1):
            mpaa = stripText(mpaa[0:i+1])


    # Find Director
    i = string.find(source, ">Director:")

    if i != -1:
        source = searchForPlus(source, ">Director:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</font>")
        director = stripText(source[0:i])
        i = string.find(director, "<a href")

        if i != -1:
            director = searchForPlus(director, ">")
            i = string.find(director, "<")
            director = stripText(director[0:i])

            i = string.rfind(director, " ")

            if (i != -1):
                director = stripText(director[i:]) + ", " + stripText(director[0:i])



    # Find Actors
    i = string.find(source, ">Starring:")

    if i != -1:
        source = searchForPlus(source, ">Starring:")
        source = searchForPlus(source, "<font ")
        i = string.find(source, "</font>")
        actors = stripText(source[0:i])
        actors = searchForPlus(actors, "\">")
        actors = actors + ">,<"
        actorList = []

        while (searchFor(actors, ">,<") != None):
            print "ACTORS=",actors
            i = string.find(actors, ">,<")
            actor = stripText(actors[0:i])
            i = string.find(actor, "<a href")

            if i != -1:
                actor = searchForPlus(actor, ">")
                i = string.find(actor, "<")
                actor = stripText(actor[0:i])

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

            actors = searchForPlus(actors, ">,")

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Category
    i = string.find(source, ">Category:")

    if i != -1:
        source = searchForPlus(source, ">Category:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find UPC
    i = string.find(source, ">UPC:")

    if i != -1:
        source = searchForPlus(source, ">UPC:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
