# abby scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,actor1,actor2,actor3,actor4,actor5,actor6
    global actor7,actor8,actor9,actor10,director,writer
    global screenwriter,photographer,composer,editor,series
    global upc,isbn,lccn,dewey,userNumber,format,studio,place
    global date,copyDate,mpaa,wide,closedCap,sound,copies
    global rating,condition,category,viewed,pflag,eflag,value
    global valueDate,comments,dateEntered,dataSource,cart,ordered
    global copies,location,keywords,book,author,running,color
    global track1,track2,track3,track4,track5
    global track6,track7,track8,track9,track10
    global track11,track12,track13,track14,track15
    global track16,track17,track18,track19,track20
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source

    # No place extraction default to US
    # place = "United States"


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    color               = "Color"
    sound               = "Mono"
    wide                = "N"
    closedCap           = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">Price<")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">Price<")

        i = string.find(marketinfo, "<STRIKE>")

        if (i != -1):
            listprice = searchForPlus(marketinfo, "<STRIKE>")
            listprice = searchFor(listprice, "$")
            i = string.find(listprice, "<")
            listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Title
    source = searchForPlus(source, "<!-- artist_video_item -->")
    source = searchForPlus(source, "<I>")
    i = string.find(source, "<")
    title = stripHTML(source[0:i])


    # Find Format
    i = string.find(source, "img/attrib/dvd.gif")

    if i != -1:
        format = "DVD"

    i = string.find(source, "img/attrib/vhs.gif")

    if i != -1:
        format = "VHS"


    # Find Rating
    i = string.find(source, ">RATED ")

    if i != -1:
        source = searchFor(source, ">RATED ")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        mpaa = stripHTML(source[0:i])

        i = string.find(source, " - ")

        if i != -1:
            mpaa = stripHTML(mpaa[0:i])



    # Find Image
    i = string.find(source, "img.cgi")

    if i != -1:
        source = searchForPlus(source, "img.cgi")
        source = searchForPlus(source, " SRC=\"")
        i = string.find(source, "\"")
        image = stripHTML(source[0:i])


    # Find Category
    i = string.find(source, ">Genre<")

    if i != -1:
        source = searchForPlus(source, ">Genre<")
        source = searchForPlus(source, "a=browse")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Actors
    i = string.find(source, ">Actor<")

    if i != -1:
        source = searchForPlus(source, ">Actor<")
        source = searchForPlus(source, "HREF=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        actors = stripText(source[0:i]) + "/"
        actorList = []

        while (searchFor(actors, "/") != None):
            i = string.find(actors, "/")
            actor = stripText(actors[0:i])
            actors = searchForPlus(actors, "/")

            i = string.rfind(actor, " ")

            if (i != -1):
                actor = stripText(actor[i+1:]) + ", " + stripText(actor[0:i])

            actorList.append(actor)

        if len(actorList) > 0:
            actor1 = actorList[0]

        if len(actorList) > 1:
            actor2 = actorList[1]

        if len(actorList) > 2:
            actor3 = actorList[2]

        if len(actorList) > 3:
            actor4 = actorList[3]

        if len(actorList) > 4:
            actor5 = actorList[4]

        if len(actorList) > 5:
            actor6 = actorList[5]

        if len(actorList) > 6:
            actor7 = actorList[6]

        if len(actorList) > 7:
            actor8 = actorList[7]

        if len(actorList) > 8:
            actor9 = actorList[8]

        if len(actorList) > 9:
            actor10 = actorList[9]


    # Find Release date
    i = string.find(source, ">Release<")

    if i != -1:
        source = searchForPlus(source, ">Release<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        date = stripText(source[0:i])


    # Find Studio
    i = string.find(source, ">Vendor<")

    if i != -1:
        source = searchForPlus(source, ">Vendor<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        studio = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Price<")

    if i != -1:
        source = searchForPlus(source, ">Price<")
        source = searchForPlus(source, "#FF0000")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Running time
    i = string.find(source, "RUNNING TIME:")

    if i != -1:
        source = searchForPlus(source, "RUNNING TIME:")
        i = string.find(source, "<")
        running = stripText(source[0:i])


   # Find Sound
    i = string.find(source, "img/attrib/dts.gif")

    if i != -1:
        sound = "DTS Sound"

    i = string.find(source, "img/attrib/dolby.gif")

    if i != -1:
        sound = "Dolby Digital 5.1"


   # Find Closed Cap
    i = string.find(source, "img/attrib/cc.gif")

    if i != -1:
        closedCap = "Y"


   # Find Widescreen
    i = string.find(source, ">Letter Box")

    if i != -1:
        wide = "Y"


   # Find UPC
    i = string.find(source, ">UPC")

    if i != -1:
        source = searchForPlus(source, ">UPC")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/vwuserexit.py"):
        execfile("scrapers/vwuserexit.py") in globals()
