# scrapers support functions
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  string


def searchFor(str, key):
    i = string.find(str, key)

    if i != -1:
        return str[i:]

    key = string.upper(key)

    if i != -1:
        return str[i:]

    return None


def searchForPlus(str, key):
    i = string.find(str, key)

    if i != -1:
        return str[i + len(key):]

    key = string.upper(key)
    i = string.find(str, key)

    if i != -1:
        return str[i + len(key):]

    return None


def stripText(str):
    return string.strip(str)


def stripNewLines(str):
    str = string.replace(str, "\n", " ")
    return string.strip(str)


def stripHTML(str):
    str = string.replace(str, "<B>", "")
    str = string.replace(str, "</B>", "")
    str = string.replace(str, "<b>", "")
    str = string.replace(str, "</b>", "")
    str = string.replace(str, "&nbsp;", " ")
    str = string.replace(str, "&quot;", "\"")
    str = string.replace(str, "&amp;", "&")
    str = string.replace(str, "<br>", "")
    return string.strip(str)


def stripTelnetCodes(str):
    str = string.replace(str, "\x00", " ")
    str = string.replace(str, "\x1a", " ")
    str = string.replace(str, "\x17", " ")
    str = string.replace(str, "\x7c", " ")
    return string.strip(str)


def getTelnetLine(str):
    i = string.find(str, "\n")
    retstr = string.strip(str[0:i])
    remstr = str[i+1:]
    while (string.find(remstr, "\n") != -1):
        i = string.find(remstr, "\n")

        if (i != -1):
            nextline = string.strip(remstr[0:i])
            remstr = remstr[i+1:]
            nextline = stripTelnetCodes(nextline)

            if (string.find(string.digits, nextline[0:1]) == -1):
                if (string.find(string.digits, nextline[1:2]) == -1):
                    if (string.find(string.digits, nextline[2:3]) == -1):
                        retstr = retstr + " " + nextline
                        continue

        break
    return retstr


def calcISBN10CheckDigit(isbn):
    if len(isbn) != 9:
        return isbn

    if not isbn.isdigit():
        return isbn

    i = 0
    total = 0

    while i < 9: 
        value = int(isbn[i:i+1])  
        total = total + (value * (10 - i))
        i = i + 1

    checkDigit = 11 - (total % 11);

    if checkDigit == 11:
        checkDigit = 0;

    if checkDigit == 10:
        checkDigit = "X"

    return str(isbn) + str(checkDigit)


def calcISBN13CheckDigit(isbn):
    if len(isbn) != 12:
        return isbn

    if not isbn.isdigit():
        return isbn

    odd = int(isbn[0:1]) + int(isbn[2:3]) + int(isbn[4:5]) + int(isbn[6:7]) + int(isbn[8:9]) + int(isbn[10:11])

    even = int(isbn[1:2]) + int(isbn[3:4]) + int(isbn[5:6]) + int(isbn[7:8]) + int(isbn[9:10])  + int(isbn[11:12])
    even = even * 3

    both = odd + even
    remainder = both % 10

    if remainder == 0:
        return isbn + "0"

    return isbn + str(10 - remainder)


def calcUPCCheckDigit(upc):
    if len(upc) > 11:
        return upc

    if not upc.isdigit():
        return upc

    while len(upc) < 11:
        upc = "0" + upc

    odd = int(upc[0:1]) + int(upc [2:3]) + int(upc[4:5]) + int(upc[6:7]) + int(upc[8:9]) + int(upc [10:11])
    odd = odd * 3

    even = int(upc[1:2]) + int(upc [3:4]) + int(upc[5:6]) + int(upc[7:8]) + int(upc[9:10])

    both = odd + even
    digit = both

    while (digit % 10) != 0:
        digit = digit + 1

    return upc + str(digit - both)


# Convert author, "Bill Martin" -> "Martin, Bill"
#
def convertAuthor(author):
    suffix = ""

    if author.endswith(" Inc.") == 1:
        return author

    if author.endswith(" Inc") == 1:
        return author

    if string.find(author, ", ") != -1:
        return author

    if author.endswith(" Jr.") == 1:
        suffix = " Jr."
        i = string.find(author, " Jr.")
        author = stripText(author[0:i])

    if author.endswith(" Sr.") == 1:
        suffix = " Sr."
        i = string.find(author, " Sr.")
        author = stripText(author[0:i])

    if author.endswith(" III") == 1:
        suffix = " III"
        i = string.find(author, " III")
        author = stripText(author[0:i])

    if author.endswith(" II") == 1:
        suffix = " II"
        i = string.find(author, " II")
        author = stripText(author[0:i])

    i = string.rfind(author, " ")

    if i != -1:
        author = stripText(author[i:]) + suffix + ", " + stripText(author[0:i])

    return author


# Convert artist name, "The Artist" -> "Artist, The"
#
def convertArtist(artist):
    if artist[0:4] == "The ":
        artist = stripText(artist[4:] + ", The")

    return artist


# Get composer from track level is album level empty.
#
def convertComposer(albumComposer, trackComposer):
    if albumComposer != None and albumComposer != "":
        return albumComposer

    albumComposer = ""

    for composer in trackComposer:
        composer = stripText(composer[6:])
        i = string.find(albumComposer, composer)

        if i == -1:
            albumComposer = albumComposer + " / " + composer

    if albumComposer.startswith(" / ") == 1:
        albumComposer = stripText(albumComposer[3:])

    return albumComposer


def replaceHTML(str):
    str = string.replace(str, "&copy;", "")
    str = string.replace(str, "&lt;", "<")
    str = string.replace(str, "&gt;", ">")
    str = string.replace(str, "&amp;", "&")
    str = string.replace(str, "&quot;", "\"")
    str = string.replace(str, "&auml;", "\344")
    str = string.replace(str, "&ouml;", "\366")
    str = string.replace(str, "&uuml;", "\374")
    str = string.replace(str, "&Auml;", "\304")
    str = string.replace(str, "&Ouml;", "\326")
    str = string.replace(str, "&Uuml;", "\334")
    str = string.replace(str, "&euro;", "\200")
    str = string.replace(str, "&szlig;", "\337")
    str = string.replace(str, "&laquo;", "\253")
    str = string.replace(str, "&raquo;", "\273")
    str = string.replace(str, "&#46;", ".")
    str = string.replace(str, "&#130;", "")
    str = string.replace(str, "&#132;", "")
    str = string.replace(str, "&#146;", "'")
    str = string.replace(str, "&#147;", "")
    str = string.replace(str, "&#150;", "-")
    str = string.replace(str, "&#169;", "")
    str = string.replace(str, "&#171;", "\253")
    str = string.replace(str, "&#174;", "\256")
    str = string.replace(str, "&#187;", "\273")
    str = string.replace(str, "&#191;", "\277")
    str = string.replace(str, "&#196;", "\304")
    str = string.replace(str, "&#214;", "\326")
    str = string.replace(str, "&#220;", "\334")
    str = string.replace(str, "&#223;", "\337")
    str = string.replace(str, "&#228;", "\344")
    str = string.replace(str, "&#246;", "\366")
    str = string.replace(str, "&#252;", "\374")
    str = string.replace(str, "&#8211;", "-")
    str = string.replace(str, "&#8212;", "-")
    str = string.replace(str, "&#8217;", "'")
    str = string.replace(str, "&#8220;", "\"")
    str = string.replace(str, "&#8221;", "\"")
    str = string.replace(str, "&#8230;", "...")
    str = string.replace(str, "ü", "\374")
    str = string.replace(str, "ö", "\366")
    str = string.replace(str, "ä", "\344")
    return string.strip(str)


def replaceURL(str):
    str = string.replace(str, "%E4", "\344")
    str = string.replace(str, "%e4", "\344")
    str = string.replace(str, "%F6", "\366")
    str = string.replace(str, "%f6", "\366")
    str = string.replace(str, "%FC", "\374")
    str = string.replace(str, "%fc", "\374")
    str = string.replace(str, "%C4", "\304")
    str = string.replace(str, "%c4", "\304")
    str = string.replace(str, "%D6", "\326")
    str = string.replace(str, "%d6", "\326")
    str = string.replace(str, "%DC", "\334")
    str = string.replace(str, "%dc", "\334")
    str = string.replace(str, "%DF", "\337")
    str = string.replace(str, "%df", "\337")
    return string.strip(str)



