# amazon.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import calcISBN10CheckDigit
from    scrapers.scrapers import convertAuthor
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    i = string.find(source, "<!-- Start Of Search Results -->")

    if i != -1:
        # Search results, get detail
        source = searchForPlus(source, "<!-- Start Of Search Results -->")
        source = searchForPlus(source, "href=\"")
        i = string.find(source, "\"")
        source = stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(source)
        t = open("trace.html", "w")
        t.write(source)
        t.close()



    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List price:")

    if i != -1:
        listprice = searchForPlus(marketinfo, "List price:")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    source = searchForPlus(source, "class=\"product-pane\"")


    # Find Image
    i = string.find(source, "class=\"image\"")

    if i != -1:
        source = searchForPlus(source, "class=\"image\"")
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "noimage.gif")

        if i != -1:
            image = ""


    # Find Title
    source = searchForPlus(source, "class=\"content\"")
    source = searchForPlus(source, "<h1>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    authorList = []
    i = string.find(source, ":doAuthorSearch")

    if i != -1:
        source = searchForPlus(source, ":doAuthorSearch")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        author = stripText(source[0:i])

        i = string.rfind(author, " ")

        if i != -1:
            author = stripText(author[i:]) + ", " + stripText(author[0:i])

        authorList.append(author)


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]

    if title != "" and len(authorList) == 0:
        author = "No Author"


    # Find Price
    i = string.find(source, "class=\"price\"")

    if i != -1:
        source = searchForPlus(source, "class=\"price\"")
        source = searchFor(source, "&pound;")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "class=\"plinth\"")

    if i != -1:
        source = searchForPlus(source, "class=\"plinth\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<div class=\"toolbar\"")
        comments = stripText(source[0:i])

        i = string.find(comments, "<h2>Bookseller review</h2>")

        if i != -1:
            comments = stripText(comments[0:i])

        while (searchFor(comments, "<div") != None):
            i = string.find(comments, "<div")
            j = string.find(comments[i:], ">")
            comments = comments[0:i] + comments[i+j+1:]

        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "\r", "")

        while (searchFor(comments, "\t<h") != None):
            i = string.find(comments, "\t<h")
            comments = comments[0:i] + comments[i+1:]

        comments = string.replace(comments, "\t", "    ")
        comments = string.replace(comments, "</div>", "")
        comments = string.replace(comments, "<hr />", "")
        comments = string.replace(comments, "<h2>", "")
        comments = string.replace(comments, "</h2>", "")
        comments = string.replace(comments, "<h3>", "\n")
        comments = string.replace(comments, "</h3>", "")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "</p>", "\n\n")
        comments = string.replace(comments, "&#8216;", "'")
        comments = string.replace(comments, "&#8217;;", "'")


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        format = stripText(source[0:i])

        # Find Pages
        if format.endswith(" pages") == 1:
            i = string.rfind(format, "pages")
            format = stripText(format[0:i])
            i = string.rfind(format, " ")
            pages = stripText(format[i:])
            format = stripText(format[0:i])


    # Find Publication date
    i = string.find(source, ">Date of publication:<")

    if i != -1:
        source = searchForPlus(source, ">Date of publication:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Publisher
    i = string.find(source, ">Publisher:<")

    if i != -1:
        source = searchForPlus(source, ">Publisher:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        publisher = stripText(source[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN:")

    if i != -1:
        source = searchForPlus(source, ">ISBN:")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])

        if isbn.startswith("978") == 1:
            isbn = isbn[3:]
            isbn = stripText(isbn[0:len(isbn)-1])
            isbn = calcISBN10CheckDigit(isbn)


    # Find Category
    i = string.find(source, "class=\"similar-products\"")

    if i != -1:
        source = searchForPlus(source, "class=\"similar-products\"")
        i = string.find(source, "</div>")
        categories = stripText(source[0:i])

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            categories = searchForPlus(categories, ">")
            i = string.find(categories, "<")
            temp = stripText(categories[0:i])

            if (category != ""):
                category = category + " : "

            category = category + temp



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
