# Libris scraper


import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import calcISBN10CheckDigit
from    scrapers.scrapers import calcISBN13CheckDigit
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # 10 digit ISBN search failed?
    i = string.find(source, ">Your search found no results.")

    if i != -1:
        source = searchForPlus(source, ">Your search found no results.")
        source = searchForPlus(source, "ISBN/ISSN etc.")
        source = searchForPlus(source, "value=\"")
        i = string.find(source, "\"")
        isbn13 = stripText(source[0:i])

        if len(isbn13) == 10:
            isbn13 = "978" + isbn13[0:9]
            isbn13 = calcISBN13CheckDigit(isbn13)

            url = "http://websok.libris.kb.se/websearch/search?SEARCH_NUMM=" + isbn13 + "&lang=eng"
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            source = http.getContents(url)
            t2 = open("trace2.html", "w")
            t2.write(source)
            t2.close()


    # Find author
    i = string.find(source, "author:&nbsp;")

    if i != -1:
        source = searchForPlus(source, "author:&nbsp;")
        source = searchForPlus(source, "<a href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        author = stripText(source[0:i])
    else:
        i = string.find(source, ">contributor:&nbsp;")

        if i != -1:
            author = searchForPlus(source, ">contributor:&nbsp;")
            author = searchForPlus(author, "<a href=")
            author = searchForPlus(author, ">")
            i = string.find(author, "<")
            author = stripText(author[0:i])


    # Find title
    source = searchForPlus(source, "title:&nbsp;")
    source = searchForPlus(source, "small\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find publisher
    i = string.find(source, "publisher/place of publication:&nbsp;")

    if i != -1:
        source = searchForPlus(source, "publisher/place of publication:&nbsp;")
        source = searchForPlus(source, "small\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        publisher = stripText(source[0:i])

        i = string.find(publisher, " : ")

        if i != -1:
            place = stripText(publisher[0:i])
            publisher = stripText(publisher[i+2:])

        i = string.rfind(publisher, ", ")

        if i != -1:
            date = stripText(publisher[i+1:])
            publisher = stripText(publisher[0:i])

            i = string.find(date, " (")

            if i != -1:
                date = stripText(date[0:i])


    # Find isbn
    i = string.find(source, "&nbsp;ISBN:&nbsp;")

    if i != -1:
        source = searchForPlus(source, "&nbsp;ISBN:&nbsp;")
        source = searchForPlus(source, "small\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])
        isbn = string.replace(isbn, "-", "")

        i = string.find(isbn, " (")

        if i != -1:
            isbn = stripText(isbn[0:i])
        
        if isbn.startswith("978") == 1:
            isbn = isbn[3:]
            isbn = stripText(isbn[0:len(isbn)-1])
            isbn = calcISBN10CheckDigit(isbn)


    





try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()

     


    
