# Libro, Archivos y Bibliotecas scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines
from    scrapers.scrapers import calcISBN13CheckDigit


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"

    # 10 digit ISBN search failed?
    i = string.find(source, "ERROR (205-0)")

    if i != -1:
        source = searchForPlus(source, "ERROR (205-0)")
        source = searchForPlus(source, "Consulta:")
        source = searchForPlus(source, "[(")
        i = string.find(source, ")")
        isbn13 = stripText(source[0:i])

        if len(isbn13) == 10:
            isbn13 = "978" + isbn13[0:9]
            isbn13 = calcISBN13CheckDigit(isbn13)

            url = "http://www.mcu.es/cgi-brs/BasesHTML/isbn/BRSCGI?CMD=VERLST&BASE=ISBN&DOCS=1-15&CONF=AEISPA.cnf&OPDEF=AND&SEPARADOR=&WDIS-C=%28DISPONIBLE+or+AGOTADO%29&WGEN-C=&WISB-C=" + isbn13 + "&WAUT-C=&WTIT-C=&WMAT-C=&WEDI-C=&WFEP-C=&%40T353-GE=&%40T353-LE=&WSER-C=&WLUG-C=&WLEN-C=&WCLA-C=&WSOP-C="
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            source = http.getContents(url)
            t2 = open("trace2.html", "w")
            t2.write(source)
            t2.close()

    # Get detail page is necessary
    i = string.find(source, ">Resultados <strong>")

    if i != -1:
        source = searchForPlus(source, ">Resultados <strong>")
        source = searchForPlus(source, "ISBN (")
        source = searchForPlus(source, " HREF=\"")
        i = string.find(source, "\"")
        url = "http://www.mcu.es" + stripText(source[0:i])
        url = string.replace(url, " ", "%20")
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t2 = open("trace3.html", "w")
        t2.write(source)
        t2.close()


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    source = searchForPlus(source, "class=\"cabInfAd\"")


    # Find ISBN
    i = string.find(source, "ISBN (10):")

    if i != -1:
        source = searchForPlus(source, "ISBN (10):")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])
        isbn = string.replace(isbn, "-", "")
        i = string.find(isbn, "&nbsp;")

        if i != -1:
            isbn = stripText(isbn[0:i])


    # Find Title
    source = searchForPlus(source, "tulo:")
    source = searchForPlus(source, "<strong>")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.find(title, "\n: ")

    if i != -1:
        title = stripText(title[0:i]) + " " + stripText(title[i+3:])

    title = string.replace(title, "\n", " ")
    title = string.replace(title, "\t", " ")

    while (searchFor(title, "  ") != None):
        i = string.find(title, "  ")
        title = title[0:i] + title[i+1:]


    # Find Author
    author = ""
    i = string.find(source, "Autor:")

    if i != -1:
        authorList = []
        source = searchFor(source, "Autor:")
        i = string.find(source, "</td></tr>")
        authors = stripText(source[0:i])

        while (searchFor(authors, "HREF=\"") != None):
            authors = searchForPlus(authors, "HREF=\"")
            authors = searchForPlus(authors, "\">")
            i = string.find(authors, "<")
            author = stripText(authors[0:i])

            if author.startswith("[") == 1:
                author = stripText(author[1:])
                i = string.find(author, "]")

                if i != -1:
                    author = stripText(author[0:i] + author[i+1:]) 

            authorList.append(author)


        if len(authorList) > 0:
            author = authorList[0]

        if len(authorList) > 1:
            author2 = authorList[1]

        if len(authorList) > 2:
            author3 = authorList[2]

        if len(authorList) > 3:
            author4 = authorList[3]

        if len(authorList) > 4:
            author5 = authorList[4]

        if len(authorList) > 5:
            author6 = authorList[5]

    if author == "":
        author = "No Author"


    # Find Publisher / Place / Date
    i = string.find(source, ">Publicaci")

    if i != -1:
        source = searchForPlus(source, ">Publicaci")
        source = searchForPlus(source, "<span>")
        i = string.find(source, "</span>")
        publisher = stripText(source[0:i])
        i = string.find(publisher, "<A ")

        if i != -1:
            j = string.find(publisher[i:], ">")
            publisher = publisher[0:i] + publisher[i+j+1:]
            publisher = string.replace(publisher, "</A>", "")

        i = string.find(publisher, ",&nbsp;")

        if i != -1:
            date = stripText(publisher[i+7:])
            publisher = stripHTML(publisher[0:i])

            i = string.find(date, "<")

            if i != -1: 
                date = stripText(date[0:i])

            if fullDateFormat == "false":
                i = string.rfind(date, "/")

                if i != -1:
                    date = stripText(date[i+1:])

        i = string.find(publisher, ".\n")

        if i != -1:
            place = stripText(publisher[0:i])
            publisher = stripText(publisher[i+2:])

        i = string.find(publisher, "&nbsp;:")

        if i != -1:
            place = stripText(publisher[0:i])
            publisher = stripText(publisher[i+7:])

        i = string.find(publisher, "<")

        if i != -1: 
            publisher = stripText(publisher[0:i])

        i = string.find(place, "<")

        if i != -1: 
            place = stripText(place[0:i])


    # Find Page / Dimensions
    i = string.find(source, ">Descripc")

    if i != -1:
        source = searchForPlus(source, ">Descripc")
        source = searchForPlus(source, "<span>")
        i = string.find(source, "</span>")
        pages = stripText(source[0:i])

        i = string.find(pages, " ; ")

        if i != -1:
            dimensions = stripText(pages[i+2:])
            pages = stripHTML(pages[0:i])

        if pages.endswith("v.") == 1:
            pages = ""

        i = string.find(pages, " ")

        if i != -1:
            pages = stripText(pages[0:i])


    # Find Format
    i = string.find(source, ">Encuadernac")

    if i != -1:
        source = searchForPlus(source, ">Encuadernac")
        source = searchForPlus(source, "<span>")
        i = string.find(source, "</span>")
        format = stripText(source[0:i])


    # Find Value
    i = string.find(source, "Precio:")

    if i != -1:
        source = searchForPlus(source, "Precio:")
        source = searchForPlus(source, "<span>")
        i = string.find(source, "<")
        value = stripText(source[0:i])
        value = string.replace(value, "&euro;", "")


    # Find Category
    i = string.find(source, "Materias:")

    if i != -1:
        source = searchForPlus(source, "Materias:")
        source = searchForPlus(source, "<span>")
        i = string.find(source, "</span>")
        category = stripText(source[0:i])

        if category.startswith("<A ") == 1:
            category = searchForPlus(category, ">")    
            i = string.find(category, "<")
            category = stripText(category[0:i])





try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
