# Genealogyinprint.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction


    # Find Image
    i = string.find(source, "images/full/")

    if i != -1:
        source = stripText(source[i-50:])
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = "http://www.genealogyinprint.com" + stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "class=\"PM_large\">")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    i = string.find(source, "class=\"PM_default\">")

    if i != -1:
        source = searchForPlus(source, "class=\"PM_default\">")
        i = string.find(source, "<")
        author = stripText(source[0:i])
    else:
        author = "No Author"


    # Find Price
    i = string.find(source, ">Price:<")

    if i != -1:
        source = searchForPlus(source, ">Price:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "<br clear=\"left\"/>")

    if i != -1:
        source = searchForPlus(source, "<br clear=\"left\"/>")
        i = string.find(source, "<br clear=\"left\"/>")
        comments = stripText(source[0:i])

        comments = string.replace(comments, "<br />", "\n")
        comments = string.replace(comments, "\227", "-")
        comments = string.replace(comments, "&reg;", "")


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN Number:<")

    if i != -1:
        isbn = searchForPlus(source, ">ISBN Number:<")
        isbn = searchForPlus(isbn, "<td>")
        i = string.find(isbn, "<")
        isbn = stripText(isbn[0:i])


    # Find Pages
    i = string.find(source, ">Pages:<")

    if i != -1:
        pages = searchForPlus(source, ">Pages:<")
        pages = searchForPlus(pages, "<td>")
        i = string.find(pages, "<")
        pages = stripText(pages[0:i])


    # Find Publication/Copyright Date
    i = string.find(source, ">Published:<")

    if i != -1:
        date = searchForPlus(source, ">Published:<")
        date = searchForPlus(date, "<td>")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if date == "0":
            date = ""

        copyDate = date


    # Find Publication Date
    i = string.find(source, ">Re-Printed:<")

    if i != -1:
        date2 = searchForPlus(source, ">Re-Printed:<")
        date2 = searchForPlus(date2, "<td>")
        i = string.find(date2, "<")
        date2 = stripText(date2[0:i])

        if date2 == "0":
            date2 = ""

        if date2 != "":
            date = date2




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
