# Fictionwise.com eBook scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    format              = "eBook"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Find List price
    i = string.find(marketinfo, ">List&nbsp;Price:")

    if i != -1:
        listprice = marketinfo[i:]
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "</")
        listprice = stripText(listprice[0:i])
        listprice = string.replace(listprice, "<strike>", "")


    # Main extraction
    i = string.find(source, " size=3>")

    if i == -1:
        return;


    # Find Image
    i = string.find(source, "javascript:display")

    if i != -1:
        image = searchForPlus(source, "javascript:display")
        image = searchForPlus(image, "'")
        i = string.find(image, "'")
        image = stripText(image[0:i])
        image = string.replace(image, "big_{", "%7B")
        image = string.replace(image, "big_", "")
        image = string.replace(image, "}", "%7D")
        image = "http://www.fictionwise.com/mindwise/books/" + image

    # Find Title
    source = searchForPlus(source, " size=3>")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.rfind(title, "[")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Author(s)
    authorList = []

    i = string.find(source, " by ")

    if i != -1:
        source = searchForPlus(source, " by ")
        i = string.find(source, "</font>")
        authors = stripText(source[0:i])

        while (searchFor(authors, "<a ") != None):
            authors = searchForPlus(authors, "<a ")
            authors = searchForPlus(authors, "\">")
            i = string.find(authors, "<")
            author = stripText(authors[0:i])
            i = string.rfind(author, " ")

            if (i != -1):
                author = stripText(author[i+1:]) + ", " + stripText(author[0:i])

            authorList.append(author)


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Price
    i = string.find(source, ">You Pay:")

    if i != -1:
        source = source[i:]
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">eBook Category:")

    if i != -1:
        categories = searchForPlus(source, ">eBook Category:")
        i = string.find(categories, "<font")
        categories = stripText(categories[0:i])

        category = ""

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            temp = searchForPlus(categories, "\">")
            i = string.find(temp, "<")
            temp = stripText(temp[0:i])

            if (category != ""):
                category = category + " / "

            category = category + temp


    # Find Comments
    comments = ""
    i = string.find(source, ">eBook Description:")

    if (i != -1):
        source = searchForPlus(source, ">eBook Description:")
        i = string.find(source, "<br>")
        comments = stripText(source[0:i])

        while (searchFor(comments, "\">") != None):
            comments = searchForPlus(comments, "\">")
            
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<NOBR>", "")
        comments = string.replace(comments, "</NOBR>", "")


    # Find Publisher
    i = string.find(source, ">Publisher:")

    if i != -1:
        publisher = searchForPlus(source, ">Publisher:")
        publisher = searchForPlus(publisher, ">")
        i = string.find(publisher, "<")
        publisher = stripText(publisher[0:i])

        if publisher.endswith(","):
            i = string.rfind(publisher, ",")
            publisher = stripText(publisher[0:i])


    # Find Publication Date
    i = string.find(source, ">Fictionwise Release Date:")

    if i != -1:
        date = searchForPlus(source, ">Fictionwise Release Date:")
        date = searchForPlus(date, ">")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, ",")

            if i != -1:
                date = stripText(date[i+1:])








try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
