# Family Christian Stores scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import convertAuthor
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    i = string.find(source, "matching records...<")

    if i != -1:
        source = searchFor(source, "<a href=\"/shop/product.asp?prodID=")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        url = "http://www.familychristian.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Find List price
    i = string.find(marketinfo, "Retail:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "Retail:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    i = string.find(source, "<!--Begin Content Well-->")

    if i == -1:
        title = ""
        return

    source = searchForPlus(source, "<!--Begin Content Well-->")


    # Find Image
    i = string.find(source, "images/shop")

    if i != -1:
        source = source[i-25:]
        source = searchForPlus(source, " SRC=")
        i = string.find(source, " ")
        image = stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""
        else:
            image = "http://www.familychristian.com/" + image


    # Find Format
    i = string.find(source, "Format:")

    if i != -1: 
        source = searchForPlus(source, "Format:")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Value
    i = string.find(source, "Retail:")

    if i != -1:
        source = searchForPlus(source, "Retail:")
        i = string.find(source, "<")
        value = stripText(source[0:i])

    i = string.find(source, "Sale:")

    if i != -1:
        source = searchForPlus(source, "Sale:")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "SIZE=4><I>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    i = string.find(source, "&Ntt=")
    authorList = []

    if i != -1:
        authors = searchFor(source, "&Ntt=")
        i = string.find(authors, "<BR>")
        authors = stripText(authors[0:i])

        while (searchFor(authors, "&Ntt=") != None):
            authors = searchForPlus(authors, "&Ntt=")
            authors = searchForPlus(authors, "\">")
            i = string.find(authors, "<")
            author = stripText(authors[0:i])

            i = string.rfind(author, " ")

            if i != -1:
                author = stripText(author[i:]) + ", " + stripText(author[0:i])

            authorList.append(author)


        if len(authorList) > 0:
            author = authorList[0]

        if len(authorList) > 1:
            author2 = authorList[1]

        if len(authorList) > 2:
            author3 = authorList[2]

        if len(authorList) > 3:
            author4 = authorList[3]

        if len(authorList) > 4:
            author5 = authorList[4]

        if len(authorList) > 5:
            author6 = authorList[5]

    if title != "" and len(authorList) == 0:
        author = "No Author"


    # Find Comments
    i = string.find(source, "goldline.gif")

    if i != -1:
        comments = ""
        source = searchForPlus(source, "goldline.gif")
        source = searchForPlus(source, "<BR>")
        i = string.find(source, "<BR ")
        comments = stripText(source[0:i])

        i = string.find(comments, "<br ")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<font")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<FONT")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<table")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<P>", "")
        comments = string.replace(comments, "<p>", "")
        comments = string.replace(comments, "<BR>", "\n")
        comments = string.replace(comments, "<br>", "\n")




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
