# eBooks.com eBook scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    format              = "eBook"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Find List price
    i = string.find(marketinfo, "class=\"price\"")

    if i != -1:
        listprice = marketinfo[i:]
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    i = string.find(source, ">Book Details<")

    if i == -1:
        return;


    # Find Image
    image = searchForPlus(source, ">Book Details<")
    image = searchForPlus(image, "src=\"")
    i = string.find(image, "\"")
    image = stripText(image[0:i])
    i = string.find(image, "{")

    if i != -1:
        image = ""


    # Find Title
    source = searchForPlus(source, ">Book Details<")
    source = searchForPlus(source, "<h3>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author(s)
    authorList = []

    i = string.find(source, "By:")

    if i != -1:
        source = searchForPlus(source, "By:")
        i = string.find(source, "<br />")
        authors = stripText(source[0:i] + ";")

        while (searchFor(authors, ";") != None):
            i = string.find(authors, ";")
            author = stripText(authors[0:i])
            authorList.append(author)
            authors = searchForPlus(authors, ";")   


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Publisher
    i = string.find(source, "Published By:")

    if i != -1:
        publisher = searchForPlus(source, "Published By:")
        i = string.find(publisher, "<")
        publisher = stripText(publisher[0:i])


    # Find Price
    i = string.find(source, "class=\"price\"")

    if i != -1:
        source = source[i:]
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    comments = ""
    i = string.find(source, "<td colspan=\"2\">")

    if (i != -1):
        source = searchForPlus(source, "<td colspan=\"2\">")
        i = string.find(source, "</td>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "\n<P>\n", "\n\n")
        comments = string.replace(comments, "\n<P>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "\n<p>\n", "\n\n")
        comments = string.replace(comments, "\n<p>", "\n\n")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "</P>", "")
        comments = string.replace(comments, "</p>", "")
        comments = string.replace(comments, "<li>", "")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "<B>", "")
        comments = string.replace(comments, "</B>", "")


    # Find Category
    i = string.find(source, ">Related Subjects<")

    if i != -1:
        categories = searchForPlus(source, ">Related Subjects<")
        categories = searchForPlus(source, "<li>")
        i = string.find(categories, "</li>")
        categories = stripText(categories[0:i])
        i = string.find(categories, "<br />")

        if i != -1:
            categories = stripText(categories[0:i])

        category = ""

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            temp = searchForPlus(categories, "\">")
            i = string.find(temp, "<")
            temp = stripText(temp[0:i])

            if (category != ""):
                category = category + " > "

            category = category + temp


    # Find Comments (part 2)
    i = string.find(source, "About the Author<")

    if (i != -1):
        source = searchForPlus(source, "About the Author<")
        source = searchForPlus(source, "<br />")
        i = string.find(source, "</div>")

        temp = stripText(source[0:i])
        temp = string.replace(temp, "\n ", "")
        temp = string.replace(temp, "\n", "")
        temp = string.replace(temp, "<i>", "")
        temp = string.replace(temp, "</i>", "")
        temp = string.replace(temp, "<p>", "\n\n")
        temp = string.replace(temp, "</p>", "")
        temp = string.replace(temp, "<br>", "\n")

        if comments != "":
            comments = comments + "\n\n"

        comments = comments + "About the Author\n" + temp


    # Find ISBN:
    i = string.find(source, ">ISBN<")

    if i != -1:
        isbn = searchForPlus(source, ">ISBN<")
        isbn = searchForPlus(isbn, "\">")
        i = string.find(isbn, "<")
        isbn = stripText(isbn[0:i])


    # Find Published Date:
    i = string.find(source, ">Published Date<")

    if i != -1:
        date = searchForPlus(source, ">Published Date<")
        date = searchForPlus(date, "<td>")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])






try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
